/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.event.EventDetails;
import com.tradplus.ads.common.util.LogUtil;

public class Event
extends BaseEvent {
    private Event(Builder builder) {
        super(builder);
    }

    public static BaseEvent createEventFromDetails(BaseEvent.Name name, BaseEvent.Category category, BaseEvent.SamplingRate samplingRate, EventDetails eventDetails) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)category);
        Preconditions.checkNotNull((Object)samplingRate);
        if (eventDetails == null) {
            LogUtil.show("Unable to log event due to no details present");
            return null;
        }
        double d = samplingRate.getSamplingRate();
        return new Builder(name, category, d).withAdUnitId(eventDetails.getAdUnitId()).withAdCreativeId(eventDetails.getDspCreativeId()).withAdType(eventDetails.getAdType()).withAdNetworkType(eventDetails.getAdNetworkType()).withAdWidthPx(eventDetails.getAdWidthPx()).withAdHeightPx(eventDetails.getAdHeightPx()).withGeoLat(eventDetails.getGeoLatitude()).withGeoLon(eventDetails.getGeoLongitude()).withGeoAccuracy(eventDetails.getGeoAccuracy()).withPerformanceDurationMs(eventDetails.getPerformanceDurationMs()).withRequestId(eventDetails.getRequestId()).withRequestStatusCode(eventDetails.getRequestStatusCode()).withRequestUri(eventDetails.getRequestUri()).build();
    }

    public static class Builder
    extends BaseEvent.Builder {
        public Builder(BaseEvent.Name name, BaseEvent.Category category, double d) {
            super(BaseEvent.ScribeCategory.EXCHANGE_CLIENT_EVENT, name, category, d);
        }

        @Override
        public Event build() {
            return new Event(this);
        }
    }
}

