/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.event.EventRecorder;
import com.tradplus.ads.common.util.LogUtil;
import java.util.Iterator;

public class EventDispatcher {
    private final Iterable<EventRecorder> mEventRecorders;
    private final Looper mLooper;
    private final Handler mMessageHandler;
    private final Handler.Callback mHandlerCallback;

    EventDispatcher(Iterable<EventRecorder> object, Looper looper) {
        Handler handler;
        Handler.Callback callback;
        eventDispatcher.mEventRecorders = object;
        eventDispatcher.mLooper = looper;
        object = callback;
        callback = new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (message.obj instanceof BaseEvent) {
                    Iterator iterator = iterator.EventDispatcher.this.mEventRecorders.iterator();
                    while (iterator.hasNext()) {
                        ((EventRecorder)iterator.next()).record((BaseEvent)message.obj);
                    }
                } else {
                    LogUtil.show("EventDispatcher received non-BaseEvent message type.");
                }
                return true;
            }
        };
        eventDispatcher.mHandlerCallback = object;
        EventDispatcher eventDispatcher = handler;
        handler = new Handler(looper, (Handler.Callback)object);
        v2.mMessageHandler = eventDispatcher;
    }

    public void dispatch(BaseEvent baseEvent) {
        Message.obtain((Handler)this.mMessageHandler, (int)0, (Object)baseEvent).sendToTarget();
    }

    Iterable<EventRecorder> getEventRecorders() {
        return this.mEventRecorders;
    }

    Handler.Callback getHandlerCallback() {
        return this.mHandlerCallback;
    }
}

