/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.event.BaseEvent;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public class EventSampler {
    static final int MAX_SIZE = 100;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int CAPACITY = 135;
    private Random mRandom;
    private LinkedHashMap<String, Boolean> mSampleDecisionsCache;

    public EventSampler() {
        Random random;
        EventSampler eventSampler = random2;
        Random random2 = random;
        random = new Random();
        eventSampler(random2);
    }

    public EventSampler(Random serializable) {
        LinkedHashMap<String, Boolean> linkedHashMap;
        this.mRandom = serializable;
        serializable = linkedHashMap;
        linkedHashMap = new LinkedHashMap<String, Boolean>(135, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Boolean> entry) {
                return ((AbstractMap)this).size() > 100;
            }
        };
        this.mSampleDecisionsCache = serializable;
    }

    boolean sample(BaseEvent baseEvent) {
        BaseEvent baseEvent2 = baseEvent;
        Preconditions.checkNotNull(baseEvent2);
        String string = baseEvent2.getRequestId();
        if (string == null) {
            return this.mRandom.nextDouble() < baseEvent.getSamplingRate();
        }
        Boolean bl = this.mSampleDecisionsCache.get(string);
        if (bl != null) {
            return bl;
        }
        boolean bl2 = this.mRandom.nextDouble() < baseEvent.getSamplingRate();
        ((AbstractMap)this.mSampleDecisionsCache).put(string, bl2);
        return bl2;
    }

    int getCacheSize() {
        return ((AbstractMap)this.mSampleDecisionsCache).size();
    }
}

