/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSONArray;
import com.tradplus.ads.common.serialization.JSONAware;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONObject;
import com.tradplus.ads.common.serialization.JSONStreamAware;
import com.tradplus.ads.common.serialization.TypeReference;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.ParserConfig;
import com.tradplus.ads.common.serialization.parser.deserializer.ExtraProcessor;
import com.tradplus.ads.common.serialization.parser.deserializer.ExtraTypeProvider;
import com.tradplus.ads.common.serialization.parser.deserializer.FieldTypeResolver;
import com.tradplus.ads.common.serialization.parser.deserializer.ParseProcess;
import com.tradplus.ads.common.serialization.serializer.JSONSerializable;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.JavaBeanSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeConfig;
import com.tradplus.ads.common.serialization.serializer.SerializeFilter;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.IOUtils;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JSON
implements JSONStreamAware,
JSONAware {
    public static TimeZone defaultTimeZone = TimeZone.getDefault();
    public static Locale defaultLocale = Locale.getDefault();
    public static String DEFAULT_TYPE_KEY = "@type";
    static final SerializeFilter[] emptyFilters = new SerializeFilter[0];
    public static String DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static int DEFAULT_PARSER_FEATURE;
    public static int DEFAULT_GENERATE_FEATURE;
    private static final ConcurrentHashMap<Type, Type> mixInsMapper;
    private static final ThreadLocal<byte[]> bytesLocal;
    private static final ThreadLocal<char[]> charsLocal;
    public static final String VERSION = "1.2.74";

    private static void config(Properties properties) {
        String string = properties.getProperty("fastjson.serializerFeatures.MapSortField");
        int n = SerializerFeature.MapSortField.getMask();
        if ("true".equals(string)) {
            DEFAULT_GENERATE_FEATURE |= n;
        } else if ("false".equals(string)) {
            DEFAULT_GENERATE_FEATURE &= ~n;
        }
        if ("true".equals(properties.getProperty("parser.features.NonStringKeyAsString"))) {
            DEFAULT_PARSER_FEATURE |= Feature.NonStringKeyAsString.getMask();
        }
        if ("true".equals(properties.getProperty("parser.features.ErrorOnEnumNotMatch")) || "true".equals(properties.getProperty("fastjson.parser.features.ErrorOnEnumNotMatch"))) {
            DEFAULT_PARSER_FEATURE |= Feature.ErrorOnEnumNotMatch.getMask();
        }
        if ("false".equals(properties.getProperty("fastjson.asmEnable"))) {
            ParserConfig.getGlobalInstance().setAsmEnable(false);
            SerializeConfig.getGlobalInstance().setAsmEnable(false);
        }
    }

    public static void setDefaultTypeKey(String string) {
        DEFAULT_TYPE_KEY = string;
        String string2 = string;
        int n = string2.length();
        int n2 = string2.hashCode();
        ParserConfig.global.symbolTable.addSymbol(string2, 0, n, n2, true);
    }

    public static Object parse(String string) {
        return JSON.parse(string, DEFAULT_PARSER_FEATURE);
    }

    public static Object parse(String string, ParserConfig parserConfig) {
        return JSON.parse(string, parserConfig, DEFAULT_PARSER_FEATURE);
    }

    public static Object parse(String string, ParserConfig parserConfig, Feature ... featureArray) {
        int n = DEFAULT_PARSER_FEATURE;
        int n2 = featureArray.length;
        for (int i = 0; i < n2; ++i) {
            n = Feature.jsonCfg(n, featureArray[i], true);
        }
        return JSON.parse(string, parserConfig, n);
    }

    public static Object parse(String object, ParserConfig parserConfig, int n) {
        DefaultJSONParser defaultJSONParser;
        if (object == null) {
            return null;
        }
        DefaultJSONParser defaultJSONParser2 = defaultJSONParser;
        object = new DefaultJSONParser((String)object, parserConfig, n).parse();
        DefaultJSONParser defaultJSONParser3 = defaultJSONParser2;
        defaultJSONParser3.handleResovleTask(object);
        defaultJSONParser3.close();
        return object;
    }

    public static Object parse(String string, int n) {
        return JSON.parse(string, ParserConfig.getGlobalInstance(), n);
    }

    public static Object parse(byte[] objectArray, Feature ... featureArray) {
        int n = IOUtils.ddu(objectArray = (Object[])JSON.allocateChars(objectArray.length), 0, objectArray.length, (char[])objectArray);
        if (n < 0) {
            return null;
        }
        return JSON.parse(new String((char[])objectArray, 0, n), featureArray);
    }

    public static Object parse(byte[] byArray, int n, int n2, CharsetDecoder charsetDecoder, Feature ... featureArray) {
        if (byArray != null && byArray.length != 0) {
            int n3 = DEFAULT_PARSER_FEATURE;
            int n4 = featureArray.length;
            for (int i = 0; i < n4; ++i) {
                n3 = Feature.jsonCfg(n3, featureArray[i], true);
            }
            return JSON.parse(byArray, n, n2, charsetDecoder, n3);
        }
        return null;
    }

    public static Object parse(byte[] object, int n, int n2, CharsetDecoder charsetDecoder, int n3) {
        DefaultJSONParser defaultJSONParser;
        charsetDecoder.reset();
        char[] cArray = JSON.allocateChars((int)((double)n2 * (double)charsetDecoder.maxCharsPerByte()));
        object = ByteBuffer.wrap(object, n, n2);
        Object object2 = CharBuffer.wrap(cArray);
        IOUtils.dd(charsetDecoder, (ByteBuffer)object, (CharBuffer)object2);
        int n4 = ((Buffer)object2).position();
        object2 = defaultJSONParser;
        Object object3 = new DefaultJSONParser(cArray, n4, ParserConfig.getGlobalInstance(), n3).parse();
        Object object4 = object2;
        ((DefaultJSONParser)object4).handleResovleTask(object3);
        ((DefaultJSONParser)object4).close();
        return object3;
    }

    public static Object parse(String string, Feature ... featureArray) {
        int n = DEFAULT_PARSER_FEATURE;
        int n2 = featureArray.length;
        for (int i = 0; i < n2; ++i) {
            n = Feature.jsonCfg(n, featureArray[i], true);
        }
        return JSON.parse(string, n);
    }

    public static JSONObject parseObject(String string, Feature ... featureArray) {
        return (JSONObject)JSON.parse(string, featureArray);
    }

    public static JSONObject parseObject(String object) {
        if ((object = JSON.parse((String)object)) instanceof JSONObject) {
            return (JSONObject)object;
        }
        try {
            return (JSONObject)JSON.toJSON(object);
        }
        catch (RuntimeException runtimeException) {
            throw new JSONException("can not cast to JSONObject.", runtimeException);
        }
    }

    public static <T> T parseObject(String string, TypeReference<T> typeReference, Feature ... featureArray) {
        return JSON.parseObject(string, typeReference.type, ParserConfig.global, DEFAULT_PARSER_FEATURE, featureArray);
    }

    public static <T> T parseObject(String object, Class<T> clazz, Feature ... featureArray) {
        String string = object;
        object = ParserConfig.global;
        int n = DEFAULT_PARSER_FEATURE;
        return JSON.parseObject(string, clazz, (ParserConfig)object, null, n, featureArray);
    }

    public static <T> T parseObject(String object, Class<T> clazz, ParseProcess parseProcess, Feature ... featureArray) {
        String string = object;
        object = ParserConfig.global;
        int n = DEFAULT_PARSER_FEATURE;
        return JSON.parseObject(string, clazz, (ParserConfig)object, parseProcess, n, featureArray);
    }

    public static <T> T parseObject(String string, Type type, Feature ... featureArray) {
        return JSON.parseObject(string, type, ParserConfig.global, DEFAULT_PARSER_FEATURE, featureArray);
    }

    public static <T> T parseObject(String object, Type type, ParseProcess parseProcess, Feature ... featureArray) {
        String string = object;
        object = ParserConfig.global;
        int n = DEFAULT_PARSER_FEATURE;
        return JSON.parseObject(string, type, (ParserConfig)object, parseProcess, n, featureArray);
    }

    public static <T> T parseObject(String string, Type type, int n, Feature ... object) {
        DefaultJSONParser defaultJSONParser;
        if (string == null) {
            return null;
        }
        int n2 = ((Feature[])object).length;
        for (int i = 0; i < n2; ++i) {
            n = Feature.jsonCfg(n, object[i], true);
        }
        object = defaultJSONParser;
        string = new DefaultJSONParser(string, ParserConfig.getGlobalInstance(), n).parseObject(type);
        Object object2 = object;
        ((DefaultJSONParser)object2).handleResovleTask(string);
        ((DefaultJSONParser)object2).close();
        return (T)string;
    }

    public static <T> T parseObject(String string, Type type, ParserConfig parserConfig, Feature ... featureArray) {
        int n = DEFAULT_PARSER_FEATURE;
        return JSON.parseObject(string, type, parserConfig, null, n, featureArray);
    }

    public static <T> T parseObject(String string, Type type, ParserConfig parserConfig, int n, Feature ... featureArray) {
        return JSON.parseObject(string, type, parserConfig, null, n, featureArray);
    }

    public static <T> T parseObject(String string, Type type, ParserConfig parserConfig, ParseProcess parseProcess, int n, Feature ... object) {
        if (string != null && string.length() != 0) {
            DefaultJSONParser defaultJSONParser;
            if (object != null) {
                int n2 = ((Feature[])object).length;
                for (int i = 0; i < n2; ++i) {
                    n |= object[i].mask;
                }
            }
            object = defaultJSONParser;
            defaultJSONParser = new DefaultJSONParser(string, parserConfig, n);
            if (parseProcess != null) {
                if (parseProcess instanceof ExtraTypeProvider) {
                    ((DefaultJSONParser)object).getExtraTypeProviders().add((ExtraTypeProvider)parseProcess);
                }
                if (parseProcess instanceof ExtraProcessor) {
                    ((DefaultJSONParser)object).getExtraProcessors().add((ExtraProcessor)parseProcess);
                }
                if (parseProcess instanceof FieldTypeResolver) {
                    ((DefaultJSONParser)object).setFieldTypeResolver((FieldTypeResolver)parseProcess);
                }
            }
            string = ((DefaultJSONParser)object).parseObject(type, null);
            Object object2 = object;
            ((DefaultJSONParser)object2).handleResovleTask(string);
            ((DefaultJSONParser)object2).close();
            return (T)string;
        }
        return null;
    }

    public static <T> T parseObject(byte[] object, Type type, Feature ... featureArray) {
        int n = ((byte[])object).length;
        object = IOUtils.UTF8;
        return JSON.parseObject(object, 0, n, (Charset)object, type, featureArray);
    }

    public static <T> T parseObject(byte[] object, int n, int n2, Charset charset, Type type, Feature ... featureArray) {
        byte[] byArray = object;
        int n3 = n;
        object = ParserConfig.global;
        n = DEFAULT_PARSER_FEATURE;
        return JSON.parseObject(byArray, n3, n2, charset, type, (ParserConfig)object, null, n, featureArray);
    }

    public static <T> T parseObject(byte[] byArray, Charset charset, Type type, ParserConfig parserConfig, ParseProcess parseProcess, int n, Feature ... featureArray) {
        return JSON.parseObject(byArray, 0, byArray.length, charset, type, parserConfig, parseProcess, n, featureArray);
    }

    public static <T> T parseObject(byte[] objectArray, int n, int n2, Charset charset, Type type, ParserConfig parserConfig, ParseProcess parseProcess, int n3, Feature ... featureArray) {
        String string;
        if (charset == null) {
            charset = IOUtils.UTF8;
        }
        if (charset == IOUtils.UTF8) {
            String string2;
            if ((n = IOUtils.ddu(objectArray, n, n2, (char[])(objectArray = (Object[])JSON.allocateChars(objectArray.length)))) < 0) {
                return null;
            }
            string = string2;
            string2 = new String((char[])objectArray, 0, n);
        } else {
            String string3;
            if (n2 < 0) {
                return null;
            }
            String string4 = string3;
            string3 = new String((byte[])objectArray, n, n2, charset);
            string = string4;
        }
        return JSON.parseObject(string, type, parserConfig, parseProcess, n3, featureArray);
    }

    public static <T> T parseObject(byte[] object, int n, int n2, CharsetDecoder charsetDecoder, Type type, Feature ... featureArray) {
        charsetDecoder.reset();
        char[] cArray = JSON.allocateChars((int)((double)n2 * (double)charsetDecoder.maxCharsPerByte()));
        object = ByteBuffer.wrap(object, n, n2);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        IOUtils.dd(charsetDecoder, (ByteBuffer)object, charBuffer);
        return JSON.parseObject(cArray, charBuffer.position(), type, featureArray);
    }

    public static <T> T parseObject(char[] object, int n, Type type, Feature ... object2) {
        if (object != null && ((char[])object).length != 0) {
            DefaultJSONParser defaultJSONParser;
            int n2 = DEFAULT_PARSER_FEATURE;
            int n3 = ((Feature[])object2).length;
            for (int i = 0; i < n3; ++i) {
                n2 = Feature.jsonCfg(n2, object2[i], true);
            }
            object2 = defaultJSONParser;
            ParserConfig parserConfig = ParserConfig.getGlobalInstance();
            Object t = new DefaultJSONParser((char[])object, n, parserConfig, n2).parseObject(type);
            object = t;
            Object object3 = object2;
            ((DefaultJSONParser)object3).handleResovleTask(object);
            ((DefaultJSONParser)object3).close();
            return t;
        }
        return null;
    }

    public static <T> T parseObject(InputStream inputStream, Type type, Feature ... featureArray) {
        return JSON.parseObject(inputStream, IOUtils.UTF8, type, featureArray);
    }

    public static <T> T parseObject(InputStream inputStream, Charset charset, Type type, Feature ... featureArray) {
        return JSON.parseObject(inputStream, charset, type, ParserConfig.global, featureArray);
    }

    public static <T> T parseObject(InputStream inputStream, Charset charset, Type type, ParserConfig parserConfig, Feature ... featureArray) {
        int n = DEFAULT_PARSER_FEATURE;
        return JSON.parseObject(inputStream, charset, type, parserConfig, null, n, featureArray);
    }

    public static <T> T parseObject(InputStream inputStream, Charset charset, Type type, ParserConfig parserConfig, ParseProcess parseProcess, int n, Feature ... featureArray) {
        if (charset == null) {
            charset = IOUtils.UTF8;
        }
        byte[] byArray = JSON.allocateBytes(65536);
        int n2 = 0;
        int n3;
        while ((n3 = inputStream.read(byArray, n2, byArray.length - n2)) != -1) {
            if ((n2 += n3) != byArray.length) continue;
            byArray = new byte[byArray.length * 3 / 2];
            n3 = byArray.length;
            System.arraycopy(byArray, 0, byArray, 0, n3);
        }
        return JSON.parseObject(byArray, 0, n2, charset, type, parserConfig, parseProcess, n, featureArray);
    }

    public static <T> T parseObject(String string, Class<T> clazz) {
        return JSON.parseObject(string, clazz, new Feature[0]);
    }

    public static JSONArray parseArray(String string) {
        return JSON.parseArray(string, ParserConfig.global);
    }

    public static JSONArray parseArray(String object, ParserConfig parserConfig) {
        DefaultJSONParser defaultJSONParser;
        if (object == null) {
            return null;
        }
        DefaultJSONParser defaultJSONParser2 = defaultJSONParser;
        object = new DefaultJSONParser((String)object, (ParserConfig)parserConfig).lexer;
        if (object.token() == 8) {
            object.nextToken();
            object = null;
        } else if (object.token() == 20) {
            object = null;
        } else {
            JSONArray jSONArray;
            DefaultJSONParser defaultJSONParser3 = defaultJSONParser2;
            object = jSONArray;
            jSONArray = new JSONArray();
            defaultJSONParser3.parseArray((Collection)object);
            defaultJSONParser3.handleResovleTask(object);
        }
        defaultJSONParser2.close();
        return object;
    }

    public static <T> List<T> parseArray(String string, Class<T> clazz) {
        return JSON.parseArray(string, clazz, ParserConfig.global);
    }

    public static <T> List<T> parseArray(String object, Class<T> clazz, ParserConfig parserConfig) {
        DefaultJSONParser defaultJSONParser;
        if (object == null) {
            return null;
        }
        DefaultJSONParser defaultJSONParser2 = defaultJSONParser;
        object = new DefaultJSONParser((String)object, (ParserConfig)parserConfig).lexer;
        int n = object.token();
        if (n == 8) {
            object.nextToken();
            object = null;
        } else if (n == 20 && object.isBlankInput()) {
            object = null;
        } else {
            ArrayList arrayList;
            DefaultJSONParser defaultJSONParser3 = defaultJSONParser2;
            object = arrayList;
            arrayList = new ArrayList();
            defaultJSONParser3.parseArray(clazz, (Collection)object);
            defaultJSONParser3.handleResovleTask(object);
        }
        defaultJSONParser2.close();
        return object;
    }

    public static List<Object> parseArray(String string, Type[] typeArray) {
        return JSON.parseArray(string, typeArray, ParserConfig.global);
    }

    public static List<Object> parseArray(String object, Type[] typeArray, ParserConfig parserConfig) {
        DefaultJSONParser defaultJSONParser;
        if (object == null) {
            return null;
        }
        DefaultJSONParser defaultJSONParser2 = defaultJSONParser;
        object = (object = new DefaultJSONParser((String)object, parserConfig).parseArray(typeArray)) == null ? null : Arrays.asList(object);
        DefaultJSONParser defaultJSONParser3 = defaultJSONParser2;
        defaultJSONParser3.handleResovleTask(object);
        defaultJSONParser3.close();
        return object;
    }

    public static String toJSONString(Object object) {
        return JSON.toJSONString(object, emptyFilters, new SerializerFeature[0]);
    }

    public static String toJSONString(Object object, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static String toJSONString(Object object, int n, SerializerFeature ... serializerFeatureArray) {
        String string;
        SerializeWriter serializeWriter;
        SerializeWriter serializeWriter2 = serializeWriter;
        serializeWriter = new SerializeWriter(null, n, serializerFeatureArray);
        try {
            new JSONSerializer(serializeWriter2).write(object);
            string = serializeWriter.toString();
            serializeWriter2.close();
        }
        catch (Throwable throwable) {
            serializeWriter2.close();
            throw throwable;
        }
        return string;
    }

    public static String toJSONStringWithDateFormat(Object object, String string, SerializerFeature ... serializerFeatureArray) {
        int n = DEFAULT_GENERATE_FEATURE;
        return JSON.toJSONString(object, SerializeConfig.globalInstance, null, string, n, serializerFeatureArray);
    }

    public static String toJSONString(Object object, SerializeFilter serializeFilter, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, new SerializeFilter[]{serializeFilter}, null, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static String toJSONString(Object object, SerializeFilter[] serializeFilterArray, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, serializeFilterArray, null, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter serializeFilter, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, SerializeConfig.globalInstance, new SerializeFilter[]{serializeFilter}, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, int n, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, SerializeConfig.globalInstance, n, serializerFeatureArray);
    }

    public static String toJSONString(Object object, SerializeConfig serializeConfig, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, serializeConfig, null, serializerFeatureArray);
    }

    public static String toJSONString(Object serializeFilterArray, SerializeConfig serializeConfig, SerializeFilter serializeFilter, SerializerFeature ... serializerFeatureArray) {
        SerializeFilter[] serializeFilterArray2 = serializeFilterArray;
        SerializeFilter[] serializeFilterArray3 = new SerializeFilter[1];
        serializeFilterArray = serializeFilterArray3;
        serializeFilterArray3[0] = serializeFilter;
        int n = DEFAULT_GENERATE_FEATURE;
        return JSON.toJSONString((Object)serializeFilterArray2, serializeConfig, serializeFilterArray, null, n, serializerFeatureArray);
    }

    public static String toJSONString(Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, SerializerFeature ... serializerFeatureArray) {
        int n = DEFAULT_GENERATE_FEATURE;
        return JSON.toJSONString(object, serializeConfig, serializeFilterArray, null, n, serializerFeatureArray);
    }

    public static String toJSONString(Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, String string, int n, SerializerFeature ... serializerFeatureArray) {
        String string2;
        JSONSerializer jSONSerializer;
        SerializeWriter serializeWriter;
        block10: {
            JSONSerializer jSONSerializer2;
            SerializeWriter serializeWriter2;
            serializeWriter = serializeWriter2;
            serializeWriter2 = new SerializeWriter(null, n, serializerFeatureArray);
            jSONSerializer = jSONSerializer2;
            jSONSerializer2 = new JSONSerializer(serializeWriter, serializeConfig);
            if (string == null) break block10;
            if (string.length() == 0) break block10;
            JSONSerializer jSONSerializer3 = jSONSerializer;
            jSONSerializer3.setDateFormat(string);
            jSONSerializer3.jsonCfg(SerializerFeature.WriteDateUseDateFormat, true);
        }
        if (serializeFilterArray != null) {
            int n2 = serializeFilterArray.length;
            for (int i = 0; i < n2; ++i) {
                jSONSerializer.addFilter(serializeFilterArray[i]);
                continue;
            }
        }
        try {
            jSONSerializer.write(object);
            string2 = serializeWriter.toString();
            serializeWriter.close();
        }
        catch (Throwable throwable) {
            serializeWriter.close();
            throw throwable;
        }
        return string2;
    }

    public static String toJSONStringZ(Object object, SerializeConfig serializeConfig, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, serializeConfig, emptyFilters, null, 0, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig serializeConfig, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, serializeConfig, emptyFilters, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig serializeConfig, int n, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, serializeConfig, emptyFilters, n, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter[] serializeFilterArray, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, SerializeConfig.globalInstance, serializeFilterArray, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object serializeFilterArray, SerializeConfig serializeConfig, SerializeFilter serializeFilter, SerializerFeature ... serializerFeatureArray) {
        SerializeFilter[] serializeFilterArray2 = serializeFilterArray;
        SerializeFilter[] serializeFilterArray3 = new SerializeFilter[1];
        serializeFilterArray = serializeFilterArray3;
        serializeFilterArray3[0] = serializeFilter;
        return JSON.toJSONBytes((Object)serializeFilterArray2, serializeConfig, serializeFilterArray, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, int n, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, serializeConfig, serializeFilterArray, null, n, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, String string, int n, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(IOUtils.UTF8, object, serializeConfig, serializeFilterArray, string, n, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Charset charset, Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, String string, int n, SerializerFeature ... serializerFeatureArray) {
        byte[] byArray;
        JSONSerializer jSONSerializer;
        SerializeWriter serializeWriter;
        block10: {
            JSONSerializer jSONSerializer2;
            SerializeWriter serializeWriter2;
            serializeWriter = serializeWriter2;
            serializeWriter2 = new SerializeWriter(null, n, serializerFeatureArray);
            jSONSerializer = jSONSerializer2;
            jSONSerializer2 = new JSONSerializer(serializeWriter, serializeConfig);
            if (string == null) break block10;
            if (string.length() == 0) break block10;
            JSONSerializer jSONSerializer3 = jSONSerializer;
            jSONSerializer3.setDateFormat(string);
            jSONSerializer3.jsonCfg(SerializerFeature.WriteDateUseDateFormat, true);
        }
        if (serializeFilterArray != null) {
            int n2 = serializeFilterArray.length;
            for (int i = 0; i < n2; ++i) {
                jSONSerializer.addFilter(serializeFilterArray[i]);
                continue;
            }
        }
        try {
            jSONSerializer.write(object);
            byArray = serializeWriter.toBytes(charset);
            serializeWriter.close();
        }
        catch (Throwable throwable) {
            serializeWriter.close();
            throw throwable;
        }
        return byArray;
    }

    public static byte[] toJSONBytesWithFastJsonConfig(Charset charset, Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, String string, int n, SerializerFeature ... serializerFeatureArray) {
        byte[] byArray;
        JSONSerializer jSONSerializer;
        SerializeWriter serializeWriter;
        block10: {
            JSONSerializer jSONSerializer2;
            SerializeWriter serializeWriter2;
            serializeWriter = serializeWriter2;
            serializeWriter2 = new SerializeWriter(null, n, serializerFeatureArray);
            jSONSerializer = jSONSerializer2;
            jSONSerializer2 = new JSONSerializer(serializeWriter, serializeConfig);
            if (string == null) break block10;
            if (string.length() == 0) break block10;
            JSONSerializer jSONSerializer3 = jSONSerializer;
            jSONSerializer3.setFastJsonConfigDateFormatPattern(string);
            jSONSerializer3.jsonCfg(SerializerFeature.WriteDateUseDateFormat, true);
        }
        if (serializeFilterArray != null) {
            int n2 = serializeFilterArray.length;
            for (int i = 0; i < n2; ++i) {
                jSONSerializer.addFilter(serializeFilterArray[i]);
                continue;
            }
        }
        try {
            jSONSerializer.write(object);
            byArray = serializeWriter.toBytes(charset);
            serializeWriter.close();
        }
        catch (Throwable throwable) {
            serializeWriter.close();
            throw throwable;
        }
        return byArray;
    }

    public static String toJSONString(Object object, boolean bl) {
        if (!bl) {
            return JSON.toJSONString(object);
        }
        return JSON.toJSONString(object, SerializerFeature.PrettyFormat);
    }

    public static void writeJSONStringTo(Object object, Writer writer, SerializerFeature ... serializerFeatureArray) {
        JSON.writeJSONString(writer, object, serializerFeatureArray);
    }

    public static void writeJSONString(Writer writer, Object object, SerializerFeature ... serializerFeatureArray) {
        JSON.writeJSONString(writer, object, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static void writeJSONString(Writer writer, Object object, int n, SerializerFeature ... serializerFeatureArray) {
        SerializeWriter serializeWriter;
        SerializeWriter serializeWriter2 = serializeWriter;
        serializeWriter = new SerializeWriter(writer, n, serializerFeatureArray);
        try {
            new JSONSerializer(serializeWriter2).write(object);
            serializeWriter.close();
            return;
        }
        catch (Throwable throwable) {
            serializeWriter2.close();
            throw throwable;
        }
    }

    public static final int writeJSONString(OutputStream outputStream, Object object, SerializerFeature ... serializerFeatureArray) {
        return JSON.writeJSONString(outputStream, object, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static final int writeJSONString(OutputStream outputStream, Object object, int n, SerializerFeature ... serializerFeatureArray) {
        return JSON.writeJSONString(outputStream, IOUtils.UTF8, object, SerializeConfig.globalInstance, null, null, n, serializerFeatureArray);
    }

    public static final int writeJSONString(OutputStream outputStream, Charset charset, Object object, SerializerFeature ... serializerFeatureArray) {
        int n = DEFAULT_GENERATE_FEATURE;
        return JSON.writeJSONString(outputStream, charset, object, SerializeConfig.globalInstance, null, null, n, serializerFeatureArray);
    }

    public static final int writeJSONString(OutputStream outputStream, Charset charset, Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, String string, int n, SerializerFeature ... serializerFeatureArray) {
        int n2;
        JSONSerializer jSONSerializer;
        SerializeWriter serializeWriter;
        block10: {
            JSONSerializer jSONSerializer2;
            SerializeWriter serializeWriter2;
            serializeWriter = serializeWriter2;
            serializeWriter2 = new SerializeWriter(null, n, serializerFeatureArray);
            jSONSerializer = jSONSerializer2;
            jSONSerializer2 = new JSONSerializer(serializeWriter, serializeConfig);
            if (string == null) break block10;
            if (string.length() == 0) break block10;
            JSONSerializer jSONSerializer3 = jSONSerializer;
            jSONSerializer3.setDateFormat(string);
            jSONSerializer3.jsonCfg(SerializerFeature.WriteDateUseDateFormat, true);
        }
        if (serializeFilterArray != null) {
            int n3 = serializeFilterArray.length;
            for (int i = 0; i < n3; ++i) {
                jSONSerializer.addFilter(serializeFilterArray[i]);
                continue;
            }
        }
        try {
            jSONSerializer.write(object);
            n2 = serializeWriter.writeToEx(outputStream, charset);
            serializeWriter.close();
        }
        catch (Throwable throwable) {
            serializeWriter.close();
            throw throwable;
        }
        return n2;
    }

    public static final int writeJSONStringWithFastJsonConfig(OutputStream outputStream, Charset charset, Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, String string, int n, SerializerFeature ... serializerFeatureArray) {
        int n2;
        JSONSerializer jSONSerializer;
        SerializeWriter serializeWriter;
        block10: {
            JSONSerializer jSONSerializer2;
            SerializeWriter serializeWriter2;
            serializeWriter = serializeWriter2;
            serializeWriter2 = new SerializeWriter(null, n, serializerFeatureArray);
            jSONSerializer = jSONSerializer2;
            jSONSerializer2 = new JSONSerializer(serializeWriter, serializeConfig);
            if (string == null) break block10;
            if (string.length() == 0) break block10;
            JSONSerializer jSONSerializer3 = jSONSerializer;
            jSONSerializer3.setFastJsonConfigDateFormatPattern(string);
            jSONSerializer3.jsonCfg(SerializerFeature.WriteDateUseDateFormat, true);
        }
        if (serializeFilterArray != null) {
            int n3 = serializeFilterArray.length;
            for (int i = 0; i < n3; ++i) {
                jSONSerializer.addFilter(serializeFilterArray[i]);
                continue;
            }
        }
        try {
            jSONSerializer.write(object);
            n2 = serializeWriter.writeToEx(outputStream, charset);
            serializeWriter.close();
        }
        catch (Throwable throwable) {
            serializeWriter.close();
            throw throwable;
        }
        return n2;
    }

    public static Object toJSON(Object object) {
        return JSON.toJSON(object, SerializeConfig.globalInstance);
    }

    public static Object toJSON(Object object, ParserConfig parserConfig) {
        return JSON.toJSON(object, SerializeConfig.globalInstance);
    }

    /*
     * WARNING - void declaration
     */
    public static Object toJSON(Object object, SerializeConfig serializeConfig) {
        if (object == null) {
            return null;
        }
        if (object instanceof JSON) {
            return object;
        }
        if (object instanceof Map) {
            void var3_11;
            JSONObject jSONObject;
            object = (Map)object;
            int n = object.size();
            if (object instanceof LinkedHashMap) {
                LinkedHashMap linkedHashMap;
                LinkedHashMap object22 = linkedHashMap;
                linkedHashMap = new LinkedHashMap(n);
            } else if (object instanceof TreeMap) {
                TreeMap treeMap;
                TreeMap i = treeMap;
                treeMap = new TreeMap();
            } else {
                HashMap hashMap;
                HashMap entry = hashMap;
                hashMap = new HashMap(n);
            }
            Iterator iterator = object;
            object = jSONObject;
            jSONObject = new JSONObject((Map<String, Object>)var3_11);
            for (Map.Entry entry : iterator.entrySet()) {
                ((JSONObject)object).put(TypeUtils.castToString(entry.getKey()), JSON.toJSON(entry.getValue(), serializeConfig));
            }
            return object;
        }
        if (object instanceof Collection) {
            JSONArray jSONArray;
            object = (Collection)object;
            JSONArray jSONArray2 = jSONArray;
            jSONArray = new JSONArray(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                jSONArray2.add(JSON.toJSON(object.next(), serializeConfig));
            }
            return jSONArray2;
        }
        if (object instanceof JSONSerializable) {
            return JSON.parse(JSON.toJSONString(object));
        }
        Object object3 = object.getClass();
        if (((Class)object3).isEnum()) {
            return ((Enum)object).name();
        }
        if (((Class)object3).isArray()) {
            void var3_15;
            JSONArray jSONArray;
            int n = Array.getLength(object);
            object3 = jSONArray;
            jSONArray = new JSONArray(n);
            boolean bl = false;
            while (var3_15 < n) {
                ((JSONArray)object3).add(JSON.toJSON(Array.get(object, (int)var3_15)));
                ++var3_15;
            }
            return object3;
        }
        if (ParserConfig.isPrimitive2(object3)) {
            return object;
        }
        if ((object3 = serializeConfig.getObjectWriter((Class<?>)object3)) instanceof JavaBeanSerializer) {
            JSONObject jSONObject;
            Object object2 = object;
            object = jSONObject;
            jSONObject = new JSONObject();
            try {
                object3 = ((JavaBeanSerializer)object3).getFieldValuesMap(object2).entrySet().iterator();
            }
            catch (Exception exception) {
                throw new JSONException("toJSON error", exception);
            }
            while (true) {
                if (!object3.hasNext()) break;
                Object object4 = object;
                Map.Entry<String, Object> entry = object3.next();
                ((JSONObject)object4).put(entry.getKey(), JSON.toJSON(entry.getValue(), serializeConfig));
            }
            return object;
        }
        return JSON.parse(JSON.toJSONString(object, serializeConfig, new SerializerFeature[0]));
    }

    public static <T> T toJavaObject(JSON jSON, Class<T> clazz) {
        return TypeUtils.cast((Object)jSON, clazz, ParserConfig.getGlobalInstance());
    }

    private static byte[] allocateBytes(int n) {
        byte[] byArray;
        block4: {
            block3: {
                block2: {
                    ThreadLocal<byte[]> threadLocal = bytesLocal;
                    byArray = threadLocal.get();
                    if (byArray != null) break block2;
                    if (n > 65536) break block3;
                    byArray = new byte[65536];
                    threadLocal.set(byArray);
                    break block4;
                }
                if (byArray.length >= n) break block4;
            }
            byArray = new byte[n];
        }
        return byArray;
    }

    private static char[] allocateChars(int n) {
        char[] cArray;
        block4: {
            block3: {
                block2: {
                    ThreadLocal<char[]> threadLocal = charsLocal;
                    cArray = threadLocal.get();
                    if (cArray != null) break block2;
                    if (n > 65536) break block3;
                    cArray = new char[65536];
                    threadLocal.set(cArray);
                    break block4;
                }
                if (cArray.length >= n) break block4;
            }
            cArray = new char[n];
        }
        return cArray;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isValid(String var0) {
        block9: {
            block8: {
                if (var0 == null || var0.length() == 0) break block9;
                var1_2 = v0;
                new JSONScanner(var0).nextToken();
                var0_1 = var1_2.token();
                if (var0_1 == 12) ** GOTO lbl18
                if (var0_1 == 14) ** GOTO lbl16
                switch (var0_1) {
                    default: {
                        var1_2.close();
                        return false;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                }
                var1_2.nextToken();
                ** GOTO lbl24
lbl16:
                // 1 sources

                var1_2.skipArray(true);
                ** GOTO lbl24
lbl18:
                // 1 sources

                if (var1_2.getCurrent() != '\u001a') break block8;
                var1_2.close();
                return false;
            }
            try {
                var1_2.skipObject(true);
lbl24:
                // 3 sources

                v1 = var1_2.token() == 20;
                var1_2.close();
            }
            catch (Throwable v2) {
                var1_2.close();
                throw v2;
            }
            catch (Exception v3) {
                var1_2.close();
                return false;
            }
            return v1;
        }
        return false;
    }

    public static boolean isValidObject(String string) {
        if (string != null && string.length() != 0) {
            JSONScanner jSONScanner;
            block6: {
                boolean bl;
                block7: {
                    JSONScanner jSONScanner2;
                    jSONScanner = jSONScanner2;
                    new JSONScanner(string).nextToken();
                    if (jSONScanner.token() != 12) break block6;
                    if (jSONScanner.getCurrent() != '\u001a') break block7;
                    jSONScanner.close();
                    return false;
                }
                try {
                    JSONScanner jSONScanner3 = jSONScanner;
                    jSONScanner3.skipObject(true);
                    bl = jSONScanner3.token() == 20;
                    jSONScanner.close();
                }
                catch (Throwable throwable) {
                    jSONScanner.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    jSONScanner.close();
                    return false;
                }
                return bl;
            }
            jSONScanner.close();
            return false;
        }
        return false;
    }

    public static boolean isValidArray(String string) {
        if (string != null && string.length() != 0) {
            JSONScanner jSONScanner;
            block5: {
                boolean bl;
                JSONScanner jSONScanner2;
                jSONScanner = jSONScanner2;
                new JSONScanner(string).nextToken();
                if (jSONScanner.token() != 14) break block5;
                try {
                    JSONScanner jSONScanner3 = jSONScanner;
                    jSONScanner3.skipArray(true);
                    bl = jSONScanner3.token() == 20;
                    jSONScanner.close();
                }
                catch (Throwable throwable) {
                    jSONScanner.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    jSONScanner.close();
                    return false;
                }
                return bl;
            }
            jSONScanner.close();
            return false;
        }
        return false;
    }

    public static <T> void handleResovleTask(DefaultJSONParser defaultJSONParser, T t) {
        defaultJSONParser.handleResovleTask(t);
    }

    public static void addMixInAnnotations(Type type, Type type2) {
        if (type != null && type2 != null) {
            mixInsMapper.put(type, type2);
        }
    }

    public static void removeMixInAnnotations(Type type) {
        if (type != null) {
            mixInsMapper.remove(type);
        }
    }

    public static void clearMixInAnnotations() {
        mixInsMapper.clear();
    }

    public static Type getMixInAnnotations(Type type) {
        if (type != null) {
            return mixInsMapper.get(type);
        }
        return null;
    }

    static {
        mixInsMapper = new ConcurrentHashMap(16);
        DEFAULT_PARSER_FEATURE = Feature.AutoCloseSource.getMask() | 0 | Feature.InternFieldNames.getMask() | Feature.UseBigDecimal.getMask() | Feature.AllowUnQuotedFieldNames.getMask() | Feature.AllowSingleQuotes.getMask() | Feature.AllowArbitraryCommas.getMask() | Feature.SortFeidFastMatch.getMask() | Feature.IgnoreNotMatch.getMask();
        DEFAULT_GENERATE_FEATURE = SerializerFeature.QuoteFieldNames.getMask() | 0 | SerializerFeature.SkipTransientField.getMask() | SerializerFeature.WriteEnumUsingName.getMask() | SerializerFeature.SortField.getMask();
        JSON.config(IOUtils.DEFAULT_PROPERTIES);
        bytesLocal = new ThreadLocal();
        charsLocal = new ThreadLocal();
    }

    public String toString() {
        return this.toJSONString();
    }

    @Override
    public String toJSONString() {
        String string;
        SerializeWriter serializeWriter;
        SerializeWriter serializeWriter2 = serializeWriter;
        serializeWriter = new SerializeWriter();
        try {
            new JSONSerializer(serializeWriter2).write(this);
            string = serializeWriter.toString();
            serializeWriter2.close();
        }
        catch (Throwable throwable) {
            serializeWriter2.close();
            throw throwable;
        }
        return string;
    }

    public String toString(SerializerFeature ... serializerFeatureArray) {
        String string;
        SerializeWriter serializeWriter;
        SerializeWriter serializeWriter2 = serializeWriter;
        serializeWriter = new SerializeWriter(null, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
        try {
            new JSONSerializer(serializeWriter2).write(this);
            string = serializeWriter.toString();
            serializeWriter2.close();
        }
        catch (Throwable throwable) {
            serializeWriter2.close();
            throw throwable;
        }
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeJSONString(Appendable appendable) {
        Throwable throwable2;
        SerializeWriter serializeWriter2;
        block5: {
            SerializeWriter serializeWriter2;
            SerializeWriter serializeWriter3 = serializeWriter2 = serializeWriter2;
            serializeWriter3();
            new JSONSerializer(serializeWriter2).write(this);
            appendable.append(serializeWriter3.toString());
            {
                catch (Throwable throwable2) {
                    break block5;
                }
                catch (IOException iOException) {}
                {
                    throw new JSONException(iOException.getMessage(), iOException);
                }
            }
            serializeWriter2.close();
            return;
        }
        serializeWriter2.close();
        throw throwable2;
    }

    public <T> T toJavaObject(Class<T> clazz) {
        if (clazz != JSONArray.class && clazz != JSON.class && clazz != Collection.class && clazz != List.class) {
            return TypeUtils.cast((Object)this, clazz, ParserConfig.getGlobalInstance());
        }
        return (T)this;
    }

    public <T> T toJavaObject(Type type) {
        return TypeUtils.cast((Object)this, type, ParserConfig.getGlobalInstance());
    }

    public <T> T toJavaObject(TypeReference object) {
        object = object != null ? ((TypeReference)object).getType() : null;
        return TypeUtils.cast((Object)this, (Type)object, ParserConfig.getGlobalInstance());
    }
}

