/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONPath;
import com.tradplus.ads.common.serialization.annotation.JSONField;
import com.tradplus.ads.common.serialization.annotation.JSONType;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;

public class JSONPatch {
    public static String apply(String string, String string2) {
        return JSON.toJSONString(JSONPatch.apply(JSON.parse(string, Feature.OrderedField), string2));
    }

    public static Object apply(Object object, String string) {
        Operation[] operationArray;
        if (JSONPatch.isObject(string)) {
            Operation[] operationArray2 = new Operation[1];
            operationArray = operationArray2;
            operationArray2[0] = JSON.parseObject(string, Operation.class);
        } else {
            operationArray = JSON.parseObject(string, Operation[].class);
        }
        block7: for (Operation operation : operationArray) {
            JSONPath jSONPath = JSONPath.compile(operation.path);
            switch (1.$SwitchMap$com$tradplus$ads$common$serialization$JSONPatch$OperationType[operation.type.ordinal()]) {
                default: {
                    continue block7;
                }
                case 6: {
                    object = jSONPath.eval(object);
                    if (object == null) {
                        return operation.value == null;
                    }
                    return object.equals(operation.value);
                }
                case 4: 
                case 5: {
                    Operation operation2 = operation;
                    JSONPath jSONPath2 = JSONPath.compile(operation2.from);
                    Object object2 = jSONPath2.eval(object);
                    if (operation2.type == OperationType.move && !jSONPath2.remove(object)) {
                        throw new JSONException("json patch move error : " + operation.from + " -> " + operation.path);
                    }
                    jSONPath.set(object, object2);
                    continue block7;
                }
                case 3: {
                    jSONPath.remove(object);
                    continue block7;
                }
                case 2: {
                    jSONPath.patchAdd(object, operation.value, true);
                    continue block7;
                }
                case 1: {
                    jSONPath.patchAdd(object, operation.value, false);
                }
            }
        }
        return object;
    }

    private static boolean isObject(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (JSONLexerBase.isWhitespace(c)) {
                continue;
            }
            return c == '{';
        }
        return false;
    }

    @JSONType(orders={"op", "from", "path", "value"})
    public static class Operation {
        @JSONField(name="op")
        public OperationType type;
        public String from;
        public String path;
        public Object value;
    }

    public static enum OperationType {
        add,
        remove,
        replace,
        move,
        copy,
        test;

    }
}

