/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONStreamContext;
import com.tradplus.ads.common.serialization.TypeReference;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.JSONReaderScanner;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.io.Closeable;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class JSONReader
implements Closeable {
    private final DefaultJSONParser parser;
    private JSONStreamContext context;

    public JSONReader(Reader reader) {
        this(reader, new Feature[0]);
    }

    public JSONReader(Reader reader, Feature ... featureArray) {
        JSONReaderScanner jSONReaderScanner;
        JSONReaderScanner jSONReaderScanner2 = jSONReaderScanner;
        jSONReaderScanner = new JSONReaderScanner(reader);
        this(jSONReaderScanner2);
        int n = featureArray.length;
        for (int i = 0; i < n; ++i) {
            this.jsonCfg(featureArray[i], true);
        }
    }

    public JSONReader(JSONLexer jSONLexer) {
        DefaultJSONParser defaultJSONParser;
        JSONReader jSONReader = closeable;
        Closeable closeable = defaultJSONParser;
        defaultJSONParser = new DefaultJSONParser(jSONLexer);
        jSONReader((DefaultJSONParser)closeable);
    }

    public JSONReader(DefaultJSONParser defaultJSONParser) {
        this.parser = defaultJSONParser;
    }

    private void startStructure() {
        switch (this.context.state) {
            default: {
                throw new JSONException("illegal state : " + this.context.state);
            }
            case 1003: 
            case 1005: {
                this.parser.accept(16);
                break;
            }
            case 1002: {
                this.parser.accept(17);
            }
            case 1001: 
            case 1004: 
        }
    }

    private void endStructure() {
        JSONStreamContext jSONStreamContext;
        this.context = jSONStreamContext = this.context.parent;
        if (jSONStreamContext == null) {
            return;
        }
        int n = -1;
        switch (jSONStreamContext.state) {
            default: {
                break;
            }
            case 1004: {
                n = 1005;
                break;
            }
            case 1002: {
                n = 1003;
                break;
            }
            case 1001: 
            case 1003: {
                n = 1002;
            }
        }
        if (n != -1) {
            jSONStreamContext.state = n;
        }
    }

    private void readBefore() {
        int n = this.context.state;
        switch (n) {
            default: {
                throw new JSONException("illegal state : " + n);
            }
            case 1005: {
                this.parser.accept(16);
                break;
            }
            case 1003: {
                this.parser.accept(16, 18);
                break;
            }
            case 1002: {
                this.parser.accept(17);
            }
            case 1001: 
            case 1004: 
        }
    }

    private void readAfter() {
        JSONStreamContext jSONStreamContext = ((JSONReader)((Object)jSONStreamContext)).context;
        int n = jSONStreamContext.state;
        int n2 = -1;
        switch (n) {
            default: {
                throw new JSONException("illegal state : " + n);
            }
            case 1004: {
                n2 = 1005;
                break;
            }
            case 1002: {
                n2 = 1003;
                break;
            }
            case 1001: 
            case 1003: {
                n2 = 1002;
            }
            case 1005: 
        }
        if (n2 != -1) {
            jSONStreamContext.state = n2;
        }
    }

    public void setTimzeZone(TimeZone timeZone) {
        this.parser.lexer.setTimeZone(timeZone);
    }

    public void setLocale(Locale locale) {
        this.parser.lexer.setLocale(locale);
    }

    public void jsonCfg(Feature feature, boolean bl) {
        this.parser.jsonCfg(feature, bl);
    }

    public Locale getLocal() {
        return this.parser.lexer.getLocale();
    }

    public TimeZone getTimzeZone() {
        return this.parser.lexer.getTimeZone();
    }

    public void startObject() {
        if (this.context == null) {
            JSONStreamContext jSONStreamContext;
            JSONStreamContext jSONStreamContext2 = jSONStreamContext;
            jSONStreamContext = new JSONStreamContext(null, 1001);
            this.context = jSONStreamContext2;
        } else {
            this.startStructure();
            this.context = new JSONStreamContext(this.context, 1001);
        }
        this.parser.accept(12, 18);
    }

    public void endObject() {
        JSONReader jSONReader = this;
        jSONReader.parser.accept(13);
        jSONReader.endStructure();
    }

    public void startArray() {
        if (this.context == null) {
            JSONStreamContext jSONStreamContext;
            JSONStreamContext jSONStreamContext2 = jSONStreamContext;
            jSONStreamContext = new JSONStreamContext(null, 1004);
            this.context = jSONStreamContext2;
        } else {
            this.startStructure();
            this.context = new JSONStreamContext(this.context, 1004);
        }
        this.parser.accept(14);
    }

    public void endArray() {
        JSONReader jSONReader = this;
        jSONReader.parser.accept(15);
        jSONReader.endStructure();
    }

    public boolean hasNext() {
        if (this.context != null) {
            JSONReader jSONReader = this;
            int n = jSONReader.parser.lexer.token();
            int n2 = jSONReader.context.state;
            switch (n2) {
                default: {
                    throw new JSONException("illegal state : " + n2);
                }
                case 1004: 
                case 1005: {
                    return n != 15;
                }
                case 1001: 
                case 1003: 
            }
            return n != 13;
        }
        throw new JSONException("context is null");
    }

    public int peek() {
        return this.parser.lexer.token();
    }

    @Override
    public void close() {
        this.parser.close();
    }

    public Integer readInteger() {
        Object object;
        if (((JSONReader)object).context == null) {
            object = ((JSONReader)object).parser.parse();
        } else {
            JSONReader jSONReader = object;
            jSONReader.readBefore();
            object = jSONReader.parser.parse();
            jSONReader.readAfter();
        }
        return TypeUtils.castToInt(object);
    }

    public Long readLong() {
        Object object;
        if (((JSONReader)object).context == null) {
            object = ((JSONReader)object).parser.parse();
        } else {
            JSONReader jSONReader = object;
            jSONReader.readBefore();
            object = jSONReader.parser.parse();
            jSONReader.readAfter();
        }
        return TypeUtils.castToLong(object);
    }

    public String readString() {
        Object object;
        if (((JSONReader)object).context == null) {
            object = ((JSONReader)object).parser.parse();
        } else {
            JSONReader jSONReader = object;
            jSONReader.readBefore();
            Object object2 = jSONReader.parser.lexer;
            if (jSONReader.context.state == 1001 && object2.token() == 18) {
                Object object3 = object2;
                object2 = object3.stringVal();
                object3.nextToken();
            } else {
                object2 = ((JSONReader)object).parser.parse();
            }
            super.readAfter();
            object = object2;
        }
        return TypeUtils.castToString(object);
    }

    public <T> T readObject(TypeReference<T> typeReference) {
        return this.readObject(typeReference.getType());
    }

    public <T> T readObject(Type type) {
        if (this.context == null) {
            return this.parser.parseObject(type);
        }
        JSONReader jSONReader = this;
        jSONReader.readBefore();
        Object t = jSONReader.parser.parseObject(type);
        this.readAfter();
        return t;
    }

    public <T> T readObject(Class<T> clazz) {
        if (this.context == null) {
            return this.parser.parseObject(clazz);
        }
        JSONReader jSONReader = this;
        jSONReader.readBefore();
        T t = jSONReader.parser.parseObject(clazz);
        this.readAfter();
        return t;
    }

    public void readObject(Object object) {
        if (this.context == null) {
            this.parser.parseObject(object);
            return;
        }
        JSONReader jSONReader = this;
        jSONReader.readBefore();
        jSONReader.parser.parseObject(object);
        jSONReader.readAfter();
    }

    public Object readObject() {
        if (this.context == null) {
            return this.parser.parse();
        }
        JSONReader jSONReader = this;
        jSONReader.readBefore();
        int n = jSONReader.context.state;
        Object object = n != 1001 && n != 1003 ? this.parser.parse() : this.parser.parseKey();
        this.readAfter();
        return object;
    }

    public Object readObject(Map map) {
        if (this.context == null) {
            return this.parser.parseObject(map);
        }
        JSONReader jSONReader = this;
        jSONReader.readBefore();
        Object object = jSONReader.parser.parseObject(map);
        this.readAfter();
        return object;
    }
}

