/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSONException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public abstract class JSONValidator
implements Cloneable,
Closeable {
    protected boolean eof;
    protected int pos = -1;
    protected char ch;
    protected Type type;
    protected int count = 0;
    protected boolean supportMultiValue = true;

    public static JSONValidator fromUtf8(byte[] byArray) {
        return new UTF8Validator(byArray);
    }

    public static JSONValidator fromUtf8(InputStream inputStream) {
        return new UTF8InputStreamValidator(inputStream);
    }

    public static JSONValidator from(String string) {
        return new UTF16Validator(string);
    }

    public static JSONValidator from(Reader reader) {
        return new ReaderValidator(reader);
    }

    /*
     * Unable to fully structure code
     */
    private boolean any() {
        block39: {
            block48: {
                block50: {
                    block49: {
                        block47: {
                            block45: {
                                block46: {
                                    block40: {
                                        block41: {
                                            block42: {
                                                block43: {
                                                    block44: {
                                                        var1_1 = this.ch;
                                                        if (var1_1 == '\"') break block39;
                                                        if (var1_1 == '+' || var1_1 == '-') ** GOTO lbl108
                                                        if (var1_1 == '[') break block40;
                                                        if (var1_1 == 'f') break block41;
                                                        if (var1_1 == 'n') break block42;
                                                        if (var1_1 == 't') break block43;
                                                        if (var1_1 == '{') break block44;
                                                        switch (var1_1) {
                                                            default: {
                                                                return false;
                                                            }
                                                            case '0': 
                                                            case '1': 
                                                            case '2': 
                                                            case '3': 
                                                            case '4': 
                                                            case '5': 
                                                            case '6': 
                                                            case '7': 
                                                            case '8': 
                                                            case '9': {
                                                                if (var1_1 == '-') break block45;
                                                            }
                                                        }
                                                    }
                                                    do {
                                                        this.next();
                                                    } while (JSONValidator.isWhiteSpace(this.ch));
                                                    if (this.ch == '}') lbl-1000:
                                                    // 2 sources

                                                    {
                                                        while (true) {
                                                            this.next();
                                                            v0 = Type.Object;
lbl22:
                                                            // 4 sources

                                                            while (true) {
                                                                this.type = v0;
                                                                return true;
                                                            }
                                                            break;
                                                        }
                                                    }
                                                    while (this.ch == '\"') {
                                                        this.fieldName();
                                                        this.skipWhiteSpace();
                                                        if (this.ch == ':') {
                                                            this.next();
                                                            this.skipWhiteSpace();
                                                            if (!this.any()) {
                                                                return false;
                                                            }
                                                            this.skipWhiteSpace();
                                                            var1_1 = this.ch;
                                                            if (var1_1 == ',') {
                                                                this.next();
                                                                this.skipWhiteSpace();
                                                                continue;
                                                            }
                                                            if (var1_1 != '}') continue;
                                                            ** continue;
                                                        }
                                                        return false;
                                                    }
                                                    return false;
                                                }
                                                this.next();
                                                if (this.ch != 'r') {
                                                    return false;
                                                }
                                                this.next();
                                                if (this.ch != 'u') {
                                                    return false;
                                                }
                                                this.next();
                                                if (this.ch != 'e') {
                                                    return false;
                                                }
                                                this.next();
                                                if (!JSONValidator.isWhiteSpace(this.ch) && (var1_1 = this.ch) != ',' && var1_1 != ']' && var1_1 != '}' && var1_1 != '\u0000') {
                                                    return false;
                                                }
lbl56:
                                                // 4 sources

                                                while (true) {
                                                    v0 = Type.Value;
                                                    ** GOTO lbl22
                                                    break;
                                                }
                                            }
                                            this.next();
                                            if (this.ch != 'u') {
                                                return false;
                                            }
                                            this.next();
                                            if (this.ch != 'l') {
                                                return false;
                                            }
                                            this.next();
                                            if (this.ch != 'l') {
                                                return false;
                                            }
                                            this.next();
                                            if (JSONValidator.isWhiteSpace(this.ch) || (var1_1 = this.ch) == ',' || var1_1 == ']' || var1_1 == '}' || var1_1 == '\u0000') ** GOTO lbl56
                                            return false;
                                        }
                                        this.next();
                                        if (this.ch != 'a') {
                                            return false;
                                        }
                                        this.next();
                                        if (this.ch != 'l') {
                                            return false;
                                        }
                                        this.next();
                                        if (this.ch != 's') {
                                            return false;
                                        }
                                        this.next();
                                        if (this.ch != 'e') {
                                            return false;
                                        }
                                        this.next();
                                        ** while (JSONValidator.isWhiteSpace((char)this.ch) || (var1_1 = this.ch) == ',' || var1_1 == ']' || var1_1 == '}' || var1_1 == '\u0000')
lbl87:
                                        // 1 sources

                                        return false;
                                    }
                                    this.next();
                                    this.skipWhiteSpace();
                                    if (this.ch != ']') break block46;
lbl92:
                                    // 2 sources

                                    while (true) {
                                        this.next();
                                        v0 = Type.Array;
                                        ** GOTO lbl22
                                        break;
                                    }
                                }
                                while (true) {
                                    if (!this.any()) {
                                        return false;
                                    }
                                    this.skipWhiteSpace();
                                    var1_1 = this.ch;
                                    if (var1_1 != ',') break;
                                    this.next();
                                    this.skipWhiteSpace();
                                }
                                ** while (var1_1 == ']')
lbl107:
                                // 1 sources

                                return false;
lbl108:
                                // 1 sources

                                if (var1_1 == '-') break block45;
                                if (var1_1 != '+') break block47;
                            }
                            this.next();
                            this.skipWhiteSpace();
                            var1_1 = this.ch;
                            if (var1_1 < '0' || var1_1 > '9') break block48;
                        }
                        do {
                            this.next();
                        } while ((var1_1 = this.ch) >= '0' && var1_1 <= '9');
                        if (var1_1 == '.') {
                            this.next();
                            var1_1 = this.ch;
                            if (var1_1 >= '0' && var1_1 <= '9') {
                                while ((var1_1 = this.ch) >= '0' && var1_1 <= '9') {
                                    this.next();
                                }
                            } else {
                                return false;
                            }
                        }
                        if ((var1_1 = this.ch) != 'e' && var1_1 != 'E') break block49;
                        this.next();
                        var1_1 = this.ch;
                        if (var1_1 == '-' || var1_1 == '+') {
                            this.next();
                        }
                        if ((var1_1 = this.ch) < '0' || var1_1 > '9') break block50;
                        do {
                            this.next();
                            var1_1 = this.ch;
                        } while (var1_1 >= '0' && var1_1 <= '9');
                    }
                    this.type = Type.Value;
                    return true;
                }
                return false;
            }
            return false;
        }
        block13: while (true) {
            this.next();
            while (true) {
                if (this.eof) {
                    return false;
                }
                var1_1 = this.ch;
                if (var1_1 != '\\') break;
                this.next();
                if (this.ch != 'u') continue block13;
                this.next();
                this.next();
                this.next();
                this.next();
                this.next();
            }
            if (var1_1 == '\"') break;
        }
        this.next();
        v0 = Type.Value;
        ** while (true)
    }

    static final boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f' || c == '\b';
    }

    public boolean isSupportMultiValue() {
        return this.supportMultiValue;
    }

    public void setSupportMultiValue(boolean bl) {
        this.supportMultiValue = bl;
    }

    public Type getType() {
        if (this.type == null) {
            this.validate();
        }
        return this.type;
    }

    abstract void next();

    public boolean validate() {
        block3: {
            JSONValidator jSONValidator;
            do {
                if (!this.any()) {
                    return false;
                }
                JSONValidator jSONValidator2 = this;
                ++jSONValidator2.count;
                if (jSONValidator2.eof) {
                    return true;
                }
                if (!this.supportMultiValue) break block3;
                jSONValidator = this;
                jSONValidator.skipWhiteSpace();
            } while (!jSONValidator.eof);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
    }

    protected void fieldName() {
        this.next();
        while (true) {
            char c;
            if ((c = this.ch) == '\\') {
                JSONValidator jSONValidator = this;
                jSONValidator.next();
                if (jSONValidator.ch == 'u') {
                    JSONValidator jSONValidator2 = this;
                    jSONValidator2.next();
                    jSONValidator2.next();
                    jSONValidator2.next();
                    jSONValidator2.next();
                    jSONValidator2.next();
                    continue;
                }
            } else if (c == '\"') {
                this.next();
                return;
            }
            this.next();
        }
    }

    protected boolean string() {
        this.next();
        while (!this.eof) {
            char c = this.ch;
            if (c == '\\') {
                JSONValidator jSONValidator = this;
                jSONValidator.next();
                if (jSONValidator.ch == 'u') {
                    JSONValidator jSONValidator2 = this;
                    jSONValidator2.next();
                    jSONValidator2.next();
                    jSONValidator2.next();
                    jSONValidator2.next();
                    jSONValidator2.next();
                    continue;
                }
            } else if (c == '\"') {
                this.next();
                return true;
            }
            this.next();
        }
        return false;
    }

    void skipWhiteSpace() {
        while (JSONValidator.isWhiteSpace(this.ch)) {
            this.next();
        }
    }

    static class UTF8Validator
    extends JSONValidator {
        private final byte[] bytes;

        public UTF8Validator(byte[] byArray) {
            UTF8Validator uTF8Validator = this;
            uTF8Validator.bytes = byArray;
            uTF8Validator.next();
            uTF8Validator.skipWhiteSpace();
        }

        @Override
        void next() {
            int n = this.pos + 1;
            UTF8Validator uTF8Validator = this;
            uTF8Validator.pos = n;
            byte[] byArray = uTF8Validator.bytes;
            if (n >= uTF8Validator.bytes.length) {
                UTF8Validator uTF8Validator2 = this;
                uTF8Validator2.ch = '\u0000';
                uTF8Validator2.eof = true;
            } else {
                this.ch = (char)byArray[n];
            }
        }
    }

    static class UTF8InputStreamValidator
    extends JSONValidator {
        private static final ThreadLocal<byte[]> bufLocal = new ThreadLocal();
        private final InputStream is;
        private byte[] buf;
        private int end = -1;
        private int readCount = 0;

        public UTF8InputStreamValidator(InputStream object) {
            this.is = object;
            object = bufLocal;
            this.buf = ((ThreadLocal)object).get();
            if (this.buf != null) {
                ((ThreadLocal)object).set(null);
            } else {
                this.buf = new byte[8192];
            }
            UTF8InputStreamValidator uTF8InputStreamValidator = this;
            uTF8InputStreamValidator.next();
            uTF8InputStreamValidator.skipWhiteSpace();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        void next() {
            int n;
            block6: {
                byte[] byArray;
                InputStream inputStream;
                n = this.pos;
                if (n < this.end) {
                    this.pos = n + 1;
                    this.ch = (char)this.buf[this.pos];
                    return;
                }
                if (this.eof) return;
                try {
                    inputStream = this.is;
                    byArray = this.buf;
                    n = 0;
                }
                catch (IOException iOException) {
                    throw new JSONException("read error");
                }
                {
                    n = inputStream.read(this.buf, n, byArray.length);
                }
                {
                    ++this.readCount;
                    if (n <= 0) break block6;
                }
                this.ch = (char)this.buf[0];
                this.pos = 0;
                this.end = n - 1;
                return;
            }
            if (n == -1) {
                this.pos = 0;
                this.end = 0;
                this.buf = null;
                this.ch = '\u0000';
                this.eof = true;
                return;
            }
            this.pos = 0;
            this.end = 0;
            this.buf = null;
            this.ch = '\u0000';
            this.eof = true;
            throw new JSONException("read error");
        }

        @Override
        public void close() {
            bufLocal.set(this.buf);
            this.is.close();
        }
    }

    static class UTF16Validator
    extends JSONValidator {
        private final String str;

        public UTF16Validator(String string) {
            UTF16Validator uTF16Validator = this;
            uTF16Validator.str = string;
            uTF16Validator.next();
            uTF16Validator.skipWhiteSpace();
        }

        @Override
        void next() {
            int n;
            this.pos = n = this.pos + 1;
            if (n >= this.str.length()) {
                UTF16Validator uTF16Validator = this;
                uTF16Validator.ch = '\u0000';
                uTF16Validator.eof = true;
            } else {
                this.ch = this.str.charAt(this.pos);
            }
        }

        @Override
        protected final void fieldName() {
            char c;
            int n;
            for (n = this.pos + 1; n < this.str.length() && (c = this.str.charAt(n)) != '\\'; ++n) {
                if (c != '\"') continue;
                int n2 = n + 1;
                this.ch = this.str.charAt(n2);
                this.pos = n2;
                return;
            }
            block1: while (true) {
                this.next();
                while (true) {
                    char c2 = this.ch;
                    n = c2;
                    if (c2 != '\\') break;
                    UTF16Validator uTF16Validator = this;
                    uTF16Validator.next();
                    if (uTF16Validator.ch != 'u') continue block1;
                    UTF16Validator uTF16Validator2 = this;
                    uTF16Validator2.next();
                    uTF16Validator2.next();
                    uTF16Validator2.next();
                    uTF16Validator2.next();
                    uTF16Validator2.next();
                }
                if (n == 34) break;
            }
            this.next();
        }

        @Override
        final void skipWhiteSpace() {
            if (this.ch > '\r') {
                return;
            }
            while (JSONValidator.isWhiteSpace(this.ch)) {
                this.next();
            }
        }
    }

    static class ReaderValidator
    extends JSONValidator {
        private static final ThreadLocal<char[]> bufLocal = new ThreadLocal();
        final Reader r;
        private char[] buf;
        private int end = -1;
        private int readCount = 0;

        ReaderValidator(Reader object) {
            this.r = object;
            object = bufLocal;
            this.buf = ((ThreadLocal)object).get();
            if (this.buf != null) {
                ((ThreadLocal)object).set(null);
            } else {
                this.buf = new char[8192];
            }
            ReaderValidator readerValidator = this;
            readerValidator.next();
            readerValidator.skipWhiteSpace();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        void next() {
            int n;
            block6: {
                char[] cArray;
                Reader reader;
                n = this.pos;
                if (n < this.end) {
                    this.pos = n + 1;
                    this.ch = this.buf[this.pos];
                    return;
                }
                if (this.eof) return;
                try {
                    reader = this.r;
                    cArray = this.buf;
                    n = 0;
                }
                catch (IOException iOException) {
                    throw new JSONException("read error");
                }
                {
                    n = reader.read(this.buf, n, cArray.length);
                }
                {
                    ++this.readCount;
                    if (n <= 0) break block6;
                }
                this.ch = this.buf[0];
                this.pos = 0;
                this.end = n - 1;
                return;
            }
            if (n == -1) {
                this.pos = 0;
                this.end = 0;
                this.buf = null;
                this.ch = '\u0000';
                this.eof = true;
                return;
            }
            this.pos = 0;
            this.end = 0;
            this.buf = null;
            this.ch = '\u0000';
            this.eof = true;
            throw new JSONException("read error");
        }

        @Override
        public void close() {
            bufLocal.set(this.buf);
            this.r.close();
        }
    }

    public static enum Type {
        Object,
        Array,
        Value;

    }
}

