/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONStreamContext;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import java.io.Closeable;
import java.io.Flushable;
import java.io.Writer;

public class JSONWriter
implements Closeable,
Flushable {
    private SerializeWriter writer;
    private JSONSerializer serializer;
    private JSONStreamContext context;

    public JSONWriter(Writer object) {
        JSONSerializer jSONSerializer;
        SerializeWriter serializeWriter;
        Closeable closeable = serializeWriter;
        serializeWriter = new SerializeWriter((Writer)object);
        v1.writer = closeable;
        object = jSONSerializer;
        jSONSerializer = new JSONSerializer((SerializeWriter)closeable);
        v1.serializer = object;
    }

    private void beginStructure() {
        int n = this.context.state;
        switch (n) {
            default: {
                throw new JSONException("illegal state : " + n);
            }
            case 1005: {
                this.writer.write(44);
                break;
            }
            case 1002: {
                this.writer.write(58);
            }
            case 1001: 
            case 1004: 
        }
    }

    private void endStructure() {
        JSONStreamContext jSONStreamContext;
        this.context = jSONStreamContext = this.context.parent;
        if (jSONStreamContext == null) {
            return;
        }
        int n = -1;
        switch (jSONStreamContext.state) {
            default: {
                break;
            }
            case 1004: {
                n = 1005;
                break;
            }
            case 1002: {
                n = 1003;
                break;
            }
            case 1001: {
                n = 1002;
            }
        }
        if (n != -1) {
            jSONStreamContext.state = n;
        }
    }

    private void beforeWrite() {
        JSONStreamContext jSONStreamContext = this.context;
        if (jSONStreamContext == null) {
            return;
        }
        switch (jSONStreamContext.state) {
            default: {
                break;
            }
            case 1003: 
            case 1005: {
                this.writer.write(44);
                break;
            }
            case 1002: {
                this.writer.write(58);
            }
        }
    }

    private void afterWrite() {
        JSONStreamContext jSONStreamContext = ((JSONWriter)((Object)jSONStreamContext)).context;
        if (jSONStreamContext == null) {
            return;
        }
        int n = -1;
        switch (jSONStreamContext.state) {
            default: {
                break;
            }
            case 1004: {
                n = 1005;
                break;
            }
            case 1002: {
                n = 1003;
                break;
            }
            case 1001: 
            case 1003: {
                n = 1002;
            }
        }
        if (n != -1) {
            jSONStreamContext.state = n;
        }
    }

    public void jsonCfg(SerializerFeature serializerFeature, boolean bl) {
        this.writer.jsonCfg(serializerFeature, bl);
    }

    public void startObject() {
        if (this.context != null) {
            this.beginStructure();
        }
        this.context = new JSONStreamContext(this.context, 1001);
        this.writer.write(123);
    }

    public void endObject() {
        JSONWriter jSONWriter = this;
        jSONWriter.writer.write(125);
        jSONWriter.endStructure();
    }

    public void writeKey(String string) {
        this.writeObject(string);
    }

    public void writeValue(Object object) {
        this.writeObject(object);
    }

    public void writeObject(String string) {
        JSONWriter jSONWriter = this;
        jSONWriter.beforeWrite();
        jSONWriter.serializer.write(string);
        jSONWriter.afterWrite();
    }

    public void writeObject(Object object) {
        JSONWriter jSONWriter = this;
        jSONWriter.beforeWrite();
        jSONWriter.serializer.write(object);
        jSONWriter.afterWrite();
    }

    public void startArray() {
        if (this.context != null) {
            this.beginStructure();
        }
        this.context = new JSONStreamContext(this.context, 1004);
        this.writer.write(91);
    }

    public void endArray() {
        JSONWriter jSONWriter = this;
        jSONWriter.writer.write(93);
        jSONWriter.endStructure();
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Deprecated
    public void writeStartObject() {
        this.startObject();
    }

    @Deprecated
    public void writeEndObject() {
        this.endObject();
    }

    @Deprecated
    public void writeStartArray() {
        this.startArray();
    }

    @Deprecated
    public void writeEndArray() {
        this.endArray();
    }
}

