/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.JSONToken;
import com.tradplus.ads.common.serialization.parser.SymbolTable;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public abstract class JSONLexerBase
implements JSONLexer,
Closeable {
    private static final ThreadLocal<char[]> SBUF_LOCAL = new ThreadLocal();
    protected static final char[] typeFieldName = ("\"" + JSON.DEFAULT_TYPE_KEY + "\":\"").toCharArray();
    protected static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    protected static final int INT_MULTMIN_RADIX_TEN = -214748364;
    protected static final int[] digits = new int[103];
    protected int token;
    protected int pos;
    protected int features;
    protected char ch;
    protected int bp;
    protected int eofPos;
    protected char[] sbuf;
    protected int sp;
    protected int np;
    protected boolean hasSpecial;
    protected Calendar calendar = null;
    protected TimeZone timeZone = JSON.defaultTimeZone;
    protected Locale locale = JSON.defaultLocale;
    public int matchStat = 0;
    protected String stringDefaultValue = null;
    protected int nanos = 0;

    public JSONLexerBase(int n) {
        this.features = n;
        if ((n & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.stringDefaultValue = "";
        }
        if ((this.sbuf = SBUF_LOCAL.get()) == null) {
            this.sbuf = new char[512];
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String readString(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5;
            int n6 = cArray[n3];
            if (n6 != 92) {
                n5 = n2 + 1;
                cArray2[n2] = n6;
                n4 = n5;
            } else {
                n6 = cArray[++n3];
                block0 : switch (n6) {
                    default: {
                        switch (n6) {
                            default: {
                                switch (n6) {
                                    default: {
                                        throw new JSONException("unclosed.str.lit");
                                    }
                                    case 118: {
                                        n6 = n2 + 1;
                                        cArray2[n2] = 11;
                                        break block0;
                                    }
                                    case 117: {
                                        n6 = n2 + 1;
                                        char[] cArray3 = new char[4];
                                        char[] cArray4 = cArray3;
                                        cArray4[0] = cArray[++n3];
                                        cArray4[1] = cArray[++n3];
                                        cArray4[2] = cArray[++n3];
                                        cArray3[3] = cArray[++n3];
                                        cArray2[n2] = n5 = (int)((char)Integer.parseInt(new String(cArray3), 16));
                                        break block0;
                                    }
                                    case 116: 
                                }
                                n6 = n2 + 1;
                                cArray2[n2] = 9;
                                break block0;
                            }
                            case 55: {
                                n6 = n2 + 1;
                                cArray2[n2] = 7;
                                break block0;
                            }
                            case 54: {
                                n6 = n2 + 1;
                                cArray2[n2] = 6;
                                break block0;
                            }
                            case 53: {
                                n6 = n2 + 1;
                                cArray2[n2] = 5;
                                break block0;
                            }
                            case 52: {
                                n6 = n2 + 1;
                                cArray2[n2] = 4;
                                break block0;
                            }
                            case 51: {
                                n6 = n2 + 1;
                                cArray2[n2] = 3;
                                break block0;
                            }
                            case 50: {
                                n6 = n2 + 1;
                                cArray2[n2] = 2;
                                break block0;
                            }
                            case 49: {
                                n6 = n2 + 1;
                                cArray2[n2] = '\u0001';
                                break block0;
                            }
                            case 48: {
                                n6 = n2 + 1;
                                cArray2[n2] = '\u0000';
                                break block0;
                            }
                            case 47: 
                        }
                        n6 = n2 + 1;
                        cArray2[n2] = 47;
                        break;
                    }
                    case 120: {
                        n6 = n2 + 1;
                        int[] nArray = digits;
                        n3 = n3 + 1;
                        cArray2[n2] = n5 = (int)((char)(digits[cArray[n3]] * 16 + nArray[cArray[++n3]]));
                        break;
                    }
                    case 114: {
                        n6 = n2 + 1;
                        cArray2[n2] = 13;
                        break;
                    }
                    case 110: {
                        n6 = n2 + 1;
                        cArray2[n2] = 10;
                        break;
                    }
                    case 98: {
                        n6 = n2 + 1;
                        cArray2[n2] = 8;
                        break;
                    }
                    case 92: {
                        n6 = n2 + 1;
                        cArray2[n2] = 92;
                        break;
                    }
                    case 70: 
                    case 102: {
                        n6 = n2 + 1;
                        cArray2[n2] = 12;
                        break;
                    }
                    case 39: {
                        n6 = n2 + 1;
                        cArray2[n2] = 39;
                        break;
                    }
                    case 34: {
                        n6 = n2 + 1;
                        cArray2[n2] = 34;
                    }
                }
                n4 = n6;
            }
            n2 = n4;
            ++n3;
        }
        return new String(cArray2, 0, n2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void scanStringSingleQuote() {
        this.np = this.bp;
        this.hasSpecial = false;
        while (true) {
            int n;
            char c;
            block41: {
                int n2;
                JSONLexerBase jSONLexerBase;
                block39: {
                    block40: {
                        block38: {
                            if ((c = this.next()) == '\'') {
                                this.token = 4;
                                this.next();
                                return;
                            }
                            if (c != '\u001a') break block38;
                            if (this.isEOF()) {
                                throw new JSONException("unclosed single-quote string");
                            }
                            jSONLexerBase = this;
                            n2 = 26;
                            break block39;
                        }
                        if (c != '\\') break block40;
                        if (!this.hasSpecial) {
                            this.hasSpecial = true;
                            int n3 = this.sp;
                            char[] cArray = this.sbuf;
                            if (n3 > this.sbuf.length) {
                                char[] cArray2 = new char[n3 * 2];
                                int n4 = cArray.length;
                                System.arraycopy(cArray, 0, cArray2, 0, n4);
                                this.sbuf = cArray2;
                            }
                            int n5 = this.sp;
                            cArray = this.sbuf;
                            this.copyTo(this.np + 1, n5, cArray);
                        }
                        c = this.next();
                        block0 : switch (c) {
                            default: {
                                switch (c) {
                                    default: {
                                        switch (c) {
                                            default: {
                                                this.ch = c;
                                                throw new JSONException("unclosed single-quote string");
                                            }
                                            case 'v': {
                                                jSONLexerBase = this;
                                                n2 = 11;
                                                break block0;
                                            }
                                            case 'u': {
                                                n2 = (char)Integer.parseInt(new String(new char[]{this.next(), this.next(), this.next(), this.next()}), 16);
                                                jSONLexerBase = this;
                                                break block0;
                                            }
                                            case 't': 
                                        }
                                        jSONLexerBase = this;
                                        n2 = 9;
                                        break block0;
                                    }
                                    case '7': {
                                        jSONLexerBase = this;
                                        n2 = 7;
                                        break block0;
                                    }
                                    case '6': {
                                        jSONLexerBase = this;
                                        n2 = 6;
                                        break block0;
                                    }
                                    case '5': {
                                        jSONLexerBase = this;
                                        n2 = 5;
                                        break block0;
                                    }
                                    case '4': {
                                        jSONLexerBase = this;
                                        n2 = 4;
                                        break block0;
                                    }
                                    case '3': {
                                        jSONLexerBase = this;
                                        n2 = 3;
                                        break block0;
                                    }
                                    case '2': {
                                        jSONLexerBase = this;
                                        n2 = 2;
                                        break block0;
                                    }
                                    case '1': {
                                        jSONLexerBase = this;
                                        n2 = 1;
                                        break block0;
                                    }
                                    case '0': {
                                        jSONLexerBase = this;
                                        n2 = 0;
                                        break block0;
                                    }
                                    case '/': 
                                }
                                jSONLexerBase = this;
                                n2 = 47;
                                break;
                            }
                            case 'x': {
                                void var3_13;
                                c = this.next();
                                char c2 = this.next();
                                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                                    boolean bl = true;
                                } else {
                                    boolean bl = false;
                                }
                                boolean bl = c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F';
                                if (var3_13 != false && bl) {
                                    int[] nArray = digits;
                                    n2 = (char)(digits[c] * 16 + nArray[c2]);
                                    jSONLexerBase = this;
                                    break;
                                }
                                throw new JSONException("invalid escape character \\x" + c + c2);
                            }
                            case 'r': {
                                jSONLexerBase = this;
                                n2 = 13;
                                break;
                            }
                            case 'n': {
                                jSONLexerBase = this;
                                n2 = 10;
                                break;
                            }
                            case 'b': {
                                jSONLexerBase = this;
                                n2 = 8;
                                break;
                            }
                            case '\\': {
                                jSONLexerBase = this;
                                n2 = 92;
                                break;
                            }
                            case 'F': 
                            case 'f': {
                                jSONLexerBase = this;
                                n2 = 12;
                                break;
                            }
                            case '\'': {
                                jSONLexerBase = this;
                                n2 = 39;
                                break;
                            }
                            case '\"': {
                                jSONLexerBase = this;
                                n2 = 34;
                                break;
                            }
                        }
                        break block39;
                    }
                    if (!this.hasSpecial) {
                        ++this.sp;
                        continue;
                    }
                    n = this.sp;
                    char[] cArray = this.sbuf;
                    if (n != this.sbuf.length) break block41;
                    jSONLexerBase = this;
                    n2 = c;
                }
                jSONLexerBase.putChar((char)n2);
                continue;
            }
            this.sp = n + 1;
            cArray[n] = c;
        }
    }

    public static boolean isWhitespace(char c) {
        return c <= ' ' && (c == ' ' || c == '\n' || c == '\r' || c == '\t' || c == '\f' || c == '\b');
    }

    static {
        int n = 48;
        while (n <= 57) {
            int n2 = n++;
            JSONLexerBase.digits[n2] = n2 - 48;
        }
        n = 97;
        while (n <= 102) {
            int n3 = n++;
            JSONLexerBase.digits[n3] = n3 - 97 + 10;
        }
        n = 65;
        while (n <= 70) {
            int n4 = n++;
            JSONLexerBase.digits[n4] = n4 - 65 + 10;
        }
    }

    protected void lexError(String string, Object ... objectArray) {
        this.token = 1;
    }

    public final int matchStat() {
        return this.matchStat;
    }

    public void setToken(int n) {
        this.token = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void nextToken() {
        this.sp = 0;
        while (true) {
            block26: {
                this.pos = this.bp;
                int n = this.ch;
                if (n == 47) {
                    this.skipComment();
                    continue;
                }
                if (n == 34) {
                    this.scanString();
                    return;
                }
                if (n == 44) {
                    this.next();
                    this.token = 16;
                    return;
                }
                if (n >= 48 && n <= 57) {
                    this.scanNumber();
                    return;
                }
                if (n == 45) {
                    this.scanNumber();
                    return;
                }
                switch (n) {
                    default: {
                        if (!this.isEOF()) break;
                        if (this.token == 20) throw new JSONException("EOF error");
                        this.token = 20;
                        this.pos = n = this.bp;
                        this.eofPos = n;
                        return;
                    }
                    case 125: {
                        this.next();
                        this.token = 13;
                        return;
                    }
                    case 123: {
                        this.next();
                        this.token = 12;
                        return;
                    }
                    case 120: {
                        this.scanHex();
                        return;
                    }
                    case 116: {
                        this.scanTrue();
                        return;
                    }
                    case 110: {
                        this.scanNullOrNew();
                        return;
                    }
                    case 102: {
                        this.scanFalse();
                        return;
                    }
                    case 93: {
                        this.next();
                        this.token = 15;
                        return;
                    }
                    case 91: {
                        this.next();
                        this.token = 14;
                        return;
                    }
                    case 78: 
                    case 83: 
                    case 84: 
                    case 117: {
                        this.scanIdent();
                        return;
                    }
                    case 59: {
                        this.next();
                        this.token = 24;
                        return;
                    }
                    case 58: {
                        this.next();
                        this.token = 17;
                        return;
                    }
                    case 46: {
                        this.next();
                        this.token = 25;
                        return;
                    }
                    case 43: {
                        this.next();
                        this.scanNumber();
                        return;
                    }
                    case 41: {
                        this.next();
                        this.token = 11;
                        return;
                    }
                    case 40: {
                        this.next();
                        this.token = 10;
                        return;
                    }
                    case 39: {
                        if (!this.isEnabled(Feature.AllowSingleQuotes)) throw new JSONException("Feature.AllowSingleQuotes is false");
                        this.scanStringSingleQuote();
                        return;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 32: {
                        break block26;
                    }
                }
                n = this.ch;
                if (n > 31 && n != 127) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = String.valueOf(n);
                    this.lexError("illegal.char", objectArray2);
                    this.next();
                    return;
                }
            }
            this.next();
        }
    }

    @Override
    public final void nextToken(int n) {
        this.sp = 0;
        while (true) {
            char c;
            block30: {
                block25: {
                    block26: {
                        block27: {
                            block28: {
                                block29: {
                                    if (n == 2) break block25;
                                    if (n == 4) break block26;
                                    if (n == 12) break block27;
                                    if (n == 18) break block28;
                                    if (n == 20) break block29;
                                    switch (n) {
                                        default: {
                                            break block30;
                                        }
                                        case 16: {
                                            c = this.ch;
                                            if (c == ',') {
                                                this.token = 16;
                                                this.next();
                                                return;
                                            }
                                            if (c == '}') {
                                                this.token = 13;
                                                this.next();
                                                return;
                                            }
                                            if (c == ']') {
                                                this.token = 15;
                                                this.next();
                                                return;
                                            }
                                            if (c == '\u001a') {
                                                this.token = 20;
                                                return;
                                            }
                                            if (c == 'n') {
                                                this.scanNullOrNew(false);
                                                return;
                                            }
                                            break block30;
                                        }
                                        case 15: {
                                            if (this.ch != ']') break;
                                            this.token = 15;
                                            this.next();
                                            return;
                                        }
                                        case 14: {
                                            c = this.ch;
                                            if (c == '[') {
                                                this.token = 14;
                                                this.next();
                                                return;
                                            }
                                            if (c == '{') {
                                                this.token = 12;
                                                this.next();
                                                return;
                                            }
                                            break block30;
                                        }
                                    }
                                }
                                if (this.ch == '\u001a') {
                                    this.token = 20;
                                    return;
                                }
                                break block30;
                            }
                            this.nextIdent();
                            return;
                        }
                        c = this.ch;
                        if (c == '{') {
                            this.token = 12;
                            this.next();
                            return;
                        }
                        if (c == '[') {
                            this.token = 14;
                            this.next();
                            return;
                        }
                        break block30;
                    }
                    c = this.ch;
                    if (c == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (c >= '0' && c <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (c == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (c == '{') {
                        this.token = 12;
                        this.next();
                        return;
                    }
                    break block30;
                }
                c = this.ch;
                if (c >= '0' && c <= '9') {
                    this.pos = this.bp;
                    this.scanNumber();
                    return;
                }
                if (c == '\"') {
                    this.pos = this.bp;
                    this.scanString();
                    return;
                }
                if (c == '[') {
                    this.token = 14;
                    this.next();
                    return;
                }
                if (c == '{') {
                    this.token = 12;
                    this.next();
                    return;
                }
            }
            c = this.ch;
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '\f' && c != '\b') {
                this.nextToken();
                return;
            }
            this.next();
        }
    }

    public final void nextIdent() {
        while (JSONLexerBase.isWhitespace(this.ch)) {
            this.next();
        }
        char c = this.ch;
        if (c != '_' && c != '$' && !Character.isLetter(c)) {
            this.nextToken();
        } else {
            this.scanIdent();
        }
    }

    @Override
    public final void nextTokenWithColon() {
        this.nextTokenWithChar(':');
    }

    public final void nextTokenWithChar(char c) {
        this.sp = 0;
        while (true) {
            char c2;
            if ((c2 = this.ch) == c) {
                JSONLexerBase jSONLexerBase = this;
                jSONLexerBase.next();
                jSONLexerBase.nextToken();
                return;
            }
            if (c2 != ' ' && c2 != '\n' && c2 != '\r' && c2 != '\t' && c2 != '\f' && c2 != '\b') {
                throw new JSONException("not match " + c + " - " + this.ch + ", info : " + this.info());
            }
            this.next();
        }
    }

    @Override
    public final int token() {
        return this.token;
    }

    @Override
    public final String tokenName() {
        return JSONToken.name(this.token);
    }

    @Override
    public final int pos() {
        return this.pos;
    }

    public final String stringDefaultValue() {
        return this.stringDefaultValue;
    }

    @Override
    public final Number integerValue() {
        long l;
        long l2 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        JSONLexerBase jSONLexerBase = this;
        int n = jSONLexerBase.np;
        int n2 = n + this.sp;
        int n3 = 32;
        char c = jSONLexerBase.charAt(n2 - 1);
        if (c != 'B') {
            if (c != 'L') {
                if (c == 'S') {
                    --n2;
                    n3 = 83;
                }
            } else {
                --n2;
                n3 = 76;
            }
        } else {
            --n2;
            n3 = 66;
        }
        JSONLexerBase jSONLexerBase2 = this;
        if (jSONLexerBase2.charAt(jSONLexerBase2.np) == '-') {
            bl = true;
            l = Long.MIN_VALUE;
            ++n;
        } else {
            l = -9223372036854775807L;
        }
        long l3 = -922337203685477580L;
        if (n < n2) {
            l2 = -(this.charAt(n++) - 48);
        }
        while (n < n2) {
            int n4 = this.charAt(n++) - 48;
            if (l2 < l3) {
                return new BigInteger(this.numberString(), 10);
            }
            long l4 = n4;
            if ((l2 *= 10L) < l + l4) {
                return new BigInteger(this.numberString(), 10);
            }
            l2 -= l4;
        }
        if (bl) {
            if (n > this.np + 1) {
                if (l2 >= Integer.MIN_VALUE && n3 != 76) {
                    if (n3 == 83) {
                        return (short)l2;
                    }
                    if (n3 == 66) {
                        return (byte)l2;
                    }
                    return (int)l2;
                }
                return l2;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((l2 = -l2) <= Integer.MAX_VALUE && n3 != 76) {
            if (n3 == 83) {
                return (short)l2;
            }
            if (n3 == 66) {
                return (byte)l2;
            }
            return (int)l2;
        }
        return l2;
    }

    @Override
    public final void nextTokenWithColon(int n) {
        this.nextTokenWithChar(':');
    }

    @Override
    public float floatValue() {
        char c;
        float f = Float.parseFloat((String)(this = ((JSONLexerBase)this).numberString()));
        if ((f == 0.0f || f == Float.POSITIVE_INFINITY) && (c = ((String)this).charAt(0)) > '0' && c <= '9') {
            throw new JSONException("float overflow : " + (String)this);
        }
        return f;
    }

    public double doubleValue() {
        return Double.parseDouble(this.numberString());
    }

    @Override
    public void jsonCfg(Feature feature, boolean bl) {
        this.features = Feature.jsonCfg(this.features, feature, bl);
        if ((this.features & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.stringDefaultValue = "";
        }
    }

    @Override
    public final boolean isEnabled(Feature feature) {
        return this.isEnabled(feature.mask);
    }

    @Override
    public final boolean isEnabled(int n) {
        return (this.features & n) != 0;
    }

    public final boolean isEnabled(int n, int n2) {
        return (this.features & n2) != 0 || (n & n2) != 0;
    }

    @Override
    public abstract String numberString();

    public abstract boolean isEOF();

    @Override
    public final char getCurrent() {
        return this.ch;
    }

    public abstract char charAt(int var1);

    @Override
    public abstract char next();

    /*
     * Enabled aggressive block sorting
     */
    protected void skipComment() {
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.next();
        char c = jSONLexerBase.ch;
        if (c != '/') {
            if (c != '*') {
                throw new JSONException("invalid comment");
            }
            block0: while (true) {
                JSONLexerBase jSONLexerBase2;
                this.next();
                do {
                    if ((c = this.ch) == '\u001a') {
                        return;
                    }
                    if (c != '*') continue block0;
                    jSONLexerBase2 = this;
                    jSONLexerBase2.next();
                } while (jSONLexerBase2.ch != '/');
                break;
            }
            this.next();
            return;
        }
        do {
            JSONLexerBase jSONLexerBase3 = this;
            jSONLexerBase3.next();
            c = jSONLexerBase3.ch;
            if (c != '\n') continue;
            this.next();
            return;
        } while (c != '\u001a');
    }

    @Override
    public final String scanSymbol(SymbolTable symbolTable) {
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.skipWhitespace();
        char c = jSONLexerBase.ch;
        if (c == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (c == '\'') {
            if (this.isEnabled(Feature.AllowSingleQuotes)) {
                return this.scanSymbol(symbolTable, '\'');
            }
            throw new JSONException("syntax error");
        }
        if (c == '}') {
            this.next();
            this.token = 13;
            return null;
        }
        if (c == ',') {
            this.next();
            this.token = 16;
            return null;
        }
        if (c == '\u001a') {
            this.token = 20;
            return null;
        }
        if (this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
            return this.scanSymbolUnQuoted(symbolTable);
        }
        throw new JSONException("syntax error");
    }

    protected abstract void arrayCopy(int var1, char[] var2, int var3, int var4);

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final String scanSymbol(SymbolTable var1_1, char var2_2) {
        var3_3 = 0;
        this.np = this.bp;
        this.sp = 0;
        var4_4 = 0;
        block26: while (true) {
            if ((var5_5 = this.next()) == var2_2) {
                this.token = 4;
                if (var4_4 == 0) {
                    v0 = this.np;
                    var2_2 = (char)v0;
                    var2_2 = v0 == -1 ? '\u0000' : (char)(var2_2 + 1);
                    var4_4 = this.sp;
                    v1 = this.addSymbol(var2_2, var4_4, var3_3, var1_1);
                } else {
                    v1 = var1_1.addSymbol(this.sbuf, 0, this.sp, var3_3);
                }
                this.sp = 0;
                this.next();
                return v1;
            }
            if (var5_5 == '\u001a') break;
            if (var5_5 == '\\') {
                if (var4_4 == 0) {
                    var4_4 = 1;
                    var5_5 = this.sp;
                    var6_9 = this.sbuf;
                    if (var5_5 >= this.sbuf.length) {
                        var7_11 = var6_9.length * 2;
                        if (var5_5 <= var7_11) {
                            var5_5 = var7_11;
                        }
                        var5_6 = new char[var5_5];
                        var6_10 = var6_9.length;
                        System.arraycopy(var6_9, 0, var5_6, 0, var6_10);
                        this.sbuf = var5_6;
                    }
                    var5_7 = this.sbuf;
                    var6_8 = this.sp;
                    this.arrayCopy(this.np + 1, var5_7, 0, var6_8);
                }
                var5_5 = this.next();
                block0 : switch (var5_5) {
                    default: {
                        switch (var5_5) {
                            default: {
                                switch (var5_5) {
                                    default: {
                                        this.ch = var5_5;
                                        throw new JSONException("unclosed.str.lit");
                                    }
                                    case 'v': {
                                        var3_3 = var3_3 * 31 + 11;
                                        v2 = this;
                                        v3 = '\u000b';
                                        break block0;
                                    }
                                    case 'u': {
                                        var5_5 = this.next();
                                        var6_8 = this.next();
                                        var7_11 = this.next();
                                        var8_14 = this.next();
                                        v4 = Integer.parseInt(new String(new char[]{var5_5, var6_8, var7_11, var8_14}), 16);
                                        var3_3 = var3_3 * 31 + v4;
                                        v3 = (char)v4;
                                        v2 = this;
                                        break block0;
                                    }
                                    case 't': 
                                }
                                var3_3 = var3_3 * 31 + 9;
                                v2 = this;
                                v3 = '\t';
                                break block0;
                            }
                            case '7': {
                                var3_3 = var3_3 * 31 + var5_5;
                                v2 = this;
                                v3 = '\u0007';
                                break block0;
                            }
                            case '6': {
                                var3_3 = var3_3 * 31 + var5_5;
                                v2 = this;
                                v3 = '\u0006';
                                break block0;
                            }
                            case '5': {
                                var3_3 = var3_3 * 31 + var5_5;
                                v2 = this;
                                v3 = '\u0005';
                                break block0;
                            }
                            case '4': {
                                var3_3 = var3_3 * 31 + var5_5;
                                v2 = this;
                                v3 = '\u0004';
                                break block0;
                            }
                            case '3': {
                                var3_3 = var3_3 * 31 + var5_5;
                                v2 = this;
                                v3 = '\u0003';
                                break block0;
                            }
                            case '2': {
                                var3_3 = var3_3 * 31 + var5_5;
                                v2 = this;
                                v3 = '\u0002';
                                break block0;
                            }
                            case '1': {
                                var3_3 = var3_3 * 31 + var5_5;
                                v2 = this;
                                v3 = '\u0001';
                                break block0;
                            }
                            case '0': {
                                var3_3 = var3_3 * 31 + var5_5;
                                v2 = this;
                                v3 = '\u0000';
                                break block0;
                            }
                            case '/': 
                        }
                        var3_3 = var3_3 * 31 + 47;
                        v2 = this;
                        v3 = '/';
                        break;
                    }
                    case 'x': {
                        var5_5 = this.next();
                        this.ch = var5_5;
                        var6_8 = this.next();
                        this.ch = var6_8;
                        var7_12 = JSONLexerBase.digits;
                        var5_5 = (char)(JSONLexerBase.digits[var5_5] * 16 + var7_12[var6_8]);
                        var3_3 = var3_3 * 31 + var5_5;
                        v2 = this;
                        v3 = var5_5;
                        break;
                    }
                    case 'r': {
                        var3_3 = var3_3 * 31 + 13;
                        v2 = this;
                        v3 = '\r';
                        break;
                    }
                    case 'n': {
                        var3_3 = var3_3 * 31 + 10;
                        v2 = this;
                        v3 = '\n';
                        break;
                    }
                    case 'b': {
                        var3_3 = var3_3 * 31 + 8;
                        v2 = this;
                        v3 = '\b';
                        break;
                    }
                    case '\\': {
                        var3_3 = var3_3 * 31 + 92;
                        v2 = this;
                        v3 = '\\';
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        var3_3 = var3_3 * 31 + 12;
                        v2 = this;
                        v3 = '\f';
                        break;
                    }
                    case '\'': {
                        var3_3 = var3_3 * 31 + 39;
                        v2 = this;
                        v3 = '\'';
                        break;
                    }
                    case '\"': {
                        var3_3 = var3_3 * 31 + 34;
                        v2 = this;
                        v3 = '\"';
                    }
                }
lbl156:
                // 21 sources

                while (true) {
                    v2.putChar(v3);
                    continue block26;
                    break;
                }
            }
            var3_3 = var3_3 * 31 + var5_5;
            if (var4_4 == 0) {
                ++this.sp;
                continue;
            }
            var6_8 = this.sp;
            var7_13 = this.sbuf;
            if (var6_8 == this.sbuf.length) {
                v2 = this;
                v3 = var5_5;
                ** continue;
            }
            v5 = var6_8;
            this.sp = v5 + 1;
            var7_13[v5] = var5_5;
        }
        throw new JSONException("unclosed.str");
    }

    @Override
    public final void resetStringPosition() {
        this.sp = 0;
    }

    @Override
    public String info() {
        return "";
    }

    @Override
    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        boolean[] blArray;
        int n;
        if (this.token == 1 && this.pos == 0 && this.bp == 1) {
            this.bp = 0;
        }
        boolean bl = (n = this.ch) >= (blArray = IOUtils.firstIdentifierFlags).length || blArray[n];
        if (bl) {
            blArray = IOUtils.identifierFlags;
            this.np = this.bp;
            this.sp = 1;
            while (true) {
                char c;
                if ((c = this.next()) < blArray.length && !blArray[c]) {
                    this.ch = this.charAt(this.bp);
                    this.token = 18;
                    if (this.sp == 4 && n == 3392903 && this.charAt(this.np) == 'n' && this.charAt(this.np + 1) == 'u' && this.charAt(this.np + 2) == 'l' && this.charAt(this.np + 3) == 'l') {
                        return null;
                    }
                    if (symbolTable == null) {
                        int n2 = this.sp;
                        return this.subString(this.np, n2);
                    }
                    int n3 = this.sp;
                    return this.addSymbol(this.np, n3, n, symbolTable);
                }
                n = n * 31 + c;
                ++this.sp;
            }
        }
        throw new JSONException("illegal identifier : " + this.ch + this.info());
    }

    protected abstract void copyTo(int var1, int var2, char[] var3);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void scanString() {
        this.np = this.bp;
        this.hasSpecial = false;
        while (true) {
            int n;
            char c;
            block40: {
                int n2;
                JSONLexerBase jSONLexerBase;
                block38: {
                    block39: {
                        char c2;
                        block37: {
                            if ((c = this.next()) == '\"') {
                                this.token = 4;
                                this.ch = this.next();
                                return;
                            }
                            if (c != '\u001a') break block37;
                            if (this.isEOF()) {
                                throw new JSONException("unclosed string : " + c);
                            }
                            jSONLexerBase = this;
                            n2 = 26;
                            break block38;
                        }
                        if (c != '\\') break block39;
                        if (!this.hasSpecial) {
                            this.hasSpecial = true;
                            int n3 = this.sp;
                            char[] cArray = this.sbuf;
                            if (n3 >= this.sbuf.length) {
                                char c3;
                                c2 = cArray.length * 2;
                                if (n3 <= c2) {
                                    c3 = c2;
                                }
                                char[] cArray2 = new char[c3];
                                int n4 = cArray.length;
                                System.arraycopy(cArray, 0, cArray2, 0, n4);
                                this.sbuf = cArray2;
                            }
                            int n5 = this.sp;
                            cArray = this.sbuf;
                            this.copyTo(this.np + 1, n5, cArray);
                        }
                        c = this.next();
                        block0 : switch (c) {
                            default: {
                                char c4;
                                switch (c) {
                                    default: {
                                        switch (c) {
                                            default: {
                                                this.ch = c;
                                                throw new JSONException("unclosed string : " + c);
                                            }
                                            case 'v': {
                                                jSONLexerBase = this;
                                                n2 = 11;
                                                break block0;
                                            }
                                            case 'u': {
                                                c = this.next();
                                                char c5 = this.next();
                                                c2 = this.next();
                                                c4 = this.next();
                                                n2 = (char)Integer.parseInt(new String(new char[]{c, c5, c2, c4}), 16);
                                                jSONLexerBase = this;
                                                break block0;
                                            }
                                            case 't': 
                                        }
                                        jSONLexerBase = this;
                                        n2 = 9;
                                        break block0;
                                    }
                                    case '7': {
                                        jSONLexerBase = this;
                                        n2 = 7;
                                        break block0;
                                    }
                                    case '6': {
                                        jSONLexerBase = this;
                                        n2 = 6;
                                        break block0;
                                    }
                                    case '5': {
                                        jSONLexerBase = this;
                                        n2 = 5;
                                        break block0;
                                    }
                                    case '4': {
                                        jSONLexerBase = this;
                                        n2 = 4;
                                        break block0;
                                    }
                                    case '3': {
                                        jSONLexerBase = this;
                                        n2 = 3;
                                        break block0;
                                    }
                                    case '2': {
                                        jSONLexerBase = this;
                                        n2 = 2;
                                        break block0;
                                    }
                                    case '1': {
                                        jSONLexerBase = this;
                                        n2 = 1;
                                        break block0;
                                    }
                                    case '0': {
                                        jSONLexerBase = this;
                                        n2 = 0;
                                        break block0;
                                    }
                                    case '/': 
                                }
                                jSONLexerBase = this;
                                n2 = 47;
                                break;
                            }
                            case 'x': {
                                c = this.next();
                                char c6 = this.next();
                                c2 = c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' ? (char)'\u0001' : '\u0000';
                                char c4 = c6 >= '0' && c6 <= '9' || c6 >= 'a' && c6 <= 'f' || c6 >= 'A' && c6 <= 'F' ? (char)'\u0001' : '\u0000';
                                if (c2 != '\u0000' && c4 != '\u0000') {
                                    int[] nArray = digits;
                                    n2 = (char)(digits[c] * 16 + nArray[c6]);
                                    jSONLexerBase = this;
                                    break;
                                }
                                throw new JSONException("invalid escape character \\x" + c + c6);
                            }
                            case 'r': {
                                jSONLexerBase = this;
                                n2 = 13;
                                break;
                            }
                            case 'n': {
                                jSONLexerBase = this;
                                n2 = 10;
                                break;
                            }
                            case 'b': {
                                jSONLexerBase = this;
                                n2 = 8;
                                break;
                            }
                            case '\\': {
                                jSONLexerBase = this;
                                n2 = 92;
                                break;
                            }
                            case 'F': 
                            case 'f': {
                                jSONLexerBase = this;
                                n2 = 12;
                                break;
                            }
                            case '\'': {
                                jSONLexerBase = this;
                                n2 = 39;
                                break;
                            }
                            case '\"': {
                                jSONLexerBase = this;
                                n2 = 34;
                                break;
                            }
                        }
                        break block38;
                    }
                    if (!this.hasSpecial) {
                        ++this.sp;
                        continue;
                    }
                    n = this.sp;
                    char[] cArray = this.sbuf;
                    if (n != this.sbuf.length) break block40;
                    jSONLexerBase = this;
                    n2 = c;
                }
                jSONLexerBase.putChar((char)n2);
                continue;
            }
            this.sp = n + 1;
            cArray[n] = c;
        }
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public final int intValue() {
        int n;
        if (this.np == -1) {
            this.np = 0;
        }
        JSONLexerBase jSONLexerBase = this;
        int n2 = 0;
        boolean bl = false;
        int n3 = jSONLexerBase.np;
        int n4 = n3 + this.sp;
        if (jSONLexerBase.charAt(n3) == '-') {
            bl = true;
            n = Integer.MIN_VALUE;
            ++n3;
        } else {
            n = -2147483647;
        }
        long l = -214748364L;
        if (n3 < n4) {
            n2 = -(this.charAt(n3++) - 48);
        }
        while (n3 < n4) {
            int n5 = n3 + 1;
            char c = this.charAt(n3);
            n3 = c;
            if (c != 'L' && n3 != 83 && n3 != 66) {
                n3 -= 48;
                if ((long)n2 >= l) {
                    if ((n2 *= 10) >= n + n3) {
                        n2 -= n3;
                        n3 = n5;
                        continue;
                    }
                    throw new NumberFormatException(this.numberString());
                }
                throw new NumberFormatException(this.numberString());
            }
            n3 = n5;
            break;
        }
        if (bl) {
            if (n3 > this.np + 1) {
                return n2;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -n2;
    }

    @Override
    public abstract byte[] bytesValue();

    @Override
    public void close() {
        char[] cArray = this.sbuf;
        if (this.sbuf.length <= 8192) {
            SBUF_LOCAL.set(cArray);
        }
        this.sbuf = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean isRef() {
        if (this.sp != 4) {
            return false;
        }
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.np + 1) != '$') return false;
        JSONLexerBase jSONLexerBase2 = this;
        if (jSONLexerBase2.charAt(jSONLexerBase2.np + 2) != 'r') return false;
        JSONLexerBase jSONLexerBase3 = this;
        if (jSONLexerBase3.charAt(jSONLexerBase3.np + 3) != 'e') return false;
        JSONLexerBase jSONLexerBase4 = this;
        if (jSONLexerBase4.charAt(jSONLexerBase4.np + 4) != 'f') return false;
        return true;
    }

    @Override
    public String scanTypeName(SymbolTable symbolTable) {
        return null;
    }

    public final int scanType(String string) {
        this.matchStat = 0;
        char[] cArray = typeFieldName;
        if (!this.charArrayCompare(cArray)) {
            return -2;
        }
        int n = this.bp + cArray.length;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == this.charAt(n + i)) continue;
            return -1;
        }
        int n3 = n + n2;
        if (this.charAt(n3) != '\"') {
            return -1;
        }
        char c = this.charAt(++n3);
        n = c;
        this.ch = (char)n;
        if (c == ',') {
            this.ch = this.charAt(++n3);
            this.bp = n3;
            this.token = 16;
            return 3;
        }
        if (n == 125) {
            char c2 = this.charAt(++n3);
            n = c2;
            this.ch = (char)n;
            if (c2 == ',') {
                this.token = 16;
                this.ch = this.charAt(++n3);
            } else if (n == 93) {
                this.token = 15;
                this.ch = this.charAt(++n3);
            } else if (n == 125) {
                this.token = 13;
                this.ch = this.charAt(++n3);
            } else {
                if (n != 26) {
                    return -1;
                }
                this.token = 20;
            }
            this.matchStat = 4;
        }
        this.bp = n3;
        return this.matchStat;
    }

    public final boolean matchField(char[] cArray) {
        int n;
        while (!this.charArrayCompare(cArray)) {
            if (JSONLexerBase.isWhitespace(this.ch)) {
                this.next();
                continue;
            }
            return false;
        }
        this.bp = n = this.bp + cArray.length;
        char c = this.charAt(n);
        n = c;
        this.ch = (char)n;
        if (c == '{') {
            this.next();
            this.token = 12;
        } else if (n == 91) {
            this.next();
            this.token = 14;
        } else if (n == 83 && this.charAt(this.bp + 1) == 'e' && this.charAt(this.bp + 2) == 't' && this.charAt(this.bp + 3) == '[') {
            this.bp = n = this.bp + 3;
            this.ch = this.charAt(n);
            this.token = 21;
        } else {
            this.nextToken();
        }
        return true;
    }

    public int matchField(long l) {
        throw new UnsupportedOperationException();
    }

    public boolean seekArrayToItem(int n) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long l, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long[] lArray) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToFieldDeepScan(long l) {
        throw new UnsupportedOperationException();
    }

    public void skipObject() {
        throw new UnsupportedOperationException();
    }

    public void skipObject(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void skipArray() {
        throw new UnsupportedOperationException();
    }

    public abstract int indexOf(char var1, int var2);

    public abstract String addSymbol(int var1, int var2, int var3, SymbolTable var4);

    public String scanFieldString(char[] cArray) {
        block10: {
            block11: {
                block16: {
                    String string;
                    block13: {
                        int n;
                        int n2;
                        block15: {
                            block14: {
                                block12: {
                                    this.matchStat = 0;
                                    if (!this.charArrayCompare(cArray)) {
                                        this.matchStat = -2;
                                        return this.stringDefaultValue();
                                    }
                                    int n3 = cArray.length;
                                    n2 = n3 + 1;
                                    if (this.charAt(this.bp + n3) != '\"') {
                                        this.matchStat = -1;
                                        return this.stringDefaultValue();
                                    }
                                    int n4 = this.bp + cArray.length + 1;
                                    if ((n4 = this.indexOf('\"', n4)) == -1) break block10;
                                    int n5 = this.bp + cArray.length + 1;
                                    int n6 = n4 - n5;
                                    string = this.subString(n5, n6);
                                    if (string.indexOf(92) != -1) {
                                        while (true) {
                                            int n7 = 0;
                                            for (n6 = n4 - 1; n6 >= 0 && this.charAt(n6) == '\\'; --n6) {
                                                ++n7;
                                            }
                                            if (n7 % 2 == 0) {
                                                int n8 = this.bp;
                                                n7 = n8;
                                                n7 = n4 - (n7 + cArray.length + 1);
                                                string = JSONLexerBase.readString(this.sub_chars(n8 + cArray.length + 1, n7), n7);
                                                break;
                                            }
                                            ++n4;
                                            n4 = this.indexOf('\"', n4);
                                        }
                                    }
                                    n6 = this.bp;
                                    int n9 = n2 + (n4 - (n6 + cArray.length + 1) + 1);
                                    n = n9 + 1;
                                    char c = this.charAt(n6 + n9);
                                    n2 = c;
                                    if (c == ',') {
                                        this.bp = n = this.bp + n;
                                        this.ch = this.charAt(n);
                                        this.matchStat = 3;
                                        return string;
                                    }
                                    if (n2 != 125) break block11;
                                    char c2 = this.charAt(this.bp + n++);
                                    n2 = c2;
                                    if (c2 != ',') break block12;
                                    this.token = 16;
                                    this.bp = n = this.bp + n;
                                    this.ch = this.charAt(n);
                                    break block13;
                                }
                                if (n2 != 93) break block14;
                                this.token = 15;
                                this.bp = n = this.bp + n;
                                this.ch = this.charAt(n);
                                break block13;
                            }
                            if (n2 != 125) break block15;
                            this.token = 13;
                            this.bp = n = this.bp + n;
                            this.ch = this.charAt(n);
                            break block13;
                        }
                        if (n2 != 26) break block16;
                        this.token = 20;
                        this.bp += n - 1;
                        this.ch = (char)26;
                    }
                    this.matchStat = 4;
                    return string;
                }
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        throw new JSONException("unclosed str");
    }

    @Override
    public String scanString(char c) {
        this.matchStat = 0;
        int n = this.bp;
        char c2 = '\u0001';
        char c3 = this.charAt(n + 0);
        n = c3;
        if (c3 == 'n') {
            if (this.charAt(this.bp + c2) == 'u' && this.charAt(this.bp + c2 + 1) == 'l' && this.charAt(this.bp + c2 + 2) == 'l') {
                n = this.bp;
                c2 = '\u0005';
                if (this.charAt(n + 4) == c) {
                    c = (char)(this.bp + c2);
                    this.bp = c;
                    this.ch = this.charAt(c);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            this.matchStat = -1;
            return null;
        }
        while (true) {
            if (n == 34) {
                n = this.bp + c2;
                int n2 = this.indexOf('\"', n);
                if (n2 != -1) {
                    int n3 = this.bp + c2;
                    int n4 = n2 - n;
                    String string = this.subString(n3, n4);
                    if (string.indexOf(92) != -1) {
                        while (true) {
                            int n5 = 0;
                            for (n4 = n2 - 1; n4 >= 0 && this.charAt(n4) == '\\'; --n4) {
                                ++n5;
                            }
                            if (n5 % 2 == 0) {
                                n5 = n2 - n;
                                string = JSONLexerBase.readString(this.sub_chars(this.bp + 1, n5), n5);
                                break;
                            }
                            ++n2;
                            n2 = this.indexOf('\"', n2);
                        }
                    }
                    int n6 = c2 + (n2 - n + 1);
                    n = n6 + 1;
                    c2 = this.charAt(this.bp + n6);
                    while (true) {
                        if (c2 == c) {
                            c = (char)(this.bp + n);
                            this.bp = c;
                            this.ch = this.charAt(c);
                            this.matchStat = 3;
                            this.token = 16;
                            return string;
                        }
                        if (!JSONLexerBase.isWhitespace(c2)) break;
                        c2 = this.charAt(this.bp + n++);
                    }
                    if (c2 == ']') {
                        c = (char)(this.bp + n);
                        this.bp = c;
                        this.ch = this.charAt(c);
                        this.matchStat = -1;
                    }
                    return string;
                }
                throw new JSONException("unclosed str");
            }
            if (!JSONLexerBase.isWhitespace((char)n)) break;
            n = this.charAt(this.bp + c2++);
        }
        this.matchStat = -1;
        return this.stringDefaultValue();
    }

    public long scanFieldSymbol(char[] cArray) {
        char c;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0L;
        }
        int n = cArray.length;
        int n2 = n + 1;
        if (this.charAt(this.bp + n) != '\"') {
            this.matchStat = -1;
            return 0L;
        }
        long l = -3750763034362895579L;
        do {
            block7: {
                block8: {
                    block13: {
                        block10: {
                            block12: {
                                block11: {
                                    block9: {
                                        if ((c = this.charAt(this.bp + n2++)) != '\"') break block7;
                                        if ((c = this.charAt(this.bp + n2++)) == ',') {
                                            this.bp = n2 = this.bp + n2;
                                            this.ch = this.charAt(n2);
                                            this.matchStat = 3;
                                            return l;
                                        }
                                        if (c != '}') break block8;
                                        if ((c = this.charAt(this.bp + n2++)) != ',') break block9;
                                        this.token = 16;
                                        this.bp = n2 = this.bp + n2;
                                        this.ch = this.charAt(n2);
                                        break block10;
                                    }
                                    if (c != ']') break block11;
                                    this.token = 15;
                                    this.bp = n2 = this.bp + n2;
                                    this.ch = this.charAt(n2);
                                    break block10;
                                }
                                if (c != '}') break block12;
                                this.token = 13;
                                this.bp = n2 = this.bp + n2;
                                this.ch = this.charAt(n2);
                                break block10;
                            }
                            if (c != '\u001a') break block13;
                            this.token = 20;
                            this.bp += n2 - 1;
                            this.ch = (char)26;
                        }
                        this.matchStat = 4;
                        return l;
                    }
                    this.matchStat = -1;
                    return 0L;
                }
                this.matchStat = -1;
                return 0L;
            }
            l = (l ^ (long)c) * 1099511628211L;
        } while (c != '\\');
        this.matchStat = -1;
        return 0L;
    }

    public long scanEnumSymbol(char[] cArray) {
        int n;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0L;
        }
        int n2 = cArray.length;
        int n3 = n2 + 1;
        if (this.charAt(this.bp + n2) != '\"') {
            this.matchStat = -1;
            return 0L;
        }
        long l = -3750763034362895579L;
        do {
            block7: {
                block8: {
                    block13: {
                        block10: {
                            block12: {
                                block11: {
                                    block9: {
                                        if ((n = this.charAt(this.bp + n3++)) != 34) break block7;
                                        char c = this.charAt(this.bp + n3++);
                                        n = c;
                                        if (c == ',') {
                                            this.bp = n3 = this.bp + n3;
                                            this.ch = this.charAt(n3);
                                            this.matchStat = 3;
                                            return l;
                                        }
                                        if (n != 125) break block8;
                                        char c2 = this.charAt(this.bp + n3++);
                                        n = c2;
                                        if (c2 != ',') break block9;
                                        this.token = 16;
                                        this.bp = n3 = this.bp + n3;
                                        this.ch = this.charAt(n3);
                                        break block10;
                                    }
                                    if (n != 93) break block11;
                                    this.token = 15;
                                    this.bp = n3 = this.bp + n3;
                                    this.ch = this.charAt(n3);
                                    break block10;
                                }
                                if (n != 125) break block12;
                                this.token = 13;
                                this.bp = n3 = this.bp + n3;
                                this.ch = this.charAt(n3);
                                break block10;
                            }
                            if (n != 26) break block13;
                            this.token = 20;
                            this.bp += n3 - 1;
                            this.ch = (char)26;
                        }
                        this.matchStat = 4;
                        return l;
                    }
                    this.matchStat = -1;
                    return 0L;
                }
                this.matchStat = -1;
                return 0L;
            }
            int n4 = n >= 65 && n <= 90 ? n + 32 : n;
            l = (l ^ (long)n4) * 1099511628211L;
        } while (n != 92);
        this.matchStat = -1;
        return 0L;
    }

    @Override
    public Enum<?> scanEnum(Class<?> clazz, SymbolTable symbolTable, char c) {
        if ((this = ((JSONLexerBase)this).scanSymbolWithSeperator(symbolTable, c)) == null) {
            return null;
        }
        return Enum.valueOf(clazz, (String)this);
    }

    @Override
    public String scanSymbolWithSeperator(SymbolTable object, char c) {
        int n;
        this.matchStat = 0;
        int n2 = this.bp;
        char c2 = '\u0001';
        char c3 = this.charAt(n2 + 0);
        n2 = c3;
        if (c3 == 'n') {
            if (this.charAt(this.bp + c2) == 'u' && this.charAt(this.bp + c2 + 1) == 'l' && this.charAt(this.bp + c2 + 2) == 'l') {
                int n3 = this.bp;
                n2 = 5;
                if (this.charAt(n3 + 4) == c) {
                    this.bp = n3 = this.bp + n2;
                    this.ch = this.charAt(n3);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            this.matchStat = -1;
            return null;
        }
        if (n2 != 34) {
            this.matchStat = -1;
            return null;
        }
        n2 = 0;
        do {
            if ((n = this.charAt(this.bp + c2++)) == 34) {
                int n4 = this.bp;
                n = n4 + 0 + 1;
                int n5 = n4 + c2 - n - 1;
                object = this.addSymbol(n, n5, n2, (SymbolTable)object);
                char c4 = c2;
                n2 = c4 + 1;
                c2 = this.charAt(this.bp + c4);
                while (true) {
                    if (c2 == c) {
                        int n6;
                        this.bp = n6 = this.bp + n2;
                        this.ch = this.charAt(n6);
                        this.matchStat = 3;
                        return object;
                    }
                    if (!JSONLexerBase.isWhitespace(c2)) break;
                    c2 = this.charAt(this.bp + n2++);
                }
                this.matchStat = -1;
                return object;
            }
            n2 = n2 * 31 + n;
        } while (n != 92);
        this.matchStat = -1;
        return null;
    }

    public Collection<String> newCollectionByType(Class<?> clazz) {
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet<String>();
        }
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<String>();
        }
        if (clazz.isAssignableFrom(LinkedList.class)) {
            return new LinkedList<String>();
        }
        try {
            return (Collection)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JSONException(exception.getMessage(), exception);
        }
    }

    public Collection<String> scanFieldStringArray(char[] object, Class<?> clazz) {
        block17: {
            block18: {
                block23: {
                    block20: {
                        int n;
                        int n2;
                        block22: {
                            block21: {
                                block19: {
                                    block16: {
                                        block15: {
                                            this.matchStat = 0;
                                            if (!this.charArrayCompare((char[])object)) {
                                                this.matchStat = -2;
                                                return null;
                                            }
                                            char[] cArray = object;
                                            object = this.newCollectionByType(clazz);
                                            int n3 = cArray.length;
                                            n2 = n3 + 1;
                                            if (this.charAt(this.bp + n3) != '[') {
                                                this.matchStat = -1;
                                                return null;
                                            }
                                            do {
                                                if ((n = this.charAt(this.bp + n2++)) == 34) {
                                                    n = this.bp + n2;
                                                    if ((n = this.indexOf('\"', n)) != -1) {
                                                        int n4 = this.bp + n2;
                                                        int n5 = n - n4;
                                                        String string = this.subString(n4, n5);
                                                        if (string.indexOf(92) != -1) {
                                                            while (true) {
                                                                int n6 = 0;
                                                                for (n5 = n - 1; n5 >= 0 && this.charAt(n5) == '\\'; --n5) {
                                                                    ++n6;
                                                                }
                                                                if (n6 % 2 == 0) {
                                                                    int n7 = this.bp;
                                                                    n6 = n7;
                                                                    n6 = n - (n6 + n2);
                                                                    string = JSONLexerBase.readString(this.sub_chars(n7 + n2, n6), n6);
                                                                    break;
                                                                }
                                                                ++n;
                                                                n = this.indexOf('\"', n);
                                                            }
                                                        }
                                                        n4 = this.bp;
                                                        int n8 = n2 + (n - (n4 + n2) + 1);
                                                        n2 = n8 + 1;
                                                        n = this.charAt(n4 + n8);
                                                        object.add(string);
                                                        continue;
                                                    }
                                                    throw new JSONException("unclosed str");
                                                }
                                                if (n != 110 || this.charAt(this.bp + n2) != 'u' || this.charAt(this.bp + n2 + 1) != 'l' || this.charAt(this.bp + n2 + 2) != 'l') break block15;
                                                int n9 = n2 + 3;
                                                n2 = n9 + 1;
                                                n = this.charAt(this.bp + n9);
                                                object.add(null);
                                            } while (n == 44);
                                            if (n != 93) {
                                                this.matchStat = -1;
                                                return null;
                                            }
                                            break block16;
                                        }
                                        if (n != 93 || object.size() != 0) break block17;
                                    }
                                    n = this.charAt(this.bp + n2++);
                                    if (n == 44) {
                                        int n10;
                                        this.bp = n10 = this.bp + n2;
                                        this.ch = this.charAt(n10);
                                        this.matchStat = 3;
                                        return object;
                                    }
                                    if (n != 125) break block18;
                                    char c = this.charAt(this.bp + n2++);
                                    n = c;
                                    if (c != ',') break block19;
                                    this.token = 16;
                                    this.bp = n2 = this.bp + n2;
                                    this.ch = this.charAt(n2);
                                    break block20;
                                }
                                if (n != 93) break block21;
                                this.token = 15;
                                this.bp = n2 = this.bp + n2;
                                this.ch = this.charAt(n2);
                                break block20;
                            }
                            if (n != 125) break block22;
                            this.token = 13;
                            this.bp = n2 = this.bp + n2;
                            this.ch = this.charAt(n2);
                            break block20;
                        }
                        if (n != 26) break block23;
                        this.bp += n2 - 1;
                        this.token = 20;
                        this.ch = (char)26;
                    }
                    this.matchStat = 4;
                    return object;
                }
                this.matchStat = -1;
                return null;
            }
            this.matchStat = -1;
            return null;
        }
        throw new JSONException("illega str");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void scanStringArray(Collection<String> var1_1, char var2_4) {
        block14: {
            block15: {
                this.matchStat = 0;
                var3_5 = this.bp;
                var4_6 = 1;
                v0 = this.charAt(var3_5 + 0);
                var3_5 = v0;
                if (v0 == 'n' && this.charAt(this.bp + var4_6) == 'u' && this.charAt(this.bp + var4_6 + 1) == 'l' && this.charAt(this.bp + var4_6 + 2) == 'l' && this.charAt(this.bp + var4_6 + 3) == var2_4) {
                    this.bp = var1_2 = this.bp + 5;
                    this.ch = this.charAt(var1_2);
                    this.matchStat = 5;
                    return;
                }
                if (var3_5 != 91) {
                    this.matchStat = -1;
                    return;
                }
                var3_5 = 2;
                var4_6 = this.charAt(this.bp + var4_6);
                while (true) {
                    if (var4_6 == 110 && this.charAt(this.bp + var3_5) == 'u' && this.charAt(this.bp + var3_5 + 1) == 'l' && this.charAt(this.bp + var3_5 + 2) == 'l') {
                        v1 = var3_5 + 3;
                        var3_5 = v1 + 1;
                        var4_6 = this.charAt(this.bp + v1);
                        var1_1.add(null);
                    } else {
                        if (var4_6 == 93 && var1_1.size() == 0) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                continue;
                                break;
                            }
                        }
                        if (var4_6 != 34) {
                            this.matchStat = -1;
                            return;
                        }
                        var4_6 = this.bp + var3_5;
                        var5_7 = this.indexOf('\"', var4_6);
                        if (var5_7 == -1) break block14;
                        var6_9 = this.bp + var3_5;
                        var7_11 = var5_7 - var4_6;
                        var6_8 = this.subString(var6_9, var7_11);
                        if (var6_8.indexOf(92) != -1) {
                            while (true) {
                                var6_10 = 0;
                                for (var7_11 = var5_7 - 1; var7_11 >= 0 && this.charAt(var7_11) == '\\'; --var7_11) {
                                    ++var6_10;
                                }
                                if (var6_10 % 2 == 0) {
                                    var4_6 = var5_7 - var4_6;
                                    var6_8 = JSONLexerBase.readString(this.sub_chars(this.bp + var3_5, var4_6), var4_6);
                                    break;
                                }
                                ++var5_7;
                                var5_7 = this.indexOf('\"', var5_7);
                            }
                        }
                        var4_6 = this.bp;
                        v2 = var3_5 + (var5_7 - (var4_6 + var3_5) + 1);
                        var3_5 = v2 + 1;
                        var4_6 = this.charAt(var4_6 + v2);
                        var1_1.add(var6_8);
                    }
                    if (var4_6 != 44) break;
                    var4_6 = this.charAt(this.bp + var3_5++);
                }
                if (var4_6 == 93) {
                    ** continue;
                }
                break block15;
                v3 = var3_5;
                var1_3 = v3 + 1;
                if (this.charAt(this.bp + v3) == var2_4) {
                    this.bp = var1_3 = this.bp + var1_3;
                    this.ch = this.charAt(var1_3);
                    this.matchStat = 3;
                    return;
                }
                this.matchStat = -1;
                return;
            }
            this.matchStat = -1;
            return;
        }
        throw new JSONException("unclosed str");
    }

    public int scanFieldInt(char[] cArray) {
        block10: {
            block11: {
                block12: {
                    block17: {
                        boolean bl;
                        int n;
                        block14: {
                            int n2;
                            int n3;
                            block16: {
                                block15: {
                                    block13: {
                                        char c;
                                        this.matchStat = 0;
                                        if (!this.charArrayCompare(cArray)) {
                                            this.matchStat = -2;
                                            return 0;
                                        }
                                        int n4 = cArray.length;
                                        n3 = n4 + 1;
                                        n = this.charAt(this.bp + n4);
                                        bl = n == 45;
                                        if (bl) {
                                            n = this.charAt(this.bp + n3++);
                                        }
                                        if (n < 48 || n > 57) break block10;
                                        n -= 48;
                                        while ((c = this.charAt(this.bp + n3++)) >= '0' && c <= '9') {
                                            n = n * 10 + (c - 48);
                                        }
                                        if (c == '.') {
                                            this.matchStat = -1;
                                            return 0;
                                        }
                                        if ((n < 0 || n3 > cArray.length + 14) && (n != Integer.MIN_VALUE || n3 != 17 || !bl)) break block11;
                                        if (c == ',') {
                                            int n5;
                                            this.bp = n5 = this.bp + n3;
                                            this.ch = this.charAt(n5);
                                            this.matchStat = 3;
                                            this.token = 16;
                                            if (bl) {
                                                n = -n;
                                            }
                                            return n;
                                        }
                                        if (c != '}') break block12;
                                        int n6 = n3;
                                        n2 = n6 + 1;
                                        char c2 = this.charAt(this.bp + n6);
                                        n3 = c2;
                                        if (c2 != ',') break block13;
                                        this.token = 16;
                                        this.bp = n2 = this.bp + n2;
                                        this.ch = this.charAt(n2);
                                        break block14;
                                    }
                                    if (n3 != 93) break block15;
                                    this.token = 15;
                                    this.bp = n2 = this.bp + n2;
                                    this.ch = this.charAt(n2);
                                    break block14;
                                }
                                if (n3 != 125) break block16;
                                this.token = 13;
                                this.bp = n2 = this.bp + n2;
                                this.ch = this.charAt(n2);
                                break block14;
                            }
                            if (n3 != 26) break block17;
                            this.token = 20;
                            this.bp += n2 - 1;
                            this.ch = (char)26;
                        }
                        this.matchStat = 4;
                        if (bl) {
                            n = -n;
                        }
                        return n;
                    }
                    this.matchStat = -1;
                    return 0;
                }
                this.matchStat = -1;
                return 0;
            }
            this.matchStat = -1;
            return 0;
        }
        this.matchStat = -1;
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public final int[] scanFieldIntArray(char[] var1_1) {
        block12: {
            this.matchStat = 0;
            if (!this.charArrayCompare(var1_1)) {
                this.matchStat = -2;
                return null;
            }
            v0 = var1_1.length;
            var1_2 = v0 + 1;
            if (this.charAt(this.bp + v0) != '[') {
                this.matchStat = -2;
                return null;
            }
            var2_3 = this.charAt(this.bp + var1_2++);
            var3_4 = new int[16];
            var4_5 = 0;
            if (var2_3 != 93) break block12;
            var2_3 = this.charAt(this.bp + var1_2++);
            ** GOTO lbl42
        }
        while (true) {
            block14: {
                block15: {
                    block16: {
                        block21: {
                            block18: {
                                block20: {
                                    block19: {
                                        block17: {
                                            block13: {
                                                var5_6 = 0;
                                                if (var2_3 == 45) {
                                                    var2_3 = this.charAt(this.bp + var1_2++);
                                                    var5_6 = 1;
                                                }
                                                if (var2_3 < 48 || var2_3 > 57) break;
                                                var2_3 -= 48;
                                                while ((var6_7 = this.charAt(this.bp + var1_2++)) >= '0' && var6_7 <= '9') {
                                                    var2_3 = var2_3 * 10 + (var6_7 - 48);
                                                }
                                                if (var4_5 >= var3_4.length) {
                                                    var3_4 = new int[var3_4.length * 3 / 2];
                                                    System.arraycopy(var3_4, 0, var3_4, 0, var4_5);
                                                }
                                                v1 = var5_6;
                                                var5_6 = var4_5 + 1;
                                                if (v1 != 0) {
                                                    var2_3 = -var2_3;
                                                }
                                                var3_4[var4_5] = var2_3;
                                                if (var6_7 != ',') break block13;
                                                var2_3 = this.charAt(this.bp + var1_2++);
                                                break block14;
                                            }
                                            if (var6_7 != ']') break block15;
                                            var2_3 = this.charAt(this.bp + var1_2++);
                                            var4_5 = var5_6;
lbl42:
                                            // 2 sources

                                            if (var4_5 != var3_4.length) {
                                                v2 = var3_4;
                                                var3_4 = new int[var4_5];
                                                System.arraycopy(v2, 0, var3_4, 0, var4_5);
                                            }
                                            if (var2_3 == 44) {
                                                this.bp += var1_2 - 1;
                                                this.next();
                                                this.matchStat = 3;
                                                this.token = 16;
                                                return var3_4;
                                            }
                                            if (var2_3 != 125) break block16;
                                            v3 = this.charAt(this.bp + var1_2++);
                                            var2_3 = v3;
                                            if (v3 != ',') break block17;
                                            this.token = 16;
                                            this.bp += var1_2 - 1;
                                            this.next();
                                            break block18;
                                        }
                                        if (var2_3 != 93) break block19;
                                        this.token = 15;
                                        this.bp += var1_2 - 1;
                                        this.next();
                                        break block18;
                                    }
                                    if (var2_3 != 125) break block20;
                                    this.token = 13;
                                    this.bp += var1_2 - 1;
                                    this.next();
                                    break block18;
                                }
                                if (var2_3 != 26) break block21;
                                this.bp += var1_2 - 1;
                                this.token = 20;
                                this.ch = (char)26;
                            }
                            this.matchStat = 4;
                            return var3_4;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    this.matchStat = -1;
                    return null;
                }
                var2_3 = var6_7;
            }
            var4_5 = var5_6;
        }
        this.matchStat = -1;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean scanBoolean(char c) {
        boolean bl;
        int n;
        int n2;
        block12: {
            this.matchStat = 0;
            n2 = this.bp;
            n = 1;
            char c2 = this.charAt(n2 + 0);
            n2 = c2;
            bl = false;
            if (c2 == 't') {
                if (this.charAt(this.bp + n) == 'r' && this.charAt(this.bp + n + 1) == 'u' && this.charAt(this.bp + n + 2) == 'e') {
                    n2 = this.bp;
                    n = 5;
                    n2 = this.charAt(n2 + 4);
                    bl = true;
                    break block12;
                } else {
                    this.matchStat = -1;
                    return false;
                }
            }
            if (n2 == 102) {
                if (this.charAt(this.bp + n) == 'a' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 's' && this.charAt(this.bp + n + 3) == 'e') {
                    n2 = this.bp;
                    n = 6;
                    n2 = this.charAt(n2 + 5);
                    bl = false;
                    break block12;
                } else {
                    this.matchStat = -1;
                    return false;
                }
            }
            if (n2 == 49) {
                int n3 = n;
                n = 2;
                n2 = this.charAt(this.bp + n3);
                bl = true;
            } else if (n2 == 48) {
                int n4 = n;
                n = 2;
                n2 = this.charAt(this.bp + n4);
                bl = false;
            }
        }
        while (true) {
            if (n2 == c) {
                c = (char)(this.bp + n);
                this.bp = c;
                this.ch = this.charAt(c);
                this.matchStat = 3;
                return bl;
            }
            if (!JSONLexerBase.isWhitespace((char)n2)) {
                this.matchStat = -1;
                return bl;
            }
            n2 = this.charAt(this.bp + n++);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int scanInt(char var1_1) {
        block12: {
            this.matchStat = 0;
            var2_2 = this.bp;
            var3_3 = '\u0001';
            v0 = this.charAt(var2_2 + 0);
            var2_2 = v0;
            var4_4 = v0 == '\"' ? '\u0001' : '\u0000';
            if (var4_4 != '\u0000') {
                v1 = var3_3;
                var3_3 = '\u0002';
                var2_2 = this.charAt(this.bp + v1);
            }
            if (var5_5 = var2_2 == 45) {
                var2_2 = this.charAt(this.bp + var3_3++);
            }
            if (var2_2 >= 48 && var2_2 <= 57) {
                var2_2 -= 48;
                while ((var4_4 = this.charAt(this.bp + var3_3++)) >= '0' && var4_4 <= '9') {
                    var2_2 = var2_2 * 10 + (var4_4 - 48);
                }
                if (var4_4 == '.') {
                    this.matchStat = -1;
                    return 0;
                }
                if (var2_2 < 0) {
                    this.matchStat = -1;
                    return 0;
                }
                while (true) {
                    if (var4_4 == var1_1) {
                        var1_1 = (char)(this.bp + var3_3);
                        this.bp = var1_1;
                        this.ch = this.charAt(var1_1);
                        this.matchStat = 3;
                        this.token = 16;
                        if (var5_5) {
                            var2_2 = -var2_2;
                        }
                        return var2_2;
                    }
                    if (!JSONLexerBase.isWhitespace(var4_4)) break;
                    var4_4 = this.charAt(this.bp + var3_3++);
                }
                this.matchStat = -1;
                if (var5_5) {
                    var2_2 = -var2_2;
                }
                return var2_2;
            }
            if (var2_2 != 110 || this.charAt(this.bp + var3_3) != 'u' || this.charAt(this.bp + var3_3 + 1) != 'l' || this.charAt(this.bp + var3_3 + 2) != 'l') break block12;
            this.matchStat = 5;
            var1_1 = '\u0000';
            v2 = var3_3 + 3;
            var2_2 = v2 + 1;
            var3_3 = this.charAt(this.bp + v2);
            if (var4_4 == '\u0000' || var3_3 != 34) ** GOTO lbl50
            do {
                var3_3 = this.charAt(this.bp + var2_2++);
lbl50:
                // 2 sources

                if (var3_3 == ',') {
                    v3 = var1_1;
                    var1_1 = (char)(this.bp + var2_2);
                    this.bp = var1_1;
                    this.ch = this.charAt(var1_1);
                    this.matchStat = 5;
                    this.token = 16;
                    return v3;
                }
                if (var3_3 != 93) continue;
                v4 = var1_1;
                var1_1 = (char)(this.bp + var2_2);
                this.bp = var1_1;
                this.ch = this.charAt(var1_1);
                this.matchStat = 5;
                this.token = 15;
                return v4;
            } while (JSONLexerBase.isWhitespace(var3_3));
            this.matchStat = -1;
            return 0;
        }
        this.matchStat = -1;
        return 0;
    }

    public boolean scanFieldBoolean(char[] cArray) {
        block14: {
            block15: {
                block20: {
                    char c;
                    block17: {
                        char c2;
                        int n;
                        block19: {
                            block18: {
                                block16: {
                                    block13: {
                                        block12: {
                                            this.matchStat = 0;
                                            if (!this.charArrayCompare(cArray)) {
                                                this.matchStat = -2;
                                                return false;
                                            }
                                            int n2 = cArray.length;
                                            n = n2 + 1;
                                            c = this.charAt(this.bp + n2);
                                            if (c != 't') break block12;
                                            if (this.charAt(this.bp + n++) != 'r') {
                                                this.matchStat = -1;
                                                return false;
                                            }
                                            if (this.charAt(this.bp + n++) != 'u') {
                                                this.matchStat = -1;
                                                return false;
                                            }
                                            if (this.charAt(this.bp + n++) != 'e') {
                                                this.matchStat = -1;
                                                return false;
                                            }
                                            c = '\u0001';
                                            break block13;
                                        }
                                        if (c != 'f') break block14;
                                        if (this.charAt(this.bp + n++) != 'a') {
                                            this.matchStat = -1;
                                            return false;
                                        }
                                        if (this.charAt(this.bp + n++) != 'l') {
                                            this.matchStat = -1;
                                            return false;
                                        }
                                        if (this.charAt(this.bp + n++) != 's') {
                                            this.matchStat = -1;
                                            return false;
                                        }
                                        if (this.charAt(this.bp + n++) != 'e') {
                                            this.matchStat = -1;
                                            return false;
                                        }
                                        c = '\u0000';
                                    }
                                    c2 = this.charAt(this.bp + n++);
                                    if (c2 == ',') {
                                        this.bp = n = this.bp + n;
                                        this.ch = this.charAt(n);
                                        this.matchStat = 3;
                                        this.token = 16;
                                        return c != '\u0000';
                                    }
                                    if (c2 != '}') break block15;
                                    if ((c2 = this.charAt(this.bp + n++)) != ',') break block16;
                                    this.token = 16;
                                    this.bp = n = this.bp + n;
                                    this.ch = this.charAt(n);
                                    break block17;
                                }
                                if (c2 != ']') break block18;
                                this.token = 15;
                                this.bp = n = this.bp + n;
                                this.ch = this.charAt(n);
                                break block17;
                            }
                            if (c2 != '}') break block19;
                            this.token = 13;
                            this.bp = n = this.bp + n;
                            this.ch = this.charAt(n);
                            break block17;
                        }
                        if (c2 != '\u001a') break block20;
                        this.token = 20;
                        this.bp += n - 1;
                        this.ch = (char)26;
                    }
                    this.matchStat = 4;
                    return c != '\u0000';
                }
                this.matchStat = -1;
                return false;
            }
            this.matchStat = -1;
            return false;
        }
        this.matchStat = -1;
        return false;
    }

    public long scanFieldLong(char[] cArray) {
        block11: {
            block12: {
                block17: {
                    long l;
                    boolean bl;
                    block14: {
                        int n;
                        int n2;
                        block16: {
                            block15: {
                                block13: {
                                    this.matchStat = 0;
                                    if (!this.charArrayCompare(cArray)) {
                                        this.matchStat = -2;
                                        return 0L;
                                    }
                                    int n3 = cArray.length;
                                    n2 = n3 + 1;
                                    char c = this.charAt(this.bp + n3);
                                    bl = false;
                                    if (c == '-') {
                                        c = this.charAt(this.bp + n2++);
                                        bl = true;
                                    }
                                    if (c < '0' || c > '9') break block11;
                                    l = c - 48;
                                    while ((c = this.charAt(this.bp + n2++)) >= '0' && c <= '9') {
                                        l = l * 10L + (long)(c - 48);
                                    }
                                    if (c == '.') {
                                        this.matchStat = -1;
                                        return 0L;
                                    }
                                    if (!(n2 - cArray.length < 21 && (l >= 0L || l == Long.MIN_VALUE && bl))) {
                                        this.matchStat = -1;
                                        return 0L;
                                    }
                                    if (c == ',') {
                                        int n4;
                                        this.bp = n4 = this.bp + n2;
                                        this.ch = this.charAt(n4);
                                        this.matchStat = 3;
                                        this.token = 16;
                                        if (bl) {
                                            l = -l;
                                        }
                                        return l;
                                    }
                                    if (c != '}') break block12;
                                    int n5 = n2;
                                    n = n5 + 1;
                                    char c2 = this.charAt(this.bp + n5);
                                    n2 = c2;
                                    if (c2 != ',') break block13;
                                    this.token = 16;
                                    this.bp = n = this.bp + n;
                                    this.ch = this.charAt(n);
                                    break block14;
                                }
                                if (n2 != 93) break block15;
                                this.token = 15;
                                this.bp = n = this.bp + n;
                                this.ch = this.charAt(n);
                                break block14;
                            }
                            if (n2 != 125) break block16;
                            this.token = 13;
                            this.bp = n = this.bp + n;
                            this.ch = this.charAt(n);
                            break block14;
                        }
                        if (n2 != 26) break block17;
                        this.token = 20;
                        this.bp += n - 1;
                        this.ch = (char)26;
                    }
                    this.matchStat = 4;
                    if (bl) {
                        l = -l;
                    }
                    return l;
                }
                this.matchStat = -1;
                return 0L;
            }
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = -1;
        return 0L;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public long scanLong(char var1_1) {
        block11: {
            block9: {
                block10: {
                    this.matchStat = 0;
                    var2_2 = this.bp;
                    var3_3 = 1;
                    v0 = this.charAt(var2_2 + 0);
                    var2_2 = v0;
                    var4_4 = v0 == '\"';
                    if (var4_4) {
                        v1 = var3_3;
                        var3_3 = 2;
                        var2_2 = this.charAt(this.bp + v1);
                    }
                    if (var5_6 = var2_2 == '-') {
                        var2_2 = this.charAt(this.bp + var3_3++);
                    }
                    if (var2_2 < '0' || var2_2 > '9') break block9;
                    var6_7 = var2_2 - 48;
                    while (true) {
                        v2 = this.charAt(this.bp + var3_3++);
                        var2_2 = v2;
                        if (v2 < '0' || var2_2 > '9') break;
                        var6_7 = var6_7 * 10L + (long)(var2_2 - 48);
                    }
                    if (var2_2 == '.') {
                        this.matchStat = -1;
                        return 0L;
                    }
                    v3 = var6_7 >= 0L || var6_7 == -9223372036854775808L && var5_6;
                    if (!v3) break block10;
                    if (!var4_4) ** GOTO lbl32
                    if (var2_2 != '\"') {
                        this.matchStat = -1;
                        return 0L;
                    }
                    do {
                        var2_2 = this.charAt(this.bp + var3_3++);
lbl32:
                        // 2 sources

                        if (var2_2 != var1_1) continue;
                        var1_1 = (char)(this.bp + var3_3);
                        this.bp = var1_1;
                        this.ch = this.charAt(var1_1);
                        this.matchStat = 3;
                        this.token = 16;
                        if (var5_6) {
                            var6_7 = -var6_7;
                        }
                        return var6_7;
                    } while (JSONLexerBase.isWhitespace(var2_2));
                    this.matchStat = -1;
                    return var6_7;
                }
                var1_1 = (char)this.bp;
                var2_2 = var3_3 - 1;
                this = this.subString(var1_1, var2_2);
                throw new NumberFormatException(this);
            }
            if (var2_2 != 'n' || this.charAt(this.bp + var3_3) != 'u' || this.charAt(this.bp + var3_3 + 1) != 'l' || this.charAt(this.bp + var3_3 + 2) != 'l') break block11;
            this.matchStat = 5;
            var4_5 = 0L;
            v4 = var3_3 + 3;
            var1_1 = (char)(v4 + 1);
            var2_2 = this.charAt(this.bp + v4);
            if (!var4_4 || var2_2 != '\"') ** GOTO lbl61
            do {
                v5 = var1_1;
                var1_1 = (char)(v5 + '\u0001');
                var2_2 = this.charAt(this.bp + v5);
lbl61:
                // 2 sources

                if (var2_2 == ',') {
                    var1_1 = (char)(this.bp + var1_1);
                    this.bp = var1_1;
                    this.ch = this.charAt(var1_1);
                    this.matchStat = 5;
                    this.token = 16;
                    return var4_5;
                }
                if (var2_2 != ']') continue;
                var1_1 = (char)(this.bp + var1_1);
                this.bp = var1_1;
                this.ch = this.charAt(var1_1);
                this.matchStat = 5;
                this.token = 15;
                return var4_5;
            } while (JSONLexerBase.isWhitespace(var2_2));
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = -1;
        return 0L;
    }

    /*
     * Unable to fully structure code
     */
    public final float scanFieldFloat(char[] var1_1) {
        block30: {
            block22: {
                block24: {
                    block29: {
                        block26: {
                            block28: {
                                block27: {
                                    block25: {
                                        block23: {
                                            this.matchStat = 0;
                                            if (!this.charArrayCompare(var1_1)) {
                                                this.matchStat = -2;
                                                return 0.0f;
                                            }
                                            v0 = var1_1.length;
                                            var2_8 = v0 + 1;
                                            var3_9 = this.charAt(this.bp + v0);
                                            var4_10 = var3_9 == '\"' ? 1 : 0;
                                            if (var4_10 != 0) {
                                                var3_9 = this.charAt(this.bp + var2_8++);
                                            }
                                            if (var5_11 = var3_9 == '-') {
                                                var3_9 = this.charAt(this.bp + var2_8++);
                                            }
                                            if (var3_9 < '0' || var3_9 > '9') break block22;
                                            var6_12 = var3_9 - 48;
                                            while ((var3_9 = this.charAt(this.bp + var2_8++)) >= '0' && var3_9 <= '9') {
                                                var6_12 = var6_12 * 10L + (long)(var3_9 - 48);
                                            }
                                            var8_13 = 1L;
                                            if (var3_9 == '.') {
                                                if ((var3_9 = this.charAt(this.bp + var2_8++)) >= '0' && var3_9 <= '9') {
                                                    var6_12 = var6_12 * 10L + (long)(var3_9 - 48);
                                                    var8_13 = 10L;
                                                    while ((var3_9 = this.charAt(this.bp + var2_8++)) >= '0' && var3_9 <= '9') {
                                                        var6_12 = var6_12 * 10L + (long)(var3_9 - 48);
                                                        var8_13 *= 10L;
                                                    }
                                                } else {
                                                    this.matchStat = -1;
                                                    return 0.0f;
                                                }
                                            }
                                            var10_14 = var3_9 == 'e' || var3_9 == 'E';
                                            if (!var10_14) break block23;
                                            if ((var3_9 = this.charAt(this.bp + var2_8++)) != '+' && var3_9 != '-') ** GOTO lbl35
                                            do {
                                                var3_9 = this.charAt(this.bp + var2_8++);
lbl35:
                                                // 2 sources

                                            } while (var3_9 >= '0' && var3_9 <= '9');
                                        }
                                        if (var4_10 != 0) {
                                            if (var3_9 != '\"') {
                                                this.matchStat = -1;
                                                return 0.0f;
                                            }
                                            var3_9 = this.charAt(this.bp + var2_8++);
                                            v1 = this.bp;
                                            var1_2 = v1 + var1_1.length + 1;
                                            var4_10 = v1 + var2_8 - var1_2 - 2;
                                        } else {
                                            v2 = this.bp;
                                            var1_2 = v2 + var1_1.length;
                                            var4_10 = v2 + var2_8 - var1_2 - 1;
                                        }
                                        if (!var10_14 && var4_10 < 17) {
                                            var1_3 = (float)((double)var6_12 / (double)var8_13);
                                            if (var5_11) {
                                                var1_3 = -var1_3;
                                            }
                                        } else {
                                            var1_3 = Float.parseFloat(this.subString(var1_2, var4_10));
                                        }
                                        if (var3_9 == ',') {
                                            this.bp = var1_4 = this.bp + var2_8;
                                            this.ch = this.charAt(var1_4);
                                            this.matchStat = 3;
                                            this.token = 16;
                                            return var1_3;
                                        }
                                        if (var3_9 != '}') break block24;
                                        if ((var3_9 = this.charAt(this.bp + var2_8++)) != ',') break block25;
                                        this.token = 16;
                                        this.bp = var2_8 = this.bp + var2_8;
                                        this.ch = this.charAt(var2_8);
                                        break block26;
                                    }
                                    if (var3_9 != ']') break block27;
                                    this.token = 15;
                                    this.bp = var2_8 = this.bp + var2_8;
                                    this.ch = this.charAt(var2_8);
                                    break block26;
                                }
                                if (var3_9 != '}') break block28;
                                this.token = 13;
                                this.bp = var2_8 = this.bp + var2_8;
                                this.ch = this.charAt(var2_8);
                                break block26;
                            }
                            if (var3_9 != '\u001a') break block29;
                            this.bp += var2_8 - 1;
                            this.token = 20;
                            this.ch = (char)26;
                        }
                        this.matchStat = 4;
                        return var1_3;
                    }
                    this.matchStat = -1;
                    return 0.0f;
                }
                this.matchStat = -1;
                return 0.0f;
            }
            if (var3_9 != 'n' || this.charAt(this.bp + var2_8) != 'u' || this.charAt(this.bp + var2_8 + 1) != 'l' || this.charAt(this.bp + var2_8 + 2) != 'l') break block30;
            this.matchStat = 5;
            var1_5 = 0.0f;
            v3 = var2_8 + 3;
            var2_8 = v3 + 1;
            var3_9 = this.charAt(this.bp + v3);
            if (var4_10 == 0 || var3_9 != '\"') ** GOTO lbl103
            do {
                var3_9 = this.charAt(this.bp + var2_8++);
lbl103:
                // 2 sources

                if (var3_9 == ',') {
                    this.bp = var1_6 = this.bp + var2_8;
                    this.ch = this.charAt(var1_6);
                    this.matchStat = 5;
                    this.token = 16;
                    return var1_5;
                }
                if (var3_9 != '}') continue;
                this.bp = var1_7 = this.bp + var2_8;
                this.ch = this.charAt(var1_7);
                this.matchStat = 5;
                this.token = 13;
                return var1_5;
            } while (JSONLexerBase.isWhitespace(var3_9));
            this.matchStat = -1;
            return 0.0f;
        }
        this.matchStat = -1;
        return 0.0f;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final float scanFloat(char var1_1) {
        block21: {
            this.matchStat = 0;
            var2_5 = this.bp;
            var3_6 = 1;
            v0 = this.charAt(var2_5 + 0);
            var2_5 = v0;
            var4_7 = v0 == '\"' ? 1 : 0;
            if (var4_7 != 0) {
                v1 = var3_6;
                var3_6 = 2;
                var2_5 = this.charAt(this.bp + v1);
            }
            if (var5_9 = var2_5 == 45) {
                var2_5 = this.charAt(this.bp + var3_6++);
            }
            if (var2_5 >= 48 && var2_5 <= 57) {
                var6_10 = var2_5 - 48;
                while (true) {
                    v2 = this.charAt(this.bp + var3_6++);
                    var2_5 = v2;
                    if (v2 < '0' || var2_5 > 57) break;
                    var6_10 = var6_10 * 10L + (long)(var2_5 - 48);
                }
                var8_11 = 1L;
                if (var2_5 == 46) {
                    v3 = var3_6;
                    var2_5 = v3 + 1;
                    v4 = this.charAt(this.bp + v3);
                    var3_6 = v4;
                    if (v4 >= '0' && var3_6 <= 57) {
                        var6_10 = var6_10 * 10L + (long)(var3_6 - 48);
                        var8_11 = 10L;
                        while (true) {
                            v5 = this.charAt(this.bp + var2_5++);
                            var3_6 = v5;
                            if (v5 < '0' || var3_6 > 57) break;
                            var6_10 = var6_10 * 10L + (long)(var3_6 - 48);
                            var8_11 *= 10L;
                        }
                        v6 = var3_6;
                        var3_6 = var2_5;
                        var2_5 = v6;
                    } else {
                        this.matchStat = -1;
                        return 0.0f;
                    }
                }
                var10_12 = var2_5 == 101 || var2_5 == 69;
                if (var10_12) {
                    v7 = var3_6;
                    var2_5 = v7 + 1;
                    v8 = this.charAt(this.bp + v7);
                    var3_6 = v8;
                    if (v8 != '+' && var3_6 != 45) {
                        v9 = var3_6;
                        var3_6 = var2_5;
                        var2_5 = v9;
                    } else {
                        v10 = var3_6 = this.charAt(this.bp + var2_5++);
                        var3_6 = var2_5;
                        var2_5 = v10;
                    }
                    while (var2_5 >= 48 && var2_5 <= 57) {
                        v11 = var3_6;
                        var2_5 = v11 + 1;
                        v12 = var3_6 = (int)this.charAt(this.bp + v11);
                        var3_6 = var2_5;
                        var2_5 = v12;
                    }
                }
                if (var4_7 != 0) {
                    if (var2_5 != 34) {
                        this.matchStat = -1;
                        return 0.0f;
                    }
                    var2_5 = this.charAt(this.bp + var3_6++);
                    v13 = this.bp;
                    var4_7 = v13 + 1;
                    var11_13 = v13 + var3_6 - var4_7 - 2;
                } else {
                    var4_7 = this.bp;
                    var11_13 = var4_7 + var3_6 - var4_7 - 1;
                }
                if (!var10_12 && var11_13 < 17) {
                    var4_8 = (float)((double)var6_10 / (double)var8_11);
                    if (var5_9) {
                        var4_8 = -var4_8;
                    }
                } else {
                    var4_8 = Float.parseFloat(this.subString(var4_7, var11_13));
                }
                if (var2_5 == var1_1) {
                    this.bp = var1_1 = this.bp + var3_6;
                    this.ch = this.charAt(var1_1);
                    this.matchStat = 3;
                    this.token = 16;
                    return var4_8;
                }
                this.matchStat = -1;
                return var4_8;
            }
            if (var2_5 != 110 || this.charAt(this.bp + var3_6) != 'u' || this.charAt(this.bp + var3_6 + 1) != 'l' || this.charAt(this.bp + var3_6 + 2) != 'l') break block21;
            this.matchStat = 5;
            var1_2 = 0.0f;
            v14 = var3_6 + 3;
            var2_5 = v14 + 1;
            var3_6 = this.charAt(this.bp + v14);
            if (var4_7 == 0 || var3_6 != 34) ** GOTO lbl98
            do {
                var3_6 = this.charAt(this.bp + var2_5++);
lbl98:
                // 2 sources

                if (var3_6 == 44) {
                    this.bp = var1_3 = this.bp + var2_5;
                    this.ch = this.charAt(var1_3);
                    this.matchStat = 5;
                    this.token = 16;
                    return var1_2;
                }
                if (var3_6 != 93) continue;
                this.bp = var1_4 = this.bp + var2_5;
                this.ch = this.charAt(var1_4);
                this.matchStat = 5;
                this.token = 15;
                return var1_2;
            } while (JSONLexerBase.isWhitespace((char)var3_6));
            this.matchStat = -1;
            return 0.0f;
        }
        this.matchStat = -1;
        return 0.0f;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double scanDouble(char var1_1) {
        block21: {
            this.matchStat = 0;
            var2_2 = this.bp;
            var3_3 = 1;
            v0 = this.charAt(var2_2 + 0);
            var2_2 = v0;
            var4_4 = v0 == '\"' ? 1 : 0;
            if (var4_4 != 0) {
                v1 = var3_3;
                var3_3 = 2;
                var2_2 = this.charAt(this.bp + v1);
            }
            if (var5_7 = var2_2 == 45) {
                var2_2 = this.charAt(this.bp + var3_3++);
            }
            if (var2_2 >= 48 && var2_2 <= 57) {
                var6_8 = var2_2 - 48;
                while (true) {
                    v2 = this.charAt(this.bp + var3_3++);
                    var2_2 = v2;
                    if (v2 < '0' || var2_2 > 57) break;
                    var6_8 = var6_8 * 10L + (long)(var2_2 - 48);
                }
                var8_9 = 1L;
                if (var2_2 == 46) {
                    v3 = var3_3;
                    var2_2 = v3 + 1;
                    v4 = this.charAt(this.bp + v3);
                    var3_3 = v4;
                    if (v4 >= '0' && var3_3 <= 57) {
                        var6_8 = var6_8 * 10L + (long)(var3_3 - 48);
                        var8_9 = 10L;
                        while (true) {
                            v5 = this.charAt(this.bp + var2_2++);
                            var3_3 = v5;
                            if (v5 < '0' || var3_3 > 57) break;
                            var6_8 = var6_8 * 10L + (long)(var3_3 - 48);
                            var8_9 *= 10L;
                        }
                        v6 = var3_3;
                        var3_3 = var2_2;
                        var2_2 = v6;
                    } else {
                        this.matchStat = -1;
                        return 0.0;
                    }
                }
                var10_10 = var2_2 == 101 || var2_2 == 69;
                if (var10_10) {
                    v7 = var3_3;
                    var2_2 = v7 + 1;
                    v8 = this.charAt(this.bp + v7);
                    var3_3 = v8;
                    if (v8 != '+' && var3_3 != 45) {
                        v9 = var3_3;
                        var3_3 = var2_2;
                        var2_2 = v9;
                    } else {
                        v10 = var3_3 = this.charAt(this.bp + var2_2++);
                        var3_3 = var2_2;
                        var2_2 = v10;
                    }
                    while (var2_2 >= 48 && var2_2 <= 57) {
                        v11 = var3_3;
                        var2_2 = v11 + 1;
                        v12 = var3_3 = (int)this.charAt(this.bp + v11);
                        var3_3 = var2_2;
                        var2_2 = v12;
                    }
                }
                if (var4_4 != 0) {
                    if (var2_2 != 34) {
                        this.matchStat = -1;
                        return 0.0;
                    }
                    var2_2 = this.charAt(this.bp + var3_3++);
                    v13 = this.bp;
                    var4_4 = v13 + 1;
                    var11_11 = v13 + var3_3 - var4_4 - 2;
                } else {
                    var4_4 = this.bp;
                    var11_11 = var4_4 + var3_3 - var4_4 - 1;
                }
                if (!var10_10 && var11_11 < 17) {
                    var4_5 = (double)var6_8 / (double)var8_9;
                    if (var5_7) {
                        var4_5 = -var4_5;
                    }
                } else {
                    var4_5 = Double.parseDouble(this.subString(var4_4, var11_11));
                }
                if (var2_2 == var1_1) {
                    this.bp = var1_1 = this.bp + var3_3;
                    this.ch = this.charAt(var1_1);
                    this.matchStat = 3;
                    this.token = 16;
                    return var4_5;
                }
                this.matchStat = -1;
                return var4_5;
            }
            if (var2_2 != 110 || this.charAt(this.bp + var3_3) != 'u' || this.charAt(this.bp + var3_3 + 1) != 'l' || this.charAt(this.bp + var3_3 + 2) != 'l') break block21;
            this.matchStat = 5;
            var4_6 = 0.0;
            v14 = var3_3 + 3;
            var1_1 = v14 + 1;
            var2_2 = this.charAt(this.bp + v14);
            if (var4_4 == 0 || var2_2 != 34) ** GOTO lbl98
            do {
                var2_2 = this.charAt(this.bp + var1_1++);
lbl98:
                // 2 sources

                if (var2_2 == 44) {
                    this.bp = var1_1 = (int)(this.bp + var1_1);
                    this.ch = this.charAt(var1_1);
                    this.matchStat = 5;
                    this.token = 16;
                    return var4_6;
                }
                if (var2_2 != 93) continue;
                this.bp = var1_1 = this.bp + var1_1;
                this.ch = this.charAt(var1_1);
                this.matchStat = 5;
                this.token = 15;
                return var4_6;
            } while (JSONLexerBase.isWhitespace((char)var2_2));
            this.matchStat = -1;
            return 0.0;
        }
        this.matchStat = -1;
        return 0.0;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public BigDecimal scanDecimal(char var1_1) {
        block28: {
            block20: {
                block21: {
                    block22: {
                        block27: {
                            block24: {
                                block26: {
                                    block25: {
                                        block23: {
                                            this.matchStat = 0;
                                            var1_1 = (char)this.bp;
                                            var2_5 = 1;
                                            var3_6 = (var1_1 = this.charAt(var1_1 + '\u0000')) == '\"' ? '\u0001' : '\u0000';
                                            if (var3_6 != '\u0000') {
                                                v0 = var2_5;
                                                var2_5 = 2;
                                                var1_1 = this.charAt(this.bp + v0);
                                            }
                                            if (var1_1 == '-') {
                                                var1_1 = this.charAt(this.bp + var2_5++);
                                            }
                                            if (var1_1 < '0' || var1_1 > '9') break block20;
                                            while ((var1_1 = this.charAt(this.bp + var2_5++)) >= '0' && var1_1 <= '9') {
                                            }
                                            if (var1_1 == '.') {
                                                v1 = var2_5;
                                                var1_1 = (char)(v1 + 1);
                                                v2 = this.charAt(this.bp + v1);
                                                var2_5 = v2;
                                                if (v2 >= '0' && var2_5 <= 57) {
                                                    do {
                                                        v3 = var1_1;
                                                        var1_1 = (char)(v3 + '\u0001');
                                                        v4 = this.charAt(this.bp + v3);
                                                        var2_5 = v4;
                                                    } while (v4 >= '0' && var2_5 <= 57);
                                                    v5 = var2_5;
                                                    var2_5 = var1_1;
                                                    var1_1 = (char)v5;
                                                } else {
                                                    this.matchStat = -1;
                                                    return null;
                                                }
                                            }
                                            v6 = var1_1 == 'e' || var1_1 == 'E';
                                            if (v6) {
                                                v7 = var2_5;
                                                var1_1 = (char)(v7 + 1);
                                                v8 = this.charAt(this.bp + v7);
                                                var2_5 = v8;
                                                if (v8 != '+' && var2_5 != 45) {
                                                    v9 = var2_5;
                                                    var2_5 = var1_1;
                                                    var1_1 = (char)v9;
                                                } else {
                                                    v10 = var1_1;
                                                    var1_1 = (char)(v10 + '\u0001');
                                                    v11 = var2_5 = (int)this.charAt(this.bp + v10);
                                                    var2_5 = var1_1;
                                                    var1_1 = (char)v11;
                                                }
                                                while (var1_1 >= '0' && var1_1 <= '9') {
                                                    v12 = var2_5;
                                                    var1_1 = (char)(v12 + 1);
                                                    v13 = var2_5 = (int)this.charAt(this.bp + v12);
                                                    var2_5 = var1_1;
                                                    var1_1 = (char)v13;
                                                }
                                            }
                                            if (var3_6 != '\u0000') {
                                                if (var1_1 != '\"') {
                                                    this.matchStat = -1;
                                                    return null;
                                                }
                                                var1_1 = this.charAt(this.bp + var2_5++);
                                                v14 = this.bp;
                                                var3_6 = v14 + 1;
                                                var4_8 = v14 + var2_5 - var3_6 - 2;
                                            } else {
                                                var3_6 = this.bp;
                                                var4_8 = var3_6 + var2_5 - var3_6 - 1;
                                            }
                                            if (var4_8 > 65535) break block21;
                                            var3_7 = this.sub_chars(var3_6, var4_8);
                                            var4_9 = v15;
                                            var5_10 = var3_7.length;
                                            var6_11 = MathContext.UNLIMITED;
                                            v15 = new BigDecimal(var3_7, 0, var5_10, var6_11);
                                            if (var1_1 == ',') {
                                                var1_1 = (char)(this.bp + var2_5);
                                                this.bp = var1_1;
                                                this.ch = this.charAt(var1_1);
                                                this.matchStat = 3;
                                                this.token = 16;
                                                return var4_9;
                                            }
                                            if (var1_1 != ']') break block22;
                                            v16 = var2_5;
                                            var1_1 = (char)(v16 + 1);
                                            v17 = this.charAt(this.bp + v16);
                                            var2_5 = v17;
                                            if (v17 != ',') break block23;
                                            this.token = 16;
                                            var1_1 = (char)(this.bp + var1_1);
                                            this.bp = var1_1;
                                            this.ch = this.charAt(var1_1);
                                            break block24;
                                        }
                                        if (var2_5 != 93) break block25;
                                        this.token = 15;
                                        var1_1 = (char)(this.bp + var1_1);
                                        this.bp = var1_1;
                                        this.ch = this.charAt(var1_1);
                                        break block24;
                                    }
                                    if (var2_5 != 125) break block26;
                                    this.token = 13;
                                    var1_1 = (char)(this.bp + var1_1);
                                    this.bp = var1_1;
                                    this.ch = this.charAt(var1_1);
                                    break block24;
                                }
                                if (var2_5 != 26) break block27;
                                this.token = 20;
                                this.bp += var1_1 - '\u0001';
                                this.ch = (char)26;
                            }
                            this.matchStat = 4;
                            return var4_9;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    this.matchStat = -1;
                    return null;
                }
                throw new JSONException("decimal overflow");
            }
            if (var1_1 != 'n' || this.charAt(this.bp + var2_5) != 'u' || this.charAt(this.bp + var2_5 + 1) != 'l' || this.charAt(this.bp + var2_5 + 2) != 'l') break block28;
            v18 = var3_6;
            this.matchStat = 5;
            var1_2 = null;
            v19 = var2_5 + 3;
            var2_5 = v19 + 1;
            var3_6 = this.charAt(this.bp + v19);
            if (v18 == '\u0000' || var3_6 != '\"') ** GOTO lbl131
            do {
                var3_6 = this.charAt(this.bp + var2_5++);
lbl131:
                // 2 sources

                if (var3_6 == ',') {
                    this.bp = var1_3 = this.bp + var2_5;
                    this.ch = this.charAt(var1_3);
                    this.matchStat = 5;
                    this.token = 16;
                    return var1_2;
                }
                if (var3_6 != '}') continue;
                this.bp = var1_4 = this.bp + var2_5;
                this.ch = this.charAt(var1_4);
                this.matchStat = 5;
                this.token = 13;
                return var1_2;
            } while (JSONLexerBase.isWhitespace(var3_6));
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final float[] scanFieldFloatArray(char[] var1_1) {
        this.matchStat = 0;
        if (!this.charArrayCompare(var1_1)) {
            this.matchStat = -2;
            return null;
        }
        v0 = var1_1.length;
        var1_2 = v0 + 1;
        if (this.charAt(this.bp + v0) != '[') {
            this.matchStat = -2;
            return null;
        }
        var2_3 = this.charAt(this.bp + var1_2++);
        var3_6 = new float[16];
        var4_7 = 0;
        while (true) {
            block23: {
                block24: {
                    block25: {
                        block30: {
                            block27: {
                                block29: {
                                    block28: {
                                        block26: {
                                            block22: {
                                                block21: {
                                                    var5_8 = this.bp;
                                                    var6_9 = var5_8 + var1_2 - 1;
                                                    var7_10 = var2_3 == 45;
                                                    if (var7_10) {
                                                        var2_3 = var1_2 + 1;
                                                        v1 = var1_2 = (int)this.charAt(var5_8 + var1_2);
                                                        var1_2 = var2_3;
                                                        var2_3 = v1;
                                                    }
                                                    if (var2_3 < 48 || var2_3 > 57) break;
                                                    var2_3 -= 48;
                                                    while (true) {
                                                        v2 = this.charAt(this.bp + var1_2++);
                                                        var5_8 = v2;
                                                        if (v2 < '0' || var5_8 > 57) break;
                                                        var2_3 = var2_3 * 10 + (var5_8 - 48);
                                                    }
                                                    var8_11 = 1;
                                                    if (var5_8 == 46) {
                                                        v3 = this.charAt(this.bp + var1_2++);
                                                        var5_8 = v3;
                                                        var8_11 = 10;
                                                        if (v3 >= '0' && var5_8 <= 57) {
                                                            var2_3 = var2_3 * 10 + (var5_8 - 48);
                                                            while (true) {
                                                                v4 = this.charAt(this.bp + var1_2++);
                                                                var5_8 = v4;
                                                                if (v4 >= '0' && var5_8 <= 57) {
                                                                    var2_3 = var2_3 * 10 + (var5_8 - 48);
                                                                    var8_11 = var5_8 = var8_11 * 10;
                                                                    continue;
                                                                }
                                                                break;
                                                            }
                                                        } else {
                                                            this.matchStat = -1;
                                                            return null;
                                                        }
                                                    }
                                                    var9_12 = var5_8 != 101 && var5_8 != 69 ? 0 : 1;
                                                    if (var9_12 == 0) break block21;
                                                    v5 = this.charAt(this.bp + var1_2++);
                                                    var5_8 = v5;
                                                    if (v5 != '+' && var5_8 != 45) ** GOTO lbl54
                                                    do {
                                                        var5_8 = this.charAt(this.bp + var1_2++);
lbl54:
                                                        // 2 sources

                                                    } while (var5_8 >= 48 && var5_8 <= 57);
                                                }
                                                v6 = var9_12;
                                                var9_12 = this.bp + var1_2 - var6_9 - 1;
                                                if (v6 == 0 && var9_12 < 10) {
                                                    var2_4 = (float)var2_3 / (float)var8_11;
                                                    if (var7_10) {
                                                        var2_4 = -var2_4;
                                                    }
                                                } else {
                                                    var2_4 = Float.parseFloat(this.subString(var6_9, var9_12));
                                                }
                                                if (var4_7 >= var3_6.length) {
                                                    var3_6 = new float[var3_6.length * 3 / 2];
                                                    System.arraycopy(var3_6, 0, var3_6, 0, var4_7);
                                                }
                                                var6_9 = var4_7 + 1;
                                                var3_6[var4_7] = var2_4;
                                                if (var5_8 != 44) break block22;
                                                var2_3 = this.charAt(this.bp + var1_2++);
                                                break block23;
                                            }
                                            if (var5_8 != 93) break block24;
                                            var2_5 = this.charAt(this.bp + var1_2++);
                                            if (var6_9 != var3_6.length) {
                                                v7 = var3_6;
                                                var3_6 = new float[var6_9];
                                                System.arraycopy(v7, 0, var3_6, 0, var6_9);
                                            }
                                            if (var2_5 == ',') {
                                                this.bp += var1_2 - 1;
                                                this.next();
                                                this.matchStat = 3;
                                                this.token = 16;
                                                return var3_6;
                                            }
                                            if (var2_5 != '}') break block25;
                                            if ((var2_5 = this.charAt(this.bp + var1_2++)) != ',') break block26;
                                            this.token = 16;
                                            this.bp += var1_2 - 1;
                                            this.next();
                                            break block27;
                                        }
                                        if (var2_5 != ']') break block28;
                                        this.token = 15;
                                        this.bp += var1_2 - 1;
                                        this.next();
                                        break block27;
                                    }
                                    if (var2_5 != '}') break block29;
                                    this.token = 13;
                                    this.bp += var1_2 - 1;
                                    this.next();
                                    break block27;
                                }
                                if (var2_5 != '\u001a') break block30;
                                this.bp += var1_2 - 1;
                                this.token = 20;
                                this.ch = (char)26;
                            }
                            this.matchStat = 4;
                            return var3_6;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    this.matchStat = -1;
                    return null;
                }
                var2_3 = var5_8;
            }
            var4_7 = var6_9;
        }
        this.matchStat = -1;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final float[][] scanFieldFloatArray2(char[] var1_1) {
        block31: {
            block36: {
                block33: {
                    block35: {
                        block34: {
                            block32: {
                                this.matchStat = 0;
                                if (!this.charArrayCompare(var1_1)) {
                                    this.matchStat = -2;
                                    return null;
                                }
                                v0 = var1_1.length;
                                var1_2 = v0 + 1;
                                if (this.charAt(this.bp + v0) != '[') {
                                    this.matchStat = -2;
                                    return null;
                                }
                                var2_3 = this.charAt(this.bp + var1_2++);
                                var3_5 = new float[16][];
                                var4_6 = 0;
                                block0: while (var2_3 == 91) {
                                    var2_3 = this.charAt(this.bp + var1_2++);
                                    var5_7 = new float[16];
                                    var6_8 = 0;
                                    while (true) {
                                        block30: {
                                            var7_9 = this.bp;
                                            var8_10 = var7_9 + var1_2 - 1;
                                            var9_11 = var2_3 == 45;
                                            if (var9_11) {
                                                var2_3 = var1_2 + 1;
                                                v1 = var1_2 = (int)this.charAt(var7_9 + var1_2);
                                                var1_2 = var2_3;
                                                var2_3 = v1;
                                            }
                                            if (var2_3 < 48 || var2_3 > 57) break;
                                            var2_3 -= 48;
                                            while (true) {
                                                v2 = this.charAt(this.bp + var1_2++);
                                                var7_9 = v2;
                                                if (v2 < '0' || var7_9 > 57) break;
                                                var2_3 = var2_3 * 10 + (var7_9 - 48);
                                            }
                                            var10_12 = 1;
                                            if (var7_9 == 46) {
                                                v3 = this.charAt(this.bp + var1_2++);
                                                var7_9 = v3;
                                                if (v3 >= '0' && var7_9 <= 57) {
                                                    var2_3 = var2_3 * 10 + (var7_9 - 48);
                                                    var10_12 = var7_9 = 10;
                                                    while (true) {
                                                        v4 = this.charAt(this.bp + var1_2++);
                                                        var7_9 = v4;
                                                        if (v4 >= '0' && var7_9 <= 57) {
                                                            var2_3 = var2_3 * 10 + (var7_9 - 48);
                                                            var10_12 = var7_9 = var10_12 * 10;
                                                            continue;
                                                        }
                                                        break;
                                                    }
                                                } else {
                                                    this.matchStat = -1;
                                                    return null;
                                                }
                                            }
                                            var11_13 = var7_9 != 101 && var7_9 != 69 ? 0 : 1;
                                            if (var11_13 == 0) break block30;
                                            v5 = this.charAt(this.bp + var1_2++);
                                            var7_9 = v5;
                                            if (v5 != '+' && var7_9 != 45) ** GOTO lbl58
                                            do {
                                                var7_9 = this.charAt(this.bp + var1_2++);
lbl58:
                                                // 2 sources

                                            } while (var7_9 >= 48 && var7_9 <= 57);
                                        }
                                        v6 = var11_13;
                                        var11_13 = this.bp + var1_2 - var8_10 - 1;
                                        if (v6 == 0 && var11_13 < 10) {
                                            var2_4 = (float)var2_3 / (float)var10_12;
                                            if (var9_11) {
                                                var2_4 = -var2_4;
                                            }
                                        } else {
                                            var2_4 = Float.parseFloat(this.subString(var8_10, var11_13));
                                        }
                                        if (var6_8 >= var5_7.length) {
                                            var5_7 = new float[var5_7.length * 3 / 2];
                                            System.arraycopy(var5_7, 0, var5_7, 0, var6_8);
                                        }
                                        var8_10 = var6_8 + 1;
                                        var5_7[var6_8] = var2_4;
                                        if (var7_9 == 44) {
                                            var2_3 = this.charAt(this.bp + var1_2++);
                                        } else {
                                            if (var7_9 == 93) {
                                                var2_3 = this.charAt(this.bp + var1_2++);
                                                if (var8_10 != var5_7.length) {
                                                    v7 = var5_7;
                                                    var5_7 = new float[var8_10];
                                                    System.arraycopy(v7, 0, var5_7, 0, var8_10);
                                                }
                                                if (var4_6 >= var3_5.length) {
                                                    var3_5 = new float[var3_5.length * 3 / 2][];
                                                    System.arraycopy(var5_7, 0, var3_5, 0, var8_10);
                                                }
                                                var6_8 = var4_6 + 1;
                                                var3_5[var4_6] = var5_7;
                                                if (var2_3 == 44) {
                                                    var2_3 = this.charAt(this.bp + var1_2++);
                                                } else if (var2_3 == 93) {
                                                    var2_3 = this.charAt(this.bp + var1_2++);
                                                    var4_6 = var6_8;
                                                    break block0;
                                                }
                                                var4_6 = var6_8;
                                                continue block0;
                                            }
                                            var2_3 = var7_9;
                                        }
                                        var6_8 = var8_10;
                                    }
                                    this.matchStat = -1;
                                    return null;
                                }
                                if (var4_6 != var3_5.length) {
                                    v8 = var3_5;
                                    var3_5 = new float[var4_6][];
                                    System.arraycopy(v8, 0, var3_5, 0, var4_6);
                                }
                                if (var2_3 == 44) {
                                    this.bp += var1_2 - 1;
                                    this.next();
                                    this.matchStat = 3;
                                    this.token = 16;
                                    return var3_5;
                                }
                                if (var2_3 != 125) break block31;
                                if ((var2_3 = this.charAt(this.bp + var1_2++)) != 44) break block32;
                                this.token = 16;
                                this.bp += var1_2 - 1;
                                this.next();
                                break block33;
                            }
                            if (var2_3 != 93) break block34;
                            this.token = 15;
                            this.bp += var1_2 - 1;
                            this.next();
                            break block33;
                        }
                        if (var2_3 != 125) break block35;
                        this.token = 13;
                        this.bp += var1_2 - 1;
                        this.next();
                        break block33;
                    }
                    if (var2_3 != 26) break block36;
                    this.bp += var1_2 - 1;
                    this.token = 20;
                    this.ch = (char)26;
                }
                this.matchStat = 4;
                return var3_5;
            }
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final double scanFieldDouble(char[] var1_1) {
        block30: {
            block22: {
                block24: {
                    block29: {
                        block26: {
                            block28: {
                                block27: {
                                    block25: {
                                        block23: {
                                            this.matchStat = 0;
                                            if (!this.charArrayCompare(var1_1)) {
                                                this.matchStat = -2;
                                                return 0.0;
                                            }
                                            v0 = var1_1.length;
                                            var2_4 = v0 + 1;
                                            var3_5 = this.charAt(this.bp + v0);
                                            var4_7 = var3_5 == '\"' ? 1 : 0;
                                            if (var4_7 != 0) {
                                                var3_5 = this.charAt(this.bp + var2_4++);
                                            }
                                            if (var5_9 = var3_5 == '-') {
                                                var3_5 = this.charAt(this.bp + var2_4++);
                                            }
                                            if (var3_5 < '0' || var3_5 > '9') break block22;
                                            var6_10 = var3_5 - 48;
                                            while ((var3_5 = this.charAt(this.bp + var2_4++)) >= '0' && var3_5 <= '9') {
                                                var6_10 = var6_10 * 10L + (long)(var3_5 - 48);
                                            }
                                            var8_11 = 1L;
                                            if (var3_5 == '.') {
                                                if ((var3_5 = this.charAt(this.bp + var2_4++)) >= '0' && var3_5 <= '9') {
                                                    var6_10 = var6_10 * 10L + (long)(var3_5 - 48);
                                                    var8_11 = 10L;
                                                    while ((var3_5 = this.charAt(this.bp + var2_4++)) >= '0' && var3_5 <= '9') {
                                                        var6_10 = var6_10 * 10L + (long)(var3_5 - 48);
                                                        var8_11 *= 10L;
                                                    }
                                                } else {
                                                    this.matchStat = -1;
                                                    return 0.0;
                                                }
                                            }
                                            var10_12 = var3_5 == 'e' || var3_5 == 'E';
                                            if (!var10_12) break block23;
                                            if ((var3_5 = this.charAt(this.bp + var2_4++)) != '+' && var3_5 != '-') ** GOTO lbl35
                                            do {
                                                var3_5 = this.charAt(this.bp + var2_4++);
lbl35:
                                                // 2 sources

                                            } while (var3_5 >= '0' && var3_5 <= '9');
                                        }
                                        if (var4_7 != 0) {
                                            if (var3_5 != '\"') {
                                                this.matchStat = -1;
                                                return 0.0;
                                            }
                                            var3_5 = this.charAt(this.bp + var2_4++);
                                            v1 = this.bp;
                                            var1_2 = v1 + var1_1.length + 1;
                                            var4_7 = v1 + var2_4 - var1_2 - 2;
                                        } else {
                                            v2 = this.bp;
                                            var1_2 = v2 + var1_1.length;
                                            var4_7 = v2 + var2_4 - var1_2 - 1;
                                        }
                                        if (!var10_12 && var4_7 < 17) {
                                            var4_8 = (double)var6_10 / (double)var8_11;
                                            if (var5_9) {
                                                var4_8 = -var4_8;
                                            }
                                        } else {
                                            var4_8 = Double.parseDouble(this.subString(var1_2, var4_7));
                                        }
                                        if (var3_5 == ',') {
                                            this.bp = var1_2 = this.bp + var2_4;
                                            this.ch = this.charAt(var1_2);
                                            this.matchStat = 3;
                                            this.token = 16;
                                            return var4_8;
                                        }
                                        if (var3_5 != '}') break block24;
                                        v3 = var2_4;
                                        var1_2 = v3 + 1;
                                        v4 = this.charAt(this.bp + v3);
                                        var2_4 = v4;
                                        if (v4 != ',') break block25;
                                        this.token = 16;
                                        this.bp = var1_2 = this.bp + var1_2;
                                        this.ch = this.charAt(var1_2);
                                        break block26;
                                    }
                                    if (var2_4 != 93) break block27;
                                    this.token = 15;
                                    this.bp = var1_2 = this.bp + var1_2;
                                    this.ch = this.charAt(var1_2);
                                    break block26;
                                }
                                if (var2_4 != 125) break block28;
                                this.token = 13;
                                this.bp = var1_2 = this.bp + var1_2;
                                this.ch = this.charAt(var1_2);
                                break block26;
                            }
                            if (var2_4 != 26) break block29;
                            this.token = 20;
                            this.bp += var1_2 - 1;
                            this.ch = (char)26;
                        }
                        this.matchStat = 4;
                        return var4_8;
                    }
                    this.matchStat = -1;
                    return 0.0;
                }
                this.matchStat = -1;
                return 0.0;
            }
            if (var3_5 != 'n' || this.charAt(this.bp + var2_4) != 'u' || this.charAt(this.bp + var2_4 + 1) != 'l' || this.charAt(this.bp + var2_4 + 2) != 'l') break block30;
            this.matchStat = 5;
            var3_6 = 0.0;
            v5 = var2_4 + 3;
            var1_3 = v5 + 1;
            var2_4 = this.charAt(this.bp + v5);
            if (var4_7 == 0 || var2_4 != 34) ** GOTO lbl107
            do {
                var2_4 = this.charAt(this.bp + var1_3++);
lbl107:
                // 2 sources

                if (var2_4 == 44) {
                    this.bp = var1_3 = this.bp + var1_3;
                    this.ch = this.charAt(var1_3);
                    this.matchStat = 5;
                    this.token = 16;
                    return var3_6;
                }
                if (var2_4 != 125) continue;
                this.bp = var1_3 = this.bp + var1_3;
                this.ch = this.charAt(var1_3);
                this.matchStat = 5;
                this.token = 13;
                return var3_6;
            } while (JSONLexerBase.isWhitespace((char)var2_4));
            this.matchStat = -1;
            return 0.0;
        }
        this.matchStat = -1;
        return 0.0;
    }

    /*
     * Unable to fully structure code
     */
    public BigDecimal scanFieldDecimal(char[] var1_1) {
        block27: {
            block18: {
                block20: {
                    block21: {
                        block26: {
                            block23: {
                                block25: {
                                    block24: {
                                        block22: {
                                            block19: {
                                                this.matchStat = 0;
                                                if (!this.charArrayCompare(var1_1)) {
                                                    this.matchStat = -2;
                                                    return null;
                                                }
                                                v0 = var1_1.length;
                                                var2_8 = v0 + 1;
                                                var3_9 = this.charAt(this.bp + v0);
                                                var4_10 = var3_9 == '\"' ? 1 : 0;
                                                if (var4_10 != 0) {
                                                    var3_9 = this.charAt(this.bp + var2_8++);
                                                }
                                                if (var3_9 == '-') {
                                                    var3_9 = this.charAt(this.bp + var2_8++);
                                                }
                                                if (var3_9 < '0' || var3_9 > '9') break block18;
                                                while ((var3_9 = this.charAt(this.bp + var2_8++)) >= '0' && var3_9 <= '9') {
                                                }
                                                if (var3_9 == '.') {
                                                    if ((var3_9 = this.charAt(this.bp + var2_8++)) >= '0' && var3_9 <= '9') {
                                                        while ((var3_9 = this.charAt(this.bp + var2_8++)) >= '0' && var3_9 <= '9') {
                                                        }
                                                    } else {
                                                        this.matchStat = -1;
                                                        return null;
                                                    }
                                                }
                                                v1 = var3_9 == 'e' || var3_9 == 'E';
                                                if (!v1) break block19;
                                                if ((var3_9 = this.charAt(this.bp + var2_8++)) != '+' && var3_9 != '-') ** GOTO lbl28
                                                do {
                                                    var3_9 = this.charAt(this.bp + var2_8++);
lbl28:
                                                    // 2 sources

                                                } while (var3_9 >= '0' && var3_9 <= '9');
                                            }
                                            if (var4_10 != 0) {
                                                if (var3_9 != '\"') {
                                                    this.matchStat = -1;
                                                    return null;
                                                }
                                                var3_9 = this.charAt(this.bp + var2_8++);
                                                v2 = this.bp;
                                                var1_2 = v2 + var1_1.length + 1;
                                                var4_10 = v2 + var2_8 - var1_2 - 2;
                                            } else {
                                                v3 = this.bp;
                                                var1_2 = v3 + var1_1.length;
                                                var4_10 = v3 + var2_8 - var1_2 - 1;
                                            }
                                            if (var4_10 > 65535) break block20;
                                            var1_3 = this.sub_chars(var1_2, var4_10);
                                            var4_11 = v4;
                                            var5_12 = var1_3.length;
                                            var6_13 = MathContext.UNLIMITED;
                                            v4 = new BigDecimal(var1_3, 0, var5_12, var6_13);
                                            if (var3_9 == ',') {
                                                this.bp = var1_4 = this.bp + var2_8;
                                                this.ch = this.charAt(var1_4);
                                                this.matchStat = 3;
                                                this.token = 16;
                                                return var4_11;
                                            }
                                            if (var3_9 != '}') break block21;
                                            v5 = var2_8;
                                            var1_5 = v5 + 1;
                                            v6 = this.charAt(this.bp + v5);
                                            var2_8 = v6;
                                            if (v6 != ',') break block22;
                                            this.token = 16;
                                            this.bp = var1_5 = this.bp + var1_5;
                                            this.ch = this.charAt(var1_5);
                                            break block23;
                                        }
                                        if (var2_8 != 93) break block24;
                                        this.token = 15;
                                        this.bp = var1_5 = this.bp + var1_5;
                                        this.ch = this.charAt(var1_5);
                                        break block23;
                                    }
                                    if (var2_8 != 125) break block25;
                                    this.token = 13;
                                    this.bp = var1_5 = this.bp + var1_5;
                                    this.ch = this.charAt(var1_5);
                                    break block23;
                                }
                                if (var2_8 != 26) break block26;
                                this.token = 20;
                                this.bp += var1_5 - 1;
                                this.ch = (char)26;
                            }
                            this.matchStat = 4;
                            return var4_11;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    this.matchStat = -1;
                    return null;
                }
                throw new JSONException("scan decimal overflow");
            }
            if (var3_9 != 'n' || this.charAt(this.bp + var2_8) != 'u' || this.charAt(this.bp + var2_8 + 1) != 'l' || this.charAt(this.bp + var2_8 + 2) != 'l') break block27;
            this.matchStat = 5;
            var1_1 = null;
            v7 = var2_8 + 3;
            var2_8 = v7 + 1;
            var3_9 = this.charAt(this.bp + v7);
            if (var4_10 == 0 || var3_9 != '\"') ** GOTO lbl102
            do {
                var3_9 = this.charAt(this.bp + var2_8++);
lbl102:
                // 2 sources

                if (var3_9 == ',') {
                    this.bp = var1_6 = this.bp + var2_8;
                    this.ch = this.charAt(var1_6);
                    this.matchStat = 5;
                    this.token = 16;
                    return var1_1;
                }
                if (var3_9 != '}') continue;
                this.bp = var1_7 = this.bp + var2_8;
                this.ch = this.charAt(var1_7);
                this.matchStat = 5;
                this.token = 13;
                return var1_1;
            } while (JSONLexerBase.isWhitespace(var3_9));
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger scanFieldBigInteger(char[] var1_1) {
        block25: {
            block15: {
                block18: {
                    block19: {
                        block24: {
                            block21: {
                                block23: {
                                    block22: {
                                        block20: {
                                            block17: {
                                                block16: {
                                                    this.matchStat = 0;
                                                    if (!this.charArrayCompare(var1_1)) {
                                                        this.matchStat = -2;
                                                        return null;
                                                    }
                                                    v0 = var1_1.length;
                                                    var2_7 = v0 + 1;
                                                    var3_8 = this.charAt(this.bp + v0);
                                                    var4_11 = var3_8 == '\"' ? 1 : 0;
                                                    if (var4_11 != 0) {
                                                        var3_8 = this.charAt(this.bp + var2_7++);
                                                    }
                                                    if (var5_12 = var3_8 == '-') {
                                                        var3_8 = this.charAt(this.bp + var2_7++);
                                                    }
                                                    if (var3_8 < '0' || var3_8 > '9') break block15;
                                                    var6_13 = var3_8 - 48;
                                                    var3_8 = '\u0000';
                                                    while ((var8_14 = this.charAt(this.bp + var2_7++)) >= '0' && var8_14 <= '9') {
                                                        var9_15 = var6_13 * 10L + (long)(var8_14 - 48);
                                                        if (var9_15 < var6_13) {
                                                            var3_8 = '\u0001';
                                                            break;
                                                        }
                                                        var6_13 = var9_15;
                                                    }
                                                    if (var4_11 != 0) {
                                                        if (var8_14 != '\"') {
                                                            this.matchStat = -1;
                                                            return null;
                                                        }
                                                        var8_14 = this.charAt(this.bp + var2_7++);
                                                        v1 = this.bp;
                                                        var1_2 = v1 + var1_1.length + 1;
                                                        var4_11 = v1 + var2_7 - var1_2 - 2;
                                                    } else {
                                                        v2 = this.bp;
                                                        var1_2 = v2 + var1_1.length;
                                                        var4_11 = v2 + var2_7 - var1_2 - 1;
                                                    }
                                                    if (var3_8 != '\u0000' || var4_11 >= 20 && (!var5_12 || var4_11 >= 21)) break block16;
                                                    if (var5_12) {
                                                        var6_13 = -var6_13;
                                                    }
                                                    var1_3 = BigInteger.valueOf(var6_13);
                                                    break block17;
                                                }
                                                if (var4_11 > 65535) break block18;
                                                var1_3 = this.subString(var1_2, var4_11);
                                                var3_9 = v3;
                                                v3 = new BigInteger((String)var1_3, 10);
                                                var1_3 = var3_9;
                                            }
                                            if (var8_14 == ',') {
                                                this.bp = var1_4 = this.bp + var2_7;
                                                this.ch = this.charAt(var1_4);
                                                this.matchStat = 3;
                                                this.token = 16;
                                                return var1_3;
                                            }
                                            if (var8_14 != '}') break block19;
                                            if ((var3_10 = this.charAt(this.bp + var2_7++)) != ',') break block20;
                                            this.token = 16;
                                            this.bp = var2_7 = this.bp + var2_7;
                                            this.ch = this.charAt(var2_7);
                                            break block21;
                                        }
                                        if (var3_10 != ']') break block22;
                                        this.token = 15;
                                        this.bp = var2_7 = this.bp + var2_7;
                                        this.ch = this.charAt(var2_7);
                                        break block21;
                                    }
                                    if (var3_10 != '}') break block23;
                                    this.token = 13;
                                    this.bp = var2_7 = this.bp + var2_7;
                                    this.ch = this.charAt(var2_7);
                                    break block21;
                                }
                                if (var3_10 != '\u001a') break block24;
                                this.token = 20;
                                this.bp += var2_7 - 1;
                                this.ch = (char)26;
                            }
                            this.matchStat = 4;
                            return var1_3;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    this.matchStat = -1;
                    return null;
                }
                throw new JSONException("scanInteger overflow");
            }
            if (var3_8 != 'n' || this.charAt(this.bp + var2_7) != 'u' || this.charAt(this.bp + var2_7 + 1) != 'l' || this.charAt(this.bp + var2_7 + 2) != 'l') break block25;
            this.matchStat = 5;
            var1_1 = null;
            v4 = var2_7 + 3;
            var2_7 = v4 + 1;
            var3_8 = this.charAt(this.bp + v4);
            if (var4_11 == 0 || var3_8 != '\"') ** GOTO lbl97
            do {
                var3_8 = this.charAt(this.bp + var2_7++);
lbl97:
                // 2 sources

                if (var3_8 == ',') {
                    this.bp = var1_5 = this.bp + var2_7;
                    this.ch = this.charAt(var1_5);
                    this.matchStat = 5;
                    this.token = 16;
                    return var1_1;
                }
                if (var3_8 != '}') continue;
                this.bp = var1_6 = this.bp + var2_7;
                this.ch = this.charAt(var1_6);
                this.matchStat = 5;
                this.token = 13;
                return var1_1;
            } while (JSONLexerBase.isWhitespace(var3_8));
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    public Date scanFieldDate(char[] cArray) {
        block23: {
            block28: {
                Object object;
                block25: {
                    int n;
                    int n2;
                    block27: {
                        block26: {
                            block24: {
                                Date date;
                                this.matchStat = 0;
                                if (!this.charArrayCompare(cArray)) {
                                    this.matchStat = -2;
                                    return null;
                                }
                                int n3 = cArray.length;
                                n2 = n3 + 1;
                                int n4 = this.charAt(this.bp + n3);
                                if (n4 == 34) {
                                    n4 = this.bp + cArray.length + 1;
                                    if ((n4 = this.indexOf('\"', n4)) != -1) {
                                        block22: {
                                            JSONScanner jSONScanner;
                                            int n5 = this.bp + cArray.length + 1;
                                            int n6 = n4 - n5;
                                            String string = this.subString(n5, n6);
                                            if (string.indexOf(92) != -1) {
                                                while (true) {
                                                    int n7 = 0;
                                                    for (n6 = n4 - 1; n6 >= 0 && this.charAt(n6) == '\\'; --n6) {
                                                        ++n7;
                                                    }
                                                    if (n7 % 2 == 0) {
                                                        int n8 = this.bp;
                                                        n7 = n8;
                                                        n7 = n4 - (n7 + cArray.length + 1);
                                                        string = JSONLexerBase.readString(this.sub_chars(n8 + cArray.length + 1, n7), n7);
                                                        break;
                                                    }
                                                    ++n4;
                                                    n4 = this.indexOf('\"', n4);
                                                }
                                            }
                                            n6 = this.bp;
                                            int n9 = n2 + (n4 - (n6 + cArray.length + 1) + 1);
                                            n = n9 + 1;
                                            n2 = this.charAt(n6 + n9);
                                            object = jSONScanner;
                                            try {
                                                if (!new JSONScanner(string).scanISO8601DateIfMatch(false)) break block22;
                                            }
                                            catch (Throwable throwable) {
                                                ((JSONLexerBase)object).close();
                                                throw throwable;
                                            }
                                            Object object2 = object;
                                            object = ((JSONLexerBase)object2).getCalendar().getTime();
                                            ((JSONLexerBase)object2).close();
                                        }
                                        this.matchStat = -1;
                                        ((JSONLexerBase)object).close();
                                        return null;
                                    }
                                    throw new JSONException("unclosed str");
                                }
                                if (n4 != 45 && (n4 < 48 || n4 > 57)) {
                                    this.matchStat = -1;
                                    return null;
                                }
                                long l = 0L;
                                boolean bl = false;
                                if (n4 == 45) {
                                    n4 = this.charAt(this.bp + n2++);
                                    bl = true;
                                }
                                if (n4 >= 48 && n4 <= 57) {
                                    long l2;
                                    l = l2 = (long)(n4 - 48);
                                    while (true) {
                                        char c = this.charAt(this.bp + n2++);
                                        n4 = c;
                                        if (c < '0' || n4 > 57) break;
                                        l = l2 = l * 10L + (long)(n4 - 48);
                                    }
                                }
                                if (l < 0L) {
                                    this.matchStat = -1;
                                    return null;
                                }
                                if (bl) {
                                    l = -l;
                                }
                                Date date2 = date;
                                date = new Date(l);
                                object = date2;
                                n = n2;
                                n2 = n4;
                                if (n2 == 44) {
                                    this.bp = n = this.bp + n;
                                    this.ch = this.charAt(n);
                                    this.matchStat = 3;
                                    return object;
                                }
                                if (n2 != 125) break block23;
                                char c = this.charAt(this.bp + n++);
                                n2 = c;
                                if (c != ',') break block24;
                                this.token = 16;
                                this.bp = n = this.bp + n;
                                this.ch = this.charAt(n);
                                break block25;
                            }
                            if (n2 != 93) break block26;
                            this.token = 15;
                            this.bp = n = this.bp + n;
                            this.ch = this.charAt(n);
                            break block25;
                        }
                        if (n2 != 125) break block27;
                        this.token = 13;
                        this.bp = n = this.bp + n;
                        this.ch = this.charAt(n);
                        break block25;
                    }
                    if (n2 != 26) break block28;
                    this.token = 20;
                    this.bp += n - 1;
                    this.ch = (char)26;
                }
                this.matchStat = 4;
                return object;
            }
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date scanDate(char c) {
        Object object;
        int n;
        block26: {
            Date date;
            block27: {
                JSONScanner jSONScanner;
                this.matchStat = 0;
                c = '\u0001';
                n = this.charAt(this.bp + 0);
                if (n != 34) break block27;
                n = this.bp + 1;
                if ((n = this.indexOf('\"', n)) == -1) {
                    throw new JSONException("unclosed str");
                }
                int n2 = this.bp + 1;
                int n3 = n - n2;
                object = this.subString(n2, n3);
                if (((String)object).indexOf(92) != -1) {
                    while (true) {
                        int n4 = 0;
                        for (n3 = n - 1; n3 >= 0 && this.charAt(n3) == '\\'; ++n4, --n3) {
                        }
                        if (n4 % 2 == 0) {
                            n4 = this.bp;
                            n3 = n - (n4 + 1);
                            object = JSONLexerBase.readString(this.sub_chars(n4 + 1, n3), n3);
                            break;
                        }
                        ++n;
                        n = this.indexOf('\"', n);
                    }
                }
                n3 = this.bp;
                int n5 = c + (n - (n3 + 1) + 1);
                c = (char)(n5 + 1);
                n = this.charAt(n3 + n5);
                JSONScanner jSONScanner2 = jSONScanner;
                try {
                    if (new JSONScanner((String)object).scanISO8601DateIfMatch(false)) {
                        JSONScanner jSONScanner3 = jSONScanner2;
                        object = jSONScanner3.getCalendar().getTime();
                        jSONScanner3.close();
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    jSONScanner2.close();
                    throw throwable;
                }
                {
                    this.matchStat = -1;
                    jSONScanner2.close();
                    return null;
                }
            }
            if (n != 45 && (n < 48 || n > 57)) {
                if (n == 110 && this.charAt(this.bp + c) == 'u' && this.charAt(this.bp + c + 1) == 'l' && this.charAt(this.bp + c + 2) == 'l') {
                    this.matchStat = 5;
                    object = null;
                    c = (char)5;
                    n = this.charAt(this.bp + 4);
                    break block26;
                } else {
                    this.matchStat = -1;
                    return null;
                }
            }
            long l = 0L;
            boolean bl = false;
            if (n == 45) {
                char c2 = c;
                c = (char)2;
                n = this.charAt(this.bp + c2);
                bl = true;
            }
            if (n >= 48 && n <= 57) {
                long l2;
                l = l2 = (long)(n - 48);
                while (true) {
                    char c3 = c;
                    c = (char)(c3 + '\u0001');
                    char c4 = this.charAt(this.bp + c3);
                    n = c4;
                    if (c4 < '0' || n > 57) break;
                    l = l2 = l * 10L + (long)(n - 48);
                }
            }
            if (l < 0L) {
                this.matchStat = -1;
                return null;
            }
            if (bl) {
                l = -l;
            }
            Date date2 = date;
            date = new Date(l);
            object = date2;
        }
        if (n == 44) {
            c = (char)(this.bp + c);
            this.bp = c;
            this.ch = this.charAt(c);
            this.matchStat = 3;
            this.token = 16;
            return object;
        }
        if (n != 93) {
            this.matchStat = -1;
            return null;
        }
        char c5 = c;
        c = (char)(c5 + '\u0001');
        char c6 = this.charAt(this.bp + c5);
        n = c6;
        if (c6 == ',') {
            this.token = 16;
            c = (char)(this.bp + c);
            this.bp = c;
            this.ch = this.charAt(c);
        } else if (n == 93) {
            this.token = 15;
            c = (char)(this.bp + c);
            this.bp = c;
            this.ch = this.charAt(c);
        } else if (n == 125) {
            this.token = 13;
            c = (char)(this.bp + c);
            this.bp = c;
            this.ch = this.charAt(c);
        } else {
            if (n != 26) {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += c - '\u0001';
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return object;
    }

    public UUID scanFieldUUID(char[] cArray) {
        block66: {
            block67: {
                block72: {
                    UUID uUID;
                    block69: {
                        int n;
                        int n2;
                        block71: {
                            block70: {
                                block68: {
                                    block56: {
                                        int n3;
                                        block33: {
                                            block34: {
                                                block57: {
                                                    UUID uUID2;
                                                    int n4;
                                                    int n5;
                                                    int n6;
                                                    int n7;
                                                    block35: {
                                                        UUID uUID3;
                                                        int n8;
                                                        int n9;
                                                        this.matchStat = 0;
                                                        if (!this.charArrayCompare(cArray)) {
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        int n10 = cArray.length;
                                                        n2 = n10 + 1;
                                                        n3 = this.charAt(this.bp + n10);
                                                        if (n3 != 34) break block33;
                                                        n3 = this.bp + cArray.length + 1;
                                                        if ((n3 = this.indexOf('\"', n3)) == -1) break block34;
                                                        n7 = this.bp + cArray.length + 1;
                                                        n6 = n3 - n7;
                                                        if (n6 != 36) break block35;
                                                        long l = 0L;
                                                        long l2 = 0L;
                                                        for (n9 = 0; n9 < 8; ++n9) {
                                                            block39: {
                                                                block37: {
                                                                    block38: {
                                                                        block36: {
                                                                            n8 = this.charAt(n7 + n9);
                                                                            if (n8 < 48 || n8 > 57) break block36;
                                                                            n8 -= 48;
                                                                            break block37;
                                                                        }
                                                                        if (n8 < 97 || n8 > 102) break block38;
                                                                        n8 = n8 - 97 + 10;
                                                                        break block37;
                                                                    }
                                                                    if (n8 < 65 || n8 > 70) break block39;
                                                                    n8 = n8 - 65 + 10;
                                                                }
                                                                l = l << 4 | (long)n8;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n9 = 9; n9 < 13; ++n9) {
                                                            block43: {
                                                                block41: {
                                                                    block42: {
                                                                        block40: {
                                                                            n8 = this.charAt(n7 + n9);
                                                                            if (n8 < 48 || n8 > 57) break block40;
                                                                            n8 -= 48;
                                                                            break block41;
                                                                        }
                                                                        if (n8 < 97 || n8 > 102) break block42;
                                                                        n8 = n8 - 97 + 10;
                                                                        break block41;
                                                                    }
                                                                    if (n8 < 65 || n8 > 70) break block43;
                                                                    n8 = n8 - 65 + 10;
                                                                }
                                                                l = l << 4 | (long)n8;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n9 = 14; n9 < 18; ++n9) {
                                                            block47: {
                                                                block45: {
                                                                    block46: {
                                                                        block44: {
                                                                            char c = this.charAt(n7 + n9);
                                                                            n8 = c;
                                                                            if (c < '0' || n8 > 57) break block44;
                                                                            n8 -= 48;
                                                                            break block45;
                                                                        }
                                                                        if (n8 < 97 || n8 > 102) break block46;
                                                                        n8 = n8 - 97 + 10;
                                                                        break block45;
                                                                    }
                                                                    if (n8 < 65 || n8 > 70) break block47;
                                                                    n8 = n8 - 65 + 10;
                                                                }
                                                                l = l << 4 | (long)n8;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n9 = 19; n9 < 23; ++n9) {
                                                            block51: {
                                                                block49: {
                                                                    block50: {
                                                                        block48: {
                                                                            char c = this.charAt(n7 + n9);
                                                                            n8 = c;
                                                                            if (c < '0' || n8 > 57) break block48;
                                                                            n8 -= 48;
                                                                            break block49;
                                                                        }
                                                                        if (n8 < 97 || n8 > 102) break block50;
                                                                        n8 = n8 - 97 + 10;
                                                                        break block49;
                                                                    }
                                                                    if (n8 < 65 || n8 > 70) break block51;
                                                                    n8 = n8 - 65 + 10;
                                                                }
                                                                l2 = l2 << 4 | (long)n8;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n9 = 24; n9 < 36; ++n9) {
                                                            block55: {
                                                                block53: {
                                                                    block54: {
                                                                        block52: {
                                                                            char c = this.charAt(n7 + n9);
                                                                            n8 = c;
                                                                            if (c < '0' || n8 > 57) break block52;
                                                                            n8 -= 48;
                                                                            break block53;
                                                                        }
                                                                        if (n8 < 97 || n8 > 102) break block54;
                                                                        n8 = n8 - 97 + 10;
                                                                        break block53;
                                                                    }
                                                                    if (n8 < 65 || n8 > 70) break block55;
                                                                    n8 = n8 - 65 + 10;
                                                                }
                                                                l2 = l2 << 4 | (long)n8;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        uUID = uUID3;
                                                        uUID3 = new UUID(l, l2);
                                                        int n11 = this.bp;
                                                        int n12 = n2 + (n3 - (n11 + cArray.length + 1) + 1);
                                                        n = n12 + 1;
                                                        n2 = this.charAt(n11 + n12);
                                                        break block56;
                                                    }
                                                    if (n6 != 32) break block57;
                                                    long l = 0L;
                                                    long l3 = 0L;
                                                    for (n5 = 0; n5 < 16; ++n5) {
                                                        block61: {
                                                            block59: {
                                                                block60: {
                                                                    block58: {
                                                                        n4 = this.charAt(n7 + n5);
                                                                        if (n4 < 48 || n4 > 57) break block58;
                                                                        n4 -= 48;
                                                                        break block59;
                                                                    }
                                                                    if (n4 < 97 || n4 > 102) break block60;
                                                                    n4 = n4 - 97 + 10;
                                                                    break block59;
                                                                }
                                                                if (n4 < 65 || n4 > 70) break block61;
                                                                n4 = n4 - 65 + 10;
                                                            }
                                                            l = l << 4 | (long)n4;
                                                            continue;
                                                        }
                                                        this.matchStat = -2;
                                                        return null;
                                                    }
                                                    for (n5 = 16; n5 < 32; ++n5) {
                                                        block65: {
                                                            block63: {
                                                                block64: {
                                                                    block62: {
                                                                        n4 = this.charAt(n7 + n5);
                                                                        if (n4 < 48 || n4 > 57) break block62;
                                                                        n4 -= 48;
                                                                        break block63;
                                                                    }
                                                                    if (n4 < 97 || n4 > 102) break block64;
                                                                    n4 = n4 - 97 + 10;
                                                                    break block63;
                                                                }
                                                                if (n4 < 65 || n4 > 70) break block65;
                                                                n4 = n4 - 65 + 10;
                                                            }
                                                            l3 = l3 << 4 | (long)n4;
                                                            continue;
                                                        }
                                                        this.matchStat = -2;
                                                        return null;
                                                    }
                                                    uUID = uUID2;
                                                    uUID2 = new UUID(l, l3);
                                                    int n13 = this.bp;
                                                    int n14 = n2 + (n3 - (n13 + cArray.length + 1) + 1);
                                                    n = n14 + 1;
                                                    n2 = this.charAt(n13 + n14);
                                                    break block56;
                                                }
                                                this.matchStat = -1;
                                                return null;
                                            }
                                            throw new JSONException("unclosed str");
                                        }
                                        if (n3 != 110) break block66;
                                        int n15 = n2;
                                        n = n15 + 1;
                                        if (this.charAt(this.bp + n15) != 'u' || this.charAt(this.bp + n++) != 'l' || this.charAt(this.bp + n++) != 'l') break block66;
                                        uUID = null;
                                        n2 = this.charAt(this.bp + n++);
                                    }
                                    if (n2 == 44) {
                                        this.bp = n = this.bp + n;
                                        this.ch = this.charAt(n);
                                        this.matchStat = 3;
                                        return uUID;
                                    }
                                    if (n2 != 125) break block67;
                                    char c = this.charAt(this.bp + n++);
                                    n2 = c;
                                    if (c != ',') break block68;
                                    this.token = 16;
                                    this.bp = n = this.bp + n;
                                    this.ch = this.charAt(n);
                                    break block69;
                                }
                                if (n2 != 93) break block70;
                                this.token = 15;
                                this.bp = n = this.bp + n;
                                this.ch = this.charAt(n);
                                break block69;
                            }
                            if (n2 != 125) break block71;
                            this.token = 13;
                            this.bp = n = this.bp + n;
                            this.ch = this.charAt(n);
                            break block69;
                        }
                        if (n2 != 26) break block72;
                        this.token = 20;
                        this.bp += n - 1;
                        this.ch = (char)26;
                    }
                    this.matchStat = 4;
                    return uUID;
                }
                this.matchStat = -1;
                return null;
            }
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    public UUID scanUUID(char c) {
        block65: {
            block66: {
                block71: {
                    UUID uUID;
                    block68: {
                        int n;
                        block70: {
                            block69: {
                                block67: {
                                    block55: {
                                        block32: {
                                            block33: {
                                                block56: {
                                                    UUID uUID2;
                                                    int n2;
                                                    int n3;
                                                    int n4;
                                                    int n5;
                                                    block34: {
                                                        UUID uUID3;
                                                        int n6;
                                                        int n7;
                                                        this.matchStat = 0;
                                                        c = (char)this.bp;
                                                        n = 1;
                                                        if ((c = this.charAt(c + '\u0000')) != '\"') break block32;
                                                        c = (char)(this.bp + 1);
                                                        int n8 = this.indexOf('\"', c);
                                                        c = (char)n8;
                                                        if (n8 == -1) break block33;
                                                        n5 = this.bp + 1;
                                                        n4 = c - n5;
                                                        if (n4 != 36) break block34;
                                                        long l = 0L;
                                                        long l2 = 0L;
                                                        for (n7 = 0; n7 < 8; ++n7) {
                                                            block38: {
                                                                block36: {
                                                                    block37: {
                                                                        block35: {
                                                                            n6 = this.charAt(n5 + n7);
                                                                            if (n6 < 48 || n6 > 57) break block35;
                                                                            n6 -= 48;
                                                                            break block36;
                                                                        }
                                                                        if (n6 < 97 || n6 > 102) break block37;
                                                                        n6 = n6 - 97 + 10;
                                                                        break block36;
                                                                    }
                                                                    if (n6 < 65 || n6 > 70) break block38;
                                                                    n6 = n6 - 65 + 10;
                                                                }
                                                                l = l << 4 | (long)n6;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n7 = 9; n7 < 13; ++n7) {
                                                            block42: {
                                                                block40: {
                                                                    block41: {
                                                                        block39: {
                                                                            n6 = this.charAt(n5 + n7);
                                                                            if (n6 < 48 || n6 > 57) break block39;
                                                                            n6 -= 48;
                                                                            break block40;
                                                                        }
                                                                        if (n6 < 97 || n6 > 102) break block41;
                                                                        n6 = n6 - 97 + 10;
                                                                        break block40;
                                                                    }
                                                                    if (n6 < 65 || n6 > 70) break block42;
                                                                    n6 = n6 - 65 + 10;
                                                                }
                                                                l = l << 4 | (long)n6;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n7 = 14; n7 < 18; ++n7) {
                                                            block46: {
                                                                block44: {
                                                                    block45: {
                                                                        block43: {
                                                                            char c2 = this.charAt(n5 + n7);
                                                                            n6 = c2;
                                                                            if (c2 < '0' || n6 > 57) break block43;
                                                                            n6 -= 48;
                                                                            break block44;
                                                                        }
                                                                        if (n6 < 97 || n6 > 102) break block45;
                                                                        n6 = n6 - 97 + 10;
                                                                        break block44;
                                                                    }
                                                                    if (n6 < 65 || n6 > 70) break block46;
                                                                    n6 = n6 - 65 + 10;
                                                                }
                                                                l = l << 4 | (long)n6;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n7 = 19; n7 < 23; ++n7) {
                                                            block50: {
                                                                block48: {
                                                                    block49: {
                                                                        block47: {
                                                                            char c3 = this.charAt(n5 + n7);
                                                                            n6 = c3;
                                                                            if (c3 < '0' || n6 > 57) break block47;
                                                                            n6 -= 48;
                                                                            break block48;
                                                                        }
                                                                        if (n6 < 97 || n6 > 102) break block49;
                                                                        n6 = n6 - 97 + 10;
                                                                        break block48;
                                                                    }
                                                                    if (n6 < 65 || n6 > 70) break block50;
                                                                    n6 = n6 - 65 + 10;
                                                                }
                                                                l2 = l2 << 4 | (long)n6;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        for (n7 = 24; n7 < 36; ++n7) {
                                                            block54: {
                                                                block52: {
                                                                    block53: {
                                                                        block51: {
                                                                            char c4 = this.charAt(n5 + n7);
                                                                            n6 = c4;
                                                                            if (c4 < '0' || n6 > 57) break block51;
                                                                            n6 -= 48;
                                                                            break block52;
                                                                        }
                                                                        if (n6 < 97 || n6 > 102) break block53;
                                                                        n6 = n6 - 97 + 10;
                                                                        break block52;
                                                                    }
                                                                    if (n6 < 65 || n6 > 70) break block54;
                                                                    n6 = n6 - 65 + 10;
                                                                }
                                                                l2 = l2 << 4 | (long)n6;
                                                                continue;
                                                            }
                                                            this.matchStat = -2;
                                                            return null;
                                                        }
                                                        uUID = uUID3;
                                                        uUID3 = new UUID(l, l2);
                                                        int n9 = this.bp;
                                                        int n10 = n + (c - (n9 + 1) + 1);
                                                        c = (char)(n10 + 1);
                                                        n = this.charAt(n9 + n10);
                                                        break block55;
                                                    }
                                                    if (n4 != 32) break block56;
                                                    long l = 0L;
                                                    long l3 = 0L;
                                                    for (n3 = 0; n3 < 16; ++n3) {
                                                        block60: {
                                                            block58: {
                                                                block59: {
                                                                    block57: {
                                                                        n2 = this.charAt(n5 + n3);
                                                                        if (n2 < 48 || n2 > 57) break block57;
                                                                        n2 -= 48;
                                                                        break block58;
                                                                    }
                                                                    if (n2 < 97 || n2 > 102) break block59;
                                                                    n2 = n2 - 97 + 10;
                                                                    break block58;
                                                                }
                                                                if (n2 < 65 || n2 > 70) break block60;
                                                                n2 = n2 - 65 + 10;
                                                            }
                                                            l = l << 4 | (long)n2;
                                                            continue;
                                                        }
                                                        this.matchStat = -2;
                                                        return null;
                                                    }
                                                    for (n3 = 16; n3 < 32; ++n3) {
                                                        block64: {
                                                            block62: {
                                                                block63: {
                                                                    block61: {
                                                                        n2 = this.charAt(n5 + n3);
                                                                        if (n2 < 48 || n2 > 57) break block61;
                                                                        n2 -= 48;
                                                                        break block62;
                                                                    }
                                                                    if (n2 < 97 || n2 > 102) break block63;
                                                                    n2 = n2 - 97 + 10;
                                                                    break block62;
                                                                }
                                                                if (n2 < 65 || n2 > 70) break block64;
                                                                n2 = n2 - 65 + 10;
                                                            }
                                                            l3 = l3 << 4 | (long)n2;
                                                            continue;
                                                        }
                                                        this.matchStat = -2;
                                                        return null;
                                                    }
                                                    uUID = uUID2;
                                                    uUID2 = new UUID(l, l3);
                                                    int n11 = this.bp;
                                                    int n12 = n + (c - (n11 + 1) + 1);
                                                    c = (char)(n12 + 1);
                                                    n = this.charAt(n11 + n12);
                                                    break block55;
                                                }
                                                this.matchStat = -1;
                                                return null;
                                            }
                                            throw new JSONException("unclosed str");
                                        }
                                        if (c != 'n') break block65;
                                        c = (char)2;
                                        if (this.charAt(this.bp + n) != 'u') break block65;
                                        char c5 = c;
                                        c = (char)3;
                                        if (this.charAt(this.bp + c5) != 'l') break block65;
                                        char c6 = c;
                                        c = (char)4;
                                        if (this.charAt(this.bp + c6) != 'l') break block65;
                                        uUID = null;
                                        char c7 = c;
                                        c = (char)5;
                                        n = this.charAt(this.bp + c7);
                                    }
                                    if (n == 44) {
                                        c = (char)(this.bp + c);
                                        this.bp = c;
                                        this.ch = this.charAt(c);
                                        this.matchStat = 3;
                                        return uUID;
                                    }
                                    if (n != 93) break block66;
                                    char c8 = c;
                                    c = (char)(c8 + '\u0001');
                                    char c9 = this.charAt(this.bp + c8);
                                    n = c9;
                                    if (c9 != ',') break block67;
                                    this.token = 16;
                                    c = (char)(this.bp + c);
                                    this.bp = c;
                                    this.ch = this.charAt(c);
                                    break block68;
                                }
                                if (n != 93) break block69;
                                this.token = 15;
                                c = (char)(this.bp + c);
                                this.bp = c;
                                this.ch = this.charAt(c);
                                break block68;
                            }
                            if (n != 125) break block70;
                            this.token = 13;
                            c = (char)(this.bp + c);
                            this.bp = c;
                            this.ch = this.charAt(c);
                            break block68;
                        }
                        if (n != 26) break block71;
                        this.token = 20;
                        this.bp += c - '\u0001';
                        this.ch = (char)26;
                    }
                    this.matchStat = 4;
                    return uUID;
                }
                this.matchStat = -1;
                return null;
            }
            this.matchStat = -1;
            return null;
        }
        this.matchStat = -1;
        return null;
    }

    public final void scanTrue() {
        if (this.ch == 't') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            if (jSONLexerBase.ch == 'r') {
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == 'u') {
                    JSONLexerBase jSONLexerBase3 = this;
                    jSONLexerBase3.next();
                    if (jSONLexerBase3.ch == 'e') {
                        JSONLexerBase jSONLexerBase4 = this;
                        jSONLexerBase4.next();
                        char c = jSONLexerBase4.ch;
                        if (c != ' ' && c != ',' && c != '}' && c != ']' && c != '\n' && c != '\r' && c != '\t' && c != '\u001a' && c != '\f' && c != '\b' && c != ':' && c != '/') {
                            throw new JSONException("scan true error");
                        }
                        this.token = 6;
                        return;
                    }
                    throw new JSONException("error parse true");
                }
                throw new JSONException("error parse true");
            }
            throw new JSONException("error parse true");
        }
        throw new JSONException("error parse true");
    }

    public final void scanNullOrNew() {
        this.scanNullOrNew(true);
    }

    public final void scanNullOrNew(boolean c) {
        if (this.ch == 'n') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            char c2 = jSONLexerBase.ch;
            if (c2 == 'u') {
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == 'l') {
                    JSONLexerBase jSONLexerBase3 = this;
                    jSONLexerBase3.next();
                    if (jSONLexerBase3.ch == 'l') {
                        JSONLexerBase jSONLexerBase4 = this;
                        jSONLexerBase4.next();
                        c2 = jSONLexerBase4.ch;
                        if (c2 != ' ' && c2 != ',' && c2 != '}' && c2 != ']' && c2 != '\n' && c2 != '\r' && c2 != '\t' && c2 != '\u001a' && (c2 != ':' || c == '\u0000') && c2 != '\f' && c2 != '\b') {
                            throw new JSONException("scan null error");
                        }
                        this.token = 8;
                        return;
                    }
                    throw new JSONException("error parse null");
                }
                throw new JSONException("error parse null");
            }
            if (c2 == 'e') {
                JSONLexerBase jSONLexerBase5 = this;
                jSONLexerBase5.next();
                if (jSONLexerBase5.ch == 'w') {
                    JSONLexerBase jSONLexerBase6 = this;
                    jSONLexerBase6.next();
                    c = jSONLexerBase6.ch;
                    if (c != ' ' && c != ',' && c != '}' && c != ']' && c != '\n' && c != '\r' && c != '\t' && c != '\u001a' && c != '\f' && c != '\b') {
                        throw new JSONException("scan new error");
                    }
                    this.token = 9;
                    return;
                }
                throw new JSONException("error parse new");
            }
            throw new JSONException("error parse new");
        }
        throw new JSONException("error parse null or new");
    }

    public final void scanFalse() {
        if (this.ch == 'f') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            if (jSONLexerBase.ch == 'a') {
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == 'l') {
                    JSONLexerBase jSONLexerBase3 = this;
                    jSONLexerBase3.next();
                    if (jSONLexerBase3.ch == 's') {
                        JSONLexerBase jSONLexerBase4 = this;
                        jSONLexerBase4.next();
                        if (jSONLexerBase4.ch == 'e') {
                            JSONLexerBase jSONLexerBase5 = this;
                            jSONLexerBase5.next();
                            char c = jSONLexerBase5.ch;
                            if (c != ' ' && c != ',' && c != '}' && c != ']' && c != '\n' && c != '\r' && c != '\t' && c != '\u001a' && c != '\f' && c != '\b' && c != ':' && c != '/') {
                                throw new JSONException("scan false error");
                            }
                            this.token = 7;
                            return;
                        }
                        throw new JSONException("error parse false");
                    }
                    throw new JSONException("error parse false");
                }
                throw new JSONException("error parse false");
            }
            throw new JSONException("error parse false");
        }
        throw new JSONException("error parse false");
    }

    public final void scanIdent() {
        JSONLexerBase jSONLexerBase;
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            jSONLexerBase = this;
            ++jSONLexerBase.sp;
            jSONLexerBase.next();
        } while (Character.isLetterOrDigit(jSONLexerBase.ch));
        String string = this.stringVal();
        this.token = "null".equalsIgnoreCase(string) ? 8 : ("new".equals(string) ? 9 : ("true".equals(string) ? 6 : ("false".equals(string) ? 7 : ("undefined".equals(string) ? 23 : ("Set".equals(string) ? 21 : ("TreeSet".equals(string) ? 22 : 18))))));
    }

    @Override
    public abstract String stringVal();

    public abstract String subString(int var1, int var2);

    protected abstract char[] sub_chars(int var1, int var2);

    protected abstract boolean charArrayCompare(char[] var1);

    @Override
    public boolean isBlankInput() {
        int n = 0;
        while (true) {
            char c;
            if ((c = this.charAt(n)) == '\u001a') {
                this.token = 20;
                return true;
            }
            if (!JSONLexerBase.isWhitespace(c)) {
                return false;
            }
            ++n;
        }
    }

    @Override
    public final void skipWhitespace() {
        char c;
        while ((c = this.ch) <= '/') {
            if (c != ' ' && c != '\r' && c != '\n' && c != '\t' && c != '\f' && c != '\b') {
                if (c != '/') break;
                this.skipComment();
                continue;
            }
            this.next();
        }
    }

    protected final void putChar(char c) {
        char[] cArray = this.sbuf;
        if (this.sp == this.sbuf.length) {
            cArray = new char[cArray.length * 2];
            int n = cArray.length;
            System.arraycopy(cArray, 0, cArray, 0, n);
            this.sbuf = cArray;
        }
        int n = this.sp;
        this.sp = n + 1;
        this.sbuf[n] = c;
    }

    public final void scanHex() {
        if (this.ch == 'x') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            if (jSONLexerBase.ch == '\'') {
                char c;
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.np = jSONLexerBase2.bp;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == '\'') {
                    this.next();
                    this.token = 26;
                    return;
                }
                while ((c = this.next()) >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
                    ++this.sp;
                }
                if (c == '\'') {
                    JSONLexerBase jSONLexerBase3 = this;
                    ++jSONLexerBase3.sp;
                    jSONLexerBase3.next();
                    jSONLexerBase3.token = 26;
                    return;
                }
                throw new JSONException("illegal state. " + c);
            }
            throw new JSONException("illegal state. " + this.ch);
        }
        throw new JSONException("illegal state. " + this.ch);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    @Override
    public final void scanNumber() {
        int n;
        char c;
        this.np = this.bp;
        boolean bl = true;
        do {
            if (bl && !(bl = false) && this.ch != '-') continue;
            ++this.sp;
            this.next();
        } while ((c = this.ch) >= '0' && c <= '9');
        char c2 = c;
        c = '\u0000';
        if (c2 == '.') {
            ++this.sp;
            this.next();
            c = '\u0001';
            while (true) {
                char c3 = this.ch;
                n = c3;
                if (c3 < '0' || n > 57) break;
                ++this.sp;
                this.next();
            }
        }
        if ((n = this.sp) > 65535) throw new JSONException("scanNumber overflow");
        char c4 = this.ch;
        if (c4 == 'L' || c4 == 'S' || c4 == 'B') {
            this.sp = n + 1;
            this.next();
        } else if (c4 == 'F' || c4 == 'D') {
            this.sp = n + 1;
            this.next();
            c = '\u0001';
        } else if (c4 == 'e' || c4 == 'E') {
            this.sp = n + 1;
            this.next();
            c = this.ch;
            boolean bl2 = true;
            do {
                if (bl2 && !(bl2 = false) && c != '+' && c != '-') continue;
                ++this.sp;
                this.next();
            } while ((c = this.ch) >= '0' && c <= '9');
            if (c == 'D' || c == 'F') {
                ++this.sp;
                this.next();
            }
            c = '\u0001';
        }
        if (c != '\u0000') {
            this.token = 3;
            return;
        }
        this.token = 2;
    }

    @Override
    public final long longValue() {
        long l;
        long l2 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        JSONLexerBase jSONLexerBase = this;
        int n = jSONLexerBase.np;
        int n2 = n + this.sp;
        if (jSONLexerBase.charAt(n) == '-') {
            bl = true;
            l = Long.MIN_VALUE;
            ++n;
        } else {
            l = -9223372036854775807L;
        }
        long l3 = -922337203685477580L;
        if (n < n2) {
            l2 = -(this.charAt(n++) - 48);
        }
        while (n < n2) {
            int n3 = n + 1;
            char c = this.charAt(n);
            n = c;
            if (c != 'L' && n != 83 && n != 66) {
                n -= 48;
                if (l2 >= l3) {
                    long l4 = n;
                    if ((l2 *= 10L) >= l + l4) {
                        l2 -= l4;
                        n = n3;
                        continue;
                    }
                    throw new NumberFormatException(this.numberString());
                }
                throw new NumberFormatException(this.numberString());
            }
            n = n3;
            break;
        }
        if (bl) {
            if (n > this.np + 1) {
                return l2;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Number decimalValue(boolean bl) {
        JSONLexerBase jSONLexerBase = this;
        char c = jSONLexerBase.charAt(jSONLexerBase.np + this.sp - 1);
        if (c == 'F') {
            try {
                return Float.valueOf(Float.parseFloat(this.numberString()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JSONException(numberFormatException.getMessage() + ", " + this.info());
            }
        }
        if (c == 'D') {
            return Double.parseDouble(this.numberString());
        }
        if (!bl) return this.doubleValue();
        return this.decimalValue();
    }

    @Override
    public abstract BigDecimal decimalValue();

    public String[] scanFieldStringArray(char[] cArray, int n, SymbolTable symbolTable) {
        throw new UnsupportedOperationException();
    }

    public boolean matchField2(char[] cArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFeatures() {
        return this.features;
    }

    @Override
    public void setFeatures(int n) {
        this.features = n;
    }
}

