/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.SymbolTable;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.MathContext;

public final class JSONReaderScanner
extends JSONLexerBase {
    private static final ThreadLocal<char[]> BUF_LOCAL = new ThreadLocal();
    private Reader reader;
    private char[] buf;
    private int bufLength;

    public JSONReaderScanner(String string) {
        this(string, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(String string, int n) {
        StringReader stringReader;
        JSONReaderScanner jSONReaderScanner = closeable;
        Closeable closeable = stringReader;
        stringReader = new StringReader(string);
        jSONReaderScanner((Reader)closeable, n);
    }

    public JSONReaderScanner(char[] cArray, int n) {
        int n2 = JSON.DEFAULT_PARSER_FEATURE;
        this(cArray, n, n2);
    }

    public JSONReaderScanner(Reader reader) {
        this(reader, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(Reader reader, int n) {
        super(n);
        JSONReaderScanner jSONReaderScanner;
        this.reader = reader;
        ThreadLocal<char[]> threadLocal = BUF_LOCAL;
        this.buf = threadLocal.get();
        if (this.buf != null) {
            threadLocal.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[16384];
        }
        try {
            JSONReaderScanner jSONReaderScanner2 = this;
            jSONReaderScanner = jSONReaderScanner2;
            jSONReaderScanner2.bufLength = reader.read(this.buf);
            jSONReaderScanner2.bp = -1;
            jSONReaderScanner2.next();
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
        if (jSONReaderScanner.ch == '\ufeff') {
            this.next();
        }
    }

    public JSONReaderScanner(char[] cArray, int n, int n2) {
        CharArrayReader charArrayReader;
        JSONReaderScanner jSONReaderScanner = closeable;
        Closeable closeable = charArrayReader;
        charArrayReader = new CharArrayReader(cArray, 0, n);
        jSONReaderScanner((Reader)closeable, n2);
    }

    @Override
    public final char charAt(int n) {
        block15: {
            int n2 = this.bufLength;
            if (n >= n2) {
                block14: {
                    int n3;
                    char[] cArray;
                    Reader reader;
                    if (n2 == -1) {
                        if (n < this.sp) {
                            return this.buf[n];
                        }
                        return '\u001a';
                    }
                    int n4 = this.bp;
                    if (n4 == 0) {
                        JSONReaderScanner jSONReaderScanner = this;
                        char[] cArray2 = jSONReaderScanner.buf;
                        int n5 = jSONReaderScanner.buf.length * 3 / 2;
                        char[] cArray3 = new char[n5];
                        System.arraycopy(cArray2, n4, cArray3, 0, n2);
                        n2 = this.bufLength;
                        int n6 = n5 - n2;
                        try {
                            n2 = jSONReaderScanner.reader.read(cArray3, n2, n6);
                        }
                        catch (IOException iOException) {
                            throw new JSONException(iOException.getMessage(), iOException);
                        }
                        int n7 = jSONReaderScanner.bufLength;
                        jSONReaderScanner.bufLength = n7 + n2;
                        jSONReaderScanner.buf = cArray3;
                    }
                    if ((n2 -= n4) > 0) {
                        System.arraycopy(this.buf, n4, this.buf, 0, n2);
                    }
                    try {
                        reader = this.reader;
                        cArray = this.buf;
                        n3 = this.buf.length;
                    }
                    catch (IOException iOException) {
                        throw new JSONException(iOException.getMessage(), iOException);
                    }
                    n4 = reader.read(cArray, n2, n3 - n2);
                    this.bufLength = n4;
                    if (n4 == 0) break block14;
                    if (n4 == -1) {
                        return '\u001a';
                    }
                    int n8 = n;
                    this.bufLength = n4 + n2;
                    n = this.bp;
                    n2 = n8 - n;
                    this.np -= n;
                    this.bp = 0;
                    n = n2;
                    break block15;
                }
                throw new JSONException("illegal state, textLength is zero");
            }
        }
        return this.buf[n];
    }

    @Override
    public final int indexOf(char c, int n) {
        n -= this.bp;
        while (true) {
            JSONReaderScanner jSONReaderScanner = this;
            char c2 = jSONReaderScanner.charAt(jSONReaderScanner.bp + n);
            if (c == c2) {
                return n + this.bp;
            }
            if (c2 == '\u001a') {
                return -1;
            }
            ++n;
        }
    }

    @Override
    public final String addSymbol(int n, int n2, int n3, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.buf, n, n2, n3);
    }

    @Override
    public final char next() {
        int n;
        block17: {
            this.bp = n = this.bp + 1;
            int n2 = this.bufLength;
            if (n >= n2) {
                block15: {
                    int n3;
                    block16: {
                        int n4;
                        char[] cArray;
                        block14: {
                            if (n2 == -1) {
                                return '\u001a';
                            }
                            n = this.sp;
                            if (n > 0) {
                                if (this.ch == '\"' && (n2 -= n) > 0) {
                                    --n2;
                                }
                                System.arraycopy(this.buf, n2, this.buf, 0, n);
                            }
                            JSONReaderScanner jSONReaderScanner = this;
                            jSONReaderScanner.np = -1;
                            jSONReaderScanner.bp = n = jSONReaderScanner.sp;
                            try {
                                cArray = jSONReaderScanner.buf;
                            }
                            catch (IOException iOException) {
                                throw new JSONException(iOException.getMessage(), iOException);
                            }
                            n4 = jSONReaderScanner.buf.length - n;
                            if (n4 != 0) break block14;
                            JSONReaderScanner jSONReaderScanner2 = this;
                            char[] cArray2 = cArray;
                            char[] cArray3 = cArray;
                            int n5 = cArray.length;
                            cArray = new char[n5 * 2];
                            n4 = 0;
                            int n6 = 0;
                            int n7 = cArray3.length;
                            System.arraycopy(cArray2, n4, cArray, n6, n7);
                            jSONReaderScanner2.buf = cArray;
                            n4 = cArray.length - n;
                        }
                        Reader reader = this.reader;
                        JSONReaderScanner jSONReaderScanner = this;
                        JSONReaderScanner jSONReaderScanner3 = jSONReaderScanner;
                        cArray = jSONReaderScanner.buf;
                        n3 = reader.read(cArray, jSONReaderScanner3.bp, n4);
                        this.bufLength = n3;
                        if (n3 == 0) break block15;
                        if (n3 != -1) break block16;
                        this.ch = (char)26;
                        return '\u001a';
                    }
                    this.bufLength = n3 + this.bp;
                    break block17;
                }
                throw new JSONException("illegal stat, textLength is zero");
            }
        }
        this.ch = this.buf[n];
        return this.ch;
    }

    @Override
    protected final void copyTo(int n, int n2, char[] cArray) {
        System.arraycopy(this.buf, n, cArray, 0, n2);
    }

    @Override
    public final boolean charArrayCompare(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            JSONReaderScanner jSONReaderScanner = this;
            if (jSONReaderScanner.charAt(jSONReaderScanner.bp + i) == cArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] bytesValue() {
        if (this.token != 26) {
            JSONReaderScanner jSONReaderScanner = this;
            int n = jSONReaderScanner.np + 1;
            return IOUtils.ddb(this.buf, n, jSONReaderScanner.sp);
        }
        throw new JSONException("TODO");
    }

    @Override
    protected final void arrayCopy(int n, char[] cArray, int n2, int n3) {
        System.arraycopy(this.buf, n, cArray, n2, n3);
    }

    @Override
    public final String stringVal() {
        if (!((JSONLexerBase)object).hasSpecial) {
            int n = ((JSONLexerBase)object).np + 1;
            if (n >= 0) {
                char[] cArray = ((JSONReaderScanner)object).buf;
                int n2 = ((JSONLexerBase)object).sp;
                if (n <= ((JSONReaderScanner)object).buf.length - n2) {
                    return new String(cArray, n, n2);
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        JSONReaderScanner jSONReaderScanner = object;
        Object object = jSONReaderScanner.sbuf;
        int n = jSONReaderScanner.sp;
        return new String((char[])object, 0, n);
    }

    @Override
    public final String subString(int n, int n2) {
        if (n2 >= 0) {
            return new String(this.buf, n, n2);
        }
        throw new StringIndexOutOfBoundsException(n2);
    }

    @Override
    public final char[] sub_chars(int n, int n2) {
        if (n2 >= 0) {
            if (n == 0) {
                return this.buf;
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.buf, n, cArray, 0, n2);
            return cArray;
        }
        throw new StringIndexOutOfBoundsException(n2);
    }

    @Override
    public final String numberString() {
        int n = this.np;
        if (n == -1) {
            n = 0;
        }
        char c = this.charAt(n + this.sp - 1);
        int n2 = this.sp;
        if (c == 'L' || c == 'S' || c == 'B' || c == 'F' || c == 'D') {
            --n2;
        }
        return new String(this.buf, n, n2);
    }

    @Override
    public final BigDecimal decimalValue() {
        int n = ((JSONLexerBase)object).np;
        if (n == -1) {
            n = 0;
        }
        char c = ((JSONReaderScanner)object).charAt(n + ((JSONLexerBase)object).sp - 1);
        int n2 = ((JSONLexerBase)object).sp;
        if (c == 'L' || c == 'S' || c == 'B' || c == 'F' || c == 'D') {
            --n2;
        }
        if (n2 <= 65535) {
            Object object = ((JSONReaderScanner)object).buf;
            MathContext mathContext = MathContext.UNLIMITED;
            return new BigDecimal((char[])object, n, n2, mathContext);
        }
        throw new JSONException("decimal overflow");
    }

    @Override
    public void close() {
        JSONReaderScanner jSONReaderScanner = this;
        super.close();
        char[] cArray = jSONReaderScanner.buf;
        if (jSONReaderScanner.buf.length <= 65536) {
            BUF_LOCAL.set(cArray);
        }
        this.buf = null;
        IOUtils.close(this.reader);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEOF() {
        if (this.bufLength == -1) return true;
        int n = this.bp;
        char[] cArray = this.buf;
        if (n == this.buf.length) return true;
        if (this.ch != '\u001a') return false;
        if (n + 1 < cArray.length) return false;
        return true;
    }

    @Override
    public final boolean isBlankInput() {
        int n = 0;
        while (true) {
            char c;
            if ((c = this.buf[n]) == '\u001a') {
                this.token = 20;
                return true;
            }
            if (!JSONLexerBase.isWhitespace(c)) {
                return false;
            }
            ++n;
        }
    }
}

