/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser.deserializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.deserializer.ContextObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.BeanContext;
import com.tradplus.ads.common.serialization.serializer.ContextObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.TimeZone;

public class Jdk8DateCodec
extends ContextObjectDeserializer
implements ObjectSerializer,
ContextObjectSerializer {
    public static final Jdk8DateCodec instance = new Jdk8DateCodec();
    private static final String defaultPatttern = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter defaultFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter defaultFormatter_23 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter formatter_dt19_tw = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_cn = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_cn_1 = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 H\u65f6m\u5206s\u79d2");
    private static final DateTimeFormatter formatter_dt19_kr = DateTimeFormatter.ofPattern("yyyy\ub144M\uc6d4d\uc77c HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_us = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_eur = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_de = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_in = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_d8 = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter formatter_d10_tw = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter formatter_d10_cn = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5");
    private static final DateTimeFormatter formatter_d10_kr = DateTimeFormatter.ofPattern("yyyy\ub144M\uc6d4d\uc77c");
    private static final DateTimeFormatter formatter_d10_us = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    private static final DateTimeFormatter formatter_d10_eur = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final DateTimeFormatter formatter_d10_de = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final DateTimeFormatter formatter_d10_in = DateTimeFormatter.ofPattern("dd-MM-yyyy");
    private static final DateTimeFormatter ISO_FIXED_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
    private static final String formatter_iso8601_pattern = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String formatter_iso8601_pattern_23 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String formatter_iso8601_pattern_29 = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS";
    private static final DateTimeFormatter formatter_iso8601 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    private void write(SerializeWriter serializeWriter, TemporalAccessor temporalAccessor, String string) {
        if ("unixtime".equals(string)) {
            if (temporalAccessor instanceof ChronoZonedDateTime) {
                serializeWriter.writeInt((int)((ChronoZonedDateTime)temporalAccessor).toEpochSecond());
                return;
            }
            if (temporalAccessor instanceof LocalDateTime) {
                serializeWriter.writeInt((int)((LocalDateTime)temporalAccessor).atZone(JSON.defaultTimeZone.toZoneId()).toEpochSecond());
                return;
            }
        }
        if ("millis".equals(string)) {
            Object object = null;
            if (temporalAccessor instanceof ChronoZonedDateTime) {
                object = ((ChronoZonedDateTime)temporalAccessor).toInstant();
            } else if (temporalAccessor instanceof LocalDateTime) {
                object = ((LocalDateTime)temporalAccessor).atZone(JSON.defaultTimeZone.toZoneId()).toInstant();
            }
            if (object != null) {
                serializeWriter.writeLong(((Instant)object).toEpochMilli());
                return;
            }
        }
        serializeWriter.writeString((string == formatter_iso8601_pattern ? formatter_iso8601 : DateTimeFormatter.ofPattern(string)).format(temporalAccessor));
    }

    public static Object castToLocalDateTime(Object object, String string) {
        if (object == null) {
            return null;
        }
        if (string == null) {
            string = defaultPatttern;
        }
        Object object2 = object;
        object = DateTimeFormatter.ofPattern(string);
        return LocalDateTime.parse(object2.toString(), (DateTimeFormatter)object);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser object, Type object2, Object object3, String string, int n) {
        object3 = ((DefaultJSONParser)object).lexer;
        if (object3.token() == 8) {
            object3.nextToken();
            return null;
        }
        if (object3.token() == 4) {
            Object object4 = object3;
            object3 = object4.stringVal();
            object4.nextToken();
            DateTimeFormatter dateTimeFormatter = null;
            if (string != null) {
                dateTimeFormatter = defaultPatttern.equals(string) ? defaultFormatter : DateTimeFormatter.ofPattern(string);
            }
            if ("".equals(object3)) {
                return null;
            }
            if (object2 == LocalDateTime.class) {
                return (T)(((String)object3).length() != 10 && ((String)object3).length() != 8 ? ((Jdk8DateCodec)this).parseDateTime((String)object3, dateTimeFormatter) : LocalDateTime.of(((Jdk8DateCodec)this).parseLocalDate((String)object3, string, dateTimeFormatter), LocalTime.MIN));
            }
            if (object2 == LocalDate.class) {
                LocalDate localDate;
                if (((String)object3).length() == 23) {
                    Object object5 = this = LocalDateTime.parse((CharSequence)object3);
                    int n2 = ((LocalDateTime)object5).getMonthValue();
                    localDate = LocalDate.of(((LocalDateTime)this).getYear(), n2, ((LocalDateTime)object5).getDayOfMonth());
                } else {
                    localDate = ((Jdk8DateCodec)this).parseLocalDate((String)object3, string, dateTimeFormatter);
                }
                return (T)localDate;
            }
            if (object2 == LocalTime.class) {
                LocalTime localTime;
                if (((String)object3).length() == 23) {
                    Object object6 = this = LocalDateTime.parse((CharSequence)object3);
                    int n3 = ((LocalDateTime)object6).getMinute();
                    int n4 = ((LocalDateTime)object6).getSecond();
                    int n5 = ((LocalDateTime)object6).getNano();
                    localTime = LocalTime.of(((LocalDateTime)this).getHour(), n3, n4, n5);
                } else {
                    boolean bl = true;
                    for (int i = 0; i < ((String)object3).length(); ++i) {
                        char c = ((String)object3).charAt(i);
                        if (c >= '0' && c <= '9') {
                            continue;
                        }
                        bl = false;
                        break;
                    }
                    localTime = bl && ((String)object3).length() > 8 && ((String)object3).length() < 19 ? LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong((String)object3)), JSON.defaultTimeZone.toZoneId()).toLocalTime() : LocalTime.parse((CharSequence)object3);
                }
                return (T)localTime;
            }
            if (object2 == ZonedDateTime.class) {
                if (dateTimeFormatter == defaultFormatter) {
                    dateTimeFormatter = ISO_FIXED_FORMAT;
                }
                if (dateTimeFormatter == null && ((String)object3).length() <= 19) {
                    JSONScanner jSONScanner;
                    object2 = jSONScanner;
                    ((JSONScanner)object2)((String)object3);
                    object = ((DefaultJSONParser)object).lexer.getTimeZone();
                    jSONScanner.setTimeZone((TimeZone)object);
                    if (jSONScanner.scanISO8601DateIfMatch(false)) {
                        return (T)ZonedDateTime.ofInstant(((JSONLexerBase)object2).getCalendar().getTime().toInstant(), ((TimeZone)object).toZoneId());
                    }
                }
                return (T)((Jdk8DateCodec)this).parseZonedDateTime((String)object3, dateTimeFormatter);
            }
            if (object2 == OffsetDateTime.class) {
                return (T)OffsetDateTime.parse((CharSequence)object3);
            }
            if (object2 == OffsetTime.class) {
                return (T)OffsetTime.parse((CharSequence)object3);
            }
            if (object2 == ZoneId.class) {
                return (T)ZoneId.of((String)object3);
            }
            if (object2 == Period.class) {
                return (T)Period.parse((CharSequence)object3);
            }
            if (object2 == Duration.class) {
                return (T)Duration.parse((CharSequence)object3);
            }
            if (object2 == Instant.class) {
                boolean bl = true;
                for (int i = 0; i < ((String)object3).length(); ++i) {
                    char c = ((String)object3).charAt(i);
                    if (c >= '0' && c <= '9') {
                        continue;
                    }
                    bl = false;
                    break;
                }
                if (bl && ((String)object3).length() > 8 && ((String)object3).length() < 19) {
                    return (T)Instant.ofEpochMilli(Long.parseLong((String)object3));
                }
                return (T)Instant.parse((CharSequence)object3);
            }
            return null;
        }
        if (object3.token() == 2) {
            Object object7 = object3;
            long l = object7.longValue();
            object7.nextToken();
            if ("unixtime".equals(string)) {
                l *= 1000L;
            } else if ("yyyyMMddHHmmss".equals(string)) {
                long l2 = l;
                int n6 = (int)(l2 / 10000000000L);
                int n7 = (int)(l2 / 100000000L % 100L);
                n = (int)(l2 / 1000000L % 100L);
                int n8 = (int)(l2 / 10000L % 100L);
                int n9 = (int)(l2 / 100L % 100L);
                int n10 = (int)(l2 % 100L);
                if (object2 == LocalDateTime.class) {
                    return (T)LocalDateTime.of(n6, n7, n, n8, n9, n10);
                }
            }
            if (object2 == LocalDateTime.class) {
                return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId());
            }
            if (object2 == LocalDate.class) {
                return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId()).toLocalDate();
            }
            if (object2 == LocalTime.class) {
                return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId()).toLocalTime();
            }
            if (object2 == ZonedDateTime.class) {
                return (T)ZonedDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId());
            }
            if (object2 == Instant.class) {
                return (T)Instant.ofEpochMilli(l);
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected LocalDateTime parseDateTime(String string, DateTimeFormatter dateTimeFormatter) {
        LocalDateTime localDateTime;
        char c;
        int n;
        block20: {
            block22: {
                char c2;
                char c3;
                block21: {
                    char c4;
                    block25: {
                        block26: {
                            String string2;
                            block27: {
                                int n2;
                                block24: {
                                    DateTimeFormatter dateTimeFormatter2;
                                    block23: {
                                        if (dateTimeFormatter != null) break block20;
                                        if (string.length() != 19) break block21;
                                        n2 = string.charAt(4);
                                        n = string.charAt(7);
                                        c = string.charAt(10);
                                        c3 = string.charAt(16);
                                        if (string.charAt(13) != ':' || c3 != ':') break block22;
                                        if (n2 != 45 || n != 45) break block23;
                                        if (c == 'T') {
                                            DateTimeFormatter dateTimeFormatter3;
                                            dateTimeFormatter = dateTimeFormatter3 = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                                            break block22;
                                        } else if (c == ' ') {
                                            DateTimeFormatter dateTimeFormatter4;
                                            dateTimeFormatter = dateTimeFormatter4 = defaultFormatter;
                                        }
                                        break block22;
                                    }
                                    if (n2 != 47 || n != 47) break block24;
                                    dateTimeFormatter = dateTimeFormatter2 = formatter_dt19_tw;
                                    break block22;
                                }
                                n = string.charAt(0);
                                c = string.charAt(1);
                                c3 = string.charAt(2);
                                c2 = string.charAt(3);
                                c4 = string.charAt(5);
                                if (c3 != '/' || c4 != '/') break block25;
                                n2 = (c2 - 48) * 10 + (n2 - 48);
                                if ((n - 48) * 10 + (c - 48) > 12) break block26;
                                if (n2 <= 12 && !(string2 = Locale.getDefault().getCountry()).equals("US")) break block27;
                                dateTimeFormatter = formatter_dt19_us;
                                break block22;
                            }
                            if (!string2.equals("BR") && !string2.equals("AU")) break block22;
                        }
                        dateTimeFormatter = formatter_dt19_eur;
                        break block22;
                    }
                    if (c3 == '.' && c4 == '.') {
                        DateTimeFormatter dateTimeFormatter5;
                        dateTimeFormatter = dateTimeFormatter5 = formatter_dt19_de;
                        break block22;
                    } else if (c3 == '-' && c4 == '-') {
                        DateTimeFormatter dateTimeFormatter6;
                        dateTimeFormatter = dateTimeFormatter6 = formatter_dt19_in;
                    }
                    break block22;
                }
                if (string.length() == 23) {
                    char c5 = string.charAt(4);
                    n = string.charAt(7);
                    c = string.charAt(10);
                    c3 = string.charAt(16);
                    c2 = string.charAt(19);
                    if (string.charAt(13) == ':' && c3 == ':' && c5 == '-' && n == 45 && c == ' ' && c2 == '.') {
                        dateTimeFormatter = defaultFormatter_23;
                    }
                }
            }
            if (string.length() >= 17) {
                char c6 = string.charAt(4);
                if (c6 == '\u5e74') {
                    dateTimeFormatter = string.charAt(string.length() - 1) == '\u79d2' ? formatter_dt19_cn_1 : formatter_dt19_cn;
                } else if (c6 == '\ub144') {
                    dateTimeFormatter = formatter_dt19_kr;
                }
            }
        }
        if (dateTimeFormatter == null) {
            JSONScanner jSONScanner;
            JSONScanner jSONScanner2 = jSONScanner;
            if (new JSONScanner(string).scanISO8601DateIfMatch(false)) {
                return LocalDateTime.ofInstant(jSONScanner2.getCalendar().toInstant(), ZoneId.systemDefault());
            }
            boolean bl = true;
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (c >= '0' && c <= '9') {
                    continue;
                }
                bl = false;
                break;
            }
            if (bl && string.length() > 8 && string.length() < 19) {
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(string)), JSON.defaultTimeZone.toZoneId());
            }
        }
        if (dateTimeFormatter == null) {
            localDateTime = LocalDateTime.parse(string);
            return localDateTime;
        }
        localDateTime = LocalDateTime.parse(string, dateTimeFormatter);
        return localDateTime;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected LocalDate parseLocalDate(String string, String string2, DateTimeFormatter dateTimeFormatter) {
        LocalDate localDate;
        block15: {
            char c;
            block16: {
                char c2;
                char c3;
                block17: {
                    DateTimeFormatter dateTimeFormatter2;
                    block18: {
                        String string3;
                        block19: {
                            DateTimeFormatter dateTimeFormatter3;
                            if (dateTimeFormatter != null) break block15;
                            if (string.length() == 8) {
                                dateTimeFormatter = formatter_d8;
                            }
                            if (string.length() != 10) break block16;
                            int n = string.charAt(4);
                            char c4 = string.charAt(7);
                            if (n == 47 && c4 == '/') {
                                dateTimeFormatter = formatter_d10_tw;
                            }
                            String string4 = string;
                            c4 = string4.charAt(0);
                            c = string4.charAt(1);
                            c3 = string4.charAt(2);
                            String string5 = string;
                            char c5 = string5.charAt(3);
                            c2 = string5.charAt(5);
                            if (c3 != '/' || c2 != '/') break block17;
                            n = (c5 - 48) * 10 + (n - 48);
                            if ((c4 - 48) * 10 + (c - 48) > 12) break block18;
                            if (n <= 12 && !(string3 = Locale.getDefault().getCountry()).equals("US")) break block19;
                            dateTimeFormatter = dateTimeFormatter3 = formatter_d10_us;
                            break block16;
                        }
                        if (!string3.equals("BR") && !string3.equals("AU")) break block16;
                    }
                    dateTimeFormatter = dateTimeFormatter2 = formatter_d10_eur;
                    break block16;
                }
                if (c3 == '.' && c2 == '.') {
                    dateTimeFormatter = formatter_d10_de;
                } else if (c3 == '-' && c2 == '-') {
                    dateTimeFormatter = formatter_d10_in;
                }
            }
            if (string.length() >= 9) {
                char c6 = string.charAt(4);
                if (c6 == '\u5e74') {
                    DateTimeFormatter dateTimeFormatter4;
                    dateTimeFormatter = dateTimeFormatter4 = formatter_d10_cn;
                } else if (c6 == '\ub144') {
                    DateTimeFormatter dateTimeFormatter5;
                    dateTimeFormatter = dateTimeFormatter5 = formatter_d10_kr;
                }
            }
            boolean bl = true;
            for (int i = 0; i < string.length(); ++i) {
                c = string.charAt(i);
                if (c >= '0' && c <= '9') {
                    continue;
                }
                bl = false;
                break;
            }
            if (bl && string.length() > 8 && string.length() < 19) {
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(string)), JSON.defaultTimeZone.toZoneId()).toLocalDate();
            }
        }
        if (dateTimeFormatter == null) {
            localDate = LocalDate.parse(string);
            return localDate;
        }
        localDate = LocalDate.parse(string, dateTimeFormatter);
        return localDate;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ZonedDateTime parseZonedDateTime(String string, DateTimeFormatter dateTimeFormatter) {
        ZonedDateTime zonedDateTime;
        block16: {
            char c;
            int n;
            block17: {
                char c2;
                char c3;
                block20: {
                    DateTimeFormatter dateTimeFormatter2;
                    block21: {
                        String string2;
                        block22: {
                            DateTimeFormatter dateTimeFormatter3;
                            int n2;
                            block19: {
                                block18: {
                                    if (dateTimeFormatter != null) break block16;
                                    if (string.length() != 19) break block17;
                                    n2 = string.charAt(4);
                                    n = string.charAt(7);
                                    c = string.charAt(10);
                                    c3 = string.charAt(16);
                                    if (string.charAt(13) != ':' || c3 != ':') break block17;
                                    if (n2 != 45 || n != 45) break block18;
                                    if (c == 'T') {
                                        dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                                        break block17;
                                    } else if (c == ' ') {
                                        dateTimeFormatter = defaultFormatter;
                                    }
                                    break block17;
                                }
                                if (n2 != 47 || n != 47) break block19;
                                dateTimeFormatter = formatter_dt19_tw;
                                break block17;
                            }
                            n = string.charAt(0);
                            c = string.charAt(1);
                            c3 = string.charAt(2);
                            char c4 = string.charAt(3);
                            c2 = string.charAt(5);
                            if (c3 != '/' || c2 != '/') break block20;
                            n2 = (c4 - 48) * 10 + (n2 - 48);
                            if ((n - 48) * 10 + (c - 48) > 12) break block21;
                            if (n2 <= 12 && !(string2 = Locale.getDefault().getCountry()).equals("US")) break block22;
                            dateTimeFormatter = dateTimeFormatter3 = formatter_dt19_us;
                            break block17;
                        }
                        if (!string2.equals("BR") && !string2.equals("AU")) break block17;
                    }
                    dateTimeFormatter = dateTimeFormatter2 = formatter_dt19_eur;
                    break block17;
                }
                if (c3 == '.' && c2 == '.') {
                    dateTimeFormatter = formatter_dt19_de;
                } else if (c3 == '-' && c2 == '-') {
                    dateTimeFormatter = formatter_dt19_in;
                }
            }
            if (string.length() >= 17) {
                char c5 = string.charAt(4);
                if (c5 == '\u5e74') {
                    DateTimeFormatter dateTimeFormatter4;
                    DateTimeFormatter dateTimeFormatter5;
                    dateTimeFormatter = string.charAt(string.length() - 1) == '\u79d2' ? (dateTimeFormatter5 = formatter_dt19_cn_1) : (dateTimeFormatter4 = formatter_dt19_cn);
                } else if (c5 == '\ub144') {
                    DateTimeFormatter dateTimeFormatter6;
                    dateTimeFormatter = dateTimeFormatter6 = formatter_dt19_kr;
                }
            }
            boolean bl = true;
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (c >= '0' && c <= '9') {
                    continue;
                }
                bl = false;
                break;
            }
            if (bl && string.length() > 8 && string.length() < 19) {
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(string)), JSON.defaultTimeZone.toZoneId());
            }
        }
        if (dateTimeFormatter == null) {
            zonedDateTime = ZonedDateTime.parse(string);
            return zonedDateTime;
        }
        zonedDateTime = ZonedDateTime.parse(string, dateTimeFormatter);
        return zonedDateTime;
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void write(JSONSerializer var1_1, Object var2_3, Object var3_4, Type var4_5, int var5_7) {
        block8: {
            block9: {
                block10: {
                    block7: {
                        var3_4 = var1_1.out;
                        if (var2_3 != null) break block7;
                        var3_4.writeNull();
                        break block8;
                    }
                    if (var4_5 == null) {
                        var4_5 = var2_3.getClass();
                    }
                    if (var4_5 != LocalDateTime.class) break block9;
                    v0 = var2_3;
                    var2_3 = SerializerFeature.UseISO8601DateFormat;
                    var4_6 = var2_3.getMask();
                    var6_8 = (LocalDateTime)v0;
                    var7_9 = var1_1.getDateFormatPattern();
                    if (var7_9 != null) break block10;
                    if ((var5_7 & var4_6) != 0 || var1_1.isEnabled((SerializerFeature)var2_3)) ** GOTO lbl-1000
                    if (var1_1.isEnabled(SerializerFeature.WriteDateUseDateFormat)) {
                        var7_9 = JSON.DEFFAULT_DATE_FORMAT;
                    } else {
                        var1_2 = var6_8.getNano();
                        if (var1_2 != 0) {
                            var7_9 = var1_2 % 1000000 == 0 ? "yyyy-MM-dd'T'HH:mm:ss.SSS" : "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS";
                        } else lbl-1000:
                        // 2 sources

                        {
                            var7_9 = "yyyy-MM-dd'T'HH:mm:ss";
                        }
                    }
                }
                if (var7_9 != null) {
                    this.write((SerializeWriter)var3_4, var6_8, var7_9);
                } else {
                    var3_4.writeLong(var6_8.atZone(JSON.defaultTimeZone.toZoneId()).toInstant().toEpochMilli());
                }
                break block8;
            }
            var3_4.writeString(var2_3.toString());
        }
    }

    @Override
    public void write(JSONSerializer object, Object object2, BeanContext beanContext) {
        Jdk8DateCodec jdk8DateCodec = serializeWriter;
        SerializeWriter serializeWriter = ((JSONSerializer)object).out;
        object = beanContext.getFormat();
        jdk8DateCodec.write(serializeWriter, (TemporalAccessor)object2, (String)object);
    }
}

