/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser.deserializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class NumberDeserializer
implements ObjectDeserializer {
    public static final NumberDeserializer instance = new NumberDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Object object2 = defaultJSONParser.lexer;
        if (object2.token() == 2) {
            if (type != Double.TYPE && type != Double.class) {
                Object object3 = object2;
                long l = object3.longValue();
                object3.nextToken(16);
                if (type != Short.TYPE && type != Short.class) {
                    if (type != Byte.TYPE && type != Byte.class) {
                        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                            return (T)Integer.valueOf((int)l);
                        }
                        return (T)Long.valueOf(l);
                    }
                    if (l <= 127L && l >= -128L) {
                        return (T)Byte.valueOf((byte)l);
                    }
                    throw new JSONException("short overflow : " + l);
                }
                if (l <= 32767L && l >= -32768L) {
                    return (T)Short.valueOf((short)l);
                }
                throw new JSONException("short overflow : " + l);
            }
            Object object4 = object2;
            object2 = object4.numberString();
            object4.nextToken(16);
            return (T)Double.valueOf(Double.parseDouble((String)object2));
        }
        if (object2.token() == 3) {
            if (type != Double.TYPE && type != Double.class) {
                if (type != Short.TYPE && type != Short.class) {
                    if (type != Byte.TYPE && type != Byte.class) {
                        Object object5 = object2;
                        object2 = object5.decimalValue();
                        object5.nextToken(16);
                        if (object5.isEnabled(Feature.UseBigDecimal)) {
                            return (T)object2;
                        }
                        return (T)Double.valueOf(((BigDecimal)object2).doubleValue());
                    }
                    Object object6 = object2;
                    object2 = object6.decimalValue();
                    object6.nextToken(16);
                    return (T)Byte.valueOf(TypeUtils.byteValue((BigDecimal)object2));
                }
                Object object7 = object2;
                object2 = object7.decimalValue();
                object7.nextToken(16);
                return (T)Short.valueOf(TypeUtils.shortValue((BigDecimal)object2));
            }
            Object object8 = object2;
            object2 = object8.numberString();
            object8.nextToken(16);
            return (T)Double.valueOf(Double.parseDouble((String)object2));
        }
        if (object2.token() == 18 && "NaN".equals(object2.stringVal())) {
            object2.nextToken();
            object2 = null;
            if (type == Double.class) {
                object2 = Double.NaN;
            } else if (type == Float.class) {
                object2 = Float.valueOf(Float.NaN);
            }
            return (T)object2;
        }
        object2 = defaultJSONParser.parse();
        if (object2 == null) {
            return null;
        }
        if (type != Double.TYPE && type != Double.class) {
            if (type != Short.TYPE && type != Short.class) {
                if (type != Byte.TYPE && type != Byte.class) {
                    return (T)TypeUtils.castToBigDecimal(object2);
                }
                try {
                    return (T)TypeUtils.castToByte(object2);
                }
                catch (Exception exception) {
                    throw new JSONException("parseByte error, field : " + object, exception);
                }
            }
            try {
                return (T)TypeUtils.castToShort(object2);
            }
            catch (Exception exception) {
                throw new JSONException("parseShort error, field : " + object, exception);
            }
        }
        try {
            return (T)TypeUtils.castToDouble(object2);
        }
        catch (Exception exception) {
            throw new JSONException("parseDouble error, field : " + object, exception);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

