/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.annotation.JSONType;
import com.tradplus.ads.common.serialization.serializer.BeanContext;
import com.tradplus.ads.common.serialization.serializer.ContextObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.DoubleSerializer;
import com.tradplus.ads.common.serialization.serializer.FloatCodec;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.JavaBeanSerializer;
import com.tradplus.ads.common.serialization.serializer.MapSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.FieldInfo;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Collection;

public class FieldSerializer
implements Comparable<FieldSerializer> {
    public final FieldInfo fieldInfo;
    protected final boolean writeNull;
    protected int features;
    private final String double_quoted_fieldPrefix;
    private String single_quoted_fieldPrefix;
    private String un_quoted_fieldPrefix;
    protected BeanContext fieldContext;
    private String format;
    protected boolean writeEnumUsingToString = false;
    protected boolean writeEnumUsingName = false;
    protected boolean disableCircularReferenceDetect = false;
    protected boolean serializeUsing = false;
    protected boolean persistenceXToMany = false;
    protected boolean browserCompatible;
    private RuntimeSerializerInfo runtimeInfo;

    public FieldSerializer(Class<?> serializerFeatureArray, FieldInfo fieldInfo) {
        BeanContext beanContext;
        this.fieldInfo = fieldInfo;
        Object object = beanContext;
        beanContext = new BeanContext((Class<?>)serializerFeatureArray, fieldInfo);
        this.fieldContext = object;
        if (serializerFeatureArray != null && (serializerFeatureArray = TypeUtils.getAnnotation(serializerFeatureArray, JSONType.class)) != null) {
            for (SerializerFeature serializerFeature : serializerFeatureArray.serialzeFeatures()) {
                if (serializerFeature == SerializerFeature.WriteEnumUsingToString) {
                    this.writeEnumUsingToString = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.WriteEnumUsingName) {
                    this.writeEnumUsingName = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.DisableCircularReferenceDetect) {
                    this.disableCircularReferenceDetect = true;
                    continue;
                }
                SerializerFeature serializerFeature2 = SerializerFeature.BrowserCompatible;
                if (serializerFeature == serializerFeature2) {
                    this.features |= serializerFeature2.mask;
                    this.browserCompatible = true;
                    continue;
                }
                if (serializerFeature != (serializerFeature = SerializerFeature.WriteMapNullValue)) continue;
                this.features |= serializerFeature.mask;
            }
        }
        FieldInfo fieldInfo2 = fieldInfo;
        fieldInfo2.setAccessible();
        this.double_quoted_fieldPrefix = '\"' + fieldInfo.name + "\":";
        boolean bl = false;
        object = fieldInfo2.getAnnotation();
        if (object != null) {
            SerializerFeature[] serializerFeatureArray2 = object.serialzeFeatures();
            int n = serializerFeatureArray2.length;
            for (int i = 0; i < n; ++i) {
                if ((serializerFeatureArray2[i].getMask() & SerializerFeature.WRITE_MAP_NULL_FEATURES) == 0) continue;
                bl = true;
                break;
            }
            if ((this.format = object.format()).trim().length() == 0) {
                this.format = null;
            }
            for (SerializerFeature serializerFeature : object.serialzeFeatures()) {
                if (serializerFeature == SerializerFeature.WriteEnumUsingToString) {
                    this.writeEnumUsingToString = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.WriteEnumUsingName) {
                    this.writeEnumUsingName = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.DisableCircularReferenceDetect) {
                    this.disableCircularReferenceDetect = true;
                    continue;
                }
                if (serializerFeature != SerializerFeature.BrowserCompatible) continue;
                this.browserCompatible = true;
            }
            this.features |= SerializerFeature.of(object.serialzeFeatures());
        }
        this.writeNull = bl;
        bl = TypeUtils.isAnnotationPresentOneToMany(fieldInfo.method) || TypeUtils.isAnnotationPresentManyToMany(fieldInfo.method);
        this.persistenceXToMany = bl;
    }

    public void writePrefix(JSONSerializer object) {
        object = ((JSONSerializer)object).out;
        if (((SerializeWriter)object).quoteFieldNames) {
            if (SerializerFeature.isEnabled(((SerializeWriter)object).features, this.fieldInfo.serialzeFeatures, SerializerFeature.UseSingleQuotes)) {
                if (this.single_quoted_fieldPrefix == null) {
                    this.single_quoted_fieldPrefix = '\'' + this.fieldInfo.name + "':";
                }
                ((SerializeWriter)object).write(this.single_quoted_fieldPrefix);
            } else {
                ((SerializeWriter)object).write(this.double_quoted_fieldPrefix);
            }
        } else {
            if (this.un_quoted_fieldPrefix == null) {
                this.un_quoted_fieldPrefix = this.fieldInfo.name + ":";
            }
            ((SerializeWriter)object).write(this.un_quoted_fieldPrefix);
        }
    }

    public Object getPropertyValueDirect(Object object) {
        FieldSerializer fieldSerializer = object2;
        Object object2 = fieldSerializer.fieldInfo.get(object);
        if (fieldSerializer.persistenceXToMany && !TypeUtils.isHibernateInitialized(object2)) {
            return null;
        }
        return object2;
    }

    public Object getPropertyValue(Object object) {
        Class<?> clazz;
        FieldSerializer fieldSerializer = this;
        object = fieldSerializer.fieldInfo.get(object);
        if (fieldSerializer.format != null && object != null && ((clazz = this.fieldInfo.fieldClass) == java.util.Date.class || clazz == Date.class)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format, JSON.defaultLocale);
            simpleDateFormat.setTimeZone(JSON.defaultTimeZone);
            return simpleDateFormat.format(object);
        }
        return object;
    }

    @Override
    public int compareTo(FieldSerializer fieldSerializer) {
        return this.fieldInfo.compareTo(fieldSerializer.fieldInfo);
    }

    public void writeValue(JSONSerializer object, Object object2) {
        long l;
        Object object3;
        Class<?> clazz;
        Class<?> clazz2;
        if (((FieldSerializer)object3).runtimeInfo == null) {
            RuntimeSerializerInfo runtimeSerializerInfo;
            if (object2 == null) {
                clazz2 = ((FieldSerializer)object3).fieldInfo.fieldClass;
                if (clazz2 == Byte.TYPE) {
                    clazz2 = Byte.class;
                } else if (clazz2 == Short.TYPE) {
                    clazz2 = Short.class;
                } else if (clazz2 == Integer.TYPE) {
                    clazz2 = Integer.class;
                } else if (clazz2 == Long.TYPE) {
                    clazz2 = Long.class;
                } else if (clazz2 == Float.TYPE) {
                    clazz2 = Float.class;
                } else if (clazz2 == Double.TYPE) {
                    clazz2 = Double.class;
                } else if (clazz2 == Boolean.TYPE) {
                    clazz2 = Boolean.class;
                }
            } else {
                clazz2 = object2.getClass();
            }
            ObjectSerializer objectSerializer = null;
            clazz = ((FieldSerializer)object3).fieldInfo.getAnnotation();
            if (clazz != null && clazz.serializeUsing() != Void.class) {
                objectSerializer = (ObjectSerializer)clazz.serializeUsing().newInstance();
                ((FieldSerializer)object3).serializeUsing = true;
            } else {
                if (((FieldSerializer)object3).format != null) {
                    if (clazz2 != Double.TYPE && clazz2 != Double.class) {
                        if (clazz2 == Float.TYPE || clazz2 == Float.class) {
                            FloatCodec floatCodec;
                            objectSerializer = floatCodec;
                            floatCodec = new FloatCodec(((FieldSerializer)object3).format);
                        }
                    } else {
                        DoubleSerializer doubleSerializer;
                        objectSerializer = doubleSerializer;
                        doubleSerializer = new DoubleSerializer(((FieldSerializer)object3).format);
                    }
                }
                if (objectSerializer == null) {
                    objectSerializer = ((JSONSerializer)object).getObjectWriter(clazz2);
                }
            }
            clazz = runtimeSerializerInfo;
            runtimeSerializerInfo = new RuntimeSerializerInfo(objectSerializer, clazz2);
            ((FieldSerializer)object3).runtimeInfo = clazz;
        }
        clazz2 = ((FieldSerializer)object3).runtimeInfo;
        int n = ((FieldSerializer)object3).disableCircularReferenceDetect ? ((FieldSerializer)object3).fieldInfo.serialzeFeatures | SerializerFeature.DisableCircularReferenceDetect.mask : ((FieldSerializer)object3).fieldInfo.serialzeFeatures;
        n |= ((FieldSerializer)object3).features;
        if (object2 == null) {
            object2 = ((JSONSerializer)object).out;
            if (((FieldSerializer)object3).fieldInfo.fieldClass == Object.class && ((SerializeWriter)object2).isEnabled(SerializerFeature.WRITE_MAP_NULL_FEATURES)) {
                ((SerializeWriter)object2).writeNull();
                return;
            }
            clazz = ((RuntimeSerializerInfo)((Object)clazz2)).runtimeFieldClass;
            if (Number.class.isAssignableFrom(clazz)) {
                ((SerializeWriter)object2).writeNull(((FieldSerializer)object3).features, SerializerFeature.WriteNullNumberAsZero.mask);
                return;
            }
            if (String.class == clazz) {
                ((SerializeWriter)object2).writeNull(((FieldSerializer)object3).features, SerializerFeature.WriteNullStringAsEmpty.mask);
                return;
            }
            if (Boolean.class == clazz) {
                ((SerializeWriter)object2).writeNull(((FieldSerializer)object3).features, SerializerFeature.WriteNullBooleanAsFalse.mask);
                return;
            }
            if (!Collection.class.isAssignableFrom(clazz) && !clazz.isArray()) {
                clazz2 = ((RuntimeSerializerInfo)((Object)clazz2)).fieldSerializer;
                if (((SerializeWriter)object2).isEnabled(SerializerFeature.WRITE_MAP_NULL_FEATURES) && clazz2 instanceof JavaBeanSerializer) {
                    ((SerializeWriter)object2).writeNull();
                    return;
                }
                FieldInfo fieldInfo = ((FieldSerializer)object3).fieldInfo;
                object3 = fieldInfo.name;
                object2 = fieldInfo.fieldType;
                clazz2.write((JSONSerializer)object, null, object3, (Type)object2, n);
                return;
            }
            ((SerializeWriter)object2).writeNull(((FieldSerializer)object3).features, SerializerFeature.WriteNullListAsEmpty.mask);
            return;
        }
        if (((FieldSerializer)object3).fieldInfo.isEnum) {
            if (((FieldSerializer)object3).writeEnumUsingName) {
                ((JSONSerializer)object).out.writeString(((Enum)object2).name());
                return;
            }
            if (((FieldSerializer)object3).writeEnumUsingToString) {
                ((JSONSerializer)object).out.writeString(((Enum)object2).toString());
                return;
            }
        }
        clazz2 = (clazz = object2.getClass()) != ((RuntimeSerializerInfo)((Object)clazz2)).runtimeFieldClass && !((FieldSerializer)object3).serializeUsing ? ((JSONSerializer)object).getObjectWriter(clazz) : ((RuntimeSerializerInfo)((Object)clazz2)).fieldSerializer;
        Object object4 = ((FieldSerializer)object3).format;
        if (object4 != null && !(clazz2 instanceof DoubleSerializer) && !(clazz2 instanceof FloatCodec)) {
            if (clazz2 instanceof ContextObjectSerializer) {
                ((ContextObjectSerializer)((Object)clazz2)).write((JSONSerializer)object, object2, ((FieldSerializer)object3).fieldContext);
            } else {
                ((JSONSerializer)object).writeWithFormat(object2, (String)object4);
            }
            return;
        }
        object4 = ((FieldSerializer)object3).fieldInfo;
        if (((FieldInfo)object4).unwrapped) {
            if (clazz2 instanceof JavaBeanSerializer) {
                JSONSerializer jSONSerializer = object;
                Object object5 = object4;
                object3 = ((FieldInfo)object5).name;
                object = ((FieldInfo)object5).fieldType;
                ((JavaBeanSerializer)((Object)clazz2)).write(jSONSerializer, object2, object3, (Type)object, n, true);
                return;
            }
            if (clazz2 instanceof MapSerializer) {
                JSONSerializer jSONSerializer = object;
                Object object6 = object4;
                object3 = ((FieldInfo)object6).name;
                object = ((FieldInfo)object6).fieldType;
                ((MapSerializer)((Object)clazz2)).write(jSONSerializer, object2, object3, (Type)object, n, true);
                return;
            }
        }
        if ((((FieldSerializer)object3).features & SerializerFeature.WriteClassName.mask) != 0 && clazz != ((FieldInfo)object4).fieldClass && clazz2 instanceof JavaBeanSerializer) {
            Object object7 = object;
            Object object8 = object4;
            object3 = ((FieldInfo)object8).name;
            object = ((FieldInfo)object8).fieldType;
            ((JavaBeanSerializer)((Object)clazz2)).write((JSONSerializer)object7, object2, object3, (Type)object, n, false);
            return;
        }
        if (!(!((FieldSerializer)object3).browserCompatible || (clazz = ((FieldInfo)object4).fieldClass) != Long.TYPE && clazz != Long.class || (l = ((Long)object2).longValue()) <= 0x1FFFFFFFFFFFFFL && l >= -9007199254740991L)) {
            ((JSONSerializer)object).getWriter().writeString(Long.toString(l));
            return;
        }
        Class<?> clazz3 = clazz2;
        FieldInfo fieldInfo = ((FieldSerializer)object3).fieldInfo;
        object3 = fieldInfo.name;
        clazz2 = fieldInfo.fieldType;
        clazz3.write((JSONSerializer)object, object2, object3, clazz2, n);
    }

    static class RuntimeSerializerInfo {
        final ObjectSerializer fieldSerializer;
        final Class<?> runtimeFieldClass;

        public RuntimeSerializerInfo(ObjectSerializer objectSerializer, Class<?> clazz) {
            this.fieldSerializer = objectSerializer;
            this.runtimeFieldClass = clazz;
        }
    }
}

