/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.serializer.NameFilter;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.PropertyFilter;
import com.tradplus.ads.common.serialization.serializer.SerialContext;
import com.tradplus.ads.common.serialization.serializer.SerializeConfig;
import com.tradplus.ads.common.serialization.serializer.SerializeFilter;
import com.tradplus.ads.common.serialization.serializer.SerializeFilterable;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.serializer.StringCodec;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;

public class JSONSerializer
extends SerializeFilterable {
    protected final SerializeConfig config;
    public final SerializeWriter out;
    private int indentCount;
    private String indent;
    private String dateFormatPattern;
    private DateFormat dateFormat;
    private String fastJsonConfigDateFormatPattern;
    protected IdentityHashMap<Object, SerialContext> references;
    protected SerialContext context;
    protected TimeZone timeZone;
    protected Locale locale;

    public JSONSerializer() {
        SerializeWriter serializeWriter;
        JSONSerializer jSONSerializer = serializeWriter2;
        SerializeWriter serializeWriter2 = serializeWriter;
        serializeWriter = new SerializeWriter();
        jSONSerializer(serializeWriter2, SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeWriter serializeWriter) {
        this(serializeWriter, SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeConfig serializeConfig) {
        SerializeWriter serializeWriter;
        JSONSerializer jSONSerializer = serializeWriter2;
        SerializeWriter serializeWriter2 = serializeWriter;
        serializeWriter = new SerializeWriter();
        jSONSerializer(serializeWriter2, serializeConfig);
    }

    public JSONSerializer(SerializeWriter serializeWriter, SerializeConfig serializeConfig) {
        this.indentCount = 0;
        this.indent = "\t";
        this.references = null;
        this.timeZone = JSON.defaultTimeZone;
        this.locale = JSON.defaultLocale;
        this.out = serializeWriter;
        this.config = serializeConfig;
    }

    private DateFormat generateDateFormat(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, this.locale);
        simpleDateFormat.setTimeZone(this.timeZone);
        return simpleDateFormat;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(Writer writer, Object object) {
        Throwable throwable2;
        SerializeWriter serializeWriter;
        SerializeWriter serializeWriter2 = serializeWriter;
        serializeWriter = new SerializeWriter();
        new JSONSerializer(serializeWriter2).write(object);
        serializeWriter.writeTo(writer);
        serializeWriter.close();
        return;
        {
            catch (Throwable throwable2) {
            }
            catch (IOException iOException) {}
            {
                throw new JSONException(iOException.getMessage(), iOException);
            }
        }
        serializeWriter2.close();
        throw throwable2;
    }

    public static void write(SerializeWriter serializeWriter, Object object) {
        new JSONSerializer(serializeWriter).write(object);
    }

    public String getDateFormatPattern() {
        DateFormat dateFormat = this.dateFormat;
        if (dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)dateFormat).toPattern();
        }
        return this.dateFormatPattern;
    }

    public DateFormat getDateFormat() {
        String string;
        if (this.dateFormat == null && (string = this.dateFormatPattern) != null) {
            this.dateFormat = this.generateDateFormat(string);
        }
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        if (this.dateFormatPattern != null) {
            this.dateFormatPattern = null;
        }
    }

    public void setDateFormat(String string) {
        this.dateFormatPattern = string;
        if (this.dateFormat != null) {
            this.dateFormat = null;
        }
    }

    public void setFastJsonConfigDateFormatPattern(String string) {
        this.fastJsonConfigDateFormatPattern = string;
    }

    public String getFastJsonConfigDateFormatPattern() {
        return this.fastJsonConfigDateFormatPattern;
    }

    public SerialContext getContext() {
        return this.context;
    }

    public void setContext(SerialContext serialContext) {
        this.context = serialContext;
    }

    public void setContext(SerialContext serialContext, Object object, Object object2, int n) {
        this.setContext(serialContext, object, object2, n, 0);
    }

    public void setContext(SerialContext object, Object object2, Object object3, int n, int n2) {
        if (this.out.disableCircularReferenceDetect) {
            return;
        }
        this.context = new SerialContext((SerialContext)object, object2, object3, n, n2);
        if (this.references == null) {
            IdentityHashMap identityHashMap;
            object = identityHashMap;
            identityHashMap = new IdentityHashMap();
            this.references = object;
        }
        this.references.put(object2, this.context);
    }

    public void setContext(Object object, Object object2) {
        JSONSerializer jSONSerializer = this;
        jSONSerializer.setContext(jSONSerializer.context, object, object2, 0);
    }

    public void popContext() {
        SerialContext serialContext = this.context;
        if (serialContext != null) {
            this.context = serialContext.parent;
        }
    }

    public final boolean isWriteClassName(Type type, Object object) {
        return ((JSONSerializer)this).out.isEnabled(SerializerFeature.WriteClassName) && (type != null || !((JSONSerializer)this).out.isEnabled(SerializerFeature.NotWriteRootClassName) || (this = ((JSONSerializer)this).context) != null && ((SerialContext)this).parent != null);
    }

    public boolean containsReference(Object object) {
        Object object2 = ((JSONSerializer)object2).references;
        if (object2 == null) {
            return false;
        }
        if ((object2 = (SerialContext)((IdentityHashMap)object2).get(object)) == null) {
            return false;
        }
        if (object == Collections.emptyMap()) {
            return false;
        }
        object2 = ((SerialContext)object2).fieldName;
        return object2 == null || object2 instanceof Integer || object2 instanceof String;
    }

    public void writeReference(Object object) {
        SerialContext serialContext = ((JSONSerializer)((Object)string)).context;
        if (object == serialContext.object) {
            ((JSONSerializer)((Object)string)).out.write("{\"$ref\":\"@\"}");
            return;
        }
        SerialContext serialContext2 = serialContext.parent;
        if (serialContext2 != null && object == serialContext2.object) {
            ((JSONSerializer)((Object)string)).out.write("{\"$ref\":\"..\"}");
            return;
        }
        while (true) {
            if ((serialContext2 = serialContext.parent) == null) {
                if (object == serialContext.object) {
                    ((JSONSerializer)((Object)string)).out.write("{\"$ref\":\"$\"}");
                } else {
                    JSONSerializer jSONSerializer = string;
                    jSONSerializer.out.write("{\"$ref\":\"");
                    String string = jSONSerializer.references.get(object).toString();
                    jSONSerializer.out.write(string);
                    jSONSerializer.out.write("\"}");
                }
                return;
            }
            serialContext = serialContext2;
        }
    }

    public boolean checkValue(SerializeFilterable object) {
        List<SerializeFilter> list = this.valueFilters;
        return list != null && list.size() > 0 || (list = this.contextValueFilters) != null && list.size() > 0 || (list = ((SerializeFilterable)object).valueFilters) != null && list.size() > 0 || (object = ((SerializeFilterable)object).contextValueFilters) != null && object.size() > 0 || this.out.writeNonStringValueAsString;
    }

    public boolean hasNameFilters(SerializeFilterable serializeFilterable) {
        List<NameFilter> list = ((SerializeFilterable)((Object)list)).nameFilters;
        return list != null && list.size() > 0 || (list = serializeFilterable.nameFilters) != null && list.size() > 0;
    }

    public boolean hasPropertyFilters(SerializeFilterable serializeFilterable) {
        List<PropertyFilter> list = ((SerializeFilterable)((Object)list)).propertyFilters;
        return list != null && list.size() > 0 || (list = serializeFilterable.propertyFilters) != null && list.size() > 0;
    }

    public int getIndentCount() {
        return this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    public void decrementIdent() {
        --this.indentCount;
    }

    public void println() {
        this.out.write(10);
        for (int i = 0; i < this.indentCount; ++i) {
            this.out.write(this.indent);
        }
    }

    public SerializeWriter getWriter() {
        return this.out;
    }

    public String toString() {
        return this.out.toString();
    }

    public void jsonCfg(SerializerFeature serializerFeature, boolean bl) {
        this.out.jsonCfg(serializerFeature, bl);
    }

    public boolean isEnabled(SerializerFeature serializerFeature) {
        return this.out.isEnabled(serializerFeature);
    }

    public void writeNull() {
        this.out.writeNull();
    }

    public SerializeConfig getMapping() {
        return this.config;
    }

    public final void write(Object object) {
        if (object == null) {
            this.out.writeNull();
            return;
        }
        try {
            this.getObjectWriter(object.getClass()).write(this, object, null, null, 0);
            return;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeAs(Object object, Class clazz) {
        if (object == null) {
            this.out.writeNull();
            return;
        }
        try {
            this.getObjectWriter(clazz).write(this, object, null, null, 0);
            return;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeWithFieldName(Object object, Object object2) {
        this.writeWithFieldName(object, object2, null, 0);
    }

    protected final void writeKeyValue(char c, String string, Object object) {
        if (c != '\u0000') {
            this.out.write(c);
        }
        this.out.writeFieldName(string);
        this.write(object);
    }

    /*
     * Unable to fully structure code
     */
    public final void writeWithFieldName(Object var1_2, Object var2_3, Type var3_4, int var4_5) {
        if (var1_2 != null) ** GOTO lbl5
        try {
            this.out.writeNull();
            return;
lbl5:
            // 1 sources

            this.getObjectWriter(var1_2.getClass()).write(this, var1_2, var2_3, var3_4, var4_5);
            return;
        }
        catch (IOException var0_1) {
            throw new JSONException(var0_1.getMessage(), var0_1);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeWithFormat(Object var1_3, String var2_4) {
        block23: {
            block22: {
                block21: {
                    if (var1_3 instanceof Date) {
                        if ("unixtime".equals(var2_4)) {
                            var0_1 = ((Date)var1_3).getTime() / 1000L;
                            this.out.writeInt((int)var0_1);
                            return;
                        }
                        if ("millis".equals(var2_4)) {
                            this.out.writeLong(((Date)var1_3).getTime());
                            return;
                        }
                        var3_5 = this.getDateFormat();
                        if (var3_5 == null) {
                            if (var2_4 != null) {
                                try {
                                    var3_5 = this.generateDateFormat((String)var2_4);
                                }
                                catch (IllegalArgumentException v0) {
                                    var3_5 = this.generateDateFormat(var2_4.replaceAll("T", "'T'"));
                                }
                            } else {
                                var2_4 = this.fastJsonConfigDateFormatPattern;
                                var3_5 = var2_4 != null ? super.generateDateFormat((String)var2_4) : super.generateDateFormat(JSON.DEFFAULT_DATE_FORMAT);
                            }
                        }
                        v1 = this;
                        this = var3_5.format((Date)var1_3);
                        v1.out.writeString(this);
                        return;
                    }
                    if (!(var1_3 instanceof byte[])) break block23;
                    var1_3 = (byte[])var1_3;
                    if (!"gzip".equals(var2_4) && !"gzip,base64".equals(var2_4)) {
                        if ("hex".equals(var2_4)) {
                            this.out.writeHex((byte[])var1_3);
                            return;
                        }
                        this.out.writeByteArray((byte[])var1_3);
                        return;
                    }
                    var2_4 = null;
                    var3_6 = v2;
                    v2 = new ByteArrayOutputStream();
                    if (((Object)var1_3).length >= 512) break block21;
                    {
                        catch (Throwable v3) {
                            break block22;
                        }
                        catch (IOException var0_2) {}
                        {
                            throw new JSONException("write gzipBytes error", var0_2);
                        }
                    }
                    var4_8 = v4;
                    {
                        v4 = new GZIPOutputStream((OutputStream)var3_6, ((Object)var1_3).length);
                        ** GOTO lbl48
                    }
                }
                var4_8 = v5;
                {
                    v5 = new GZIPOutputStream(var3_6);
lbl48:
                    // 2 sources

                    v6 = var2_4 = var4_8;
                    v6.write((byte[])var1_3);
                    v6.finish();
                    this.out.writeByteArray(var3_6.toByteArray());
                    IOUtils.close((Closeable)var2_4);
                }
                return;
            }
            IOUtils.close((Closeable)var2_4);
            throw v3;
        }
        if (!(var1_3 instanceof Collection)) {
            this.write(var1_3);
            return;
        }
        var1_3 = (Collection)var1_3;
        var3_7 = var1_3.iterator();
        this.out.write(91);
        var4_9 = 0;
        while (true) {
            if (var4_9 >= var1_3.size()) {
                this.out.write(93);
                return;
            }
            var5_10 = var3_7.next();
            if (var4_9 != 0) {
                this.out.write(44);
            }
            this.writeWithFormat(var5_10, (String)var2_4);
            ++var4_9;
        }
    }

    public final void write(String string) {
        StringCodec.instance.write(this, string);
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        return this.config.getObjectWriter(clazz);
    }

    public void close() {
        this.out.close();
    }
}

