/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import com.tradplus.ads.common.serialization.annotation.JSONField;
import com.tradplus.ads.common.serialization.util.ParameterizedTypeImpl;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;

public class FieldInfo
implements Comparable<FieldInfo> {
    public final String name;
    public final Method method;
    public final Field field;
    private int ordinal = 0;
    public final Class<?> fieldClass;
    public final Type fieldType;
    public final Class<?> declaringClass;
    public final boolean getOnly;
    public final int serialzeFeatures;
    public final int parserFeatures;
    public final String label;
    private final JSONField fieldAnnotation;
    private final JSONField methodAnnotation;
    public final boolean fieldAccess;
    public final boolean fieldTransient;
    public final char[] name_chars;
    public final boolean isEnum;
    public final boolean jsonDirect;
    public final boolean unwrapped;
    public final String format;
    public final String[] alternateNames;
    public final long nameHashCode;

    public FieldInfo(String string, Class<?> clazz, Class<?> clazz2, Type type, Field field, int n, int n2, int n3) {
        long l;
        if (n < 0) {
            n = 0;
        }
        this.name = string;
        this.declaringClass = clazz;
        this.fieldClass = clazz2;
        this.fieldType = type;
        this.method = null;
        this.field = field;
        this.ordinal = n;
        this.serialzeFeatures = n2;
        this.parserFeatures = n3;
        this.isEnum = clazz2.isEnum();
        if (field != null) {
            int n4 = field.getModifiers();
            int cfr_ignored_0 = n4 & 1;
            this.fieldAccess = true;
            this.fieldTransient = Modifier.isTransient(n4);
        } else {
            this.fieldTransient = false;
            this.fieldAccess = false;
        }
        this.name_chars = this.genFieldNameChars();
        if (field != null) {
            TypeUtils.setAccessible(field);
        }
        this.label = "";
        JSONField jSONField = field == null ? null : TypeUtils.getAnnotation(field, JSONField.class);
        this.fieldAnnotation = jSONField;
        this.methodAnnotation = null;
        this.getOnly = false;
        this.jsonDirect = false;
        this.unwrapped = false;
        this.format = null;
        this.alternateNames = new String[0];
        this.nameHashCode = l = this.nameHashCode64(string, jSONField);
    }

    public FieldInfo(String string, Method method, Field field, Class<?> clazz, Type type, int n, int n2, int n3, JSONField jSONField, JSONField jSONField2, String string2) {
        this(string, method, field, clazz, type, n, n2, n3, jSONField, jSONField2, string2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public FieldInfo(String string, Method method, Field object, Class<?> clazz, Type clazz2, int n, int n2, int n3, JSONField jSONField, JSONField jSONField2, String string2, Map<TypeVariable, Type> map) {
        void var7_26;
        Type type;
        void var7_23;
        boolean bl;
        long l;
        void var11_31;
        void var10_30;
        void var9_29;
        void var8_27;
        String string3;
        if (object != null && (string3 = ((Field)object).getName()).equals(string)) {
            string = string3;
        }
        if (n < 0) {
            n = 0;
        }
        this.name = string;
        this.method = method;
        this.field = object;
        this.ordinal = n;
        this.serialzeFeatures = n2;
        this.parserFeatures = var8_27;
        this.fieldAnnotation = var9_29;
        this.methodAnnotation = var10_30;
        if (object != null) {
            void var7_15;
            n = ((Field)object).getModifiers();
            if ((n & 1) == 0 && method != null) {
                boolean bl2 = false;
            } else {
                boolean bl3 = true;
            }
            this.fieldAccess = var7_15;
            n = !Modifier.isTransient(n) && !TypeUtils.isTransient(method) ? 0 : 1;
            this.fieldTransient = n;
        } else {
            this.fieldAccess = false;
            this.fieldTransient = TypeUtils.isTransient(method);
        }
        this.label = var11_31 != null && var11_31.length() > 0 ? var11_31 : "";
        String string4 = null;
        JSONField jSONField3 = this.getAnnotation();
        this.nameHashCode = l = this.nameHashCode64(string, jSONField3);
        if (jSONField3 != null) {
            string = jSONField3.format();
            string4 = string.trim().length() == 0 ? (string = null) : string;
            JSONField jSONField4 = jSONField3;
            bl = jSONField4.jsonDirect();
            this.unwrapped = jSONField4.unwrapped();
            this.alternateNames = jSONField4.alternateNames();
        } else {
            bl = false;
            this.unwrapped = false;
            this.alternateNames = new String[0];
        }
        this.format = string4;
        this.name_chars = this.genFieldNameChars();
        if (method != null) {
            TypeUtils.setAccessible(method);
        }
        if (object != null) {
            TypeUtils.setAccessible((AccessibleObject)object);
        }
        boolean bl4 = false;
        if (method != null) {
            Object object2;
            object = method.getParameterTypes();
            if (((Class<?>[])object).length == 1) {
                object = object[0];
                Type type2 = method.getGenericParameterTypes()[0];
            } else if (((Object)object).length == 2 && (object2 = object[0]) == String.class && object[1] == Object.class) {
                object = object2;
            } else {
                Method method2 = method;
                object = method2.getReturnType();
                Type type3 = method2.getGenericReturnType();
                bl4 = true;
            }
            this.declaringClass = method.getDeclaringClass();
        } else {
            Object object3 = object;
            object = ((Field)object3).getType();
            Type type4 = ((Field)object3).getGenericType();
            this.declaringClass = ((Field)object3).getDeclaringClass();
            bl4 = Modifier.isFinal(((Field)object3).getModifiers());
        }
        this.getOnly = bl4;
        bl = bl && object == String.class;
        this.jsonDirect = bl;
        if (clazz != null && object == Object.class && var7_23 instanceof TypeVariable && (type = FieldInfo.getInheritGenericType(clazz, clazz2, (TypeVariable)var7_23)) != null) {
            this.fieldClass = TypeUtils.getClass(type);
            this.fieldType = type;
            this.isEnum = ((Class)object).isEnum();
            return;
        }
        if (!(var7_23 instanceof Class)) {
            void var12_32;
            if (clazz2 == null) {
                clazz2 = clazz;
            }
            Type type5 = FieldInfo.getFieldType(clazz, clazz2, (Type)var7_23, (Map<TypeVariable, Type>)var12_32);
            if (type5 != var7_23 && (type5 instanceof ParameterizedType || type5 instanceof Class)) {
                object = TypeUtils.getClass(type5);
                Type type6 = type5;
            } else {
                Type type7 = type5;
            }
        }
        this.fieldType = var7_26;
        this.fieldClass = object;
        this.isEnum = ((Class)object).isEnum();
    }

    private long nameHashCode64(String string, JSONField jSONField) {
        if (jSONField != null && jSONField.name().length() != 0) {
            return TypeUtils.fnv1a_64_lower(string);
        }
        return TypeUtils.fnv1a_64_extract(string);
    }

    public static Type getFieldType(Class<?> clazz, Type type, Type type2) {
        return FieldInfo.getFieldType(clazz, type, type2, null);
    }

    public static Type getFieldType(Class<?> type, Type typeVariableArray, Type type2, Map<TypeVariable, Type> map) {
        if (type != null && typeVariableArray != null) {
            Type[] typeArray;
            ParameterizedType parameterizedType;
            if (type2 instanceof GenericArrayType) {
                Type type3 = ((GenericArrayType)type2).getGenericComponentType();
                if (type3 != (type = FieldInfo.getFieldType(type, (Type)typeVariableArray, type3, map))) {
                    return Array.newInstance(TypeUtils.getClass(type), 0).getClass();
                }
                return type2;
            }
            if (!TypeUtils.isGenericParamType((Type)typeVariableArray)) {
                return type2;
            }
            if (type2 instanceof TypeVariable) {
                parameterizedType = (ParameterizedType)TypeUtils.getGenericParamType((Type)typeVariableArray);
                typeArray = (Type[])type2;
                TypeVariable<Class<?>>[] typeVariableArray2 = TypeUtils.getClass(parameterizedType).getTypeParameters();
                for (int i = 0; i < typeVariableArray2.length; ++i) {
                    if (!typeVariableArray2[i].getName().equals(typeArray.getName())) continue;
                    return parameterizedType.getActualTypeArguments()[i];
                }
            }
            if (type2 instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)type2;
                typeArray = parameterizedType.getActualTypeArguments();
                boolean bl = FieldInfo.getArgument(typeArray, map);
                if (!bl) {
                    if (typeVariableArray instanceof ParameterizedType) {
                        Type type4 = type;
                        type = (ParameterizedType)typeVariableArray;
                        typeVariableArray = ((Class)type4).getTypeParameters();
                    } else if (((Class)type).getGenericSuperclass() instanceof ParameterizedType) {
                        Type type5 = type;
                        type = (ParameterizedType)((Class)type5).getGenericSuperclass();
                        typeVariableArray = ((Class)type5).getSuperclass().getTypeParameters();
                    } else {
                        typeVariableArray = typeVariableArray.getClass().getTypeParameters();
                        type = parameterizedType;
                    }
                    bl = FieldInfo.getArgument(typeArray, typeVariableArray, type.getActualTypeArguments());
                }
                if (bl) {
                    ParameterizedType parameterizedType2 = parameterizedType;
                    type = parameterizedType2.getOwnerType();
                    typeVariableArray = parameterizedType2.getRawType();
                    return new ParameterizedTypeImpl(typeArray, type, (Type)typeVariableArray);
                }
            }
            return type2;
        }
        return type2;
    }

    private static boolean getArgument(Type[] typeArray, Map<TypeVariable, Type> map) {
        if (map != null && map.size() != 0) {
            boolean bl = false;
            for (int i = 0; i < typeArray.length; ++i) {
                Type type = typeArray[i];
                if (type instanceof ParameterizedType) {
                    ParameterizedTypeImpl parameterizedTypeImpl;
                    Type[] typeArray2 = (type = (ParameterizedType)type).getActualTypeArguments();
                    if (!FieldInfo.getArgument(typeArray2, map)) continue;
                    ParameterizedTypeImpl parameterizedTypeImpl2 = parameterizedTypeImpl;
                    Type type2 = type;
                    type = type2.getOwnerType();
                    Type type3 = type2.getRawType();
                    parameterizedTypeImpl = new ParameterizedTypeImpl(typeArray2, type, type3);
                    typeArray[i] = parameterizedTypeImpl2;
                    bl = true;
                    continue;
                }
                if (!(type instanceof TypeVariable) || !map.containsKey(type)) continue;
                typeArray[i] = map.get(type);
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private static boolean getArgument(Type[] typeArray, TypeVariable[] typeVariableArray, Type[] typeArray2) {
        if (typeArray2 != null && typeVariableArray.length != 0) {
            boolean bl = false;
            for (int i = 0; i < typeArray.length; ++i) {
                Type type = typeArray[i];
                if (type instanceof ParameterizedType) {
                    ParameterizedTypeImpl parameterizedTypeImpl;
                    Type[] typeArray3 = (type = (ParameterizedType)type).getActualTypeArguments();
                    if (!FieldInfo.getArgument(typeArray3, typeVariableArray, typeArray2)) continue;
                    ParameterizedTypeImpl parameterizedTypeImpl2 = parameterizedTypeImpl;
                    Type type2 = type;
                    type = type2.getOwnerType();
                    Type type3 = type2.getRawType();
                    parameterizedTypeImpl = new ParameterizedTypeImpl(typeArray3, type, type3);
                    typeArray[i] = parameterizedTypeImpl2;
                    bl = true;
                    continue;
                }
                if (!(type instanceof TypeVariable)) continue;
                for (int j = 0; j < typeVariableArray.length; ++j) {
                    if (!type.equals(typeVariableArray[j])) continue;
                    typeArray[i] = typeArray2[j];
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    private static Type getInheritGenericType(Class<?> type, Type object, TypeVariable<?> typeVariable) {
        Class clazz = null;
        if (typeVariable.getGenericDeclaration() instanceof Class) {
            clazz = (Class)typeVariable.getGenericDeclaration();
        }
        Type[] typeArray = null;
        if (clazz == type) {
            if (object instanceof ParameterizedType) {
                typeArray = ((ParameterizedType)object).getActualTypeArguments();
            }
        } else {
            while (type != null && type != Object.class && type != clazz) {
                object = type.getGenericSuperclass();
                if (object instanceof ParameterizedType) {
                    object = ((ParameterizedType)object).getActualTypeArguments();
                    FieldInfo.getArgument(object, type.getTypeParameters(), typeArray);
                    typeArray = object;
                }
                type = type.getSuperclass();
            }
        }
        if (typeArray != null && clazz != null) {
            type = null;
            object = clazz.getTypeParameters();
            for (int i = 0; i < ((TypeVariable<Class<T>>[])object).length; ++i) {
                if (!typeVariable.equals(object[i])) continue;
                type = typeArray[i];
                break;
            }
            return type;
        }
        return null;
    }

    protected char[] genFieldNameChars() {
        int n = this.name.length();
        char[] cArray = new char[n + 3];
        char[] cArray2 = cArray;
        String string = this.name;
        string.getChars(0, string.length(), cArray2, 1);
        cArray2[0] = 34;
        cArray2[n + 1] = 34;
        cArray[n + 2] = 58;
        return cArray;
    }

    public <T extends Annotation> T getAnnation(Class<T> clazz) {
        if (clazz == JSONField.class) {
            return (T)((FieldInfo)this).getAnnotation();
        }
        T t = null;
        Method method = ((FieldInfo)this).method;
        if (method != null) {
            t = TypeUtils.getAnnotation(method, clazz);
        }
        if (t == null && (this = ((FieldInfo)this).field) != null) {
            t = TypeUtils.getAnnotation((Field)this, clazz);
        }
        return t;
    }

    public String toString() {
        return this.name;
    }

    public Member getMember() {
        Method method = this.method;
        if (method != null) {
            return method;
        }
        return this.field;
    }

    protected Class<?> getDeclaredClass() {
        Method method = ((FieldInfo)((Object)field)).method;
        if (method != null) {
            return method.getDeclaringClass();
        }
        Field field = ((FieldInfo)((Object)field)).field;
        if (field != null) {
            return field.getDeclaringClass();
        }
        return null;
    }

    @Override
    public int compareTo(FieldInfo fieldInfo) {
        Method method = fieldInfo.method;
        if (method != null && this.method != null && method.isBridge() && !this.method.isBridge() && fieldInfo.method.getName().equals(this.method.getName())) {
            return 1;
        }
        int n = this.ordinal;
        int n2 = fieldInfo.ordinal;
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        n = this.name.compareTo(fieldInfo.name);
        if (n != 0) {
            return n;
        }
        AnnotatedElement annotatedElement = this.getDeclaredClass();
        AnnotatedElement annotatedElement2 = fieldInfo.getDeclaredClass();
        if (annotatedElement != null && annotatedElement2 != null && annotatedElement != annotatedElement2) {
            if (((Class)annotatedElement).isAssignableFrom((Class<?>)annotatedElement2)) {
                return -1;
            }
            if (((Class)annotatedElement2).isAssignableFrom((Class<?>)annotatedElement)) {
                return 1;
            }
        }
        boolean bl = (annotatedElement = this.field) != null && ((Field)annotatedElement).getType() == this.fieldClass;
        annotatedElement2 = fieldInfo.field;
        boolean bl2 = annotatedElement2 != null && ((Field)annotatedElement2).getType() == fieldInfo.fieldClass;
        if (bl && !bl2) {
            return 1;
        }
        if (bl2 && !bl) {
            return -1;
        }
        if (fieldInfo.fieldClass.isPrimitive() && !this.fieldClass.isPrimitive()) {
            return 1;
        }
        if (this.fieldClass.isPrimitive() && !fieldInfo.fieldClass.isPrimitive()) {
            return -1;
        }
        if (fieldInfo.fieldClass.getName().startsWith("java.") && !this.fieldClass.getName().startsWith("java.")) {
            return 1;
        }
        if (this.fieldClass.getName().startsWith("java.") && !fieldInfo.fieldClass.getName().startsWith("java.")) {
            return -1;
        }
        return this.fieldClass.getName().compareTo(fieldInfo.fieldClass.getName());
    }

    public JSONField getAnnotation() {
        JSONField jSONField = this.fieldAnnotation;
        if (jSONField != null) {
            return jSONField;
        }
        return this.methodAnnotation;
    }

    public String getFormat() {
        return this.format;
    }

    public Object get(Object object) {
        Method method = this.method;
        return method != null ? method.invoke(object, new Object[0]) : this.field.get(object);
    }

    public void set(Object object, Object object2) {
        Method method = objectArray2.method;
        if (method != null) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object2;
            method.invoke(object, objectArray2);
            return;
        }
        objectArray2.field.set(object, object2);
    }

    public void setAccessible() {
        Method method = this.method;
        if (method != null) {
            TypeUtils.setAccessible(method);
            return;
        }
        TypeUtils.setAccessible(this.field);
    }
}

