/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import com.tradplus.ads.common.serialization.JSONException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Properties;

public class IOUtils {
    public static final String FASTJSON_PROPERTIES = "fastjson.properties";
    public static final String FASTJSON_COMPATIBLEWITHJAVABEAN = "fastjson.compatibleWithJavaBean";
    public static final String FASTJSON_COMPATIBLEWITHFIELDNAME = "fastjson.compatibleWithFieldName";
    public static final Properties DEFAULT_PROPERTIES;
    public static final Charset UTF8;
    public static final char[] DIGITS;
    public static final boolean[] firstIdentifierFlags;
    public static final boolean[] identifierFlags;
    public static final byte[] specicalFlags_doubleQuotes;
    public static final byte[] specicalFlags_singleQuotes;
    public static final boolean[] specicalFlags_doubleQuotesFlags;
    public static final boolean[] specicalFlags_singleQuotesFlags;
    public static final char[] replaceChars;
    public static final char[] ASCII_CHARS;
    static final char[] digits;
    static final char[] DigitTens;
    static final char[] DigitOnes;
    static final int[] sizeTable;
    public static final char[] CA;
    public static final int[] IA;

    public static String getStringProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {}
        if (string2 == null) {
            string2 = DEFAULT_PROPERTIES.getProperty(string);
        }
        return string2;
    }

    public static void loadPropertiesFromFile() {
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
                }
                return ClassLoader.getSystemResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
            }
        });
        if (inputStream != null) {
            try {
                DEFAULT_PROPERTIES.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        }
    }

    public static int stringSize(long l) {
        long l2 = 10L;
        for (int i = 1; i < 19; ++i) {
            if (l < l2) {
                return i;
            }
            l2 *= 10L;
        }
        return 19;
    }

    public static void getChars(long l, int n, char[] cArray) {
        int n2;
        int n3 = 0;
        if (l < 0L) {
            n3 = 45;
            l = -l;
        }
        while (l > Integer.MAX_VALUE) {
            long l2 = l;
            l = l2 / 100L;
            int n4 = (int)(l2 - ((l << 6) + (l << 5) + (l << 2)));
            cArray[n += -1] = DigitOnes[n4];
            cArray[n += -1] = DigitTens[n4];
        }
        int n5 = (int)l;
        while (n5 >= 65536) {
            int n6 = n5;
            n5 = n6 / 100;
            n2 = n6 - ((n5 << 6) + (n5 << 5) + (n5 << 2));
            cArray[n += -1] = DigitOnes[n2];
            cArray[n += -1] = DigitTens[n2];
        }
        while (true) {
            n2 = n5 * 52429 >>> 19;
            cArray[n += -1] = digits[n5 -= (n2 << 3) + (n2 << 1)];
            if (n2 == 0) {
                if (n3 != 0) {
                    cArray[n + -1] = n3;
                }
                return;
            }
            n5 = n2;
        }
    }

    public static void getChars(int n, int n2, char[] cArray) {
        int n3;
        int n4 = 0;
        if (n < 0) {
            n4 = 45;
            n = -n;
        }
        while (n >= 65536) {
            int n5 = n;
            n = n5 / 100;
            n3 = n5 - ((n << 6) + (n << 5) + (n << 2));
            cArray[n2 += -1] = DigitOnes[n3];
            cArray[n2 += -1] = DigitTens[n3];
        }
        while (true) {
            n3 = n * 52429 >>> 19;
            cArray[n2 += -1] = digits[n -= (n3 << 3) + (n3 << 1)];
            if (n3 == 0) {
                if (n4 != 0) {
                    cArray[n2 + -1] = n4;
                }
                return;
            }
            n = n3;
        }
    }

    public static void getChars(byte by, int n, char[] cArray) {
        int n2 = 0;
        if (by < 0) {
            n2 = 45;
            by = -by;
        }
        while (true) {
            int n3 = by * 52429 >>> 19;
            by = (byte)(by - ((n3 << 3) + (n3 << 1)));
            cArray[n += -1] = digits[by];
            if (n3 == 0) {
                if (n2 != 0) {
                    cArray[n + -1] = n2;
                }
                return;
            }
            by = (byte)n3;
        }
    }

    public static int stringSize(int n) {
        int n2 = 0;
        while (n > sizeTable[n2]) {
            ++n2;
        }
        return n2 + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dd(CharsetDecoder object, ByteBuffer object2, CharBuffer charBuffer) {
        try {
            object2 = ((CharsetDecoder)object).decode((ByteBuffer)object2, charBuffer, true);
            if (!((CoderResult)object2).isUnderflow()) {
                ((CoderResult)object2).throwException();
            }
            if (!((CoderResult)(object = ((CharsetDecoder)object).flush(charBuffer))).isUnderflow()) {
                ((CoderResult)object).throwException();
            }
            return;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new JSONException("utf8 decode error, " + characterCodingException.getMessage(), characterCodingException);
        }
    }

    public static boolean firstIdentifier(char c) {
        boolean[] blArray = firstIdentifierFlags;
        return c < firstIdentifierFlags.length && blArray[c];
    }

    public static boolean isIdent(char c) {
        boolean[] blArray = identifierFlags;
        return c < identifierFlags.length && blArray[c];
    }

    public static byte[] ddb(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = n + n2 - 1;
        while (n < n3 && IA[cArray[n]] < 0) {
            ++n;
        }
        while (n3 > 0 && IA[cArray[n3]] < 0) {
            --n3;
        }
        int n4 = cArray[n3] == '=' ? (cArray[n3 - 1] == '=' ? 2 : 1) : 0;
        int n5 = n2;
        n2 = n3 - n + 1;
        int n6 = n5 > 76 ? (cArray[76] == '\r' ? n2 / 78 : 0) << 1 : 0;
        n2 = ((n2 - n6) * 6 >> 3) - n4;
        byte[] byArray = new byte[n2];
        int n7 = 0;
        int n8 = 0;
        int n9 = n2 / 3 * 3;
        while (n7 < n9) {
            int n10;
            int[] nArray = IA;
            int n11 = IA[cArray[n++]] << 18 | nArray[cArray[n++]] << 12 | nArray[cArray[n++]] << 6 | nArray[cArray[n++]];
            int n12 = n10 = n11;
            byArray[n7++] = (byte)(n10 >> 16);
            n10 = n7 + 1;
            byArray[n7] = (byte)(n12 >> 8);
            n7 = n10 + 1;
            byArray[n10] = (byte)n11;
            if (n6 <= 0 || ++n8 != 19) continue;
            n += 2;
            n8 = 0;
        }
        if (n7 < n2) {
            n6 = 0;
            n8 = 0;
            while (n <= n3 - n4) {
                n6 |= IA[cArray[n++]] << 18 - n8 * 6;
                ++n8;
            }
            int n13 = 16;
            while (n7 < n2) {
                byArray[n7++] = (byte)(n6 >> n13);
                n13 -= 8;
            }
        }
        return byArray;
    }

    public static byte[] ddb(String string, int n, int n2) {
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = n + n2 - 1;
        while (n < n3 && IA[string.charAt(n)] < 0) {
            ++n;
        }
        while (n3 > 0 && IA[string.charAt(n3)] < 0) {
            --n3;
        }
        int n4 = string.charAt(n3) == '=' ? (string.charAt(n3 - 1) == '=' ? 2 : 1) : 0;
        int n5 = n2;
        n2 = n3 - n + 1;
        int n6 = n5 > 76 ? (string.charAt(76) == '\r' ? n2 / 78 : 0) << 1 : 0;
        n2 = ((n2 - n6) * 6 >> 3) - n4;
        byte[] byArray = new byte[n2];
        int n7 = 0;
        int n8 = 0;
        int n9 = n2 / 3 * 3;
        while (n7 < n9) {
            int n10;
            int[] nArray = IA;
            int n11 = IA[string.charAt(n++)] << 18 | nArray[string.charAt(n++)] << 12 | nArray[string.charAt(n++)] << 6 | nArray[string.charAt(n++)];
            int n12 = n10 = n11;
            byArray[n7++] = (byte)(n10 >> 16);
            n10 = n7 + 1;
            byArray[n7] = (byte)(n12 >> 8);
            n7 = n10 + 1;
            byArray[n10] = (byte)n11;
            if (n6 <= 0 || ++n8 != 19) continue;
            n += 2;
            n8 = 0;
        }
        if (n7 < n2) {
            n6 = 0;
            n8 = 0;
            while (n <= n3 - n4) {
                n6 |= IA[string.charAt(n++)] << 18 - n8 * 6;
                ++n8;
            }
            int n13 = 16;
            while (n7 < n2) {
                byArray[n7++] = (byte)(n6 >> n13);
                n13 -= 8;
            }
        }
        return byArray;
    }

    public static byte[] ddb(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = n2 - 1;
        for (n = 0; n < n3 && IA[string.charAt(n) & 0xFF] < 0; ++n) {
        }
        while (n3 > 0 && IA[string.charAt(n3) & 0xFF] < 0) {
            --n3;
        }
        int n4 = string.charAt(n3) == '=' ? (string.charAt(n3 - 1) == '=' ? 2 : 1) : 0;
        int n5 = n2;
        n2 = n3 - n + 1;
        int n6 = n5 > 76 ? (string.charAt(76) == '\r' ? n2 / 78 : 0) << 1 : 0;
        n2 = ((n2 - n6) * 6 >> 3) - n4;
        byte[] byArray = new byte[n2];
        int n7 = 0;
        int n8 = 0;
        int n9 = n2 / 3 * 3;
        while (n7 < n9) {
            int n10;
            int[] nArray = IA;
            int n11 = IA[string.charAt(n++)] << 18 | nArray[string.charAt(n++)] << 12 | nArray[string.charAt(n++)] << 6 | nArray[string.charAt(n++)];
            int n12 = n10 = n11;
            byArray[n7++] = (byte)(n10 >> 16);
            n10 = n7 + 1;
            byArray[n7] = (byte)(n12 >> 8);
            n7 = n10 + 1;
            byArray[n10] = (byte)n11;
            if (n6 <= 0 || ++n8 != 19) continue;
            n += 2;
            n8 = 0;
        }
        if (n7 < n2) {
            n6 = 0;
            n8 = 0;
            while (n <= n3 - n4) {
                n6 |= IA[string.charAt(n++)] << 18 - n8 * 6;
                ++n8;
            }
            int n13 = 16;
            while (n7 < n2) {
                byArray[n7++] = (byte)(n6 >> n13);
                n13 -= 8;
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int edu(char[] cArray, int n, int n2, byte[] byArray) {
        int n3;
        int n4 = n2;
        n2 = n + n2;
        int n5 = 0;
        int n6 = Math.min(n4, byArray.length) + n5;
        while (n5 < n6 && (n3 = cArray[n]) < 128) {
            int n7 = n3;
            n3 = n5 + 1;
            ++n;
            byArray[n5] = (byte)n7;
            n5 = n3;
        }
        while (true) {
            block13: {
                block12: {
                    block14: {
                        if (n >= n2) {
                            return n5;
                        }
                        n6 = n + 1;
                        if ((n = cArray[n]) < 128) {
                            int n8 = n;
                            n = n5 + 1;
                            byArray[n5] = (byte)n8;
                            n5 = n;
                            n = n6;
                            continue;
                        }
                        if (n < 2048) {
                            int n9 = n;
                            int n10 = n;
                            n = n5 + 1;
                            byArray[n5] = (byte)(n10 >> 6 | 0xC0);
                            n5 = n + 1;
                            byArray[n] = (byte)(n9 & 0x3F | 0x80);
                            n = n6;
                            continue;
                        }
                        if (n < 55296 || n >= 57344) break block13;
                        n3 = n6 - 1;
                        if (n < 55296 || n >= 56320) break block14;
                        if (n2 - n3 < 2) {
                            n = -1;
                            break block12;
                        } else if ((n3 = cArray[n3 + 1]) >= 56320 && n3 < 57344) {
                            n = (n << 10) + n3 + -56613888;
                            break block12;
                        } else {
                            n = n5 + 1;
                            byArray[n5] = 63;
                            n5 = n;
                            n = n6;
                            continue;
                        }
                    }
                    if (n >= 56320 && n < 57344) {
                        n = n5 + 1;
                        byArray[n5] = 63;
                        n5 = n;
                        n = n6;
                        continue;
                    }
                }
                if (n < 0) {
                    n = n5 + 1;
                    byArray[n5] = 63;
                } else {
                    int n11 = n;
                    int n12 = n;
                    int n13 = n;
                    int n14 = n;
                    n = n5 + 1;
                    byArray[n5] = (byte)(n14 >> 18 | 0xF0);
                    n5 = n + 1;
                    byArray[n] = (byte)(n13 >> 12 & 0x3F | 0x80);
                    n = n5 + 1;
                    byArray[n5] = (byte)(n12 >> 6 & 0x3F | 0x80);
                    n5 = n + 1;
                    byArray[n] = (byte)(n11 & 0x3F | 0x80);
                    ++n6;
                    n = n5;
                }
                n5 = n;
                n = n6;
                continue;
            }
            int n15 = n;
            int n16 = n;
            int n17 = n;
            n = n5 + 1;
            byArray[n5] = (byte)(n17 >> 12 | 0xE0);
            n5 = n + 1;
            byArray[n] = (byte)(n16 >> 6 & 0x3F | 0x80);
            n = n5 + 1;
            byArray[n5] = (byte)(n15 & 0x3F | 0x80);
            n5 = n;
            n = n6;
        }
    }

    public static int ddu(byte[] byArray, int n, int n2, char[] cArray) {
        int n3;
        int n4 = n2;
        n2 = n + n2;
        int n5 = 0;
        int n6 = Math.min(n4, cArray.length);
        while (n5 < n6 && (n3 = byArray[n]) >= 0) {
            int n7 = n3;
            n3 = n5 + 1;
            ++n;
            cArray[n5] = (char)n7;
            n5 = n3;
        }
        while (n < n2) {
            int n8;
            n6 = n + 1;
            if ((n = byArray[n]) >= 0) {
                int n9 = n;
                n = n5 + 1;
                cArray[n5] = (char)n9;
                n5 = n;
                n = n6;
                continue;
            }
            if (n >> 5 == -2 && (n & 0x1E) != 0) {
                if (n6 < n2) {
                    if (((n3 = byArray[n6++]) & 0xC0) != 128) {
                        return -1;
                    }
                    cArray[n5++] = (char)(n << 6 ^ n3 ^ 0xF80);
                    n = n6;
                    continue;
                }
                return -1;
            }
            if (n >> 4 == -2) {
                n3 = n6 + 1;
                if (n3 < n2) {
                    n6 = byArray[n6];
                    n8 = n3 + 1;
                    n3 = byArray[n3];
                    if ((n != -32 || (n6 & 0xE0) != 128) && (n6 & 0xC0) == 128 && (n3 & 0xC0) == 128) {
                        char c = (char)(n << 12 ^ n6 << 6 ^ (n3 ^ 0xFFFE1F80));
                        n = c;
                        if (c >= '\ud800' && n < 57344) {
                            return -1;
                        }
                        n6 = n5 + 1;
                        cArray[n5] = n;
                        n5 = n6;
                        n = n8;
                        continue;
                    }
                    return -1;
                }
                return -1;
            }
            if (n >> 3 == -2) {
                if (n6 + 2 < n2) {
                    byte by = byArray[n6++];
                    int n10 = n;
                    int n11 = n6;
                    n = n11 + 1;
                    n6 = byArray[n11];
                    n3 = byArray[n++];
                    n8 = n10 << 18 ^ by << 12 ^ n6 << 6 ^ (n3 ^ 0x381F80);
                    if ((by & 0xC0) == 128 && (n6 & 0xC0) == 128 && (n3 & 0xC0) == 128 && n8 >= 65536 && n8 < 0x110000) {
                        cArray[n5++] = (char)((n8 >>> 10) + 55232);
                        n6 = n5 + 1;
                        cArray[n5] = (char)((n8 & 0x3FF) + 56320);
                        n5 = n6;
                        continue;
                    }
                    return -1;
                }
                return -1;
            }
            return -1;
        }
        return n5;
    }

    /*
     * Unable to fully structure code
     */
    public static String readAll(Reader var0) {
        var1_2 = v0;
        v0 = new StringBuilder();
        var2_3 = 2048;
        try {
            var3_4 = new char[2048];
        }
        catch (Exception var0_1) {
            throw new JSONException("read string from reader error", var0_1);
        }
        while (true) lbl-1000:
        // 2 sources

        {
            var4_5 = var0.read(var3_4, 0, var2_3);
            if (var4_5 >= 0) ** break block5
            return var1_2.toString();
            break;
        }
        {
            var1_2.append(var3_4, 0, var4_5);
            ** while (true)
        }
    }

    public static boolean isValidJsonpQueryParam(String string) {
        if (string != null && string.length() != 0) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '.' || IOUtils.isIdent(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        int n;
        Object[] objectArray;
        DEFAULT_PROPERTIES = new Properties();
        UTF8 = Charset.forName("UTF-8");
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        firstIdentifierFlags = new boolean[256];
        identifierFlags = new boolean[256];
        int n2 = 0;
        while (true) {
            objectArray = firstIdentifierFlags;
            if (n2 >= firstIdentifierFlags.length) break;
            if (n2 >= 65 && n2 <= 90) {
                objectArray[n2] = true;
            } else if (n2 >= 97 && n2 <= 122) {
                objectArray[n2] = true;
            } else if (n2 == 95 || n2 == 36) {
                objectArray[n2] = true;
            }
            n2 = (char)(n2 + 1);
        }
        n2 = 0;
        while (true) {
            objectArray = identifierFlags;
            if (n2 >= identifierFlags.length) break;
            if (n2 >= 65 && n2 <= 90) {
                objectArray[n2] = true;
            } else if (n2 >= 97 && n2 <= 122) {
                objectArray[n2] = true;
            } else if (n2 == 95) {
                objectArray[n2] = true;
            } else if (n2 >= 48 && n2 <= 57) {
                objectArray[n2] = true;
            }
            n2 = (char)(n2 + 1);
        }
        try {
            IOUtils.loadPropertiesFromFile();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        byte[] byArray = new byte[161];
        specicalFlags_doubleQuotes = byArray;
        byte[] byArray2 = new byte[161];
        objectArray = byArray2;
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray;
        specicalFlags_singleQuotes = (byte[])objectArray;
        specicalFlags_doubleQuotesFlags = new boolean[161];
        specicalFlags_singleQuotesFlags = new boolean[161];
        replaceChars = new char[93];
        byArray3[0] = 4;
        byArray4[1] = 4;
        byArray3[2] = 4;
        byArray4[3] = 4;
        byArray3[4] = 4;
        byArray4[5] = 4;
        byArray3[6] = 4;
        byArray4[7] = 4;
        byArray3[8] = 1;
        byArray4[9] = 1;
        byArray3[10] = 1;
        byArray4[11] = 4;
        byArray3[12] = 1;
        byArray4[13] = 1;
        byArray3[34] = 1;
        byArray4[92] = 1;
        byArray2[0] = 4;
        byArray2[1] = 4;
        byArray2[2] = 4;
        byArray2[3] = 4;
        byArray2[4] = 4;
        byArray2[5] = 4;
        byArray2[6] = 4;
        byArray2[7] = 4;
        byArray2[8] = 1;
        byArray2[9] = 1;
        byArray2[10] = 1;
        byArray2[11] = 4;
        byArray2[12] = 1;
        byArray2[13] = 1;
        byArray2[92] = 1;
        byArray2[39] = 1;
        for (n = 14; n <= 31; ++n) {
            IOUtils.specicalFlags_doubleQuotes[n] = 4;
            IOUtils.specicalFlags_singleQuotes[n] = 4;
        }
        for (n = 127; n < 160; ++n) {
            IOUtils.specicalFlags_doubleQuotes[n] = 4;
            IOUtils.specicalFlags_singleQuotes[n] = 4;
        }
        for (n = 0; n < 161; ++n) {
            objectArray = specicalFlags_doubleQuotesFlags;
            boolean bl = specicalFlags_doubleQuotes[n] != 0;
            objectArray[n] = bl;
            objectArray = specicalFlags_singleQuotesFlags;
            bl = specicalFlags_singleQuotes[n] != 0;
            objectArray[n] = bl;
        }
        char[] cArray = replaceChars;
        char[] cArray2 = replaceChars;
        cArray[0] = 48;
        cArray2[1] = 49;
        cArray[2] = 50;
        cArray2[3] = 51;
        cArray[4] = 52;
        cArray2[5] = 53;
        cArray[6] = 54;
        cArray2[7] = 55;
        cArray[8] = 98;
        cArray2[9] = 116;
        cArray[10] = 110;
        cArray2[11] = 118;
        cArray[12] = 102;
        cArray2[13] = 114;
        cArray[34] = 34;
        cArray2[39] = 39;
        cArray[47] = 47;
        cArray2[92] = 92;
        char[] cArray3 = new char[96];
        char[] cArray4 = cArray3;
        cArray3[0] = 48;
        cArray4[1] = 48;
        cArray4[2] = 48;
        cArray4[3] = 49;
        cArray4[4] = 48;
        cArray4[5] = 50;
        cArray4[6] = 48;
        cArray4[7] = 51;
        cArray4[8] = 48;
        cArray4[9] = 52;
        cArray4[10] = 48;
        cArray4[11] = 53;
        cArray4[12] = 48;
        cArray4[13] = 54;
        cArray4[14] = 48;
        cArray4[15] = 55;
        cArray4[16] = 48;
        cArray4[17] = 56;
        cArray4[18] = 48;
        cArray4[19] = 57;
        cArray4[20] = 48;
        cArray4[21] = 65;
        cArray4[22] = 48;
        cArray4[23] = 66;
        cArray4[24] = 48;
        cArray4[25] = 67;
        cArray4[26] = 48;
        cArray4[27] = 68;
        cArray4[28] = 48;
        cArray4[29] = 69;
        cArray4[30] = 48;
        cArray4[31] = 70;
        cArray4[32] = 49;
        cArray4[33] = 48;
        cArray4[34] = 49;
        cArray4[35] = 49;
        cArray4[36] = 49;
        cArray4[37] = 50;
        cArray4[38] = 49;
        cArray4[39] = 51;
        cArray4[40] = 49;
        cArray4[41] = 52;
        cArray4[42] = 49;
        cArray4[43] = 53;
        cArray4[44] = 49;
        cArray4[45] = 54;
        cArray4[46] = 49;
        cArray4[47] = 55;
        cArray4[48] = 49;
        cArray4[49] = 56;
        cArray4[50] = 49;
        cArray4[51] = 57;
        cArray4[52] = 49;
        cArray4[53] = 65;
        cArray4[54] = 49;
        cArray4[55] = 66;
        cArray4[56] = 49;
        cArray4[57] = 67;
        cArray4[58] = 49;
        cArray4[59] = 68;
        cArray4[60] = 49;
        cArray4[61] = 69;
        cArray4[62] = 49;
        cArray4[63] = 70;
        cArray4[64] = 50;
        cArray4[65] = 48;
        cArray4[66] = 50;
        cArray4[67] = 49;
        cArray4[68] = 50;
        cArray4[69] = 50;
        cArray4[70] = 50;
        cArray4[71] = 51;
        cArray4[72] = 50;
        cArray4[73] = 52;
        cArray4[74] = 50;
        cArray4[75] = 53;
        cArray4[76] = 50;
        cArray4[77] = 54;
        cArray4[78] = 50;
        cArray4[79] = 55;
        cArray4[80] = 50;
        cArray4[81] = 56;
        cArray4[82] = 50;
        cArray4[83] = 57;
        cArray4[84] = 50;
        cArray4[85] = 65;
        cArray4[86] = 50;
        cArray4[87] = 66;
        cArray4[88] = 50;
        cArray4[89] = 67;
        cArray4[90] = 50;
        cArray4[91] = 68;
        cArray4[92] = 50;
        cArray4[93] = 69;
        cArray4[94] = 50;
        cArray4[95] = 70;
        ASCII_CHARS = cArray4;
        char[] cArray5 = new char[36];
        cArray4 = cArray5;
        cArray5[0] = 48;
        cArray4[1] = 49;
        cArray4[2] = 50;
        cArray4[3] = 51;
        cArray4[4] = 52;
        cArray4[5] = 53;
        cArray4[6] = 54;
        cArray4[7] = 55;
        cArray4[8] = 56;
        cArray4[9] = 57;
        cArray4[10] = 97;
        cArray4[11] = 98;
        cArray4[12] = 99;
        cArray4[13] = 100;
        cArray4[14] = 101;
        cArray4[15] = 102;
        cArray4[16] = 103;
        cArray4[17] = 104;
        cArray4[18] = 105;
        cArray4[19] = 106;
        cArray4[20] = 107;
        cArray4[21] = 108;
        cArray4[22] = 109;
        cArray4[23] = 110;
        cArray4[24] = 111;
        cArray4[25] = 112;
        cArray4[26] = 113;
        cArray4[27] = 114;
        cArray4[28] = 115;
        cArray4[29] = 116;
        cArray4[30] = 117;
        cArray4[31] = 118;
        cArray4[32] = 119;
        cArray4[33] = 120;
        cArray4[34] = 121;
        cArray4[35] = 122;
        digits = cArray4;
        char[] cArray6 = new char[100];
        cArray4 = cArray6;
        cArray6[0] = 48;
        cArray4[1] = 48;
        cArray4[2] = 48;
        cArray4[3] = 48;
        cArray4[4] = 48;
        cArray4[5] = 48;
        cArray4[6] = 48;
        cArray4[7] = 48;
        cArray4[8] = 48;
        cArray4[9] = 48;
        cArray4[10] = 49;
        cArray4[11] = 49;
        cArray4[12] = 49;
        cArray4[13] = 49;
        cArray4[14] = 49;
        cArray4[15] = 49;
        cArray4[16] = 49;
        cArray4[17] = 49;
        cArray4[18] = 49;
        cArray4[19] = 49;
        cArray4[20] = 50;
        cArray4[21] = 50;
        cArray4[22] = 50;
        cArray4[23] = 50;
        cArray4[24] = 50;
        cArray4[25] = 50;
        cArray4[26] = 50;
        cArray4[27] = 50;
        cArray4[28] = 50;
        cArray4[29] = 50;
        cArray4[30] = 51;
        cArray4[31] = 51;
        cArray4[32] = 51;
        cArray4[33] = 51;
        cArray4[34] = 51;
        cArray4[35] = 51;
        cArray4[36] = 51;
        cArray4[37] = 51;
        cArray4[38] = 51;
        cArray4[39] = 51;
        cArray4[40] = 52;
        cArray4[41] = 52;
        cArray4[42] = 52;
        cArray4[43] = 52;
        cArray4[44] = 52;
        cArray4[45] = 52;
        cArray4[46] = 52;
        cArray4[47] = 52;
        cArray4[48] = 52;
        cArray4[49] = 52;
        cArray4[50] = 53;
        cArray4[51] = 53;
        cArray4[52] = 53;
        cArray4[53] = 53;
        cArray4[54] = 53;
        cArray4[55] = 53;
        cArray4[56] = 53;
        cArray4[57] = 53;
        cArray4[58] = 53;
        cArray4[59] = 53;
        cArray4[60] = 54;
        cArray4[61] = 54;
        cArray4[62] = 54;
        cArray4[63] = 54;
        cArray4[64] = 54;
        cArray4[65] = 54;
        cArray4[66] = 54;
        cArray4[67] = 54;
        cArray4[68] = 54;
        cArray4[69] = 54;
        cArray4[70] = 55;
        cArray4[71] = 55;
        cArray4[72] = 55;
        cArray4[73] = 55;
        cArray4[74] = 55;
        cArray4[75] = 55;
        cArray4[76] = 55;
        cArray4[77] = 55;
        cArray4[78] = 55;
        cArray4[79] = 55;
        cArray4[80] = 56;
        cArray4[81] = 56;
        cArray4[82] = 56;
        cArray4[83] = 56;
        cArray4[84] = 56;
        cArray4[85] = 56;
        cArray4[86] = 56;
        cArray4[87] = 56;
        cArray4[88] = 56;
        cArray4[89] = 56;
        cArray4[90] = 57;
        cArray4[91] = 57;
        cArray4[92] = 57;
        cArray4[93] = 57;
        cArray4[94] = 57;
        cArray4[95] = 57;
        cArray4[96] = 57;
        cArray4[97] = 57;
        cArray4[98] = 57;
        cArray4[99] = 57;
        DigitTens = cArray4;
        char[] cArray7 = new char[100];
        cArray4 = cArray7;
        cArray7[0] = 48;
        cArray4[1] = 49;
        cArray4[2] = 50;
        cArray4[3] = 51;
        cArray4[4] = 52;
        cArray4[5] = 53;
        cArray4[6] = 54;
        cArray4[7] = 55;
        cArray4[8] = 56;
        cArray4[9] = 57;
        cArray4[10] = 48;
        cArray4[11] = 49;
        cArray4[12] = 50;
        cArray4[13] = 51;
        cArray4[14] = 52;
        cArray4[15] = 53;
        cArray4[16] = 54;
        cArray4[17] = 55;
        cArray4[18] = 56;
        cArray4[19] = 57;
        cArray4[20] = 48;
        cArray4[21] = 49;
        cArray4[22] = 50;
        cArray4[23] = 51;
        cArray4[24] = 52;
        cArray4[25] = 53;
        cArray4[26] = 54;
        cArray4[27] = 55;
        cArray4[28] = 56;
        cArray4[29] = 57;
        cArray4[30] = 48;
        cArray4[31] = 49;
        cArray4[32] = 50;
        cArray4[33] = 51;
        cArray4[34] = 52;
        cArray4[35] = 53;
        cArray4[36] = 54;
        cArray4[37] = 55;
        cArray4[38] = 56;
        cArray4[39] = 57;
        cArray4[40] = 48;
        cArray4[41] = 49;
        cArray4[42] = 50;
        cArray4[43] = 51;
        cArray4[44] = 52;
        cArray4[45] = 53;
        cArray4[46] = 54;
        cArray4[47] = 55;
        cArray4[48] = 56;
        cArray4[49] = 57;
        cArray4[50] = 48;
        cArray4[51] = 49;
        cArray4[52] = 50;
        cArray4[53] = 51;
        cArray4[54] = 52;
        cArray4[55] = 53;
        cArray4[56] = 54;
        cArray4[57] = 55;
        cArray4[58] = 56;
        cArray4[59] = 57;
        cArray4[60] = 48;
        cArray4[61] = 49;
        cArray4[62] = 50;
        cArray4[63] = 51;
        cArray4[64] = 52;
        cArray4[65] = 53;
        cArray4[66] = 54;
        cArray4[67] = 55;
        cArray4[68] = 56;
        cArray4[69] = 57;
        cArray4[70] = 48;
        cArray4[71] = 49;
        cArray4[72] = 50;
        cArray4[73] = 51;
        cArray4[74] = 52;
        cArray4[75] = 53;
        cArray4[76] = 54;
        cArray4[77] = 55;
        cArray4[78] = 56;
        cArray4[79] = 57;
        cArray4[80] = 48;
        cArray4[81] = 49;
        cArray4[82] = 50;
        cArray4[83] = 51;
        cArray4[84] = 52;
        cArray4[85] = 53;
        cArray4[86] = 54;
        cArray4[87] = 55;
        cArray4[88] = 56;
        cArray4[89] = 57;
        cArray4[90] = 48;
        cArray4[91] = 49;
        cArray4[92] = 50;
        cArray4[93] = 51;
        cArray4[94] = 52;
        cArray4[95] = 53;
        cArray4[96] = 54;
        cArray4[97] = 55;
        cArray4[98] = 56;
        cArray4[99] = 57;
        DigitOnes = cArray4;
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int n3 = CA.length;
        for (int i = 0; i < n3; ++i) {
            IOUtils.IA[IOUtils.CA[i]] = i;
        }
        IOUtils.IA[61] = 0;
    }
}

