/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import java.util.Arrays;

public class IdentityHashMap<K, V> {
    public static final int DEFAULT_SIZE = 8192;
    private final Entry<K, V>[] buckets;
    private final int indexMask;

    public IdentityHashMap() {
        this(8192);
    }

    public IdentityHashMap(int n) {
        this.indexMask = n - 1;
        this.buckets = new Entry[n];
    }

    public final V get(K k) {
        int n = System.identityHashCode(k) & this.indexMask;
        Entry<K, V> entry = this.buckets[n];
        while (entry != null) {
            if (k == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Class findClass(String string) {
        int n = 0;
        while (true) {
            Object object = this.buckets;
            if (n >= this.buckets.length) break;
            if ((object = object[n]) != null) {
                Object object2 = object;
                while (object2 != null) {
                    Object object3 = object.key;
                    if (object3 instanceof Class && ((Class)(object3 = (Class)object3)).getName().equals(string)) {
                        return object3;
                    }
                    object2 = object2.next;
                }
            }
            ++n;
        }
        return null;
    }

    public boolean put(K k, V v) {
        Entry entry;
        int n = System.identityHashCode(k);
        int n2 = n & ((IdentityHashMap)((Object)entry3)).indexMask;
        Entry entry2 = ((IdentityHashMap)((Object)entry3)).buckets[n2];
        while (entry2 != null) {
            if (k == entry2.key) {
                entry2.value = v;
                return true;
            }
            entry2 = entry2.next;
        }
        IdentityHashMap identityHashMap = entry3;
        entry2 = entry;
        Entry<K, V> entry3 = ((IdentityHashMap)((Object)entry3)).buckets[n2];
        entry = new Entry(k, v, n, entry3);
        identityHashMap.buckets[n2] = entry2;
        return false;
    }

    public void clear() {
        Arrays.fill(this.buckets, null);
    }

    public int size() {
        int n = 0;
        Entry<K, V>[] entryArray = this.buckets;
        int n2 = this.buckets.length;
        for (int i = 0; i < n2; ++i) {
            Entry<K, V> entry = entryArray[i];
            while (entry != null) {
                ++n;
                entry = entry.next;
            }
        }
        return n;
    }

    protected static final class Entry<K, V> {
        public final int hashCode;
        public final K key;
        public V value;
        public final Entry<K, V> next;

        public Entry(K k, V v, int n, Entry<K, V> entry) {
            this.key = k;
            this.value = v;
            this.next = entry;
            this.hashCode = n;
        }
    }
}

