/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONArray;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONObject;
import com.tradplus.ads.common.serialization.JSONPObject;
import com.tradplus.ads.common.serialization.PropertyNamingStrategy;
import com.tradplus.ads.common.serialization.annotation.JSONField;
import com.tradplus.ads.common.serialization.annotation.JSONType;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.ParserConfig;
import com.tradplus.ads.common.serialization.parser.deserializer.EnumDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.JavaBeanDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.CalendarCodec;
import com.tradplus.ads.common.serialization.serializer.SerializeBeanInfo;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.FieldInfo;
import com.tradplus.ads.common.serialization.util.GenericArrayTypeImpl;
import com.tradplus.ads.common.serialization.util.IOUtils;
import com.tradplus.ads.common.serialization.util.IdentityHashMap;
import com.tradplus.ads.common.serialization.util.ParameterizedTypeImpl;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeUtils {
    private static final Pattern NUMBER_WITH_TRAILING_ZEROS_PATTERN = Pattern.compile("\\.0*$");
    public static boolean compatibleWithJavaBean = false;
    public static boolean compatibleWithFieldName = false;
    private static boolean setAccessibleEnable = true;
    private static boolean oracleTimestampMethodInited = false;
    private static Method oracleTimestampMethod;
    private static boolean oracleDateMethodInited;
    private static Method oracleDateMethod;
    private static boolean optionalClassInited;
    private static Class<?> optionalClass;
    private static boolean transientClassInited;
    private static Class<? extends Annotation> transientClass;
    private static Class<? extends Annotation> class_OneToMany;
    private static boolean class_OneToMany_error;
    private static Class<? extends Annotation> class_ManyToMany;
    private static boolean class_ManyToMany_error;
    private static Method method_HibernateIsInitialized;
    private static boolean method_HibernateIsInitialized_error;
    private static volatile Class kotlin_metadata;
    private static volatile boolean kotlin_metadata_error;
    private static volatile boolean kotlin_class_klass_error;
    private static volatile Constructor kotlin_kclass_constructor;
    private static volatile Method kotlin_kclass_getConstructors;
    private static volatile Method kotlin_kfunction_getParameters;
    private static volatile Method kotlin_kparameter_getName;
    private static volatile boolean kotlin_error;
    private static volatile Map<Class, String[]> kotlinIgnores;
    private static volatile boolean kotlinIgnores_error;
    private static ConcurrentMap<String, Class<?>> mappings;
    private static Class<?> pathClass;
    private static boolean pathClass_error;
    private static Class<? extends Annotation> class_JacksonCreator;
    private static boolean class_JacksonCreator_error;
    private static volatile Class class_Clob;
    private static volatile boolean class_Clob_error;
    private static volatile Class class_XmlAccessType;
    private static volatile Class class_XmlAccessorType;
    private static volatile boolean classXmlAccessorType_error;
    private static volatile Method method_XmlAccessorType_value;
    private static volatile Field field_XmlAccessType_FIELD;
    private static volatile Object field_XmlAccessType_FIELD_VALUE;
    private static Class class_deque;

    public static boolean isXmlField(Class clazz) {
        if (class_XmlAccessorType == null && !classXmlAccessorType_error) {
            try {
                class_XmlAccessorType = Class.forName("javax.xml.bind.annotation.XmlAccessorType");
            }
            catch (Throwable throwable) {
                classXmlAccessorType_error = true;
            }
        }
        if (class_XmlAccessorType == null) {
            return false;
        }
        if ((clazz = TypeUtils.getAnnotation(clazz, class_XmlAccessorType)) == null) {
            return false;
        }
        if (method_XmlAccessorType_value == null && !classXmlAccessorType_error) {
            try {
                method_XmlAccessorType_value = class_XmlAccessorType.getMethod("value", new Class[0]);
            }
            catch (Throwable throwable) {
                classXmlAccessorType_error = true;
            }
        }
        if (method_XmlAccessorType_value == null) {
            return false;
        }
        Object object = null;
        if (!classXmlAccessorType_error) {
            try {
                object = method_XmlAccessorType_value.invoke((Object)clazz, new Object[0]);
            }
            catch (Throwable throwable) {
                classXmlAccessorType_error = true;
            }
        }
        if (object == null) {
            return false;
        }
        if (class_XmlAccessType == null && !classXmlAccessorType_error) {
            try {
                class_XmlAccessType = Class.forName("javax.xml.bind.annotation.XmlAccessType");
                field_XmlAccessType_FIELD = class_XmlAccessType.getField("FIELD");
                field_XmlAccessType_FIELD_VALUE = field_XmlAccessType_FIELD.get(null);
            }
            catch (Throwable throwable) {
                classXmlAccessorType_error = true;
            }
        }
        return object == field_XmlAccessType_FIELD_VALUE;
    }

    public static Annotation getXmlAccessorType(Class clazz) {
        if (class_XmlAccessorType == null && !classXmlAccessorType_error) {
            try {
                class_XmlAccessorType = Class.forName("javax.xml.bind.annotation.XmlAccessorType");
            }
            catch (Throwable throwable) {
                classXmlAccessorType_error = true;
            }
        }
        if (class_XmlAccessorType == null) {
            return null;
        }
        return TypeUtils.getAnnotation(clazz, class_XmlAccessorType);
    }

    public static boolean isClob(Class clazz) {
        if (class_Clob == null && !class_Clob_error) {
            try {
                class_Clob = Clob.class;
            }
            catch (Throwable throwable) {
                class_Clob_error = true;
            }
        }
        if (class_Clob == null) {
            return false;
        }
        return class_Clob.isAssignableFrom(clazz);
    }

    public static String castToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static Byte castToByte(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return TypeUtils.byteValue((BigDecimal)object);
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            if (((String)(object = (String)object)).length() != 0 && !"null".equals(object) && !"NULL".equals(object)) {
                return Byte.parseByte((String)object);
            }
            return null;
        }
        if (object instanceof Boolean) {
            return (byte)(((Boolean)object).booleanValue() ? 1 : 0);
        }
        throw new JSONException("can not cast to byte, value : " + object);
    }

    public static Character castToChar(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            if (string.length() == 1) {
                return Character.valueOf(string.charAt(0));
            }
            throw new JSONException("can not cast to char, value : " + object);
        }
        throw new JSONException("can not cast to char, value : " + object);
    }

    public static Short castToShort(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return TypeUtils.shortValue((BigDecimal)object);
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        if (object instanceof String) {
            if (((String)(object = (String)object)).length() != 0 && !"null".equals(object) && !"NULL".equals(object)) {
                return Short.parseShort((String)object);
            }
            return null;
        }
        if (object instanceof Boolean) {
            return (short)(((Boolean)object).booleanValue() ? 1 : 0);
        }
        throw new JSONException("can not cast to short, value : " + object);
    }

    public static BigDecimal castToBigDecimal(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            if (Float.isNaN(f.floatValue()) || Float.isInfinite(f.floatValue())) {
                return null;
            }
        } else if (object instanceof Double) {
            Double d = (Double)object;
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                return null;
            }
        } else {
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
            if (object instanceof BigInteger) {
                return new BigDecimal((BigInteger)object);
            }
            if (object instanceof Map && ((Map)object).size() == 0) {
                return null;
            }
        }
        if (((String)(object = object.toString())).length() != 0 && !((String)object).equalsIgnoreCase("null")) {
            if (((String)object).length() <= 65535) {
                return new BigDecimal((String)object);
            }
            throw new JSONException("decimal overflow");
        }
        return null;
    }

    public static BigInteger castToBigInteger(Object object) {
        BigDecimal bigDecimal;
        int n;
        if (object == null) {
            return null;
        }
        if (object instanceof Float) {
            if (!Float.isNaN(((Float)(object = (Float)object)).floatValue()) && !Float.isInfinite(((Float)object).floatValue())) {
                return BigInteger.valueOf(((Float)object).longValue());
            }
            return null;
        }
        if (object instanceof Double) {
            if (!Double.isNaN((Double)(object = (Double)object)) && !Double.isInfinite((Double)object)) {
                return BigInteger.valueOf(((Double)object).longValue());
            }
            return null;
        }
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (object instanceof BigDecimal && (n = (bigDecimal = (BigDecimal)object).scale()) > -1000 && n < 1000) {
            return bigDecimal.toBigInteger();
        }
        if (((String)(object = object.toString())).length() != 0 && !((String)object).equalsIgnoreCase("null")) {
            if (((String)object).length() <= 65535) {
                return new BigInteger((String)object);
            }
            throw new JSONException("decimal overflow");
        }
        return null;
    }

    public static Float castToFloat(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        if (object instanceof String) {
            if (((String)(object = object.toString())).length() != 0 && !"null".equals(object) && !"NULL".equals(object)) {
                if (((String)object).indexOf(44) != -1) {
                    object = ((String)object).replaceAll(",", "");
                }
                return Float.valueOf(Float.parseFloat((String)object));
            }
            return null;
        }
        if (object instanceof Boolean) {
            return Float.valueOf((Boolean)object != false ? 1.0f : 0.0f);
        }
        throw new JSONException("can not cast to float, value : " + object);
    }

    public static Double castToDouble(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            if (((String)(object = object.toString())).length() != 0 && !"null".equals(object) && !"NULL".equals(object)) {
                if (((String)object).indexOf(44) != -1) {
                    object = ((String)object).replaceAll(",", "");
                }
                return Double.parseDouble((String)object);
            }
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        throw new JSONException("can not cast to double, value : " + object);
    }

    public static Date castToDate(Object object) {
        return TypeUtils.castToDate(object, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date castToDate(Object object, String clazz) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        long l = -1L;
        if (object instanceof BigDecimal) {
            long l2 = TypeUtils.longValue((BigDecimal)object);
            return new Date(l2);
        }
        if (object instanceof Number) {
            l = ((Number)object).longValue();
            if (!"unixtime".equals(clazz)) return new Date(l);
            l *= 1000L;
            return new Date(l);
        }
        if (object instanceof String) {
            JSONScanner jSONScanner;
            String string;
            block31: {
                JSONScanner jSONScanner2;
                string = (String)object;
                jSONScanner = jSONScanner2;
                try {
                    if (!new JSONScanner(string).scanISO8601DateIfMatch(false)) break block31;
                    Date date = jSONScanner.getCalendar().getTime();
                    jSONScanner.close();
                    return date;
                }
                catch (Throwable throwable) {
                    jSONScanner.close();
                    throw throwable;
                }
            }
            jSONScanner.close();
            if (string.startsWith("/Date(") && string.endsWith(")/")) {
                String string2 = string;
                string = string2.substring(6, string2.length() - 2);
            }
            if (string.indexOf(45) <= 0 && string.indexOf(43) <= 0 && clazz == null) {
                if (string.length() == 0) {
                    return null;
                }
                l = Long.parseLong(string);
            } else {
                if (clazz == null) {
                    clazz = !(string.length() == JSON.DEFFAULT_DATE_FORMAT.length() || string.length() == 22 && JSON.DEFFAULT_DATE_FORMAT.equals("yyyyMMddHHmmssSSSZ")) ? (string.length() == 10 ? "yyyy-MM-dd" : (string.length() == 19 ? "yyyy-MM-dd HH:mm:ss" : (string.length() == 29 && string.charAt(26) == ':' && string.charAt(28) == '0' ? "yyyy-MM-dd'T'HH:mm:ss.SSSXXX" : (string.length() == 23 && string.charAt(19) == ',' ? "yyyy-MM-dd HH:mm:ss,SSS" : "yyyy-MM-dd HH:mm:ss.SSS")))) : JSON.DEFFAULT_DATE_FORMAT;
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)((Object)clazz), JSON.defaultLocale);
                simpleDateFormat.setTimeZone(JSON.defaultTimeZone);
                try {
                    return simpleDateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    throw new JSONException("can not cast to Date, value : " + string);
                }
            }
        }
        if (l != -1L) {
            return new Date(l);
        }
        clazz = object.getClass();
        if ("oracle.sql.TIMESTAMP".equals(clazz.getName())) {
            if (oracleTimestampMethod == null && !oracleTimestampMethodInited) {
                try {
                    oracleTimestampMethod = clazz.getMethod("toJdbc", new Class[0]);
                }
                catch (Throwable throwable) {
                    oracleTimestampMethodInited = true;
                    throw throwable;
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                oracleTimestampMethodInited = true;
            }
            try {
                return (Date)oracleTimestampMethod.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                throw new JSONException("can not cast oracle.sql.TIMESTAMP to Date", exception);
            }
        }
        if (!"oracle.sql.DATE".equals(clazz.getName())) {
            throw new JSONException("can not cast to Date, value : " + object);
        }
        if (oracleDateMethod == null && !oracleDateMethodInited) {
            try {
                oracleDateMethod = clazz.getMethod("toJdbc", new Class[0]);
            }
            catch (Throwable throwable) {
                oracleDateMethodInited = true;
                throw throwable;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            oracleDateMethodInited = true;
        }
        try {
            return (Date)oracleDateMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new JSONException("can not cast oracle.sql.DATE to Date", exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static java.sql.Date castToSqlDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof java.sql.Date) {
            return (java.sql.Date)object;
        }
        if (object instanceof Date) {
            return new java.sql.Date(((Date)object).getTime());
        }
        if (object instanceof Calendar) {
            return new java.sql.Date(((Calendar)object).getTimeInMillis());
        }
        long l = 0L;
        if (object instanceof BigDecimal) {
            l = TypeUtils.longValue((BigDecimal)object);
        } else if (object instanceof Number) {
            l = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) return null;
            if (TypeUtils.isNumber(string)) {
                l = Long.parseLong(string);
            } else {
                JSONScanner jSONScanner;
                JSONScanner jSONScanner2 = jSONScanner;
                if (!new JSONScanner(string).scanISO8601DateIfMatch(false)) throw new JSONException("can not cast to Timestamp, value : " + string);
                l = jSONScanner2.getCalendar().getTime().getTime();
            }
        }
        if (l <= 0L) throw new JSONException("can not cast to Date, value : " + object);
        return new java.sql.Date(l);
    }

    public static long longExtractValue(Number number) {
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).longValueExact();
        }
        return number.longValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Time castToSqlTime(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof Date) {
            return new Time(((Date)object).getTime());
        }
        if (object instanceof Calendar) {
            return new Time(((Calendar)object).getTimeInMillis());
        }
        long l = 0L;
        if (object instanceof BigDecimal) {
            l = TypeUtils.longValue((BigDecimal)object);
        } else if (object instanceof Number) {
            l = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equalsIgnoreCase(string)) return null;
            if (TypeUtils.isNumber(string)) {
                l = Long.parseLong(string);
            } else {
                JSONScanner jSONScanner;
                JSONScanner jSONScanner2 = jSONScanner;
                if (!new JSONScanner(string).scanISO8601DateIfMatch(false)) throw new JSONException("can not cast to Timestamp, value : " + string);
                l = jSONScanner2.getCalendar().getTime().getTime();
            }
        }
        if (l <= 0L) throw new JSONException("can not cast to Date, value : " + object);
        return new Time(l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Timestamp castToTimestamp(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return new Timestamp(((Calendar)object).getTimeInMillis());
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        long l = 0L;
        if (object instanceof BigDecimal) {
            l = TypeUtils.longValue((BigDecimal)object);
        } else if (object instanceof Number) {
            l = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) return null;
            if (string.endsWith(".000000000")) {
                String string2 = string;
                string = string2.substring(0, string2.length() - 10);
            } else if (string.endsWith(".000000")) {
                String string3 = string;
                string = string3.substring(0, string3.length() - 7);
            }
            if (string.length() == 29 && string.charAt(4) == '-' && string.charAt(7) == '-' && string.charAt(10) == ' ' && string.charAt(13) == ':' && string.charAt(16) == ':' && string.charAt(19) == '.') {
                int n = TypeUtils.num(string.charAt(0), string.charAt(1), string.charAt(2), string.charAt(3));
                int n2 = TypeUtils.num(string.charAt(5), string.charAt(6));
                int n3 = TypeUtils.num(string.charAt(8), string.charAt(9));
                int n4 = TypeUtils.num(string.charAt(11), string.charAt(12));
                int n5 = TypeUtils.num(string.charAt(14), string.charAt(15));
                int n6 = TypeUtils.num(string.charAt(17), string.charAt(18));
                int n7 = TypeUtils.num(string.charAt(20), string.charAt(21), string.charAt(22), string.charAt(23), string.charAt(24), string.charAt(25), string.charAt(26), string.charAt(27), string.charAt(28));
                return new Timestamp(n -= 1900, n2 - 1, n3, n4, n5, n6, n7);
            }
            if (TypeUtils.isNumber(string)) {
                l = Long.parseLong(string);
            } else {
                JSONScanner jSONScanner;
                JSONScanner jSONScanner2 = jSONScanner;
                if (!new JSONScanner(string).scanISO8601DateIfMatch(false)) throw new JSONException("can not cast to Timestamp, value : " + string);
                l = jSONScanner2.getCalendar().getTime().getTime();
            }
        }
        if (l < 0L) throw new JSONException("can not cast to Timestamp, value : " + object);
        return new Timestamp(l);
    }

    static int num(char c, char c2) {
        if (c >= '0' && c <= '9' && c2 >= '0' && c2 <= '9') {
            return (c - 48) * 10 + (c2 - 48);
        }
        return -1;
    }

    static int num(char c, char c2, char c3, char c4) {
        if (c >= '0' && c <= '9' && c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9' && c4 >= '0' && c4 <= '9') {
            return (c - 48) * 1000 + (c2 - 48) * 100 + (c3 - 48) * 10 + (c4 - 48);
        }
        return -1;
    }

    static int num(char c, char c2, char c3, char c4, char c5, char c6, char c7, char c8, char c9) {
        if (c >= '0' && c <= '9' && c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9' && c4 >= '0' && c4 <= '9' && c5 >= '0' && c5 <= '9' && c6 >= '0' && c6 <= '9' && c7 >= '0' && c7 <= '9' && c8 >= '0' && c8 <= '9' && c9 >= '0' && c9 <= '9') {
            return (c - 48) * 100000000 + (c2 - 48) * 10000000 + (c3 - 48) * 1000000 + (c4 - 48) * 100000 + (c5 - 48) * 10000 + (c6 - 48) * 1000 + (c7 - 48) * 100 + (c8 - 48) * 10 + (c9 - 48);
        }
        return -1;
    }

    public static boolean isNumber(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c != '+' && c != '-' ? c < '0' || c > '9' : i != 0)) continue;
            return false;
        }
        return true;
    }

    public static Long castToLong(Object object) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return TypeUtils.longValue((BigDecimal)object);
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            object2 = (String)object;
            if (((String)object2).length() != 0 && !"null".equals(object2) && !"NULL".equals(object2)) {
                if (((String)object2).indexOf(44) != -1) {
                    object2 = ((String)object2).replaceAll(",", "");
                }
                try {
                    return Long.parseLong((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    JSONScanner jSONScanner;
                    JSONScanner jSONScanner2 = jSONScanner;
                    jSONScanner = new JSONScanner((String)object2);
                    object2 = null;
                    if (jSONScanner.scanISO8601DateIfMatch(false)) {
                        object2 = jSONScanner2.getCalendar();
                    }
                    jSONScanner2.close();
                    if (object2 != null) {
                        return ((Calendar)object2).getTimeInMillis();
                    }
                }
            } else {
                return null;
            }
        }
        if (object instanceof Map && (object2 = (Map)object).size() == 2 && object2.containsKey("andIncrement") && object2.containsKey("andDecrement")) {
            Iterator iterator = object2.values().iterator();
            iterator.next();
            return TypeUtils.castToLong(iterator.next());
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        throw new JSONException("can not cast to long, value : " + object);
    }

    public static byte byteValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        int n = bigDecimal.scale();
        if (n >= -100 && n <= 100) {
            return bigDecimal.byteValue();
        }
        return bigDecimal.byteValueExact();
    }

    public static short shortValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        int n = bigDecimal.scale();
        if (n >= -100 && n <= 100) {
            return bigDecimal.shortValue();
        }
        return bigDecimal.shortValueExact();
    }

    public static int intValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        int n = bigDecimal.scale();
        if (n >= -100 && n <= 100) {
            return bigDecimal.intValue();
        }
        return bigDecimal.intValueExact();
    }

    public static long longValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0L;
        }
        int n = bigDecimal.scale();
        if (n >= -100 && n <= 100) {
            return bigDecimal.longValue();
        }
        return bigDecimal.longValueExact();
    }

    public static Integer castToInt(Object object) {
        Map map;
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof BigDecimal) {
            return TypeUtils.intValue((BigDecimal)object);
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            if (((String)(object = (String)object)).length() != 0 && !"null".equals(object) && !"NULL".equals(object)) {
                Matcher matcher;
                if (((String)object).indexOf(44) != -1) {
                    object = ((String)object).replaceAll(",", "");
                }
                if ((matcher = NUMBER_WITH_TRAILING_ZEROS_PATTERN.matcher((CharSequence)object)).find()) {
                    object = matcher.replaceAll("");
                }
                return Integer.parseInt((String)object);
            }
            return null;
        }
        if (object instanceof Boolean) {
            return ((Boolean)object).booleanValue() ? 1 : 0;
        }
        if (object instanceof Map && (map = (Map)object).size() == 2 && map.containsKey("andIncrement") && map.containsKey("andDecrement")) {
            Iterator iterator = map.values().iterator();
            iterator.next();
            return TypeUtils.castToInt(iterator.next());
        }
        throw new JSONException("can not cast to int, value : " + object);
    }

    public static byte[] castToBytes(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return IOUtils.ddb((String)object);
        }
        throw new JSONException("can not cast to byte[], value : " + object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Boolean castToBoolean(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof BigDecimal) {
            return TypeUtils.intValue((BigDecimal)object) == 1;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() == 1;
        }
        if (!(object instanceof String)) throw new JSONException("can not cast to boolean, value : " + object);
        String string = (String)object;
        if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) return null;
        if ("true".equalsIgnoreCase(string) || "1".equals(string)) return Boolean.TRUE;
        if ("false".equalsIgnoreCase(string) || "0".equals(string)) return Boolean.FALSE;
        if ("Y".equalsIgnoreCase(string) || "T".equals(string)) return Boolean.TRUE;
        if (!"F".equalsIgnoreCase(string) && !"N".equals(string)) throw new JSONException("can not cast to boolean, value : " + object);
        return Boolean.FALSE;
    }

    public static <T> T castToJavaBean(Object object, Class<T> clazz) {
        return TypeUtils.cast(object, clazz, ParserConfig.getGlobalInstance());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T cast(Object object, Class<T> serializable, ParserConfig parserConfig) {
        if (object == null) {
            if (serializable == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (serializable == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (serializable == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (serializable == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (serializable == Float.TYPE) {
                return (T)Float.valueOf(0.0f);
            }
            if (serializable == Double.TYPE) {
                return (T)Double.valueOf(0.0);
            }
            if (serializable != Boolean.TYPE) return null;
            return (T)Boolean.FALSE;
        }
        if (serializable == null) throw new IllegalArgumentException("clazz is null");
        if (serializable == object.getClass()) {
            return (T)object;
        }
        if (object instanceof Map) {
            if (serializable == Map.class) {
                return (T)object;
            }
            Map map = (Map)object;
            if (serializable != Object.class) return TypeUtils.castToJavaBean(map, serializable, parserConfig);
            if (map.containsKey(JSON.DEFAULT_TYPE_KEY)) return TypeUtils.castToJavaBean(map, serializable, parserConfig);
            return (T)object;
        }
        if (((Class)serializable).isArray()) {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                int n = 0;
                Object object2 = Array.newInstance(((Class)serializable).getComponentType(), collection.size());
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Array.set(object2, n, TypeUtils.cast(iterator.next(), ((Class)serializable).getComponentType(), parserConfig));
                    ++n;
                }
                return (T)object2;
            }
            if (serializable == byte[].class) {
                return (T)TypeUtils.castToBytes(object);
            }
        }
        if (((Class)serializable).isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        if (serializable == Boolean.TYPE) return (T)TypeUtils.castToBoolean(object);
        if (serializable == Boolean.class) {
            return (T)TypeUtils.castToBoolean(object);
        }
        if (serializable == Byte.TYPE) return (T)TypeUtils.castToByte(object);
        if (serializable == Byte.class) {
            return (T)TypeUtils.castToByte(object);
        }
        if (serializable == Character.TYPE) return (T)TypeUtils.castToChar(object);
        if (serializable == Character.class) {
            return (T)TypeUtils.castToChar(object);
        }
        if (serializable == Short.TYPE) return (T)TypeUtils.castToShort(object);
        if (serializable == Short.class) {
            return (T)TypeUtils.castToShort(object);
        }
        if (serializable == Integer.TYPE) return (T)TypeUtils.castToInt(object);
        if (serializable == Integer.class) {
            return (T)TypeUtils.castToInt(object);
        }
        if (serializable == Long.TYPE) return (T)TypeUtils.castToLong(object);
        if (serializable == Long.class) {
            return (T)TypeUtils.castToLong(object);
        }
        if (serializable == Float.TYPE) return (T)TypeUtils.castToFloat(object);
        if (serializable == Float.class) {
            return (T)TypeUtils.castToFloat(object);
        }
        if (serializable == Double.TYPE) return (T)TypeUtils.castToDouble(object);
        if (serializable == Double.class) {
            return (T)TypeUtils.castToDouble(object);
        }
        if (serializable == String.class) {
            return (T)TypeUtils.castToString(object);
        }
        if (serializable == BigDecimal.class) {
            return (T)TypeUtils.castToBigDecimal(object);
        }
        if (serializable == BigInteger.class) {
            return (T)TypeUtils.castToBigInteger(object);
        }
        if (serializable == Date.class) {
            return (T)TypeUtils.castToDate(object);
        }
        if (serializable == java.sql.Date.class) {
            return (T)TypeUtils.castToSqlDate(object);
        }
        if (serializable == Time.class) {
            return (T)TypeUtils.castToSqlTime(object);
        }
        if (serializable == Timestamp.class) {
            return (T)TypeUtils.castToTimestamp(object);
        }
        if (((Class)serializable).isEnum()) {
            return TypeUtils.castToEnum(object, serializable, parserConfig);
        }
        if (Calendar.class.isAssignableFrom((Class<?>)serializable)) {
            object = TypeUtils.castToDate(object);
            if (serializable == Calendar.class) {
                serializable = Calendar.getInstance(JSON.defaultTimeZone, JSON.defaultLocale);
            } else {
                try {
                    serializable = (Calendar)((Class)serializable).newInstance();
                }
                catch (Exception exception) {
                    throw new JSONException("can not cast to : " + ((Class)serializable).getName(), exception);
                }
            }
            Serializable serializable2 = serializable;
            ((Calendar)serializable2).setTime((Date)object);
            return (T)serializable2;
        }
        String string = ((Class)serializable).getName();
        if (string.equals("javax.xml.datatype.XMLGregorianCalendar")) {
            object = TypeUtils.castToDate(object);
            serializable = Calendar.getInstance(JSON.defaultTimeZone, JSON.defaultLocale);
            ((Calendar)serializable).setTime((Date)object);
            return (T)CalendarCodec.instance.createXMLGregorianCalendar((Calendar)serializable);
        }
        if (object instanceof String) {
            String string2 = (String)object;
            if (string2.length() == 0) return null;
            if ("null".equals(string2)) return null;
            if ("NULL".equals(string2)) {
                return null;
            }
            if (serializable == Currency.class) {
                return (T)Currency.getInstance(string2);
            }
            if (serializable == Locale.class) {
                return (T)TypeUtils.toLocale(string2);
            }
            if (string.startsWith("java.time.")) {
                return JSON.parseObject(JSON.toJSONString(string2), serializable);
            }
        }
        if (parserConfig.get((Type)((Object)serializable)) == null) throw new JSONException("can not cast to : " + ((Class)serializable).getName());
        return JSON.parseObject(JSON.toJSONString(object), serializable);
    }

    public static Locale toLocale(String object) {
        if (((String[])(object = object.split("_"))).length == 1) {
            return new Locale(object[0]);
        }
        if (((String[])object).length == 2) {
            object = object[0];
            return new Locale((String)object, object[1]);
        }
        object = object[0];
        String string = object[1];
        String string2 = object[2];
        return new Locale((String)object, string, string2);
    }

    /*
     * Unable to fully structure code
     */
    public static <T> T castToEnum(Object var0, Class<T> var1_3, ParserConfig var2_4) {
        block18: {
            block17: {
                try {
                    if (!(var0 instanceof String)) ** GOTO lbl21
                }
                catch (Exception var0_2) {
                    throw new JSONException("can not cast to : " + var1_3.getName(), var0_2);
                }
                var0 = (String)var0;
                if (var0.length() != 0) break block17;
                return null;
            }
            if (var2_4 /* !! */  == null) {
                var2_4 /* !! */  = ParserConfig.getGlobalInstance();
            }
            var2_4 /* !! */  = var2_4 /* !! */ .getDeserializer(var1_3);
            if (!(var2_4 /* !! */  instanceof EnumDeserializer)) ** GOTO lbl20
            return (T)((EnumDeserializer)var2_4 /* !! */ ).getEnumByHashCode(TypeUtils.fnv1a_64((String)var0));
lbl20:
            // 1 sources

            return Enum.valueOf(var1_3, (String)var0);
lbl21:
            // 1 sources

            if (!(var0 instanceof BigDecimal)) ** GOTO lbl30
            var2_5 = TypeUtils.intValue((BigDecimal)var0);
            var3_6 = var1_3.getEnumConstants();
            if (var2_5 >= var3_6.length) ** GOTO lbl30
            return var3_6[var2_5];
lbl30:
            // 2 sources

            if (!(var0 instanceof Number)) break block18;
            var0_1 = ((Number)var0).intValue();
            var2_4 /* !! */  = var1_3.getEnumConstants();
            if (var0_1 >= var2_4 /* !! */ .length) break block18;
            return var2_4 /* !! */ [var0_1];
        }
        throw new JSONException("can not cast to : " + var1_3.getName());
    }

    public static <T> T cast(Object object, Type type, ParserConfig object2) {
        if (object == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtils.cast(object, (Class)type, (ParserConfig)object2);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.cast(object, (ParameterizedType)type, (ParserConfig)object2);
        }
        if (object instanceof String && (((String)(object2 = (String)object)).length() == 0 || "null".equals(object2) || "NULL".equals(object2))) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return (T)object;
        }
        throw new JSONException("can not cast to : " + type);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T cast(Object entry, ParameterizedType iterator, ParserConfig parserConfig) {
        Object object;
        Type[] typeArray;
        Type object22 = iterator.getRawType();
        if (object22 == List.class || object22 == ArrayList.class) {
            typeArray = iterator.getActualTypeArguments()[0];
            if (entry instanceof List) {
                void var3_5;
                ArrayList arrayList;
                entry = (List)((Object)entry);
                iterator = arrayList;
                arrayList = new ArrayList(entry.size());
                boolean i = false;
                while (var3_5 < entry.size()) {
                    Object object2 = entry.get((int)var3_5);
                    object2 = typeArray instanceof Class ? (object2 != null && object2.getClass() == JSONObject.class ? ((JSONObject)object2).toJavaObject((Class)typeArray, parserConfig, 0) : TypeUtils.cast(object2, (Class)typeArray, parserConfig)) : TypeUtils.cast(object2, (Type)typeArray, parserConfig);
                    iterator.add(object2);
                    ++var3_5;
                }
                return (T)iterator;
            }
        }
        if (object22 == Set.class || object22 == HashSet.class || object22 == TreeSet.class || object22 == Collection.class || object22 == List.class || object22 == ArrayList.class) {
            typeArray = iterator.getActualTypeArguments()[0];
            if (entry instanceof Iterable) {
                if (object22 != Set.class && object22 != HashSet.class) {
                    if (object22 == TreeSet.class) {
                        TreeSet treeSet;
                        iterator = treeSet;
                        treeSet = new TreeSet();
                    } else {
                        ArrayList arrayList;
                        iterator = arrayList;
                        arrayList = new ArrayList();
                    }
                } else {
                    HashSet hashSet;
                    iterator = hashSet;
                    hashSet = new HashSet();
                }
                for (Object t : (Iterable)((Object)entry)) {
                    void var3_11;
                    if (typeArray instanceof Class) {
                        if (t != null && t.getClass() == JSONObject.class) {
                            Object t2 = ((JSONObject)t).toJavaObject((Class)typeArray, parserConfig, 0);
                        } else {
                            T t3 = TypeUtils.cast(t, (Class)typeArray, parserConfig);
                        }
                    } else {
                        T t4 = TypeUtils.cast(t, (Type)typeArray, parserConfig);
                    }
                    iterator.add(var3_11);
                }
                return (T)iterator;
            }
        }
        if (object22 == Map.class || object22 == HashMap.class) {
            Iterator iterator2 = iterator;
            typeArray = iterator2.getActualTypeArguments()[0];
            object = iterator2.getActualTypeArguments()[1];
            if (entry instanceof Map) {
                HashMap hashMap;
                Iterator iterator3 = entry;
                entry = hashMap;
                hashMap = new HashMap();
                for (Map.Entry entry2 : ((Map)((Object)iterator3)).entrySet()) {
                    entry.put(TypeUtils.cast(entry2.getKey(), (Type)typeArray, parserConfig), TypeUtils.cast(entry2.getValue(), (Type)object, parserConfig));
                }
                return (T)entry;
            }
        }
        if (entry instanceof String && ((String)((Object)entry)).length() == 0) {
            return null;
        }
        typeArray = iterator.getActualTypeArguments();
        if (typeArray.length == 1 && iterator.getActualTypeArguments()[0] instanceof WildcardType) {
            return TypeUtils.cast((Object)entry, object22, parserConfig);
        }
        if (object22 == Map.Entry.class && entry instanceof Map && (object = (Map)((Object)entry)).size() == 1) {
            entry = object.entrySet().iterator().next();
            iterator = entry.getValue();
            if (typeArray.length == 2 && iterator instanceof Map) {
                entry.setValue(TypeUtils.cast(iterator, typeArray[1], parserConfig));
            }
            return (T)entry;
        }
        if (object22 instanceof Class) {
            ObjectDeserializer objectDeserializer;
            if (parserConfig == null) {
                parserConfig = ParserConfig.global;
            }
            if ((objectDeserializer = parserConfig.getDeserializer(object22)) != null) {
                entry = JSON.toJSONString(entry);
                return objectDeserializer.deserialze(new DefaultJSONParser((String)((Object)entry), parserConfig), (Type)((Object)iterator), null);
            }
        }
        throw new JSONException("can not cast to : " + iterator);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static <T> T castToJavaBean(Map<String, Object> var0, Class<T> var1_3, ParserConfig var2_4) {
        block59: {
            block58: {
                block57: {
                    block56: {
                        block55: {
                            block54: {
                                block53: {
                                    block52: {
                                        block51: {
                                            block50: {
                                                block49: {
                                                    if (var1_3 != StackTraceElement.class) ** GOTO lbl27
                                                    var1_3 = (String)var0.get("className");
                                                    var2_4 = (String)var0.get("methodName");
                                                    var3_5 = (String)var0.get("fileName");
                                                    var0 = (Number)var0.get("lineNumber");
                                                    if (var0 != null) break block49;
                                                    var0_1 = 0;
                                                    ** GOTO lbl26
                                                }
                                                if (!(var0 instanceof BigDecimal)) break block50;
                                                v0 = ((BigDecimal)var0).intValueExact();
lbl19:
                                                // 2 sources

                                                while (true) {
                                                    var0_1 = v0;
                                                    ** GOTO lbl26
                                                    break;
                                                }
                                            }
                                            v0 = var0.intValue();
                                            ** continue;
lbl26:
                                            // 2 sources

                                            return (T)new StackTraceElement((String)var1_3, (String)var2_4, var3_5, var0_1);
lbl27:
                                            // 1 sources

                                            var3_6 = var0.get(JSON.DEFAULT_TYPE_KEY);
                                            try {
                                                if (!(var3_6 instanceof String)) ** GOTO lbl50
                                            }
                                            catch (Exception var0_2) {
                                                throw new JSONException(var0_2.getMessage(), var0_2);
                                            }
                                            var3_6 = (String)var3_6;
                                            if (var2_4 != null) break block51;
                                            var2_4 = ParserConfig.global;
                                        }
                                        var4_7 = var2_4.checkAutoType((String)var3_6, null);
                                        if (var4_7 == null) ** GOTO lbl45
                                        if (var4_7.equals(var1_3)) ** GOTO lbl50
                                        return (T)TypeUtils.castToJavaBean((Map<String, Object>)var0, var4_7, (ParserConfig)var2_4);
lbl45:
                                        // 1 sources

                                        v1 = v2;
                                        v3 = v2;
                                        v1((String)var3_6 + " not found");
                                        throw v3;
lbl50:
                                        // 2 sources

                                        if (!var1_3.isInterface()) ** GOTO lbl70
                                        if (!(var0 instanceof JSONObject)) break block52;
                                        var0 = (JSONObject)var0;
                                        break block53;
                                    }
                                    var3_6 = v4;
                                    v4 = new JSONObject((Map<String, Object>)var0);
                                    var0 = var3_6;
                                }
                                if (var2_4 == null) {
                                    var2_4 = ParserConfig.getGlobalInstance();
                                }
                                if (var2_4.get((Type)var1_3) == null) ** GOTO lbl69
                                return JSON.parseObject(JSON.toJSONString(var0), var1_3);
lbl69:
                                // 1 sources

                                return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{var1_3}, (InvocationHandler)var0);
lbl70:
                                // 1 sources

                                if (var1_3 != Locale.class) ** GOTO lbl90
                                var3_6 = var0.get("language");
                                var4_7 = var0.get("country");
                                if (!(var3_6 instanceof String)) ** GOTO lbl90
                                v5 /* !! */  = var4_7;
                                var3_6 = (String)var3_6;
                                if (!(v5 /* !! */  instanceof String)) break block54;
                                var0 = (String)var4_7;
                                return (T)new Locale((String)var3_6, (String)var0);
                            }
                            if (var4_7 != null) ** GOTO lbl90
                            return (T)new Locale((String)var3_6);
lbl90:
                            // 3 sources

                            if (var1_3 != String.class) ** GOTO lbl95
                            if (!(var0 instanceof JSONObject)) ** GOTO lbl95
                            return (T)var0.toString();
lbl95:
                            // 2 sources

                            if (var1_3 != JSON.class) break block55;
                            if (!(var0 instanceof JSONObject)) break block55;
                            return (T)var0;
                        }
                        if (var1_3 != LinkedHashMap.class) ** GOTO lbl112
                        if (!(var0 instanceof JSONObject)) ** GOTO lbl112
                        var3_6 = ((JSONObject)var0).getInnerMap();
                        if (!(var3_6 instanceof LinkedHashMap)) break block56;
                        return (T)var3_6;
                    }
                    new LinkedHashMap<K, V>().putAll(var3_6);
lbl112:
                    // 3 sources

                    if (!var1_3.isInstance(var0)) break block57;
                    return (T)var0;
                }
                if (var1_3 != JSONObject.class) break block58;
                return (T)new JSONObject((Map<String, Object>)var0);
            }
            if (var2_4 == null) {
                var2_4 = ParserConfig.getGlobalInstance();
            }
            var3_6 = null;
            var4_7 = var2_4.getDeserializer((Type)var1_3);
            if (!(var4_7 instanceof JavaBeanDeserializer)) break block59;
            var3_6 = (JavaBeanDeserializer)var4_7;
        }
        if (var3_6 == null) ** GOTO lbl134
        return (T)var3_6.createInstance((Map<String, Object>)var0, (ParserConfig)var2_4);
lbl134:
        // 1 sources

        throw new JSONException("can not get javaBeanDeserializer. " + var1_3.getName());
    }

    private static void addBaseClassMappings() {
        Class<?> clazz;
        mappings.put("byte", Byte.TYPE);
        mappings.put("short", Short.TYPE);
        mappings.put("int", Integer.TYPE);
        mappings.put("long", Long.TYPE);
        mappings.put("float", Float.TYPE);
        mappings.put("double", Double.TYPE);
        mappings.put("boolean", Boolean.TYPE);
        mappings.put("char", Character.TYPE);
        mappings.put("[byte", byte[].class);
        mappings.put("[short", short[].class);
        mappings.put("[int", int[].class);
        mappings.put("[long", long[].class);
        mappings.put("[float", float[].class);
        mappings.put("[double", double[].class);
        mappings.put("[boolean", boolean[].class);
        mappings.put("[char", char[].class);
        mappings.put("[B", byte[].class);
        mappings.put("[S", short[].class);
        mappings.put("[I", int[].class);
        mappings.put("[J", long[].class);
        mappings.put("[F", float[].class);
        mappings.put("[D", double[].class);
        mappings.put("[C", char[].class);
        mappings.put("[Z", boolean[].class);
        int n = 71;
        Class[] classArray = new Class[71];
        Class[] classArray2 = classArray;
        classArray[0] = Object.class;
        classArray2[1] = Cloneable.class;
        classArray2[2] = clazz = TypeUtils.loadClass("java.lang.AutoCloseable");
        classArray2[3] = Exception.class;
        classArray2[4] = RuntimeException.class;
        classArray2[5] = IllegalAccessError.class;
        classArray2[6] = IllegalAccessException.class;
        classArray2[7] = IllegalArgumentException.class;
        classArray2[8] = IllegalMonitorStateException.class;
        classArray2[9] = IllegalStateException.class;
        classArray2[10] = IllegalThreadStateException.class;
        classArray2[11] = IndexOutOfBoundsException.class;
        classArray2[12] = InstantiationError.class;
        classArray2[13] = InstantiationException.class;
        classArray2[14] = InternalError.class;
        classArray2[15] = InterruptedException.class;
        classArray2[16] = LinkageError.class;
        classArray2[17] = NegativeArraySizeException.class;
        classArray2[18] = NoClassDefFoundError.class;
        classArray2[19] = NoSuchFieldError.class;
        classArray2[20] = NoSuchFieldException.class;
        classArray2[21] = NoSuchMethodError.class;
        classArray2[22] = NoSuchMethodException.class;
        classArray2[23] = NullPointerException.class;
        classArray2[24] = NumberFormatException.class;
        classArray2[25] = OutOfMemoryError.class;
        classArray2[26] = SecurityException.class;
        classArray2[27] = StackOverflowError.class;
        classArray2[28] = StringIndexOutOfBoundsException.class;
        classArray2[29] = TypeNotPresentException.class;
        classArray2[30] = VerifyError.class;
        classArray2[31] = StackTraceElement.class;
        classArray2[32] = HashMap.class;
        classArray2[33] = Hashtable.class;
        classArray2[34] = TreeMap.class;
        classArray2[35] = IdentityHashMap.class;
        classArray2[36] = WeakHashMap.class;
        classArray2[37] = LinkedHashMap.class;
        classArray2[38] = HashSet.class;
        classArray2[39] = LinkedHashSet.class;
        classArray2[40] = TreeSet.class;
        classArray2[41] = ArrayList.class;
        classArray2[42] = TimeUnit.class;
        classArray2[43] = ConcurrentHashMap.class;
        classArray2[44] = AtomicInteger.class;
        classArray2[45] = AtomicLong.class;
        classArray2[46] = clazz = Collections.EMPTY_MAP.getClass();
        classArray2[47] = Boolean.class;
        classArray2[48] = Character.class;
        classArray2[49] = Byte.class;
        classArray2[50] = Short.class;
        classArray2[51] = Integer.class;
        classArray2[52] = Long.class;
        classArray2[53] = Float.class;
        classArray2[54] = Double.class;
        classArray2[55] = Number.class;
        classArray2[56] = String.class;
        classArray2[57] = BigDecimal.class;
        classArray2[58] = BigInteger.class;
        classArray2[59] = BitSet.class;
        classArray2[60] = Calendar.class;
        classArray2[61] = Date.class;
        classArray2[62] = Locale.class;
        classArray2[63] = UUID.class;
        classArray2[64] = Time.class;
        classArray2[65] = java.sql.Date.class;
        classArray2[66] = Timestamp.class;
        classArray2[67] = SimpleDateFormat.class;
        classArray2[68] = JSONObject.class;
        classArray2[69] = JSONPObject.class;
        classArray2[70] = JSONArray.class;
        for (int i = 0; i < n; ++i) {
            Class clazz2 = classArray2[i];
            if (clazz2 == null) continue;
            mappings.put(clazz2.getName(), clazz2);
        }
    }

    public static void clearClassMapping() {
        mappings.clear();
        TypeUtils.addBaseClassMappings();
    }

    public static void addMapping(String string, Class<?> clazz) {
        mappings.put(string, clazz);
    }

    public static Class<?> loadClass(String string) {
        return TypeUtils.loadClass(string, null);
    }

    public static boolean isPath(Class<?> clazz) {
        Class<?> clazz2;
        if (pathClass == null && !pathClass_error) {
            try {
                pathClass = Class.forName("java.nio.file.Path");
            }
            catch (Throwable throwable) {
                pathClass_error = true;
            }
        }
        if ((clazz2 = pathClass) != null) {
            return clazz2.isAssignableFrom(clazz);
        }
        return false;
    }

    public static Class<?> getClassFromMapping(String string) {
        return (Class)mappings.get(string);
    }

    public static Class<?> loadClass(String string, ClassLoader classLoader) {
        return TypeUtils.loadClass(string, classLoader, false);
    }

    public static Class<?> loadClass(String string, ClassLoader object, boolean bl) {
        block19: {
            Class<?> clazz;
            block18: {
                block16: {
                    block17: {
                        ClassLoader classLoader;
                        if (string == null || string.length() == 0 || string.length() > 128) break block19;
                        clazz = (Class<?>)mappings.get(string);
                        if (clazz != null) {
                            return clazz;
                        }
                        if (string.charAt(0) == '[') {
                            return Array.newInstance(TypeUtils.loadClass(string.substring(1), (ClassLoader)object), 0).getClass();
                        }
                        if (string.startsWith("L") && string.endsWith(";")) {
                            String string2 = string;
                            return TypeUtils.loadClass(string2.substring(1, string2.length() - 1), (ClassLoader)object);
                        }
                        if (object != null) {
                            block15: {
                                clazz = ((ClassLoader)object).loadClass(string);
                                if (!bl) break block15;
                                try {
                                    mappings.put(string, clazz);
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                            return clazz;
                        }
                        try {
                            classLoader = Thread.currentThread().getContextClassLoader();
                            if (classLoader == null || classLoader == object) break block16;
                        }
                        catch (Throwable throwable) {}
                        object = classLoader.loadClass(string);
                        if (!bl) break block17;
                        try {
                            mappings.put(string, (Class<?>)object);
                        }
                        catch (Throwable throwable) {
                            clazz = object;
                            break block16;
                        }
                    }
                    return object;
                }
                try {
                    clazz = Class.forName(string);
                    if (!bl) break block18;
                }
                catch (Throwable throwable) {
                    return clazz;
                }
                mappings.put(string, clazz);
            }
            return clazz;
        }
        return null;
    }

    public static SerializeBeanInfo buildBeanInfo(Class<?> clazz, Map<String, String> map, PropertyNamingStrategy propertyNamingStrategy) {
        return TypeUtils.buildBeanInfo(clazz, map, propertyNamingStrategy, false);
    }

    public static SerializeBeanInfo buildBeanInfo(Class<?> clazz, Map<String, String> list, PropertyNamingStrategy objectArray, boolean bl) {
        HashMap<String, Field> hashMap;
        Object object;
        int n;
        JSONType jSONType = TypeUtils.getAnnotation(clazz, JSONType.class);
        String[] stringArray = null;
        String string = null;
        String string2 = null;
        if (jSONType != null) {
            JSONType jSONType2;
            JSONType jSONType3;
            PropertyNamingStrategy propertyNamingStrategy;
            JSONType jSONType4 = jSONType;
            stringArray = jSONType4.orders();
            string = jSONType4.typeName();
            if (string.length() == 0) {
                string = null;
            }
            if ((propertyNamingStrategy = jSONType.naming()) != PropertyNamingStrategy.CamelCase) {
                objectArray = propertyNamingStrategy;
            }
            n = SerializerFeature.of(jSONType.serialzeFeatures());
            for (object = clazz.getSuperclass(); object != null && object != Object.class && (jSONType3 = TypeUtils.getAnnotation(object, JSONType.class)) != null && (string2 = jSONType3.typeKey()).length() == 0; object = object.getSuperclass()) {
            }
            object = clazz.getInterfaces();
            int n2 = ((Class<?>[])object).length;
            for (int i = 0; i < n2 && ((jSONType2 = TypeUtils.getAnnotation(object[i], JSONType.class)) == null || (string2 = jSONType2.typeKey()).length() == 0); ++i) {
            }
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
        } else {
            n = 0;
        }
        object = hashMap;
        hashMap = new HashMap<String, Field>();
        ParserConfig.parserAllFieldToCache(clazz, object);
        List<FieldInfo> list2 = bl ? TypeUtils.computeGettersWithFieldBase(clazz, list, false, (PropertyNamingStrategy)objectArray) : TypeUtils.computeGetters(clazz, jSONType, list, object, false, (PropertyNamingStrategy)objectArray);
        List<FieldInfo> list3 = list2;
        Object[] objectArray2 = new FieldInfo[list3.size()];
        list3.toArray(objectArray2);
        if (stringArray != null && stringArray.length != 0) {
            list = bl ? TypeUtils.computeGettersWithFieldBase(clazz, (Map<String, String>)((Object)list), true, (PropertyNamingStrategy)objectArray) : TypeUtils.computeGetters(clazz, jSONType, list, object, true, (PropertyNamingStrategy)objectArray);
        } else {
            ArrayList<FieldInfo> arrayList;
            list = arrayList;
            Collections.sort(new ArrayList<FieldInfo>(list2));
        }
        objectArray = new FieldInfo[list.size()];
        list.toArray(objectArray);
        if (Arrays.equals(objectArray, objectArray2)) {
            objectArray = objectArray2;
        }
        return new SerializeBeanInfo(clazz, jSONType, string, string2, n, (FieldInfo[])objectArray2, (FieldInfo[])objectArray);
    }

    public static List<FieldInfo> computeGettersWithFieldBase(Class<?> fieldArray, Map<String, String> map, boolean bl, PropertyNamingStrategy propertyNamingStrategy) {
        LinkedHashMap<String, FieldInfo> linkedHashMap;
        LinkedHashMap<String, FieldInfo> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<String, FieldInfo>();
        for (Object object = fieldArray; object != null; object = object.getSuperclass()) {
            object = object.getDeclaredFields();
            TypeUtils.computeFields(object, map, propertyNamingStrategy, linkedHashMap2, object);
        }
        return TypeUtils.getFieldInfos(fieldArray, bl, linkedHashMap2);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> map) {
        return TypeUtils.computeGetters(clazz, map, true);
    }

    public static List<FieldInfo> computeGetters(Class<?> object, Map<String, String> map, boolean bl) {
        HashMap<String, Field> hashMap;
        Class<?> clazz = object;
        object = TypeUtils.getAnnotation(clazz, JSONType.class);
        HashMap<String, Field> hashMap2 = hashMap;
        ParserConfig.parserAllFieldToCache(clazz, new HashMap<String, Field>());
        Object object2 = object;
        object = PropertyNamingStrategy.CamelCase;
        return TypeUtils.computeGetters(clazz, (JSONType)object2, map, hashMap2, bl, (PropertyNamingStrategy)((Object)object));
    }

    public static List<FieldInfo> computeGetters(Class<?> fieldArray, JSONType object, Map<String, String> map, Map<String, Field> map2, boolean bl, PropertyNamingStrategy propertyNamingStrategy) {
        LinkedHashMap linkedHashMap;
        object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        boolean bl2 = TypeUtils.isKotlin(fieldArray);
        Constructor[] constructorArray = null;
        Annotation[][] annotationArray = null;
        Object[] objectArray = null;
        Object object2 = null;
        for (Method method : fieldArray.getMethods()) {
            FieldInfo fieldInfo;
            Object object3;
            Object object4;
            Object object5 = method.getName();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            String string = null;
            if (Modifier.isStatic(method.getModifiers()) || (object4 = method.getReturnType()).equals(Void.TYPE) || method.getParameterTypes().length != 0 || object4 == ClassLoader.class || object4 == InputStream.class || object4 == Reader.class || ((String)object5).equals("getMetaClass") && ((Class)object4).getName().equals("groovy.lang.MetaClass") || ((String)object5).equals("getSuppressed") && method.getDeclaringClass() == Throwable.class || bl2 && TypeUtils.isKotlinIgnore((Class)fieldArray, (String)object5)) continue;
            Object object6 = Boolean.FALSE;
            JSONField jSONField = TypeUtils.getAnnotation(method, JSONField.class);
            if (jSONField == null) {
                jSONField = TypeUtils.getSuperMethodAnnotation(fieldArray, method);
            }
            if (jSONField == null && bl2) {
                int n4;
                if (constructorArray == null && (object3 = TypeUtils.getKotlinConstructor(constructorArray = fieldArray.getDeclaredConstructors())) != null) {
                    annotationArray = TypeUtils.getParameterAnnotations((Constructor)object3);
                    objectArray = TypeUtils.getKoltinConstructorParameters((Class)fieldArray);
                    if (objectArray != null) {
                        object2 = new String[objectArray.length];
                        int n5 = objectArray.length;
                        System.arraycopy(objectArray, 0, object2, 0, n5);
                        Arrays.sort(object2);
                        object3 = new short[objectArray.length];
                        for (n4 = 0; n4 < objectArray.length; n4 = (int)((short)(n4 + 1))) {
                            object3[Arrays.binarySearch((Object[])object2, (Object)objectArray[n4])] = n4;
                        }
                        Object[] objectArray2 = object2;
                        object2 = object3;
                        objectArray = objectArray2;
                    }
                }
                if (objectArray != null && object2 != null && ((String)object5).startsWith("get")) {
                    int n6;
                    object3 = TypeUtils.decapitalize(((String)object5).substring(3));
                    n4 = Arrays.binarySearch(objectArray, object3);
                    if (n4 < 0) {
                        for (n6 = 0; n6 < objectArray.length; ++n6) {
                            if (!((String)object3).equalsIgnoreCase((String)objectArray[n6])) continue;
                            n4 = n6;
                            break;
                        }
                    }
                    if (n4 >= 0) {
                        Annotation[] annotationArray2 = annotationArray[object2[n4]];
                        if (annotationArray2 != null) {
                            n6 = annotationArray2.length;
                            for (int i = 0; i < n6; ++i) {
                                Annotation annotation = annotationArray2[i];
                                if (!(annotation instanceof JSONField)) continue;
                                jSONField = (JSONField)annotation;
                                break;
                            }
                        }
                        if (jSONField == null && (object3 = ParserConfig.getFieldFromCache((String)object3, map2)) != null) {
                            jSONField = TypeUtils.getAnnotation((Field)object3, JSONField.class);
                        }
                    }
                }
            }
            if (jSONField != null) {
                if (!jSONField.serialize()) continue;
                JSONField jSONField2 = jSONField;
                n = jSONField2.ordinal();
                n2 = SerializerFeature.of(jSONField2.serialzeFeatures());
                n3 = Feature.of(jSONField2.parseFeatures());
                if (jSONField2.name().length() != 0) {
                    FieldInfo fieldInfo2;
                    object5 = jSONField.name();
                    if (map != null && (object5 = map.get(object5)) == null) continue;
                    object4 = fieldInfo2;
                    fieldInfo2 = new FieldInfo((String)object5, method, null, (Class<?>)fieldArray, null, n, n2, n3, jSONField, null, string);
                    object.put(object5, object4);
                    continue;
                }
                if (jSONField.label().length() != 0) {
                    string = jSONField.label();
                }
            }
            if (((String)object5).startsWith("get")) {
                FieldInfo fieldInfo3;
                char c;
                if (((String)object5).length() < 4 || ((String)object5).equals("getClass") || ((String)object5).equals("getDeclaringClass") && fieldArray.isEnum()) continue;
                char c2 = ((String)object5).charAt(3);
                Object object7 = null;
                if (!Character.isUpperCase(c2) && c2 <= '\u0200') {
                    if (c2 == '_') {
                        object3 = ((String)object5).substring(3);
                        object7 = map2.get(object3);
                        if (object7 == null) {
                            object7 = ((String)object5).substring(4);
                            Field field = ParserConfig.getFieldFromCache((String)object7, map2);
                            if (field != null) {
                                object3 = object7;
                            }
                            object7 = field;
                        }
                    } else if (c2 == 'f') {
                        object3 = ((String)object5).substring(3);
                    } else if (((String)object5).length() >= 5 && Character.isUpperCase(((String)object5).charAt(4))) {
                        object3 = TypeUtils.decapitalize(((String)object5).substring(3));
                    } else {
                        object3 = ((String)object5).substring(3);
                        object7 = ParserConfig.getFieldFromCache((String)object3, map2);
                        if (object7 == null) {
                            continue;
                        }
                    }
                } else {
                    object3 = compatibleWithJavaBean ? TypeUtils.decapitalize(((String)object5).substring(3)) : TypeUtils.getPropertyNameByMethodName((String)object5);
                    object3 = TypeUtils.getPropertyNameByCompatibleFieldName(map2, (String)object5, (String)object3, 3);
                }
                if (TypeUtils.isJSONTypeIgnore(fieldArray, (String)object3)) continue;
                if (object7 == null) {
                    object7 = ParserConfig.getFieldFromCache((String)object3, map2);
                }
                if (object7 == null && ((String)object3).length() > 1 && (c = ((String)object3).charAt(1)) >= 'A' && c <= 'Z') {
                    object7 = ParserConfig.getFieldFromCache(TypeUtils.decapitalize(((String)object5).substring(3)), map2);
                }
                JSONField jSONField3 = null;
                if (object7 != null && (jSONField3 = TypeUtils.getAnnotation((Field)object7, JSONField.class)) != null) {
                    if (!jSONField3.serialize()) continue;
                    JSONField jSONField4 = jSONField3;
                    n = jSONField4.ordinal();
                    n2 = SerializerFeature.of(jSONField4.serialzeFeatures());
                    n3 = Feature.of(jSONField4.parseFeatures());
                    if (jSONField4.name().length() != 0) {
                        object6 = Boolean.TRUE;
                        object3 = jSONField3.name();
                        if (map != null && (object3 = map.get(object3)) == null) continue;
                    }
                    if (jSONField3.label().length() != 0) {
                        string = jSONField3.label();
                    }
                }
                if (map != null && (object3 = map.get(object3)) == null) continue;
                if (propertyNamingStrategy != null && !((Boolean)object6).booleanValue()) {
                    object3 = propertyNamingStrategy.translate((String)object3);
                }
                object6 = fieldInfo3;
                fieldInfo3 = new FieldInfo((String)object3, method, (Field)object7, (Class<?>)fieldArray, null, n, n2, n3, jSONField, jSONField3, string);
                object.put(object3, object6);
            }
            if (!((String)object5).startsWith("is") || ((String)object5).length() < 3 || object4 != Boolean.TYPE && object4 != Boolean.class) continue;
            char c = ((String)object5).charAt(2);
            object6 = null;
            if (Character.isUpperCase(c)) {
                object4 = compatibleWithJavaBean ? TypeUtils.decapitalize(((String)object5).substring(2)) : Character.toLowerCase(((String)object5).charAt(2)) + ((String)object5).substring(3);
                object4 = TypeUtils.getPropertyNameByCompatibleFieldName(map2, (String)object5, (String)object4, 2);
            } else if (c == '_') {
                object4 = ((String)object5).substring(3);
                object6 = map2.get(object4);
                if (object6 == null) {
                    object6 = ((String)object5).substring(2);
                    object3 = ParserConfig.getFieldFromCache((String)object6, map2);
                    if (object3 != null) {
                        object4 = object6;
                    }
                    object6 = object3;
                }
            } else if (c == 'f') {
                object4 = ((String)object5).substring(2);
            } else {
                object4 = ((String)object5).substring(2);
                object6 = ParserConfig.getFieldFromCache((String)object4, map2);
                if (object6 == null) continue;
            }
            if (TypeUtils.isJSONTypeIgnore(fieldArray, (String)object4)) continue;
            if (object6 == null) {
                object6 = ParserConfig.getFieldFromCache((String)object4, map2);
            }
            if (object6 == null) {
                object6 = ParserConfig.getFieldFromCache((String)object5, map2);
            }
            object5 = null;
            if (object6 != null && (object5 = TypeUtils.getAnnotation((Field)object6, JSONField.class)) != null) {
                if (!object5.serialize()) continue;
                Object object8 = object5;
                n = object8.ordinal();
                n2 = SerializerFeature.of(object8.serialzeFeatures());
                n3 = Feature.of(object8.parseFeatures());
                if (object8.name().length() != 0) {
                    object4 = object5.name();
                    if (map != null && (object4 = map.get(object4)) == null) continue;
                }
                if (object5.label().length() != 0) {
                    string = object5.label();
                }
            }
            if (map != null && (object4 = map.get(object4)) == null) continue;
            if (propertyNamingStrategy != null) {
                object4 = propertyNamingStrategy.translate((String)object4);
            }
            if (object.containsKey(object4)) continue;
            object3 = fieldInfo;
            fieldInfo = new FieldInfo((String)object4, method, (Field)object6, (Class<?>)fieldArray, null, n, n2, n3, jSONField, (JSONField)object5, string);
            object.put(object4, object3);
        }
        Field[] fieldArray2 = fieldArray;
        Field[] fieldArray3 = fieldArray;
        fieldArray = fieldArray.getFields();
        TypeUtils.computeFields(fieldArray3, map, propertyNamingStrategy, (Map<String, FieldInfo>)object, fieldArray);
        return TypeUtils.getFieldInfos(fieldArray2, bl, (Map<String, FieldInfo>)object);
    }

    /*
     * WARNING - void declaration
     */
    private static List<FieldInfo> getFieldInfos(Class<?> serializable, boolean bl, Map<String, FieldInfo> iterator) {
        ArrayList arrayList;
        Serializable serializable2 = serializable;
        serializable = arrayList;
        arrayList = new ArrayList();
        String[] stringArray = null;
        JSONType object3 = TypeUtils.getAnnotation(serializable2, JSONType.class);
        if (object3 != null) {
            stringArray = object3.orders();
        }
        if (stringArray != null && stringArray.length > 0) {
            void var4_10;
            LinkedHashMap<String, FieldInfo> linkedHashMap;
            Object object2 = linkedHashMap;
            linkedHashMap = new LinkedHashMap<String, FieldInfo>(serializable.size());
            for (FieldInfo fieldInfo : iterator.values()) {
                ((AbstractMap)object2).put(fieldInfo.name, fieldInfo);
            }
            int n = stringArray.length;
            boolean bl2 = false;
            while (var4_10 < n) {
                String string = stringArray[var4_10];
                FieldInfo fieldInfo = (FieldInfo)((LinkedHashMap)object2).get(string);
                if (fieldInfo != null) {
                    serializable.add(fieldInfo);
                    ((AbstractMap)object2).remove(string);
                }
                ++var4_10;
            }
            object2 = ((LinkedHashMap)object2).values().iterator();
            while (object2.hasNext()) {
                serializable.add((FieldInfo)object2.next());
            }
        } else {
            iterator = iterator.values().iterator();
            while (iterator.hasNext()) {
                serializable.add(iterator.next());
            }
            if (bl) {
                Collections.sort(serializable);
            }
        }
        return serializable;
    }

    private static void computeFields(Class<?> clazz, Map<String, String> map, PropertyNamingStrategy propertyNamingStrategy, Map<String, FieldInfo> map2, Field[] fieldArray) {
        for (Field field : fieldArray) {
            FieldInfo fieldInfo;
            if (Modifier.isStatic(field.getModifiers())) continue;
            JSONField jSONField = TypeUtils.getAnnotation(field, JSONField.class);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            String string = field.getName();
            String string2 = null;
            if (jSONField != null) {
                if (!jSONField.serialize()) continue;
                JSONField jSONField2 = jSONField;
                n = jSONField2.ordinal();
                n2 = SerializerFeature.of(jSONField2.serialzeFeatures());
                n3 = Feature.of(jSONField2.parseFeatures());
                if (jSONField2.name().length() != 0) {
                    string = jSONField.name();
                }
                if (jSONField.label().length() != 0) {
                    string2 = jSONField.label();
                }
            }
            if (map != null && (string = map.get(string)) == null) continue;
            if (propertyNamingStrategy != null) {
                string = propertyNamingStrategy.translate(string);
            }
            if (map2.containsKey(string)) continue;
            FieldInfo fieldInfo2 = fieldInfo;
            fieldInfo = new FieldInfo(string, null, field, clazz, null, n, n2, n3, null, jSONField, string2);
            map2.put(string, fieldInfo2);
        }
    }

    private static String getPropertyNameByCompatibleFieldName(Map<String, Field> object, String string, String object2, int n) {
        if (compatibleWithFieldName && !object.containsKey(object2)) {
            if (object.containsKey(object = string.substring(n))) {
                object2 = object;
            }
            return object2;
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    public static JSONField getSuperMethodAnnotation(Class<?> classArray, Method method) {
        GenericDeclaration[] genericDeclarationArray = ((Class)classArray).getInterfaces();
        if (genericDeclarationArray.length > 0) {
            void object;
            Class<?>[] classArray2 = method.getParameterTypes();
            int n = genericDeclarationArray.length;
            boolean i = false;
            while (object < n) {
                for (Method method2 : genericDeclarationArray[object].getMethods()) {
                    JSONField jSONField;
                    Class<?>[] classArray3 = method2.getParameterTypes();
                    if (classArray3.length != classArray2.length || !method2.getName().equals(method.getName())) continue;
                    boolean bl = true;
                    for (int j = 0; j < classArray2.length; ++j) {
                        if (classArray3[j].equals(classArray2[j])) continue;
                        bl = false;
                        break;
                    }
                    if (!bl || (jSONField = TypeUtils.getAnnotation(method2, JSONField.class)) == null) continue;
                    return jSONField;
                }
                ++object;
            }
        }
        if ((classArray = ((Class)classArray).getSuperclass()) == null) {
            return null;
        }
        if (Modifier.isAbstract(((Class)classArray).getModifiers())) {
            Object object = classArray;
            classArray = method.getParameterTypes();
            for (GenericDeclaration genericDeclaration : ((Class)object).getMethods()) {
                JSONField jSONField;
                GenericDeclaration[] genericDeclarationArray2 = ((Method)genericDeclaration).getParameterTypes();
                if (genericDeclarationArray2.length != ((Object)classArray).length || !((Method)genericDeclaration).getName().equals(method.getName())) continue;
                int n = 1;
                for (int i = 0; i < ((Object)classArray).length; ++i) {
                    if (genericDeclarationArray2[i].equals(classArray[i])) continue;
                    n = 0;
                    break;
                }
                if (n == 0 || (jSONField = TypeUtils.getAnnotation((Method)genericDeclaration, JSONField.class)) == null) continue;
                return jSONField;
            }
        }
        return null;
    }

    private static boolean isJSONTypeIgnore(Class<?> clazz, String string) {
        String[] stringArray = TypeUtils.getAnnotation(clazz, JSONType.class);
        if (stringArray != null) {
            String[] stringArray2 = stringArray.includes();
            if (stringArray2.length > 0) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!string.equals(stringArray2[i])) continue;
                    return false;
                }
                return true;
            }
            stringArray = stringArray.ignores();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return true;
            }
        }
        if (clazz.getSuperclass() != Object.class && clazz.getSuperclass() != null) {
            return TypeUtils.isJSONTypeIgnore(clazz.getSuperclass(), string);
        }
        return false;
    }

    public static boolean isGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return true;
        }
        if (type instanceof Class) {
            return (type = ((Class)type).getGenericSuperclass()) != Object.class && TypeUtils.isGenericParamType(type);
        }
        return false;
    }

    public static Type getGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return type;
        }
        if (type instanceof Class) {
            return TypeUtils.getGenericParamType(((Class)type).getGenericSuperclass());
        }
        return type;
    }

    public static Type unwrapOptional(Type type) {
        ParameterizedType parameterizedType;
        if (!optionalClassInited) {
            try {
                optionalClass = Class.forName("java.util.Optional");
            }
            catch (Throwable throwable) {
                optionalClassInited = true;
                throw throwable;
            }
            catch (Exception exception) {}
            optionalClassInited = true;
        }
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() == optionalClass) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return type;
    }

    public static Class<?> getClass(Type typeArray) {
        if (typeArray.getClass() == Class.class) {
            return (Class)typeArray;
        }
        if (typeArray instanceof ParameterizedType) {
            return TypeUtils.getClass(((ParameterizedType)typeArray).getRawType());
        }
        if (typeArray instanceof TypeVariable) {
            if ((typeArray = ((TypeVariable)typeArray).getBounds()[0]) instanceof Class) {
                return (Class)typeArray;
            }
            return TypeUtils.getClass((Type)typeArray);
        }
        if (typeArray instanceof WildcardType && (typeArray = ((WildcardType)typeArray).getUpperBounds()).length == 1) {
            return TypeUtils.getClass(typeArray[0]);
        }
        return Object.class;
    }

    public static Field getField(Class<?> clazz, String string, Field[] fieldArray) {
        for (Field field : fieldArray) {
            char c;
            String string2 = field.getName();
            if (string.equals(string2)) {
                return field;
            }
            if (string.length() <= 2 || (c = string.charAt(0)) < 'a' || c > 'z' || (c = string.charAt(1)) < 'A' || c > 'Z' || !string.equalsIgnoreCase(string2)) continue;
            return field;
        }
        if ((clazz = clazz.getSuperclass()) != null && clazz != Object.class) {
            return TypeUtils.getField(clazz, string, clazz.getDeclaredFields());
        }
        return null;
    }

    public static int getSerializeFeatures(Class<?> object) {
        if ((object = TypeUtils.getAnnotation(object, JSONType.class)) == null) {
            return 0;
        }
        return SerializerFeature.of(object.serialzeFeatures());
    }

    public static int getParserFeatures(Class<?> object) {
        if ((object = TypeUtils.getAnnotation(object, JSONType.class)) == null) {
            return 0;
        }
        return Feature.of(object.parseFeatures());
    }

    public static String decapitalize(String object) {
        if (object != null && ((String)object).length() != 0) {
            if (((String)object).length() > 1 && Character.isUpperCase(((String)object).charAt(1)) && Character.isUpperCase(((String)object).charAt(0))) {
                return object;
            }
            char[] cArray = ((String)object).toCharArray();
            object = cArray;
            cArray[0] = Character.toLowerCase(cArray[0]);
            return new String((char[])object);
        }
        return object;
    }

    public static String getPropertyNameByMethodName(String string) {
        return Character.toLowerCase(string.charAt(3)) + string.substring(4);
    }

    static void setAccessible(AccessibleObject accessibleObject) {
        if (!setAccessibleEnable) {
            return;
        }
        if (accessibleObject.isAccessible()) {
            return;
        }
        try {
            accessibleObject.setAccessible(true);
        }
        catch (AccessControlException accessControlException) {
            setAccessibleEnable = false;
        }
    }

    public static Type getCollectionItemType(Type type) {
        if (type instanceof ParameterizedType) {
            return TypeUtils.getCollectionItemType((ParameterizedType)type);
        }
        if (type instanceof Class) {
            return TypeUtils.getCollectionItemType((Class)type);
        }
        return Object.class;
    }

    private static Type getCollectionItemType(Class<?> clazz) {
        return clazz.getName().startsWith("java.") ? Object.class : TypeUtils.getCollectionItemType(TypeUtils.getCollectionSuperType(clazz));
    }

    private static Type getCollectionItemType(ParameterizedType object) {
        Type type = object.getRawType();
        object = object.getActualTypeArguments();
        if (type == Collection.class) {
            return TypeUtils.getWildcardTypeUpperBounds(object[0]);
        }
        Class clazz = type;
        object = TypeUtils.createActualTypeMap(clazz.getTypeParameters(), object);
        type = TypeUtils.getCollectionSuperType(clazz);
        if (type instanceof ParameterizedType) {
            Class<?> clazz2 = type;
            type = TypeUtils.getRawClass(clazz2);
            Type[] typeArray = ((ParameterizedType)((Object)clazz2)).getActualTypeArguments();
            return typeArray.length > 0 ? TypeUtils.getCollectionItemType(TypeUtils.makeParameterizedType(type, typeArray, (Map<TypeVariable, Type>)object)) : TypeUtils.getCollectionItemType(type);
        }
        return TypeUtils.getCollectionItemType(type);
    }

    private static Type getCollectionSuperType(Class<?> clazz) {
        Type type = null;
        for (Type type2 : clazz.getGenericInterfaces()) {
            Class<?> clazz2 = TypeUtils.getRawClass(type2);
            if (clazz2 == Collection.class) {
                return type2;
            }
            if (!Collection.class.isAssignableFrom(clazz2)) continue;
            type = type2;
        }
        if (type == null) {
            type = clazz.getGenericSuperclass();
        }
        return type;
    }

    private static Map<TypeVariable, Type> createActualTypeMap(TypeVariable[] typeVariableArray, Type[] typeArray) {
        HashMap<TypeVariable, Type> hashMap;
        int n = typeVariableArray.length;
        HashMap<TypeVariable, Type> hashMap2 = hashMap;
        hashMap = new HashMap<TypeVariable, Type>(n);
        for (int i = 0; i < n; ++i) {
            TypeVariable typeVariable = typeVariableArray[i];
            hashMap2.put(typeVariable, typeArray[i]);
        }
        return hashMap2;
    }

    private static ParameterizedType makeParameterizedType(Class<?> clazz, Type[] typeArray, Map<TypeVariable, Type> map) {
        int n = typeArray.length;
        Type[] typeArray2 = new Type[n];
        for (int i = 0; i < n; ++i) {
            typeArray2[i] = TypeUtils.getActualType(typeArray[i], map);
        }
        return new ParameterizedTypeImpl(typeArray2, null, clazz);
    }

    private static Type getActualType(Type type, Map<TypeVariable, Type> map) {
        if (type instanceof TypeVariable) {
            return map.get(type);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.makeParameterizedType(TypeUtils.getRawClass(type), ((ParameterizedType)type).getActualTypeArguments(), map);
        }
        if (type instanceof GenericArrayType) {
            return new GenericArrayTypeImpl(TypeUtils.getActualType(((GenericArrayType)type).getGenericComponentType(), map));
        }
        return type;
    }

    private static Type getWildcardTypeUpperBounds(Type typeArray) {
        if (typeArray instanceof WildcardType) {
            return (typeArray = ((WildcardType)typeArray).getUpperBounds()).length > 0 ? typeArray[0] : Object.class;
        }
        return typeArray;
    }

    public static Class<?> getCollectionItemClass(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] typeArray;
            if ((type = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof WildcardType && (typeArray = ((WildcardType)type).getUpperBounds()).length == 1) {
                type = typeArray[0];
            }
            if (type instanceof Class) {
                if (Modifier.isPublic(((Class)(type = (Class)type)).getModifiers())) {
                    return type;
                }
                throw new JSONException("can not create ASMParser");
            }
            throw new JSONException("can not create ASMParser");
        }
        return Object.class;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Type checkPrimitiveArray(GenericArrayType var0) {
        block22: {
            block21: {
                var1_1 = var0.getGenericComponentType();
                var2_2 = "[";
                while (var1_1 instanceof GenericArrayType) {
                    var1_1 = ((GenericArrayType)var1_1).getGenericComponentType();
                    var2_2 = var2_2 + var2_2;
                }
                if (!(var1_1 instanceof Class) || !(var1_1 = (Class)var1_1).isPrimitive()) break block22;
                if (var1_1 != Boolean.TYPE) break block21;
                try {
                    v0 = var2_2 + "Z";
lbl12:
                    // 8 sources

                    while (true) {
                        var0 = Class.forName(v0);
                        break block22;
                        break;
                    }
                }
                catch (ClassNotFoundException v1) {}
            }
            if (var1_1 != Character.TYPE) ** GOTO lbl22
            v0 = var2_2 + "C";
            ** GOTO lbl12
lbl22:
            // 1 sources

            if (var1_1 != Byte.TYPE) ** GOTO lbl26
            v0 = var2_2 + "B";
            ** GOTO lbl12
lbl26:
            // 1 sources

            if (var1_1 != Short.TYPE) ** GOTO lbl30
            v0 = var2_2 + "S";
            ** GOTO lbl12
lbl30:
            // 1 sources

            if (var1_1 != Integer.TYPE) ** GOTO lbl34
            v0 = var2_2 + "I";
            ** GOTO lbl12
lbl34:
            // 1 sources

            if (var1_1 != Long.TYPE) ** GOTO lbl38
            v0 = var2_2 + "J";
            ** GOTO lbl12
lbl38:
            // 1 sources

            if (var1_1 != Float.TYPE) ** GOTO lbl42
            v0 = var2_2 + "F";
            ** GOTO lbl12
lbl42:
            // 1 sources

            if (var1_1 != Double.TYPE) break block22;
            v0 = var2_2 + "D";
            ** continue;
        }
        return var0;
    }

    public static Collection createCollection(Type object) {
        Class<Object> clazz = TypeUtils.getRawClass((Type)object);
        if (clazz != AbstractCollection.class && clazz != Collection.class) {
            if (clazz.isAssignableFrom(HashSet.class)) {
                HashSet hashSet;
                object = hashSet;
                hashSet = new HashSet();
            } else if (clazz.isAssignableFrom(LinkedHashSet.class)) {
                LinkedHashSet linkedHashSet;
                object = linkedHashSet;
                linkedHashSet = new LinkedHashSet();
            } else if (clazz.isAssignableFrom(TreeSet.class)) {
                TreeSet treeSet;
                object = treeSet;
                treeSet = new TreeSet();
            } else if (clazz.isAssignableFrom(ArrayList.class)) {
                ArrayList arrayList;
                object = arrayList;
                arrayList = new ArrayList();
            } else if (clazz.isAssignableFrom(EnumSet.class)) {
                object = EnumSet.noneOf(object instanceof ParameterizedType ? ((ParameterizedType)object).getActualTypeArguments()[0] : Object.class);
            } else if (!(clazz.isAssignableFrom(Queue.class) || (object = class_deque) != null && clazz.isAssignableFrom((Class<?>)object))) {
                try {
                    object = (Collection)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new JSONException("create instance error, class " + clazz.getName());
                }
            } else {
                LinkedList linkedList;
                object = linkedList;
                linkedList = new LinkedList();
            }
        } else {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        }
        return object;
    }

    public static Class<?> getRawClass(Type typeArray) {
        if (typeArray instanceof Class) {
            return (Class)typeArray;
        }
        if (typeArray instanceof ParameterizedType) {
            return TypeUtils.getRawClass(((ParameterizedType)typeArray).getRawType());
        }
        if (typeArray instanceof WildcardType) {
            if ((typeArray = ((WildcardType)typeArray).getUpperBounds()).length == 1) {
                return TypeUtils.getRawClass(typeArray[0]);
            }
            throw new JSONException("TODO");
        }
        throw new JSONException("TODO");
    }

    public static boolean isProxy(Class<?> classArray) {
        classArray = classArray.getInterfaces();
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            String string = classArray[i].getName();
            if (!string.equals("net.sf.cglib.proxy.Factory") && !string.equals("org.springframework.cglib.proxy.Factory")) {
                if (!string.equals("javassist.util.proxy.ProxyObject") && !string.equals("org.apache.ibatis.javassist.util.proxy.ProxyObject")) {
                    if (!string.equals("org.hibernate.proxy.HibernateProxy")) continue;
                    return true;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public static boolean isTransient(Method method) {
        Class<? extends Annotation> clazz;
        if (method == null) {
            return false;
        }
        if (!transientClassInited) {
            try {
                transientClass = Class.forName("java.beans.Transient");
            }
            catch (Throwable throwable) {
                transientClassInited = true;
                throw throwable;
            }
            catch (Exception exception) {}
            transientClassInited = true;
        }
        if ((clazz = transientClass) != null) {
            return TypeUtils.getAnnotation(method, clazz) != null;
        }
        return false;
    }

    public static boolean isAnnotationPresentOneToMany(Method method) {
        Class<? extends Annotation> clazz;
        if (method == null) {
            return false;
        }
        if (class_OneToMany == null && !class_OneToMany_error) {
            try {
                class_OneToMany = Class.forName("javax.persistence.OneToMany");
            }
            catch (Throwable throwable) {
                class_OneToMany_error = true;
            }
        }
        return (clazz = class_OneToMany) != null && method.isAnnotationPresent(clazz);
    }

    public static boolean isAnnotationPresentManyToMany(Method method) {
        if (method == null) {
            return false;
        }
        if (class_ManyToMany == null && !class_ManyToMany_error) {
            try {
                class_ManyToMany = Class.forName("javax.persistence.ManyToMany");
            }
            catch (Throwable throwable) {
                class_ManyToMany_error = true;
            }
        }
        return class_ManyToMany != null && (method.isAnnotationPresent(class_OneToMany) || method.isAnnotationPresent(class_ManyToMany));
    }

    public static boolean isHibernateInitialized(Object object) {
        Method method;
        if (object == null) {
            return false;
        }
        if (method_HibernateIsInitialized == null && !method_HibernateIsInitialized_error) {
            Class<?> clazz = Class.forName("org.hibernate.Hibernate");
            String string = "isInitialized";
            Class[] classArray = new Class[1];
            try {
                classArray[0] = Object.class;
                method_HibernateIsInitialized = clazz.getMethod(string, classArray);
            }
            catch (Throwable throwable) {
                method_HibernateIsInitialized_error = true;
            }
        }
        if ((method = method_HibernateIsInitialized) != null) {
            try {
                return (Boolean)method.invoke(null, object);
            }
            catch (Throwable throwable) {}
        }
        return true;
    }

    public static double parseDouble(String string) {
        int n = string.length();
        if (n > 10) {
            return Double.parseDouble(string);
        }
        boolean bl = false;
        long l = 0L;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '-' && i == 0) {
                bl = true;
                continue;
            }
            if (c == '.') {
                if (n2 != 0) {
                    return Double.parseDouble(string);
                }
                n2 = n - i - 1;
                continue;
            }
            if (c >= '0' && c <= '9') {
                int n3 = c - 48;
                l = l * 10L + (long)n3;
                continue;
            }
            return Double.parseDouble(string);
        }
        if (bl) {
            l = -l;
        }
        switch (n2) {
            default: {
                return Double.parseDouble(string);
            }
            case 9: {
                return (double)l / 1.0E9;
            }
            case 8: {
                return (double)l / 1.0E8;
            }
            case 7: {
                return (double)l / 1.0E7;
            }
            case 6: {
                return (double)l / 1000000.0;
            }
            case 5: {
                return (double)l / 100000.0;
            }
            case 4: {
                return (double)l / 10000.0;
            }
            case 3: {
                return (double)l / 1000.0;
            }
            case 2: {
                return (double)l / 100.0;
            }
            case 1: {
                return (double)l / 10.0;
            }
            case 0: 
        }
        return l;
    }

    public static float parseFloat(String string) {
        int n = string.length();
        if (n >= 10) {
            return Float.parseFloat(string);
        }
        boolean bl = false;
        long l = 0L;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '-' && i == 0) {
                bl = true;
                continue;
            }
            if (c == '.') {
                if (n2 != 0) {
                    return Float.parseFloat(string);
                }
                n2 = n - i - 1;
                continue;
            }
            if (c >= '0' && c <= '9') {
                int n3 = c - 48;
                l = l * 10L + (long)n3;
                continue;
            }
            return Float.parseFloat(string);
        }
        if (bl) {
            l = -l;
        }
        switch (n2) {
            default: {
                return Float.parseFloat(string);
            }
            case 9: {
                return (float)l / 1.0E9f;
            }
            case 8: {
                return (float)l / 1.0E8f;
            }
            case 7: {
                return (float)l / 1.0E7f;
            }
            case 6: {
                return (float)l / 1000000.0f;
            }
            case 5: {
                return (float)l / 100000.0f;
            }
            case 4: {
                return (float)l / 10000.0f;
            }
            case 3: {
                return (float)l / 1000.0f;
            }
            case 2: {
                return (float)l / 100.0f;
            }
            case 1: {
                return (float)l / 10.0f;
            }
            case 0: 
        }
        return l;
    }

    public static long fnv1a_64_extract(String string) {
        long l = -3750763034362895579L;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_' || c == '-') continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            l = (l ^ (long)c) * 1099511628211L;
        }
        return l;
    }

    public static long fnv1a_64_lower(String string) {
        long l = -3750763034362895579L;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            l = (l ^ (long)c) * 1099511628211L;
        }
        return l;
    }

    public static long fnv1a_64(String string) {
        long l = -3750763034362895579L;
        for (int i = 0; i < string.length(); ++i) {
            l = (l ^ (long)string.charAt(i)) * 1099511628211L;
        }
        return l;
    }

    public static boolean isKotlin(Class clazz) {
        if (kotlin_metadata == null && !kotlin_metadata_error) {
            try {
                kotlin_metadata = Class.forName("kotlin.Metadata");
            }
            catch (Throwable throwable) {
                kotlin_metadata_error = true;
            }
        }
        return kotlin_metadata != null && clazz.isAnnotationPresent(kotlin_metadata);
    }

    public static Constructor getKotlinConstructor(Constructor[] constructorArray) {
        return TypeUtils.getKotlinConstructor(constructorArray, null);
    }

    public static Constructor getKotlinConstructor(Constructor[] constructorArray, String[] stringArray) {
        Constructor constructor = null;
        for (Constructor constructor2 : constructorArray) {
            Class<?>[] classArray = constructor2.getParameterTypes();
            if (stringArray != null && classArray.length != stringArray.length || classArray.length > 0 && classArray[classArray.length - 1].getName().equals("kotlin.jvm.internal.DefaultConstructorMarker") || constructor != null && constructor.getParameterTypes().length >= classArray.length) continue;
            constructor = constructor2;
        }
        return constructor;
    }

    public static String[] getKoltinConstructorParameters(Class object) {
        int n;
        if (kotlin_kclass_constructor == null && !kotlin_class_klass_error) {
            Class<?> clazz = Class.forName("kotlin.reflect.jvm.internal.KClassImpl");
            Class[] classArray = new Class[1];
            try {
                classArray[0] = Class.class;
                kotlin_kclass_constructor = clazz.getConstructor(classArray);
            }
            catch (Throwable throwable) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kclass_constructor == null) {
            return null;
        }
        if (kotlin_kclass_getConstructors == null && !kotlin_class_klass_error) {
            try {
                kotlin_kclass_getConstructors = Class.forName("kotlin.reflect.jvm.internal.KClassImpl").getMethod("getConstructors", new Class[0]);
            }
            catch (Throwable throwable) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kfunction_getParameters == null && !kotlin_class_klass_error) {
            try {
                kotlin_kfunction_getParameters = Class.forName("kotlin.reflect.KFunction").getMethod("getParameters", new Class[0]);
            }
            catch (Throwable throwable) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kparameter_getName == null && !kotlin_class_klass_error) {
            try {
                kotlin_kparameter_getName = Class.forName("kotlin.reflect.KParameter").getMethod("getName", new Class[0]);
            }
            catch (Throwable throwable) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_error) {
            return null;
        }
        String[] stringArray = null;
        object = ((Iterable)kotlin_kclass_getConstructors.invoke(kotlin_kclass_constructor.newInstance(object), new Object[0])).iterator();
        while (true) {
            block30: {
                if (!object.hasNext()) break;
                String[] stringArray2 = stringArray;
                Object e = object.next();
                List list = (List)kotlin_kfunction_getParameters.invoke(e, new Object[0]);
                if (stringArray2 != null) {
                    if (list.size() == 0) break block30;
                }
                stringArray = e;
            }
            object.hasNext();
        }
        if (stringArray == null) {
            return null;
        }
        object = (List)kotlin_kfunction_getParameters.invoke(stringArray, new Object[0]);
        try {
            stringArray = new String[object.size()];
            n = 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            kotlin_error = true;
            return null;
        }
        while (true) {
            if (n >= object.size()) break;
            stringArray[n] = (String)kotlin_kparameter_getName.invoke(object.get(n), new Object[0]);
            ++n;
            continue;
            break;
        }
        return stringArray;
    }

    private static boolean isKotlinIgnore(Class objectArray, String string) {
        if (kotlinIgnores == null && !kotlinIgnores_error) {
            HashMap<Class, String[]> hashMap;
            HashMap<Class, String[]> hashMap2 = hashMap;
            HashMap<Class, String[]> hashMap3 = hashMap;
            HashMap<Class, String[]> hashMap4 = hashMap;
            HashMap<Class, String[]> hashMap5 = hashMap;
            HashMap<Class, String[]> hashMap6 = hashMap;
            hashMap = new HashMap<Class, String[]>();
            HashMap<Class, String[]> hashMap7 = hashMap;
            Class<?> clazz = Class.forName("kotlin.ranges.CharRange");
            String[] stringArray = new String[2];
            stringArray[0] = "getEndInclusive";
            stringArray[1] = "isEmpty";
            hashMap4.put(clazz, stringArray);
            Class<?> clazz2 = Class.forName("kotlin.ranges.IntRange");
            String[] stringArray2 = new String[2];
            stringArray2[0] = "getEndInclusive";
            stringArray2[1] = "isEmpty";
            hashMap5.put(clazz2, stringArray2);
            Class<?> clazz3 = Class.forName("kotlin.ranges.LongRange");
            String[] stringArray3 = new String[2];
            stringArray3[0] = "getEndInclusive";
            stringArray3[1] = "isEmpty";
            hashMap6.put(clazz3, stringArray3);
            Class<?> clazz4 = Class.forName("kotlin.ranges.ClosedFloatRange");
            String[] stringArray4 = new String[2];
            stringArray4[0] = "getEndInclusive";
            stringArray4[1] = "isEmpty";
            hashMap2.put(clazz4, stringArray4);
            Class<?> clazz5 = Class.forName("kotlin.ranges.ClosedDoubleRange");
            String[] stringArray5 = new String[2];
            stringArray5[0] = "getEndInclusive";
            stringArray5[1] = "isEmpty";
            hashMap3.put(clazz5, stringArray5);
            try {
                kotlinIgnores = hashMap7;
            }
            catch (Throwable throwable) {
                kotlinIgnores_error = true;
            }
        }
        if (kotlinIgnores == null) {
            return false;
        }
        return (objectArray = kotlinIgnores.get(objectArray)) != null && Arrays.binarySearch(objectArray, string) >= 0;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> annotationArray, Class<A> clazz) {
        A a = annotationArray.getAnnotation(clazz);
        Annotation[] annotationArray2 = null;
        Type type = JSON.getMixInAnnotations(annotationArray);
        if (type instanceof Class) {
            annotationArray2 = (Annotation[])type;
        }
        if (annotationArray2 != null) {
            type = annotationArray2.getAnnotation(clazz);
            annotationArray2 = annotationArray2.getAnnotations();
            if (type == null && annotationArray2.length > 0) {
                int n = annotationArray2.length;
                for (int i = 0; i < n && (type = annotationArray2[i].annotationType().getAnnotation(clazz)) == null; ++i) {
                }
            }
            if (type != null) {
                return (A)type;
            }
        }
        annotationArray = annotationArray.getAnnotations();
        if (a == null && annotationArray.length > 0) {
            int n = annotationArray.length;
            for (int i = 0; i < n && (a = annotationArray[i].annotationType().getAnnotation(clazz)) == null; ++i) {
            }
        }
        return a;
    }

    public static <A extends Annotation> A getAnnotation(Field field, Class<A> clazz) {
        Field field2 = field;
        A a = field2.getAnnotation(clazz);
        Class clazz2 = null;
        Object object = JSON.getMixInAnnotations(field2.getDeclaringClass());
        if (object instanceof Class) {
            clazz2 = (Class)object;
        }
        if (clazz2 != null) {
            Field field3 = field;
            field = null;
            object = field3.getName();
            while (clazz2 != null && clazz2 != Object.class) {
                try {
                    field = clazz2.getDeclaredField((String)object);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    clazz2 = clazz2.getSuperclass();
                }
            }
            if (field == null) {
                return a;
            }
            if ((field = field.getAnnotation(clazz)) != null) {
                return (A)field;
            }
        }
        return a;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> clazz) {
        Method method2 = method;
        A a = method2.getAnnotation(clazz);
        Class clazz2 = null;
        Object object = JSON.getMixInAnnotations(method2.getDeclaringClass());
        if (object instanceof Class) {
            clazz2 = (Class)object;
        }
        if (clazz2 != null) {
            Method method3 = method;
            method = null;
            object = method3.getName();
            Class<?>[] classArray = method3.getParameterTypes();
            while (clazz2 != null && clazz2 != Object.class) {
                try {
                    method = clazz2.getDeclaredMethod((String)object, classArray);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    clazz2 = clazz2.getSuperclass();
                }
            }
            if (method == null) {
                return a;
            }
            if ((method = method.getAnnotation(clazz)) != null) {
                return (A)method;
            }
        }
        return a;
    }

    public static Annotation[][] getParameterAnnotations(Method object) {
        Annotation[][] annotationArray = object.getParameterAnnotations();
        Class clazz = null;
        Object object2 = JSON.getMixInAnnotations(object.getDeclaringClass());
        if (object2 instanceof Class) {
            clazz = (Class)object2;
        }
        if (clazz != null) {
            object = null;
            object2 = object.getName();
            Class<?>[] classArray = object.getParameterTypes();
            while (clazz != null && clazz != Object.class) {
                try {
                    object = clazz.getDeclaredMethod((String)object2, classArray);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    clazz = clazz.getSuperclass();
                }
            }
            if (object == null) {
                return annotationArray;
            }
            if ((object = object.getParameterAnnotations()) != null) {
                return object;
            }
        }
        return annotationArray;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Annotation[][] getParameterAnnotations(Constructor var0) {
        var1_1 = var0.getParameterAnnotations();
        var2_2 = null;
        var3_3 = JSON.getMixInAnnotations(var0.getDeclaringClass());
        if (var3_3 instanceof Class) {
            var2_2 = (Class<T>)var3_3;
        }
        if (var2_2 != null) {
            v0 = var0;
            var0 = null;
            var3_3 = v0.getParameterTypes();
            var4_4 = v1;
            v1 = new ArrayList<Class<?>>(2);
            for (var5_5 = var2_2.getEnclosingClass(); var5_5 != null; var5_5 = var5_5.getEnclosingClass()) {
                var4_4.add(var5_5);
            }
            var5_6 = var4_4.size();
            block9: for (var6_7 = var2_2; var6_7 != null && var6_7 != Object.class; var6_7 = var6_7.getSuperclass()) {
                if (var5_6 != 0) {
                    v2 = var3_3;
                    v3 = var3_3;
                    v4 = var5_6 + var3_3.length;
                    var7_8 = new Class[v4];
                    var8_9 = 0;
                    var9_10 = v2.length;
                    System.arraycopy(v3, var8_9, var7_8, var5_6, var9_10);
                    for (var8_9 = var5_6; var8_9 > 0; --var8_9) {
                        var9_10 = var8_9 - 1;
                        var7_8[var9_10] = (Class)var4_4.get(var9_10);
                        continue;
                    }
                    v5 = var2_2.getDeclaredConstructor(var7_8);
lbl37:
                    // 2 sources

                    while (true) {
                        var0 = v5;
                        break block9;
                        break;
                    }
                }
                try {
                    v5 = var2_2.getDeclaredConstructor(var3_3);
                    ** continue;
                }
                catch (NoSuchMethodException v6) {
                    --var5_6;
                    continue;
                }
            }
            if (var0 == null) {
                return var1_1;
            }
            if ((var0 = var0.getParameterAnnotations()) != null) {
                return var0;
            }
        }
        return var1_1;
    }

    public static boolean isJacksonCreator(Method method) {
        Class<? extends Annotation> clazz;
        if (method == null) {
            return false;
        }
        if (class_JacksonCreator == null && !class_JacksonCreator_error) {
            try {
                class_JacksonCreator = Class.forName("com.fasterxml.jackson.annotation.JsonCreator");
            }
            catch (Throwable throwable) {
                class_JacksonCreator_error = true;
            }
        }
        return (clazz = class_JacksonCreator) != null && method.isAnnotationPresent(clazz);
    }

    static {
        oracleDateMethodInited = false;
        optionalClassInited = false;
        transientClassInited = false;
        class_OneToMany = null;
        class_OneToMany_error = false;
        class_ManyToMany = null;
        class_ManyToMany_error = false;
        method_HibernateIsInitialized = null;
        method_HibernateIsInitialized_error = false;
        mappings = new ConcurrentHashMap(256, 0.75f, 1);
        pathClass_error = false;
        class_JacksonCreator = null;
        class_JacksonCreator_error = false;
        class_Clob = null;
        class_Clob_error = false;
        class_XmlAccessType = null;
        class_XmlAccessorType = null;
        classXmlAccessorType_error = false;
        method_XmlAccessorType_value = null;
        field_XmlAccessType_FIELD = null;
        field_XmlAccessType_FIELD_VALUE = null;
        class_deque = null;
        try {
            compatibleWithJavaBean = "true".equals(IOUtils.getStringProperty("fastjson.compatibleWithJavaBean"));
            compatibleWithFieldName = "true".equals(IOUtils.getStringProperty("fastjson.compatibleWithFieldName"));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            class_deque = Class.forName("java.util.Deque");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        TypeUtils.addBaseClassMappings();
    }
}

