/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.os.Looper;
import android.os.StatFs;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.tradplus.ads.base.common.TPDataCenter;
import com.tradplus.ads.base.util.PrivacyDataInfo;
import com.tradplus.ads.common.CreativeOrientation;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Reflection;
import com.tradplus.ads.common.util.Utils;
import com.tradplus.ads.common.util.VersionCode;
import java.io.File;
import java.util.HashMap;

public class DeviceUtils {
    private static final int MAX_MEMORY_CACHE_SIZE = 0x1E00000;
    private static final int MIN_DISK_CACHE_SIZE = 0x1E00000;
    private static final int MAX_DISK_CACHE_SIZE = 0x6400000;

    private DeviceUtils() {
    }

    public static boolean isNetworkAvailable(Context context) {
        block6: {
            block5: {
                if (context == null) {
                    return false;
                }
                try {
                    context = (ConnectivityManager)context.getSystemService("connectivity");
                    if (context != null) break block5;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            context = context.getActiveNetworkInfo();
            if (context == null) break block6;
            return context.isConnected();
        }
        return false;
    }

    public static void isMainThread() {
        boolean bl = Looper.myLooper() == Looper.getMainLooper();
        Log.i((String)"TradPlus isMainThread", (String)("isMainThread == " + bl));
    }

    public static int getCPUProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int memoryCacheSizeBytes(Context context) {
        long l;
        block5: {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            l = activityManager.getMemoryClass();
            if (VersionCode.currentApiLevel().isAtLeast(VersionCode.HONEYCOMB)) {
                Context context2 = context;
                int n = ApplicationInfo.class.getDeclaredField("FLAG_LARGE_HEAP").getInt(null);
                if (!Utils.bitMaskContainsFlag(context2.getApplicationInfo().flags, n)) break block5;
                try {
                    long l2;
                    l = l2 = (long)((Integer)new Reflection.MethodBuilder(activityManager, "getLargeMemoryClass").execute()).intValue();
                }
                catch (Exception exception) {
                    LogUtil.show("Unable to reflectively determine large heap size on Honeycomb and above.");
                }
            }
        }
        long l3 = l / 8L * 1024L * 1024L;
        return (int)Math.min(0x1E00000L, l3);
    }

    public static long diskCacheSizeBytes(File file, long l) {
        long l2;
        StatFs statFs;
        StatFs statFs2 = statFs;
        try {
            l2 = new StatFs(file.getAbsolutePath()).getBlockCount();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        long l3 = l2 * (long)statFs2.getBlockSize();
        l = l3 / 50L;
        return Math.max(Math.min(l, 0x6400000L), 0x1E00000L);
    }

    public static long diskCacheSizeBytes(File file) {
        return DeviceUtils.diskCacheSizeBytes(file, 0x1E00000L);
    }

    public static int getScreenOrientation(Activity activity) {
        return DeviceUtils.getScreenOrientationFromRotationAndOrientation(activity.getWindowManager().getDefaultDisplay().getRotation(), PrivacyDataInfo.getInstance().getOrientationInt());
    }

    static int getScreenOrientationFromRotationAndOrientation(int n, int n2) {
        if (1 == n2) {
            if (n != 1 && n != 2) {
                return 1;
            }
            return 9;
        }
        if (2 == n2) {
            if (n != 2 && n != 3) {
                return 0;
            }
            return 8;
        }
        LogUtil.show("Unknown screen orientation. Defaulting to portrait.");
        return 9;
    }

    public static boolean isScreenLandscapeOrientation(Context context) {
        if (context == null) {
            return false;
        }
        if ((context = context.getResources()) == null) {
            return false;
        }
        if ((context = context.getConfiguration()) == null) {
            return false;
        }
        return context.orientation == 2;
    }

    public static String getScreenOrientationToString(Context context) {
        return DeviceUtils.isScreenLandscapeOrientation(context) ? "\u6a2a\u5c4f" : "\u7ad6\u5c4f";
    }

    public static String getScreenOrientationToString(int n) {
        if (n != 3 && n != 0) {
            if (n == 1) {
                return "\u7ad6\u5c4f";
            }
            if (n == 2) {
                return "\u6a2a\u5c4f";
            }
            if (n == 4) {
                return "\u4ec5\u7ad6\u5c4f";
            }
            if (n == 5) {
                return "\u4ec5\u6a2a\u5c4f";
            }
            return "\u81ea\u9002\u5e94";
        }
        return "\u81ea\u9002\u5e94";
    }

    public static void lockOrientation(Activity activity, CreativeOrientation creativeOrientation) {
        block3: {
            block6: {
                int n;
                block5: {
                    int n2;
                    block4: {
                        if (!Preconditions.NoThrow.checkNotNull((Object)creativeOrientation) || !Preconditions.NoThrow.checkNotNull(activity)) break block3;
                        n2 = DeviceUtils.getScreenOrientationFromRotationAndOrientation(((WindowManager)activity.getSystemService("window")).getDefaultDisplay().getRotation(), TPDataCenter.getInstance().getOrientationInt((Context)activity));
                        if (CreativeOrientation.PORTRAIT != creativeOrientation) break block4;
                        n = 9 == n2 ? 9 : 1;
                        break block5;
                    }
                    if (CreativeOrientation.LANDSCAPE != creativeOrientation) break block6;
                    n = 8 == n2 ? 8 : 0;
                }
                activity.setRequestedOrientation(n);
                return;
            }
            return;
        }
    }

    public static Point getDeviceDimensions(Context context) {
        Integer n = null;
        Integer n2 = null;
        if (PrivacyDataInfo.getInstance().getOSVersion() >= 13) {
            Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            if (PrivacyDataInfo.getInstance().getOSVersion() >= 17) {
                Point point;
                n = point;
                display.getRealSize(new Point());
                Integer n3 = n;
                n = ((Point)n3).x;
                n2 = ((Point)n3).y;
            } else {
                n = (Integer)new Reflection.MethodBuilder(display, "getRawWidth").execute();
                try {
                    n2 = (Integer)new Reflection.MethodBuilder(display, "getRawHeight").execute();
                }
                catch (Exception exception) {
                    LogUtil.show("Display#getRawWidth/Height failed." + exception);
                }
            }
        }
        if (n == null || n2 == null) {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            n = displayMetrics.widthPixels;
            n2 = displayMetrics.heightPixels;
        }
        int n4 = n;
        return new Point(n4, n2.intValue());
    }

    public static String getIpAddress(IP iP) {
        return null;
    }

    @Deprecated
    public static String getHashedUdid(Context context) {
        return null;
    }

    public static int dip2px(Context context, float f) {
        HashMap<String, Boolean> hashMap = PrivacyDataInfo.getInstance().getPrivacyDeviceParam();
        if (hashMap != null && hashMap.containsKey("screen")) {
            return (int)f;
        }
        return (int)(f * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public static int px2dip(Context context, float f) {
        float f2;
        HashMap<String, Boolean> hashMap = PrivacyDataInfo.getInstance().getPrivacyDeviceParam();
        if (hashMap != null && hashMap.containsKey("screen_density")) {
            return (int)f;
        }
        float f3 = context.getResources().getDisplayMetrics().density;
        if (f2 <= 0.0f) {
            f3 = 1.0f;
        }
        return (int)(f / f3 + 0.5f);
    }

    public static String getScreenOrientation(Context context) {
        HashMap<String, Boolean> hashMap = PrivacyDataInfo.getInstance().getPrivacyDeviceParam();
        if (hashMap != null && hashMap.containsKey("orient")) {
            return "1";
        }
        if (DeviceUtils.isScreenLandscapeOrientation(context)) {
            return "2";
        }
        return "1";
    }

    public static int getScreenHeight(Context context) {
        HashMap<String, Boolean> hashMap = PrivacyDataInfo.getInstance().getPrivacyDeviceParam();
        if (hashMap != null && (hashMap.containsKey("screen") || hashMap.containsKey("screen_density"))) {
            return -2;
        }
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getScreenWidth(Context context) {
        HashMap<String, Boolean> hashMap = PrivacyDataInfo.getInstance().getPrivacyDeviceParam();
        if (hashMap != null && (hashMap.containsKey("screen") || hashMap.containsKey("screen_density"))) {
            return -2;
        }
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    @Deprecated
    public static enum IP {
        IPv4,
        IPv6;

    }

    public static enum ForceOrientation {
        FORCE_PORTRAIT("portrait"),
        FORCE_LANDSCAPE("landscape"),
        DEVICE_ORIENTATION("device"),
        UNDEFINED("");

        private final String mKey;

        private ForceOrientation(String string2) {
            this.mKey = string2;
        }

        public static ForceOrientation getForceOrientation(String string) {
            for (ForceOrientation forceOrientation : ForceOrientation.values()) {
                if (!forceOrientation.mKey.equalsIgnoreCase(string)) continue;
                return forceOrientation;
            }
            return UNDEFINED;
        }
    }
}

