/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.tradplus.ads.common.Preconditions;

public class Dips {
    public static float pixelsToFloatDips(float f, Context context) {
        return f / Dips.getDensity(context);
    }

    public static int pixelsToIntDips(float f, Context context) {
        return (int)(Dips.pixelsToFloatDips(f, context) + 0.5f);
    }

    public static float dipsToFloatPixels(float f, Context context) {
        return f * Dips.getDensity(context);
    }

    public static int dipsToIntPixels(float f, Context context) {
        return (int)(Dips.dipsToFloatPixels(f, context) + 0.5f);
    }

    private static float getDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static float asFloatPixels(float f, Context context) {
        context = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)context);
    }

    public static int asIntPixels(float f, Context context) {
        return (int)(Dips.asFloatPixels(f, context) + 0.5f);
    }

    public static int screenWidthAsIntDips(Context context) {
        Context context2 = context;
        Preconditions.checkNotNull(context2);
        return Dips.pixelsToIntDips(context2.getResources().getDisplayMetrics().widthPixels, context);
    }

    public static int screenHeightAsIntDips(Context context) {
        Context context2 = context;
        Preconditions.checkNotNull(context2);
        return Dips.pixelsToIntDips(context2.getResources().getDisplayMetrics().heightPixels, context);
    }
}

