/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import com.tradplus.ads.common.Preconditions;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class Reflection {
    public static Method getDeclaredMethodWithTraversal(Class<?> clazz, String string, Class<?> ... classArray) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchMethodException();
    }

    public static boolean classFound(String string) {
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static <T> T instantiateClassWithEmptyConstructor(String string, Class<? extends T> clazz) {
        String string2 = string;
        Preconditions.checkNotNull(string2);
        Constructor<T> constructor = Class.forName(string2).asSubclass(clazz).getDeclaredConstructor(null);
        ((AccessibleObject)constructor).setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    public static <T> T instantiateClassWithConstructor(String string, Class<? extends T> clazz, Class[] classArray, Object[] objectArray) {
        Preconditions.checkNotNull(string);
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(classArray);
        Preconditions.checkNotNull(objectArray);
        Constructor<T> constructor = Class.forName(string).asSubclass(clazz).getDeclaredConstructor(classArray);
        ((AccessibleObject)constructor).setAccessible(true);
        return constructor.newInstance(objectArray);
    }

    public static class MethodBuilder {
        private final Object mInstance;
        private final String mMethodName;
        private Class<?> mClass;
        private List<Class<?>> mParameterClasses;
        private List<Object> mParameters;
        private boolean mIsAccessible;
        private boolean mIsStatic;

        public MethodBuilder(Object clazz, String object) {
            ArrayList arrayList;
            ArrayList arrayList2;
            this.mInstance = clazz;
            this.mMethodName = object;
            object = arrayList2;
            arrayList2 = new ArrayList();
            this.mParameterClasses = object;
            object = arrayList;
            arrayList = new ArrayList();
            this.mParameters = object;
            clazz = clazz != null ? clazz.getClass() : null;
            this.mClass = clazz;
        }

        public <T> MethodBuilder addParam(Class<T> clazz, T t) {
            MethodBuilder methodBuilder = this;
            methodBuilder.mParameterClasses.add(clazz);
            methodBuilder.mParameters.add(t);
            return methodBuilder;
        }

        public MethodBuilder setAccessible() {
            this.mIsAccessible = true;
            return this;
        }

        public MethodBuilder setStatic(Class<?> clazz) {
            this.mIsStatic = true;
            this.mClass = clazz;
            return this;
        }

        public Object execute() {
            MethodBuilder methodBuilder = this;
            Object object = new Class[methodBuilder.mParameterClasses.size()];
            object = methodBuilder.mParameterClasses.toArray((T[])object);
            object = Reflection.getDeclaredMethodWithTraversal(methodBuilder.mClass, this.mMethodName, object);
            if (methodBuilder.mIsAccessible) {
                ((AccessibleObject)object).setAccessible(true);
            }
            MethodBuilder methodBuilder2 = this;
            Object[] objectArray = methodBuilder2.mParameters.toArray();
            if (methodBuilder2.mIsStatic) {
                return ((Method)object).invoke(null, objectArray);
            }
            return ((Method)object).invoke(this.mInstance, objectArray);
        }
    }
}

