/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import com.tradplus.ads.base.util.PrivacyDataInfo;
import com.tradplus.ads.common.util.LogUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class Views {
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);

    public static void removeFromParent(View view) {
        if (view != null && view.getParent() != null) {
            if (view.getParent() instanceof ViewGroup) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            return;
        }
    }

    public static View getTopmostView(Context context, View view) {
        context = Views.getRootViewFromActivity(context);
        view = Views.getRootViewFromView(view);
        if (context == null) {
            context = view;
        }
        return context;
    }

    private static View getRootViewFromActivity(Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        return ((Activity)context).getWindow().getDecorView().findViewById(0x1020002);
    }

    private static View getRootViewFromView(View view) {
        if (view == null) {
            return null;
        }
        if (!Views.isAttachedToWindow(view)) {
            LogUtil.show("Attempting to call View#getRootView() on an unattached View.");
        }
        if ((view = view.getRootView()) == null) {
            return null;
        }
        View view2 = view.findViewById(0x1020002);
        if (view2 != null) {
            view = view2;
        }
        return view;
    }

    public static boolean isAttachedToWindow(View view) {
        if (PrivacyDataInfo.getInstance().getOSVersion() >= 19) {
            return view.isAttachedToWindow();
        }
        return view.getWindowToken() != null;
    }

    public static int generateViewId() {
        int n;
        int n2;
        AtomicInteger atomicInteger;
        if (PrivacyDataInfo.getInstance().getOSVersion() >= 17) {
            return View.generateViewId();
        }
        do {
            if ((n = (n2 = (atomicInteger = sNextGeneratedId).get()) + 1) <= 0xFFFFFF) continue;
            n = 1;
        } while (!atomicInteger.compareAndSet(n2, n));
        return n2;
    }

    public static boolean getLocalVisibleRect(Context context, View view) {
        block9: {
            Rect rect;
            Point point;
            Context context2;
            try {
                context2 = context;
            }
            catch (Throwable throwable) {
                return false;
            }
            Point point2 = point;
            point = new Point();
            if (!(context2 instanceof Activity)) break block9;
            if (((Activity)context).getWindowManager() == null) break block9;
            View view2 = view;
            View view3 = view2;
            View view4 = view2;
            Point point3 = point2;
            Point point4 = point3;
            ((Activity)context).getWindowManager().getDefaultDisplay().getSize(point2);
            int n = point3.x;
            int n2 = point4.y;
            Rect rect2 = rect;
            rect = new Rect(0, 0, n, n2);
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            view3.setTag((Object)nArray[1]);
            return view4.getLocalVisibleRect(rect2);
        }
        return false;
    }
}

