/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.graphics.Point;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tradplus.ads.network.Networking;

public abstract class BaseUrlGenerator {
    private static final String WIDTH_KEY = "w";
    private static final String HEIGHT_KEY = "h";
    public StringBuilder mStringBuilder;
    public boolean mFirstParam;

    public abstract String generateUrlString(String var1);

    public void initUrlString(String string, String string2) {
        this.mStringBuilder = new StringBuilder(Networking.getScheme()).append("://").append(string).append(string2);
        this.mFirstParam = true;
    }

    protected String getFinalUrlString() {
        return this.mStringBuilder.toString();
    }

    protected void addParam(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        this.mStringBuilder.append(this.getParamDelimiter());
        this.mStringBuilder.append(string);
        this.mStringBuilder.append("=");
        this.mStringBuilder.append(Uri.encode((String)string2));
    }

    protected <T> void addParam(String string, T t2) {
        this.mStringBuilder.append(this.getParamDelimiter());
        this.mStringBuilder.append(string);
        this.mStringBuilder.append("=");
        this.mStringBuilder.append(t2);
    }

    private String getParamDelimiter() {
        if (this.mFirstParam) {
            this.mFirstParam = false;
            return "?";
        }
        return "&";
    }

    protected void setApiVersion(String string) {
        this.addParam("v", string);
    }

    protected void setAppVersion(String string) {
        this.addParam("av", string);
    }

    protected void setExternalStoragePermission(boolean bl) {
        this.addParam("android_perms_ext_storage", bl ? "1" : "0");
    }

    protected void setDeviceInfo(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            stringBuilder.append(stringArray[i2]).append(",");
        }
        stringBuilder.append(stringArray[stringArray.length - 1]);
        this.addParam("dn", stringBuilder.toString());
    }

    protected void setDoNotTrack(boolean bl) {
        if (bl) {
            this.addParam("dnt", "1");
        }
    }

    protected void setUdid(String string) {
        this.addParam("udid", string);
    }

    protected void appendAdvertisingInfoTemplates() {
        this.addParam("udid", "mp_tmpl_advertising_id");
        this.addParam("dnt", "mp_tmpl_do_not_track");
    }

    protected void setDeviceDimensions(@NonNull Point point) {
        this.addParam(WIDTH_KEY, "" + point.x);
        this.addParam(HEIGHT_KEY, "" + point.y);
    }
}

