/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.os.AsyncTask;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.factories.MethodBuilderFactory;
import com.tradplus.ads.common.util.AsyncTasks;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Reflection;
import java.lang.ref.WeakReference;

public class GpsHelper {
    public static final int GOOGLE_PLAY_SUCCESS_CODE = 0;
    public static final String ADVERTISING_ID_KEY = "advertisingId";
    public static final String IS_LIMIT_AD_TRACKING_ENABLED_KEY = "isLimitAdTrackingEnabled";
    private static String a = "com.google.android.gms.common.GooglePlayServicesUtil";
    private static String b = "com.google.android.gms.ads.identifier.AdvertisingIdClient";

    public static boolean isPlayServicesAvailable(Context object) {
        try {
            object = MethodBuilderFactory.create(null, "isGooglePlayServicesAvailable").setStatic(Class.forName(a)).addParam(Context.class, object).execute();
            return object != null && (Integer)object == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void fetchAdvertisingInfoAsync(Context context, GpsHelperListener gpsHelperListener) {
        boolean bl = GpsHelper.isPlayServicesAvailable(context);
        if (bl && !ClientMetadata.getInstance(context).isAdvertisingInfoSet()) {
            GpsHelper.a(context, gpsHelperListener);
            return;
        }
        if (gpsHelperListener != null) {
            gpsHelperListener.onFetchAdInfoCompleted();
        }
        if (bl) {
            GpsHelper.a(context, null);
        }
    }

    @Nullable
    public static AdvertisingInfo fetchAdvertisingInfoSync(Context object) {
        if (object == null) {
            return null;
        }
        try {
            object = MethodBuilderFactory.create(null, "getAdvertisingIdInfo").setStatic(Class.forName(b)).addParam(Context.class, object).execute();
        }
        catch (Exception exception) {
            LogUtil.show("Unable to obtain Google AdvertisingIdClient.Info via reflection.");
            return null;
        }
        String string = GpsHelper.a(object);
        boolean bl = GpsHelper.b(object);
        return new AdvertisingInfo(string, bl);
    }

    private static void a(Context context, GpsHelperListener gpsHelperListener) {
        if (!Reflection.classFound(b)) {
            if (gpsHelperListener != null) {
                gpsHelperListener.onFetchAdInfoCompleted();
            }
            return;
        }
        try {
            AsyncTasks.safeExecuteOnExecutor(new a(context, gpsHelperListener), new Void[0]);
            return;
        }
        catch (Exception exception) {
            LogUtil.show("Error executing FetchAdvertisingInfoTask", exception);
            if (gpsHelperListener != null) {
                gpsHelperListener.onFetchAdInfoCompleted();
            }
            return;
        }
    }

    static void a(Context context, Object object) {
        String string = GpsHelper.a(object);
        boolean bl = GpsHelper.b(object);
        ClientMetadata.getInstance(context).setAdvertisingInfo(string, bl);
    }

    private static String a(Object object) {
        try {
            return (String)MethodBuilderFactory.create(object, "getId").execute();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean b(Object object) {
        try {
            object = (Boolean)MethodBuilderFactory.create(object, IS_LIMIT_AD_TRACKING_ENABLED_KEY).execute();
            if (object != null) {
                return (Boolean)object;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Deprecated
    public static void setClassNamesForTesting() {
        String string = "java.lang.Class";
        a = "java.lang.Class";
        b = string;
    }

    static final class a
    extends AsyncTask<Void, Void, Void> {
        private WeakReference<Context> a;
        private WeakReference<GpsHelperListener> b;

        public a(Context context, GpsHelperListener gpsHelperListener) {
            this.a = new WeakReference<Context>(context);
            this.b = new WeakReference<GpsHelperListener>(gpsHelperListener);
        }

        private Void a() {
            try {
                Context context = (Context)this.a.get();
                if (context == null) {
                    return null;
                }
                Object object = MethodBuilderFactory.create(null, "getAdvertisingIdInfo").setStatic(Class.forName(b)).addParam(Context.class, context).execute();
                if (object != null) {
                    GpsHelper.a(context, object);
                }
            }
            catch (Exception exception) {
                LogUtil.show("Unable to obtain Google AdvertisingIdClient.Info via reflection.");
            }
            return null;
        }

        protected final /* synthetic */ void onPostExecute(Object object) {
            object = (GpsHelperListener)this.b.get();
            if (object != null) {
                object.onFetchAdInfoCompleted();
            }
        }

        protected final /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a();
        }
    }

    public static interface GpsHelperListener {
        public void onFetchAdInfoCompleted();
    }

    public static class AdvertisingInfo {
        public final String advertisingId;
        public final boolean limitAdTracking;

        public AdvertisingInfo(String string, boolean bl) {
            this.advertisingId = string;
            this.limitAdTracking = bl;
        }
    }
}

