/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.network.Networking;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.toolbox.ImageLoader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class NativeImageHelper {
    public static void preCacheImages(@NonNull Context object, @NonNull List<String> object2, @NonNull ImageListener imageListener) {
        object = Networking.getImageLoader((Context)object);
        Object object3 = new AtomicInteger(object2.size());
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        object3 = new ImageLoader.ImageListener((AtomicInteger)object3, atomicBoolean, imageListener){
            final /* synthetic */ AtomicInteger a;
            final /* synthetic */ AtomicBoolean b;
            final /* synthetic */ ImageListener c;
            {
                this.a = atomicInteger;
                this.b = atomicBoolean;
                this.c = imageListener;
            }

            @Override
            public final void onResponse(ImageLoader.ImageContainer imageContainer, boolean bl) {
                if (imageContainer.getBitmap() != null && this.a.decrementAndGet() == 0 && !this.b.get()) {
                    this.c.onImagesCached();
                }
            }

            @Override
            public final void onErrorResponse(VolleyError volleyError) {
                LogUtil.show("Failed to download a native ads image:", volleyError);
                boolean bl = this.b.getAndSet(true);
                this.a.decrementAndGet();
                if (!bl) {
                    this.c.onImagesFailedToCache(TradPlusErrorCode.IMAGE_DOWNLOAD_FAILURE);
                }
            }
        };
        object2 = object2.iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            if (TextUtils.isEmpty((CharSequence)string)) {
                atomicBoolean.set(true);
                imageListener.onImagesFailedToCache(TradPlusErrorCode.IMAGE_DOWNLOAD_FAILURE);
                return;
            }
            ((ImageLoader)object).get(string, (ImageLoader.ImageListener)object3);
        }
    }

    public static void loadImageView(@Nullable String string, final @Nullable ImageView imageView) {
        if (!Preconditions.NoThrow.checkNotNull(imageView, "Cannot load image into null ImageView")) {
            return;
        }
        if (!Preconditions.NoThrow.checkNotNull(string, "Cannot load image with null url")) {
            imageView.setImageDrawable(null);
            return;
        }
        Networking.getImageLoader(imageView.getContext()).get(string, new ImageLoader.ImageListener(){

            @Override
            public final void onResponse(ImageLoader.ImageContainer imageContainer, boolean bl) {
                if (!bl) {
                    LogUtil.show("Image was not loaded immediately into your ad view. You should call preCacheImages as part of your custom event loading process.");
                }
                imageView.setImageBitmap(imageContainer.getBitmap());
            }

            @Override
            public final void onErrorResponse(VolleyError volleyError) {
                LogUtil.show("Failed to load image.", volleyError);
                imageView.setImageDrawable(null);
            }
        });
    }

    public static interface ImageListener {
        public void onImagesCached();

        public void onImagesFailedToCache(TradPlusErrorCode var1);
    }
}

