/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.event.EventDetails;
import com.tradplus.ads.common.util.LogUtil;

public class Event
extends BaseEvent {
    private Event(@NonNull Builder builder) {
        super(builder);
    }

    @Nullable
    public static BaseEvent createEventFromDetails(@NonNull BaseEvent.Name name, @NonNull BaseEvent.Category category, @NonNull BaseEvent.SamplingRate samplingRate, @Nullable EventDetails eventDetails) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)category);
        Preconditions.checkNotNull((Object)samplingRate);
        if (eventDetails == null) {
            LogUtil.show("Unable to log event due to no details present");
            return null;
        }
        return new Builder(name, category, samplingRate.getSamplingRate()).withAdUnitId(eventDetails.getAdUnitId()).withAdCreativeId(eventDetails.getDspCreativeId()).withAdType(eventDetails.getAdType()).withAdNetworkType(eventDetails.getAdNetworkType()).withAdWidthPx(eventDetails.getAdWidthPx()).withAdHeightPx(eventDetails.getAdHeightPx()).withGeoLat(eventDetails.getGeoLatitude()).withGeoLon(eventDetails.getGeoLongitude()).withGeoAccuracy(eventDetails.getGeoAccuracy()).withPerformanceDurationMs(eventDetails.getPerformanceDurationMs()).withRequestId(eventDetails.getRequestId()).withRequestStatusCode(eventDetails.getRequestStatusCode()).withRequestUri(eventDetails.getRequestUri()).build();
    }

    /* synthetic */ Event(Builder builder, byte by) {
        this(builder);
    }

    public static class Builder
    extends BaseEvent.Builder {
        public Builder(@NonNull BaseEvent.Name name, @NonNull BaseEvent.Category category, double d2) {
            super(BaseEvent.ScribeCategory.EXCHANGE_CLIENT_EVENT, name, category, d2);
        }

        @Override
        @NonNull
        public Event build() {
            return new Event(this, 0);
        }
    }
}

