/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.JavaBeanSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerialContext;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;

public final class ListSerializer
implements ObjectSerializer {
    public static final ListSerializer instance = new ListSerializer();

    @Override
    public final void write(JSONSerializer jSONSerializer, Object object, Object object2, Type object3, int n2) {
        boolean bl = jSONSerializer.out.isEnabled(SerializerFeature.WriteClassName) || SerializerFeature.isEnabled(n2, SerializerFeature.WriteClassName);
        SerializeWriter serializeWriter = jSONSerializer.out;
        Type type = null;
        if (bl) {
            type = TypeUtils.getCollectionItemType((Type)object3);
        }
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        object3 = (List)object;
        if (object3.size() == 0) {
            serializeWriter.append("[]");
            return;
        }
        SerialContext serialContext = jSONSerializer.c;
        jSONSerializer.setContext(serialContext, object, object2, 0);
        try {
            if (serializeWriter.isEnabled(SerializerFeature.PrettyFormat)) {
                serializeWriter.append('[');
                jSONSerializer.incrementIndent();
                int n3 = 0;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (n3 != 0) {
                        serializeWriter.append(',');
                    }
                    jSONSerializer.println();
                    if (e2 != null) {
                        if (jSONSerializer.containsReference(e2)) {
                            jSONSerializer.writeReference(e2);
                        } else {
                            SerialContext serialContext2;
                            ObjectSerializer objectSerializer = jSONSerializer.getObjectWriter(e2.getClass());
                            jSONSerializer.c = serialContext2 = new SerialContext(serialContext, object, object2, 0, 0);
                            objectSerializer.write(jSONSerializer, e2, n3, type, n2);
                        }
                    } else {
                        jSONSerializer.out.writeNull();
                    }
                    ++n3;
                }
                jSONSerializer.decrementIdent();
                jSONSerializer.println();
                serializeWriter.append(']');
                return;
            }
            serializeWriter.append('[');
            int n4 = object3.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                ObjectSerializer objectSerializer;
                Object e3 = object3.get(i2);
                if (i2 != 0) {
                    serializeWriter.append(',');
                }
                if (e3 == null) {
                    serializeWriter.append("null");
                    continue;
                }
                Class<?> clazz = e3.getClass();
                if (clazz == Integer.class) {
                    serializeWriter.writeInt((Integer)e3);
                    continue;
                }
                if (clazz == Long.class) {
                    long l2 = (Long)e3;
                    if (bl) {
                        serializeWriter.writeLong(l2);
                        serializeWriter.write(76);
                        continue;
                    }
                    serializeWriter.writeLong(l2);
                    continue;
                }
                if ((SerializerFeature.DisableCircularReferenceDetect.mask & n2) != 0) {
                    objectSerializer = jSONSerializer.getObjectWriter(e3.getClass());
                } else {
                    if (!serializeWriter.g) {
                        SerialContext serialContext3;
                        jSONSerializer.c = serialContext3 = new SerialContext(serialContext, object, object2, 0, 0);
                    }
                    if (jSONSerializer.containsReference(e3)) {
                        jSONSerializer.writeReference(e3);
                        continue;
                    }
                    objectSerializer = jSONSerializer.getObjectWriter(e3.getClass());
                    if ((SerializerFeature.WriteClassName.mask & n2) != 0 && objectSerializer instanceof JavaBeanSerializer) {
                        ((JavaBeanSerializer)objectSerializer).writeNoneASM(jSONSerializer, e3, i2, type, n2);
                        continue;
                    }
                }
                objectSerializer.write(jSONSerializer, e3, i2, type, n2);
            }
            serializeWriter.append(']');
            return;
        }
        finally {
            jSONSerializer.c = serialContext;
        }
    }
}

