/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class UTF8Decoder
extends CharsetDecoder {
    private static final Charset a = Charset.forName("UTF-8");

    public UTF8Decoder() {
        super(a, 1.0f, 1.0f);
    }

    private static boolean a(int n2) {
        return (n2 & 0xC0) != 128;
    }

    private static CoderResult a(ByteBuffer byteBuffer, int n2) {
        for (int i2 = 1; i2 < n2; ++i2) {
            if (!UTF8Decoder.a(byteBuffer.get())) continue;
            return CoderResult.malformedForLength(i2);
        }
        return CoderResult.malformedForLength(n2);
    }

    public static CoderResult malformedN(ByteBuffer byteBuffer, int n2) {
        switch (n2) {
            case 1: {
                byte by = byteBuffer.get();
                n2 = by;
                if (by >> 2 == -2) {
                    if (byteBuffer.remaining() < 4) {
                        return CoderResult.UNDERFLOW;
                    }
                    return UTF8Decoder.a(byteBuffer, 5);
                }
                if (n2 >> 1 == -2) {
                    if (byteBuffer.remaining() < 5) {
                        return CoderResult.UNDERFLOW;
                    }
                    return UTF8Decoder.a(byteBuffer, 6);
                }
                return CoderResult.malformedForLength(1);
            }
            case 2: {
                return CoderResult.malformedForLength(1);
            }
            case 3: {
                n2 = byteBuffer.get();
                byte by = byteBuffer.get();
                return CoderResult.malformedForLength(n2 == -32 && (by & 0xE0) == 128 || UTF8Decoder.a(by) ? 1 : 2);
            }
            case 4: {
                n2 = byteBuffer.get() & 0xFF;
                int n3 = byteBuffer.get() & 0xFF;
                if (n2 > 244 || n2 == 240 && (n3 < 144 || n3 > 191) || n2 == 244 && (n3 & 0xF0) != 128 || UTF8Decoder.a(n3)) {
                    return CoderResult.malformedForLength(1);
                }
                if (UTF8Decoder.a(byteBuffer.get())) {
                    return CoderResult.malformedForLength(2);
                }
                return CoderResult.malformedForLength(3);
            }
        }
        throw new IllegalStateException();
    }

    private static CoderResult a(ByteBuffer byteBuffer, int n2, CharBuffer charBuffer, int n3, int n4) {
        byteBuffer.position(n2 - byteBuffer.arrayOffset());
        CoderResult coderResult = UTF8Decoder.malformedN(byteBuffer, n4);
        byteBuffer.position(n2);
        charBuffer.position(n3);
        return coderResult;
    }

    private static CoderResult a(Buffer buffer, int n2, int n3, Buffer buffer2, int n4, int n5) {
        buffer.position(n2);
        buffer2.position(n4);
        if (n5 == 0 || n3 - n2 < n5) {
            return CoderResult.UNDERFLOW;
        }
        return CoderResult.OVERFLOW;
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n4 = charBuffer.arrayOffset() + charBuffer.position();
        int n5 = charBuffer.arrayOffset() + charBuffer.limit();
        int n6 = n4 + Math.min(n3 - n2, n5 - n4);
        while (n4 < n6 && byArray[n2] >= 0) {
            cArray[n4++] = (char)byArray[n2++];
        }
        while (n2 < n3) {
            byte by;
            byte by2;
            byte by3;
            byte by4;
            n6 = byArray[n2];
            if (n6 >= 0) {
                if (n4 >= n5) {
                    return UTF8Decoder.a(byteBuffer, n2, n3, charBuffer, n4, 1);
                }
                cArray[n4++] = (char)n6;
                ++n2;
                continue;
            }
            if (n6 >> 5 == -2) {
                if (n3 - n2 < 2 || n4 >= n5) {
                    return UTF8Decoder.a(byteBuffer, n2, n3, charBuffer, n4, 2);
                }
                by3 = by4 = byArray[n2 + 1];
                if ((n6 & 0x1E) == 0 || (by3 & 0xC0) != 128) {
                    return UTF8Decoder.a(byteBuffer, n2, charBuffer, n4, 2);
                }
                cArray[n4++] = (char)(n6 << 6 ^ by4 ^ 0xF80);
                n2 += 2;
                continue;
            }
            if (n6 >> 4 == -2) {
                if (n3 - n2 < 3 || n4 >= n5) {
                    return UTF8Decoder.a(byteBuffer, n2, n3, charBuffer, n4, 3);
                }
                by4 = byArray[n2 + 1];
                by = by2 = byArray[n2 + 2];
                by3 = by4;
                if (n6 == -32 && (by3 & 0xE0) == 128 || (by3 & 0xC0) != 128 || (by & 0xC0) != 128) {
                    return UTF8Decoder.a(byteBuffer, n2, charBuffer, n4, 3);
                }
                cArray[n4++] = (char)(n6 << 12 ^ by4 << 6 ^ by2 ^ 0x1F80);
                n2 += 3;
                continue;
            }
            if (n6 >> 3 == -2) {
                if (n3 - n2 < 4 || n5 - n4 < 2) {
                    return UTF8Decoder.a(byteBuffer, n2, n3, charBuffer, n4, 4);
                }
                by4 = byArray[n2 + 1];
                by2 = byArray[n2 + 2];
                by3 = byArray[n2 + 3];
                n6 = (n6 & 7) << 18 | (by4 & 0x3F) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F;
                by = by3;
                by3 = by2;
                if ((by4 & 0xC0) != 128 || (by3 & 0xC0) != 128 || (by & 0xC0) != 128 || n6 < 65536 || n6 > 0x10FFFF) {
                    return UTF8Decoder.a(byteBuffer, n2, charBuffer, n4, 4);
                }
                cArray[n4++] = (char)(0xD800 | n6 - 65536 >> 10 & 0x3FF);
                cArray[n4++] = (char)(0xDC00 | n6 - 65536 & 0x3FF);
                n2 += 4;
                continue;
            }
            return UTF8Decoder.a(byteBuffer, n2, charBuffer, n4, 1);
        }
        return UTF8Decoder.a(byteBuffer, n2, n3, charBuffer, n4, 0);
    }
}

