/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Looper;
import android.os.StatFs;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.tradplus.ads.common.CreativeOrientation;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Reflection;
import com.tradplus.ads.common.util.Utils;
import com.tradplus.ads.common.util.VersionCode;
import java.io.File;

public class DeviceUtils {
    private DeviceUtils() {
    }

    public static boolean isNetworkAvailable(@Nullable Context context) {
        if (context == null) {
            return false;
        }
        if (!DeviceUtils.isPermissionGranted(context, "android.permission.INTERNET")) {
            return false;
        }
        if (!DeviceUtils.isPermissionGranted(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return true;
        }
        try {
            context = (ConnectivityManager)context.getSystemService("connectivity");
            if (context == null) {
                return false;
            }
            if ((context = context.getActiveNetworkInfo()) != null) {
                return context.isConnected();
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static void isMainThread() {
        boolean bl = Looper.myLooper() == Looper.getMainLooper();
        Log.i((String)"TradPlus isMainThread", (String)"isMainThread == ".concat(String.valueOf(bl)));
    }

    public static int memoryCacheSizeBytes(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        long l2 = activityManager.getMemoryClass();
        if (VersionCode.currentApiLevel().isAtLeast(VersionCode.HONEYCOMB)) {
            try {
                int n2 = ApplicationInfo.class.getDeclaredField("FLAG_LARGE_HEAP").getInt(null);
                if (Utils.bitMaskContainsFlag(context.getApplicationInfo().flags, n2)) {
                    l2 = ((Integer)new Reflection.MethodBuilder(activityManager, "getLargeMemoryClass").execute()).intValue();
                }
            }
            catch (Exception exception) {
                LogUtil.show("Unable to reflectively determine large heap size on Honeycomb and above.");
            }
        }
        return (int)Math.min(0x1E00000L, l2 / 8L * 1024L * 1024L);
    }

    public static long diskCacheSizeBytes(File file, long l2) {
        long l3 = l2;
        try {
            file = new StatFs(file.getAbsolutePath());
            l3 = (long)file.getBlockCount() * (long)file.getBlockSize() / 50L;
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return Math.max(Math.min(l3, 0x6400000L), 0x1E00000L);
    }

    public static long diskCacheSizeBytes(File file) {
        return DeviceUtils.diskCacheSizeBytes(file, 0x1E00000L);
    }

    public static int getScreenOrientation(@NonNull Activity activity) {
        int n2 = activity.getWindowManager().getDefaultDisplay().getRotation();
        int n3 = activity.getResources().getConfiguration().orientation;
        return DeviceUtils.a(n2, n3);
    }

    private static int a(int n2, int n3) {
        if (1 == n3) {
            switch (n2) {
                case 1: 
                case 2: {
                    return 9;
                }
            }
            return 1;
        }
        if (2 == n3) {
            switch (n2) {
                case 2: 
                case 3: {
                    return 8;
                }
            }
            return 0;
        }
        LogUtil.show("Unknown screen orientation. Defaulting to portrait.");
        return 9;
    }

    public static boolean isScreenLandscapeOrientation(Context context) {
        switch (context.getResources().getConfiguration().orientation) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    public static String getScreenOrientationToString(Context context) {
        if (DeviceUtils.isScreenLandscapeOrientation(context)) {
            return "\u6a2a\u5c4f";
        }
        return "\u7ad6\u5c4f";
    }

    public static String getScreenOrientationToString(int n2) {
        if (n2 == 3 || n2 == 0) {
            return "\u81ea\u9002\u5e94";
        }
        if (n2 == 1) {
            return "\u7ad6\u5c4f";
        }
        if (n2 == 2) {
            return "\u6a2a\u5c4f";
        }
        if (n2 == 4) {
            return "\u4ec5\u7ad6\u5c4f";
        }
        if (n2 == 5) {
            return "\u4ec5\u6a2a\u5c4f";
        }
        return "\u81ea\u9002\u5e94";
    }

    public static void lockOrientation(@NonNull Activity activity, @NonNull CreativeOrientation creativeOrientation) {
        int n2;
        if (!Preconditions.NoThrow.checkNotNull((Object)creativeOrientation) || !Preconditions.NoThrow.checkNotNull(activity)) {
            return;
        }
        int n3 = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay().getRotation();
        int n4 = activity.getResources().getConfiguration().orientation;
        n3 = DeviceUtils.a(n3, n4);
        if (CreativeOrientation.PORTRAIT == creativeOrientation) {
            n2 = 9 == n3 ? 9 : 1;
        } else if (CreativeOrientation.LANDSCAPE == creativeOrientation) {
            n2 = 8 == n3 ? 8 : 0;
        } else {
            return;
        }
        activity.setRequestedOrientation(n2);
    }

    @TargetApi(value=17)
    public static Point getDeviceDimensions(@NonNull Context context) {
        Display display;
        Integer n2 = null;
        Integer n3 = null;
        if (Build.VERSION.SDK_INT >= 13) {
            display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            if (Build.VERSION.SDK_INT >= 17) {
                Point point = new Point();
                display.getRealSize(point);
                n2 = point.x;
                n3 = point.y;
            } else {
                try {
                    n2 = (Integer)new Reflection.MethodBuilder(display, "getRawWidth").execute();
                    n3 = (Integer)new Reflection.MethodBuilder(display, "getRawHeight").execute();
                }
                catch (Exception exception) {
                    LogUtil.show("Display#getRawWidth/Height failed.".concat(String.valueOf(exception)));
                }
            }
        }
        if (n2 == null || n3 == null) {
            display = context.getResources().getDisplayMetrics();
            n2 = display.widthPixels;
            n3 = display.heightPixels;
        }
        return new Point(n2.intValue(), n3.intValue());
    }

    public static boolean isPermissionGranted(@NonNull Context context, @NonNull String string) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(string);
        return ContextCompat.checkSelfPermission((Context)context, (String)string) == 0;
    }

    @Nullable
    public static String getIpAddress(IP iP) {
        return null;
    }

    @Deprecated
    @Nullable
    public static String getHashedUdid(Context context) {
        return null;
    }

    public static int dip2px(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().density;
        return (int)(f2 * f3 + 0.5f);
    }

    public static int px2dip(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().density;
        return (int)(f2 / (f3 <= 0.0f ? 1.0f : f3) + 0.5f);
    }

    public static String getScreenOrientation(Context context) {
        if (DeviceUtils.isScreenLandscapeOrientation(context)) {
            return "2";
        }
        return "1";
    }

    public static int getScreenHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    @Deprecated
    public static enum IP {
        IPv4,
        IPv6;

    }

    public static enum ForceOrientation {
        FORCE_PORTRAIT("portrait"),
        FORCE_LANDSCAPE("landscape"),
        DEVICE_ORIENTATION("device"),
        UNDEFINED("");

        @NonNull
        private final String a;

        private ForceOrientation(@NonNull String string2) {
            this.a = string2;
        }

        @NonNull
        public static ForceOrientation getForceOrientation(@Nullable String string) {
            for (ForceOrientation forceOrientation : ForceOrientation.values()) {
                if (!forceOrientation.a.equalsIgnoreCase(string)) continue;
                return forceOrientation;
            }
            return UNDEFINED;
        }
    }
}

