/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network.util;

import com.tradplus.ads.common.task.TPWorker;
import com.tradplus.ads.common.util.LogUtil;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Map;
import org.apache.http.conn.ConnectTimeoutException;

public abstract class ResourceDownloadBaseUrlLoader {
    private final String TAG = this.getClass().getSimpleName();
    protected String mURL;
    protected boolean mIsStop;
    protected long downloadStartTime;
    protected long downloadEndTime;
    protected long downloadSize;

    public ResourceDownloadBaseUrlLoader(String string) {
        this.mURL = string;
    }

    public void start() {
        this.mIsStop = false;
        this.load();
    }

    public void stop() {
        this.mIsStop = true;
    }

    protected abstract Map<String, String> onPrepareHeaders();

    protected abstract void onErrorAgent(String var1, String var2);

    private void load() {
        TPWorker tPWorker = new TPWorker(){

            @Override
            public final void work() {
                try {
                    1 v0 = this;
                    v0.a(v0.ResourceDownloadBaseUrlLoader.this.mURL);
                    return;
                }
                catch (OutOfMemoryError | StackOverflowError virtualMachineError) {
                    System.gc();
                    ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", virtualMachineError.getMessage());
                    return;
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    LogUtil.ownShow(exception.getMessage());
                    ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", exception2.getMessage());
                    return;
                }
            }

            private void a(String string) {
                block33: {
                    Object object;
                    ResourceDownloadBaseUrlLoader.this.downloadStartTime = System.currentTimeMillis();
                    HttpURLConnection httpURLConnection = null;
                    try {
                        Object object22;
                        LogUtil.ownShow("REQUEST URL: ".concat(String.valueOf(string)));
                        httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
                        httpURLConnection.setInstanceFollowRedirects(false);
                        object = ResourceDownloadBaseUrlLoader.this.onPrepareHeaders();
                        if (object != null && object.size() > 0) {
                            for (Object object22 : object.keySet()) {
                                httpURLConnection.addRequestProperty((String)object22, (String)object.get(object22));
                                LogUtil.ownShow("REQUEST ADDED HEADER: \n" + (String)object22 + "  :  " + (String)object.get(object22));
                            }
                        }
                        if (ResourceDownloadBaseUrlLoader.this.mIsStop) {
                            ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10001", "Task had been canceled.");
                            return;
                        }
                        httpURLConnection.setConnectTimeout(ResourceDownloadBaseUrlLoader.this.getConnectTimeout());
                        httpURLConnection.connect();
                        int n2 = httpURLConnection.getResponseCode();
                        if (n2 != 200) {
                            LogUtil.ownShow("http respond status code is " + n2 + " ! url=" + string);
                            if (n2 == 302) {
                                if (!ResourceDownloadBaseUrlLoader.this.mIsStop) {
                                    object22 = httpURLConnection.getHeaderField("Location");
                                    if (object22 != null) {
                                        if (!((String)object22).startsWith("http")) {
                                            object22 = string + (String)object22;
                                        }
                                        this.a((String)object22);
                                    }
                                } else {
                                    ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10001", "Task had been canceled.");
                                }
                                return;
                            }
                            ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", httpURLConnection.getResponseMessage());
                            return;
                        }
                        if (ResourceDownloadBaseUrlLoader.this.mIsStop) {
                            ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10001", "Task had been canceled.");
                            return;
                        }
                        ResourceDownloadBaseUrlLoader.this.downloadSize = httpURLConnection.getContentLength();
                        object22 = httpURLConnection.getInputStream();
                        boolean bl = ResourceDownloadBaseUrlLoader.this.saveHttpResource((InputStream)object22);
                        LogUtil.ownShow("save_success = ".concat(String.valueOf(bl)));
                        if (object22 != null) {
                            ((InputStream)object22).close();
                        }
                        ResourceDownloadBaseUrlLoader.this.downloadEndTime = System.currentTimeMillis();
                        if (bl) {
                            LogUtil.ownShow("download success --> " + ResourceDownloadBaseUrlLoader.this.mURL);
                            ResourceDownloadBaseUrlLoader.this.onLoadFinishCallback();
                        } else {
                            LogUtil.ownShow("download fail --> " + ResourceDownloadBaseUrlLoader.this.mURL);
                            ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", "Save fail!");
                        }
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                            return;
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", socketTimeoutException.getMessage());
                        LogUtil.ownShow(socketTimeoutException.toString());
                        return;
                    }
                    catch (ConnectTimeoutException connectTimeoutException) {
                        ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", connectTimeoutException.getMessage());
                        return;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        System.gc();
                        LogUtil.ownShow(outOfMemoryError.getMessage());
                        ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", outOfMemoryError.getMessage());
                        return;
                    }
                    catch (StackOverflowError stackOverflowError) {
                        System.gc();
                        LogUtil.ownShow(stackOverflowError.getMessage());
                        ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", stackOverflowError.getMessage());
                        return;
                    }
                    catch (Error error) {
                        System.gc();
                        LogUtil.ownShow(error.getMessage());
                        ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", error.getMessage());
                        return;
                    }
                    catch (Exception exception) {
                        object = exception;
                        LogUtil.ownShow(exception.getMessage());
                        ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", ((Throwable)object).getMessage());
                        return;
                    }
                    finally {
                        if (httpURLConnection == null) break block33;
                        httpURLConnection.disconnect();
                    }
                }
            }
        };
        this.startWorker(tPWorker);
    }

    protected int getConnectTimeout() {
        return 60000;
    }

    protected int getReadTimeout() {
        return 20000;
    }

    protected abstract boolean saveHttpResource(InputStream var1);

    protected abstract void startWorker(TPWorker var1);

    protected abstract void onLoadFinishCallback();

    protected abstract void onLoadFailedCallback(String var1, String var2);
}

