/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.volley.toolbox;

import android.os.SystemClock;
import com.tradplus.ads.volley.AuthFailureError;
import com.tradplus.ads.volley.Cache;
import com.tradplus.ads.volley.Network;
import com.tradplus.ads.volley.NetworkError;
import com.tradplus.ads.volley.NetworkResponse;
import com.tradplus.ads.volley.NoConnectionError;
import com.tradplus.ads.volley.Request;
import com.tradplus.ads.volley.RetryPolicy;
import com.tradplus.ads.volley.ServerError;
import com.tradplus.ads.volley.TimeoutError;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.VolleyLog;
import com.tradplus.ads.volley.toolbox.ByteArrayPool;
import com.tradplus.ads.volley.toolbox.HttpStack;
import com.tradplus.ads.volley.toolbox.PoolingByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.cookie.DateUtils;

public class BasicNetwork
implements Network {
    protected static final boolean a = VolleyLog.DEBUG;
    private static int d = 3000;
    private static int e = 4096;
    protected final HttpStack b;
    protected final ByteArrayPool c;

    public BasicNetwork(HttpStack httpStack) {
        this(httpStack, new ByteArrayPool(e));
    }

    public BasicNetwork(HttpStack httpStack, ByteArrayPool byteArrayPool) {
        this.b = httpStack;
        this.c = byteArrayPool;
    }

    @Override
    public NetworkResponse performRequest(Request<?> request) {
        long l2 = SystemClock.elapsedRealtime();
        while (true) {
            HttpResponse httpResponse = null;
            byte[] byArray = null;
            Map<String, String> map = Collections.emptyMap();
            try {
                Object object;
                Object object2 = new HashMap();
                Cache.Entry entry = request.getCacheEntry();
                StatusLine statusLine = object2;
                if (entry != null) {
                    if (entry.etag != null) {
                        statusLine.put((String)"If-None-Match", (String)entry.etag);
                    }
                    if (entry.serverDate > 0L) {
                        object = new Date(entry.serverDate);
                        statusLine.put("If-Modified-Since", DateUtils.formatDate((Date)object));
                    }
                }
                httpResponse = this.b.performRequest(request, (Map<String, String>)object2);
                object2 = httpResponse.getStatusLine();
                int n2 = object2.getStatusCode();
                map = BasicNetwork.a(httpResponse.getAllHeaders());
                if (n2 == 304) {
                    Cache.Entry entry2 = request.getCacheEntry();
                    if (entry2 == null) {
                        return new NetworkResponse(304, null, map, true, SystemClock.elapsedRealtime() - l2);
                    }
                    entry2.responseHeaders.putAll(map);
                    return new NetworkResponse(304, entry2.data, entry2.responseHeaders, true, SystemClock.elapsedRealtime() - l2);
                }
                byArray = httpResponse.getEntity() != null ? this.a(httpResponse.getEntity()) : new byte[]{};
                StatusLine statusLine2 = object2;
                object = byArray;
                object2 = request;
                long l3 = SystemClock.elapsedRealtime() - l2;
                if (a || l3 > (long)d) {
                    VolleyLog.d("HTTP response for request=<%s> [lifetime=%d], [size=%s], [rc=%d], [retryCount=%s]", object2, l3, object != null ? Integer.valueOf(((Object)object).length) : "null", statusLine2.getStatusCode(), ((Request)object2).getRetryPolicy().getCurrentRetryCount());
                }
                if (n2 < 200 || n2 > 299) {
                    throw new IOException();
                }
                return new NetworkResponse(n2, byArray, map, false, SystemClock.elapsedRealtime() - l2);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                BasicNetwork.a("socket", request, new TimeoutError());
                continue;
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                BasicNetwork.a("connection", request, new TimeoutError());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("Bad URL " + request.getUrl(), malformedURLException);
            }
            catch (IOException iOException) {
                if (httpResponse == null) {
                    throw new NoConnectionError(iOException);
                }
                int n3 = httpResponse.getStatusLine().getStatusCode();
                VolleyLog.e("Unexpected response code %d for %s", n3, request.getUrl());
                if (byArray != null) {
                    NetworkResponse networkResponse = new NetworkResponse(n3, byArray, map, false, SystemClock.elapsedRealtime() - l2);
                    if (n3 == 401 || n3 == 403) {
                        BasicNetwork.a("auth", request, new AuthFailureError(networkResponse));
                        continue;
                    }
                    throw new ServerError(networkResponse);
                }
                throw new NetworkError(null);
            }
            break;
        }
    }

    private static void a(String string, Request<?> request, VolleyError volleyError) {
        RetryPolicy retryPolicy = request.getRetryPolicy();
        int n2 = request.getTimeoutMs();
        try {
            retryPolicy.retry(volleyError);
        }
        catch (VolleyError volleyError2) {
            request.addMarker(String.format("%s-timeout-giveup [timeout=%s]", string, n2));
            throw volleyError2;
        }
        request.addMarker(String.format("%s-retry [timeout=%s]", string, n2));
    }

    private byte[] a(HttpEntity httpEntity) {
        Object object;
        PoolingByteArrayOutputStream poolingByteArrayOutputStream = new PoolingByteArrayOutputStream(this.c, (int)httpEntity.getContentLength());
        byte[] byArray = null;
        try {
            int n2;
            object = httpEntity.getContent();
            if (object == null) {
                throw new ServerError();
            }
            byArray = this.c.getBuf(1024);
            while ((n2 = ((InputStream)object).read(byArray)) != -1) {
                poolingByteArrayOutputStream.write(byArray, 0, n2);
            }
            object = poolingByteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                httpEntity.consumeContent();
            }
            catch (IOException iOException) {
                VolleyLog.v("Error occured when calling consumingContent", new Object[0]);
            }
            this.c.returnBuf(byArray);
            poolingByteArrayOutputStream.close();
            throw throwable;
        }
        try {
            httpEntity.consumeContent();
        }
        catch (IOException iOException) {
            VolleyLog.v("Error occured when calling consumingContent", new Object[0]);
        }
        this.c.returnBuf(byArray);
        poolingByteArrayOutputStream.close();
        return object;
    }

    private static Map<String, String> a(Header[] headerArray) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (int i2 = 0; i2 < headerArray.length; ++i2) {
            treeMap.put(headerArray[i2].getName(), headerArray[i2].getValue());
        }
        return treeMap;
    }
}

