/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TPTaskManager {
    private static TPTaskManager mInstance = null;
    private ExecutorService mNormalPool = Executors.newCachedThreadPool();
    private ExecutorService mSinglePool = Executors.newSingleThreadExecutor();
    private HandlerThread mHandlerThread = new HandlerThread("tp-thread-" + System.currentTimeMillis());
    private Handler mThreadHandler;
    private Handler mMainHandler;

    protected TPTaskManager() {
        this.mHandlerThread.start();
        this.mThreadHandler = new Handler(this.mHandlerThread.getLooper());
        this.mMainHandler = new Handler(Looper.getMainLooper());
    }

    public static synchronized TPTaskManager getInstance() {
        if (mInstance == null) {
            mInstance = new TPTaskManager();
        }
        return mInstance;
    }

    public void fastRun(Runnable runnable) {
        this.mSinglePool.execute(runnable);
    }

    public void runNormalTask(Runnable runnable) {
        this.mNormalPool.execute(runnable);
    }

    public void runOnThread(Runnable runnable) {
        this.mThreadHandler.post(runnable);
    }

    public void runOnThreadDelayed(Runnable runnable, long l2) {
        this.mThreadHandler.postDelayed(runnable, l2);
    }

    public Handler getThreadHandler() {
        return this.mThreadHandler;
    }

    public void runOnMainThread(Runnable runnable) {
        this.mMainHandler.post(runnable);
    }

    public void runOnMainThreadDelayed(Runnable runnable, long l2) {
        this.mMainHandler.postDelayed(runnable, l2);
    }
}

