/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.config;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.config.TradPlusConfigUtils;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.base.filter.FrequencyUtils;
import com.tradplus.ads.common.AdFormat;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.util.b;
import com.tradplus.ads.network.Networking;
import com.tradplus.ads.network.OnConfigListener;
import com.tradplus.ads.network.TradPlusConfigRequest;
import com.tradplus.ads.network.response.ConfigResponse;
import com.tradplus.ads.pushcenter.reqeust.AdconfRequest;
import com.tradplus.ads.pushcenter.utils.PushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.pushcenter.utils.SendMessageUtil;
import com.tradplus.ads.volley.RequestQueue;
import com.tradplus.ads.volley.VolleyError;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigLoadManager {
    private static final String CONFIG_AES_KEY = "tradplus";
    private static ConfigLoadManager mInstance = null;
    private ConcurrentHashMap<String, ConfigResponse> mConfigResponses = new ConcurrentHashMap();

    private ConfigLoadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized ConfigLoadManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<ConfigLoadManager> clazz = ConfigLoadManager.class;
        synchronized (ConfigLoadManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ConfigLoadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public ConfigResponse getLocalConfigResponse(String string) {
        ConfigResponse configResponse = this.mConfigResponses.get(string);
        if (configResponse != null) {
            return configResponse;
        }
        GlobalTradPlus.getInstance().getContext();
        configResponse = TradPlusConfigUtils.getInstance().getConfigByUnitId(string);
        if (configResponse != null) {
            this.mConfigResponses.put(string, configResponse);
        }
        return configResponse;
    }

    public void loadConfig(String object, ConfigLoadListener object2) {
        Object object3 = GlobalTradPlus.getInstance().getContext();
        Object object4 = this.mConfigResponses.get(object);
        if (object4 != null) {
            object2.onSuccess((ConfigResponse)object4);
            this.checkConfigTimeout((Context)object3, (String)object, (ConfigResponse)object4);
            return;
        }
        object4 = new b((Context)object3, (String)object, "", 0L);
        new b((Context)object3, (String)object, "", 0L).d = new OnConfigListener((Context)object3, (String)object, (ConfigLoadListener)object2){
            final /* synthetic */ Context a;
            final /* synthetic */ String b;
            final /* synthetic */ ConfigLoadListener c;
            {
                this.a = context;
                this.b = string;
                this.c = configLoadListener;
            }

            @Override
            public final void onSuccess(ConfigResponse configResponse) {
                ConfigLoadManager.this.checkConfigTimeout(this.a, this.b, configResponse);
                if (this.c == null) {
                    return;
                }
                if (configResponse != null) {
                    ConfigLoadManager.this.mConfigResponses.put(this.b, configResponse);
                    FrequencyUtils.getInstance().saveFrequency(configResponse.getFrequency(), this.b);
                    this.c.onSuccess(configResponse);
                    return;
                }
                this.c.onFailed(new VolleyError());
            }

            @Override
            public final void onFailed(VolleyError volleyError) {
                this.c.onFailed(volleyError);
            }
        };
        object2 = object = object4;
        SendMessageUtil.getInstance().sendLoadAdconfStart(((b)object2).b, ((b)object2).a, true);
        ((b)object2).c = new AdconfRequest(((b)object2).b, PushMessageUtils.PushStatus.EV_PRE_LOAD_ADCONF.getValue());
        object2 = object;
        object = ((b)object2).a();
        LogUtil.ownShow("adUrl:".concat(String.valueOf(object)), "TradPlus");
        object4 = TradPlusConfigUtils.getInstance().getConfigByUnitId(((b)object2).a);
        if (object4 == null) {
            LogUtil.ownShow("config request unitid = " + ((b)object2).a, "TradPlus");
            object3 = new TradPlusConfigRequest.Listener(){
                final /* synthetic */ boolean a;
                {
                    this.a = true;
                }

                @Override
                public final void onSuccess(ConfigResponse configResponse) {
                    if (configResponse != null) {
                        b.a(configResponse);
                        ClientMetadata.getInstance(b.this.b).putSegmentIds(b.this.a, configResponse.getBucket_id(), configResponse.getSegment_id());
                        b.this.c.setLuid(b.this.a);
                        b.this.c.setRt("" + RequestUtils.getInstance().countRuntime(b.this.c.getCreateTime()));
                        b.this.c.setEc("1");
                        b.this.c.setCf("1");
                        if (configResponse.getCode() != null) {
                            if (!configResponse.getCode().equals("0")) {
                                CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.APPID_MATCH_ADUNITAD);
                            }
                            b.this.c.setSc(configResponse.getCode());
                        }
                        if (this.a) {
                            TPPushCenter.getInstance().pushEvent(b.this.c);
                        }
                        configResponse.setCreateTime(System.currentTimeMillis());
                        TradPlusConfigUtils.getInstance().setConfigByUnitId(b.this.b, b.this.a, configResponse);
                    } else {
                        b.this.c.setRt("" + RequestUtils.getInstance().countRuntime(b.this.c.getCreateTime()));
                        b.this.c.setEc("10");
                        b.this.c.setCf("1");
                        TPPushCenter.getInstance().pushEvent(b.this.c);
                    }
                    if (b.this.d != null) {
                        b.this.d.onSuccess(configResponse);
                    }
                }

                @Override
                public final void onErrorResponse(VolleyError volleyError) {
                    Log.e((String)"TradPlus", (String)("Response is Failed,error:" + volleyError.getMessage()));
                    b.this.c.setLuid(b.this.a);
                    b.this.c.setRt("" + RequestUtils.getInstance().countRuntime(b.this.c.getCreateTime()));
                    b.this.c.setCf("1");
                    if (volleyError.networkResponse != null) {
                        b.this.c.setEc(RequestUtils.getInstance().getNetWorkStatus(volleyError.networkResponse.statusCode));
                    } else {
                        b.this.c.setEc("7");
                    }
                    if (this.a) {
                        TPPushCenter.getInstance().pushEvent(b.this.c);
                    }
                    if (b.this.d != null) {
                        b.this.d.onFailed(volleyError);
                    }
                }
            };
            object = new TradPlusConfigRequest((String)object, AdFormat.INTERSTITIAL, ((b)object2).a, ((b)object2).b, (TradPlusConfigRequest.Listener)object3);
            object2 = Networking.getRequestQueue(((b)object2).b);
            if (object2 != null) {
                ((RequestQueue)object2).add(object);
            }
            return;
        }
        LogUtil.ownShow("config local unitid = " + ((b)object2).a, "TradPlus");
        ClientMetadata.getInstance(((b)object2).b).putSegmentIds(((b)object2).a, ((ConfigResponse)object4).getBucket_id(), ((ConfigResponse)object4).getSegment_id());
        ((b)object2).c.setLuid(((b)object2).a);
        ((b)object2).c.setRt("" + RequestUtils.getInstance().countRuntime(((b)object2).c.getCreateTime()));
        ((b)object2).c.setEc("1");
        ((b)object2).c.setCf("2");
        TPPushCenter.getInstance().pushEvent(((b)object2).c);
        if (((b)object2).d != null) {
            ((b)object2).d.onSuccess((ConfigResponse)object4);
        }
    }

    public void setDefaultConfig(String string, String object) {
        if (object == null || ((String)object).length() <= 0) {
            return;
        }
        Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig getLocalConfig start---------");
        ConfigResponse configResponse = this.getLocalConfigResponse(string);
        Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig getLocalConfig end---------");
        if (configResponse != null) {
            return;
        }
        if (((String)object).contains("\n")) {
            object = ((String)object).replaceAll("\n", "").replaceAll("\r", "").replaceAll(" ", "");
        }
        try {
            object = Base64.decode((byte[])((String)object).getBytes(), (int)0);
            object = new String((byte[])object, "utf-8");
            Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig decode ========");
            object = JSON.parseObject((String)object, ConfigResponse.class);
            if (object != null) {
                Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig success ========");
                this.mConfigResponses.put(string, (ConfigResponse)object);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig error ==========");
            return;
        }
    }

    public String getCurrentConfig(String object) {
        if ((object = this.getLocalConfigResponse((String)object)) == null) {
            return "";
        }
        String string = "";
        try {
            string = Base64.encodeToString((byte[])JSON.toJSONString(object).getBytes(), (int)0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private boolean checkConfigTimeout(Context object, final String string, ConfigResponse configResponse) {
        if (configResponse == null) {
            return true;
        }
        long l2 = configResponse.getExpires();
        long l3 = configResponse.getCreateTime();
        if (System.currentTimeMillis() - l3 >= (TradPlus.isLocalDebugMode ? 300L : l2) * 1000L) {
            object = new b((Context)object, string, configResponse.getResp_uid(), configResponse.getResp_time());
            v0.d = new OnConfigListener(){

                @Override
                public final void onSuccess(ConfigResponse configResponse) {
                    if (configResponse != null) {
                        ConfigLoadManager.this.mConfigResponses.put(string, configResponse);
                    }
                }

                @Override
                public final void onFailed(VolleyError volleyError) {
                }
            };
            Object object2 = object;
            String string2 = ((b)object2).a();
            LogUtil.ownShow("adUrl:".concat(String.valueOf(string2)), "TradPlus");
            TradPlusConfigRequest.Listener listener = new TradPlusConfigRequest.Listener(){

                @Override
                public final void onSuccess(ConfigResponse configResponse) {
                    if (configResponse != null) {
                        ClientMetadata clientMetadata = ClientMetadata.getInstance(b.this.b);
                        if (!configResponse.getCode().equals("201")) {
                            configResponse.setCreateTime(System.currentTimeMillis());
                            b.a(configResponse);
                            TradPlusConfigUtils.getInstance().setConfigByUnitId(b.this.b, b.this.a, configResponse);
                            clientMetadata.putSegmentIds(b.this.a, configResponse.getBucket_id(), configResponse.getSegment_id());
                            if (b.this.d != null) {
                                b.this.d.onSuccess(configResponse);
                                return;
                            }
                        } else {
                            configResponse = TradPlusConfigUtils.getInstance().getConfigByUnitId(b.this.a);
                            if (configResponse != null) {
                                configResponse.setCreateTime(System.currentTimeMillis());
                                TradPlusConfigUtils.getInstance().setConfigByUnitId(b.this.b, b.this.a, configResponse);
                                clientMetadata.putSegmentIds(b.this.a, configResponse.getBucket_id(), configResponse.getSegment_id());
                                if (b.this.d != null) {
                                    b.this.d.onSuccess(configResponse);
                                }
                            }
                        }
                        return;
                    }
                    if (b.this.d != null) {
                        b.this.d.onFailed(null);
                    }
                }

                @Override
                public final void onErrorResponse(VolleyError volleyError) {
                    Log.e((String)"TradPlus", (String)("Response is Failed,error:" + volleyError.getMessage()));
                    if (b.this.d != null) {
                        b.this.d.onFailed(volleyError);
                    }
                }
            };
            TradPlusConfigRequest tradPlusConfigRequest = new TradPlusConfigRequest(string2, AdFormat.INTERSTITIAL, ((b)object2).a, ((b)object2).b, listener);
            object = Networking.getRequestQueue(((b)object2).b);
            if (object != null) {
                ((RequestQueue)object).add(tradPlusConfigRequest);
            }
            return true;
        }
        return false;
    }

    public static interface ConfigLoadListener {
        public void onSuccess(ConfigResponse var1);

        public void onFailed(VolleyError var1);
    }
}

