/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.config.request;

import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.volley.DefaultRetryPolicy;
import com.tradplus.ads.volley.NetworkResponse;
import com.tradplus.ads.volley.Request;
import com.tradplus.ads.volley.Response;
import com.tradplus.ads.volley.RetryPolicy;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;

public class BiddingRequest
extends Request<BiddingResponse> {
    private String body;
    private Listener listener;

    public BiddingRequest(String object, String string, Listener listener, int n2) {
        super(1, (String)object, listener);
        this.body = string;
        LogUtil.ownShow("bidding request body = " + this.body);
        this.listener = listener;
        object = new DefaultRetryPolicy(n2 == 0 ? 10000 : n2, 1, 1.0f);
        this.setShouldCache(false);
        this.setRetryPolicy((RetryPolicy)object);
    }

    @Override
    public byte[] getBody() {
        try {
            return this.body.getBytes(this.getParamsEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    @Override
    public Response<BiddingResponse> parseNetworkResponse(NetworkResponse networkResponse) {
        try {
            String string = new String(networkResponse.data);
            LogUtil.ownShow("bidding response data = ".concat(String.valueOf(string)));
            return Response.success(JSON.parseObject(string, BiddingResponse.class), HttpHeaderParser.parseCacheHeaders(networkResponse));
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return Response.error(new VolleyError(exception2.getMessage()));
        }
    }

    @Override
    protected void deliverResponse(BiddingResponse biddingResponse) {
        if (this.listener != null) {
            this.listener.onResponse(biddingResponse);
        }
    }

    public static interface Listener
    extends Response.ErrorListener {
        public void onResponse(BiddingResponse var1);
    }
}

