/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.db;

import android.database.sqlite.SQLiteDatabase;
import com.tradplus.ads.base.db.ColumnEntity;
import com.tradplus.ads.base.db.TableUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public final class TableEntity<T> {
    private final LinkedHashMap<String, ColumnEntity> columnMap;
    private final String name;
    private final Class<T> entityType;
    private ColumnEntity id;
    private volatile boolean isExists;

    public TableEntity(Class<T> object) {
        this.entityType = object;
        this.name = ((Class)object).getSimpleName();
        this.columnMap = TableUtils.findColumns(object);
        for (ColumnEntity columnEntity : this.columnMap.values()) {
            if (!columnEntity.isId()) continue;
            this.id = columnEntity;
            return;
        }
    }

    private String createSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("create table if not exists ");
        stringBuilder.append("\"");
        stringBuilder.append(this.name);
        stringBuilder.append("\"");
        stringBuilder.append("(");
        Iterator<ColumnEntity> iterator = this.columnMap.values().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().getSql());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public final String getName() {
        return this.name;
    }

    public final ColumnEntity getId() {
        return this.id;
    }

    private boolean tableExists(boolean bl, SQLiteDatabase sQLiteDatabase) {
        if (this.isExists && !bl) {
            return this.isExists;
        }
        this.isExists = TableUtils.tableExists(sQLiteDatabase, this.name);
        return this.isExists;
    }

    public final void createTableIfNotExists(SQLiteDatabase sQLiteDatabase) {
        String[] stringArray = TableUtils.getColumnNames(sQLiteDatabase, this.name);
        if (stringArray == null) {
            sQLiteDatabase.execSQL(this.createSql());
            return;
        }
        try {
            this.checkColumn(stringArray, sQLiteDatabase);
            return;
        }
        catch (Exception exception) {
            this.removeTableByName(sQLiteDatabase);
            sQLiteDatabase.execSQL(this.createSql());
            return;
        }
    }

    public final void removeTableByName(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("drop table " + this.name);
    }

    private void checkColumn(String[] object, SQLiteDatabase sQLiteDatabase) {
        HashMap<String, ColumnEntity> hashMap = new HashMap<String, ColumnEntity>(this.columnMap);
        if (object != null && ((String[])object).length > 0) {
            for (String string : object) {
                hashMap.remove(string);
            }
        }
        if (hashMap.size() == 0) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("ALTER TABLE ");
        ((StringBuilder)object).append(this.name);
        ((StringBuilder)object).append(" ADD ");
        Iterator<ColumnEntity> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            sQLiteDatabase.execSQL(new StringBuffer((CharSequence)object).append(iterator.next().getSql()).toString());
        }
    }
}

