/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.event;

import android.content.Context;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.event.TPMessageUtils;
import com.tradplus.ads.base.event.push.EventAdxPushUtil;
import com.tradplus.ads.base.event.push.EventCrossPushUtil;
import com.tradplus.ads.base.event.push.EventPushUtil;
import com.tradplus.ads.base.event.push.TrackPushUtil;
import com.tradplus.ads.base.event.timer.TPEventTimer;
import com.tradplus.ads.common.JSONHelper;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.event.EventBaseRequest;
import com.tradplus.ads.pushcenter.event.request.EventShowEndRequest;
import com.tradplus.ads.pushcenter.http.PushCenterHttpUtils;
import com.tradplus.ads.pushcenter.reqeust.BaseRequest;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TPPushCenter {
    private static volatile TPPushCenter instance;
    private ExecutorService executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private boolean enableEvent = true;
    private int maxEventNum = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPPushCenter getInstance() {
        if (instance != null) return instance;
        Class<TPPushCenter> clazz = TPPushCenter.class;
        synchronized (TPPushCenter.class) {
            if (instance != null) return instance;
            instance = new TPPushCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TPPushCenter() {
    }

    public void init(Context context) {
        PushCenterHttpUtils.init(context);
        TPEventTimer.getInstance().init();
    }

    public boolean isEnable() {
        return this.enableEvent;
    }

    public void setEnable(boolean bl) {
        this.enableEvent = bl;
    }

    public void setTime(long l2) {
        if (l2 == 0L || l2 < 5000L || l2 > 10000000L) {
            return;
        }
        TPEventTimer.getInstance().setTime(l2);
    }

    public void setMaxMessageLength(int n2) {
        if (n2 < 0) {
            this.enableEvent = false;
        }
        if (n2 == 0 || n2 < 5 || n2 > 500) {
            return;
        }
        this.maxEventNum = n2;
    }

    public void saveEvent(final BaseRequest baseRequest) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public final void run() {
                LogUtil.ownShow(JSONHelper.toJSON(baseRequest), "TradPlus  : PUSHMESSAGEARRAY");
                TPMessageUtils.saveEvent(baseRequest);
            }
        });
    }

    public void saveCrossEvent(final EventBaseRequest eventBaseRequest) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public final void run() {
                LogUtil.ownShow(JSONHelper.toJSON(eventBaseRequest), "Cross  : PUSHMESSAGEARRAY");
                TPMessageUtils.saveCrossEvent(eventBaseRequest);
            }
        });
    }

    public void saveTrackMessage(final String string, final EventShowEndRequest eventShowEndRequest) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public final void run() {
                LogUtil.ownShow(JSONHelper.toJSON(eventShowEndRequest), "Cross  : PUSHMESSAGEARRAY");
                TPMessageUtils.saveTrackMessage(string, eventShowEndRequest);
            }
        });
    }

    public void saveAdxEvent(final Object object) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public final void run() {
                LogUtil.ownShow(JSONHelper.toJSON(object), "Adx  : PUSHMESSAGEARRAY");
                StoreManager.saveAdxEvent(object);
            }
        });
    }

    public void pushEvent(final BaseRequest baseRequest) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public final void run() {
                LogUtil.ownShow(JSONHelper.toJSON(baseRequest), "TradPlus  : PUSHMESSAGEARRAY");
                new EventPushUtil().pushSingleEvent(baseRequest);
            }
        });
    }

    public void pushCrossEvent(final EventBaseRequest eventBaseRequest) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public final void run() {
                LogUtil.ownShow(JSONHelper.toJSON(eventBaseRequest), "Cross  : PUSHMESSAGEARRAY");
                new EventCrossPushUtil().pushSingleEvent(eventBaseRequest);
            }
        });
    }

    public void pushTrackEvent(final String string, final EventShowEndRequest eventShowEndRequest) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public final void run() {
                LogUtil.ownShow(JSONHelper.toJSON(eventShowEndRequest), "Cross  : PUSHMESSAGEARRAY");
                TrackPushUtil.pushTracks(string, eventShowEndRequest);
            }
        });
    }

    public void pushAdxEvent(final Object object) {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public final void run() {
                LogUtil.ownShow(JSONHelper.toJSON(object), "Adx  : PUSHMESSAGEARRAY");
                new EventAdxPushUtil().pushSingleEvent(object);
            }
        });
    }

    public boolean sendGroupMeesageToServer() {
        if (this.isEnable()) {
            this.pushEvent();
            this.pushCrossEvent();
            this.pushAdxEvent();
            this.pushTrackToServer();
        }
        return this.enableEvent;
    }

    private void pushCrossEvent() {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public final void run() {
                new EventCrossPushUtil().pushEvent(TPPushCenter.this.maxEventNum);
            }
        });
    }

    private void pushAdxEvent() {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public final void run() {
                new EventAdxPushUtil().pushEvent(TPPushCenter.this.maxEventNum);
            }
        });
    }

    private void pushTrackToServer() {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public final void run() {
                TrackPushUtil.pushTrack(TPPushCenter.this.maxEventNum);
            }
        });
    }

    public void pushEvent() {
        if (!this.isEnable()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public final void run() {
                new EventPushUtil().pushEvent(TPPushCenter.this.maxEventNum);
            }
        });
    }
}

