/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.text.TextUtils;
import android.widget.ImageView;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.network.Networking;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.toolbox.ImageLoader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class NativeImageHelper {
    public static void preCacheImages(Context object, List<String> object2, ImageListener object3) {
        object = Networking.getImageLoader((Context)object);
        Object object4 = new AtomicInteger(object2.size());
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        object3 = new ImageLoader.ImageListener((AtomicInteger)object4, atomicBoolean, (ImageListener)object3){
            final /* synthetic */ AtomicInteger a;
            final /* synthetic */ AtomicBoolean b;
            final /* synthetic */ ImageListener c;
            {
                this.a = atomicInteger;
                this.b = atomicBoolean;
                this.c = imageListener;
            }

            @Override
            public final void onResponse(ImageLoader.ImageContainer imageContainer, boolean bl) {
                if (imageContainer.getBitmap() != null && this.a.decrementAndGet() == 0 && !this.b.get()) {
                    this.c.onImagesCached();
                }
            }

            @Override
            public final void onErrorResponse(VolleyError volleyError) {
                LogUtil.show("Failed to download a native ads image:", volleyError);
                this.b.getAndSet(true);
                this.a.decrementAndGet();
            }
        };
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object4 = (String)object2.next();
            if (TextUtils.isEmpty((CharSequence)object4)) {
                atomicBoolean.set(true);
                return;
            }
            ((ImageLoader)object).get((String)object4, (ImageLoader.ImageListener)object3);
        }
    }

    public static void loadImageView(String string, final ImageView imageView) {
        if (!Preconditions.NoThrow.checkNotNull(imageView, "Cannot load image into null ImageView")) {
            return;
        }
        if (!Preconditions.NoThrow.checkNotNull(string, "Cannot load image with null url")) {
            imageView.setImageDrawable(null);
            return;
        }
        Networking.getImageLoader(imageView.getContext()).get(string, new ImageLoader.ImageListener(){

            @Override
            public final void onResponse(ImageLoader.ImageContainer imageContainer, boolean bl) {
                if (!bl) {
                    LogUtil.show("Image was not loaded immediately into your ad view. You should call preCacheImages as part of your custom event loading process.");
                }
                imageView.setImageBitmap(imageContainer.getBitmap());
            }

            @Override
            public final void onErrorResponse(VolleyError volleyError) {
                LogUtil.show("Failed to load image.", volleyError);
                imageView.setImageDrawable(null);
            }
        });
    }

    public static interface ImageListener {
        public void onImagesCached();

        public void onImagesFailedToCache(TPError var1);
    }
}

