/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Views;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class VisibilityTracker {
    private final ArrayList<View> c;
    private long d = 0L;
    @VisibleForTesting
    final ViewTreeObserver.OnPreDrawListener a;
    @VisibleForTesting
    WeakReference<ViewTreeObserver> b;
    private final Map<View, a> e;
    private final VisibilityChecker f;
    private VisibilityTrackerListener g;
    private final b h;
    private final Handler i;
    private boolean j;

    public VisibilityTracker(Context context) {
        this(context, new WeakHashMap<View, a>(10), new VisibilityChecker(), new Handler());
    }

    @VisibleForTesting
    private VisibilityTracker(Context context, Map<View, a> map, VisibilityChecker visibilityChecker, Handler handler) {
        this.e = map;
        this.f = visibilityChecker;
        this.i = handler;
        this.h = new b();
        this.c = new ArrayList(50);
        this.a = new ViewTreeObserver.OnPreDrawListener(){

            public final boolean onPreDraw() {
                VisibilityTracker.this.scheduleVisibilityCheck();
                return true;
            }
        };
        this.b = new WeakReference<Object>(null);
        this.a(context, null);
    }

    private void a(Context context, View view) {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.b.get();
        if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
            return;
        }
        if ((context = Views.getTopmostView(context, view)) == null) {
            LogUtil.show("Unable to set Visibility Tracker due to no available root view.");
            return;
        }
        if (!(context = context.getViewTreeObserver()).isAlive()) {
            LogUtil.show("Visibility Tracker was unable to track views because the root view tree observer was not alive");
            return;
        }
        this.b = new WeakReference<Context>(context);
        context.addOnPreDrawListener(this.a);
    }

    public void setVisibilityTrackerListener(VisibilityTrackerListener visibilityTrackerListener) {
        this.g = visibilityTrackerListener;
    }

    public void addView(View view, int n2, Integer n3) {
        View view2 = view;
        this.addView(view2, view2, n2, n3);
    }

    public void addView(View view, View view2, int n2, Integer n3) {
        int n4 = n2;
        this.addView(view, view2, n4, n4, n3);
    }

    public void addView(View object, View view, int n2, int n3, Integer n4) {
        this.a(view.getContext(), view);
        a a2 = this.e.get(view);
        if (a2 == null) {
            a2 = new a();
            this.e.put(view, a2);
            this.scheduleVisibilityCheck();
        }
        int n5 = Math.min(n3, n2);
        a2.d = object;
        a2.a = n2;
        a2.b = n5;
        a2.c = this.d++;
        a2.e = n4;
        if (this.d % 50L == 0L) {
            VisibilityTracker visibilityTracker = this;
            long l2 = visibilityTracker.d - 50L;
            object = visibilityTracker;
            for (Map.Entry<View, a> entry : visibilityTracker.e.entrySet()) {
                if (entry.getValue().c >= l2) continue;
                ((VisibilityTracker)object).c.add(entry.getKey());
            }
            for (View view2 : ((VisibilityTracker)object).c) {
                ((VisibilityTracker)object).removeView(view2);
            }
            ((VisibilityTracker)object).c.clear();
        }
    }

    public void removeView(View view) {
        this.e.remove(view);
    }

    public void clear() {
        this.e.clear();
        this.i.removeMessages(0);
        this.j = false;
    }

    public void destroy() {
        this.clear();
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.b.get();
        if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
            viewTreeObserver.removeOnPreDrawListener(this.a);
        }
        this.b.clear();
        this.g = null;
    }

    public void scheduleVisibilityCheck() {
        if (this.j) {
            return;
        }
        this.j = true;
        this.i.postDelayed((Runnable)this.h, 100L);
    }

    static /* synthetic */ boolean a(VisibilityTracker visibilityTracker) {
        visibilityTracker.j = false;
        return false;
    }

    public static class VisibilityChecker {
        private final Rect a = new Rect();

        public boolean hasRequiredTimeElapsed(long l2, int n2) {
            return SystemClock.uptimeMillis() - l2 >= (long)n2;
        }

        public boolean isVisible(View view, View view2, int n2, Integer n3) {
            if (view2 == null || view2.getVisibility() != 0 || view.getParent() == null) {
                return false;
            }
            if (!view2.getGlobalVisibleRect(this.a)) {
                return false;
            }
            long l2 = (long)this.a.height() * (long)this.a.width();
            long l3 = (long)view2.getHeight() * (long)view2.getWidth();
            if (l3 <= 0L) {
                return false;
            }
            if (n3 != null && n3 > 0) {
                return l2 >= (long)n3.intValue();
            }
            return 100L * l2 >= (long)n2 * l3;
        }
    }

    final class b
    implements Runnable {
        private final ArrayList<View> b;
        private final ArrayList<View> c = new ArrayList();

        b() {
            this.b = new ArrayList();
        }

        @Override
        public final void run() {
            VisibilityTracker.a(VisibilityTracker.this);
            for (Map.Entry entry : VisibilityTracker.this.e.entrySet()) {
                View view = (View)entry.getKey();
                int n2 = ((a)entry.getValue()).a;
                int n3 = ((a)entry.getValue()).b;
                Integer n4 = ((a)entry.getValue()).e;
                View view2 = ((a)entry.getValue()).d;
                if (VisibilityTracker.this.f.isVisible(view2, view, n2, n4)) {
                    this.b.add(view);
                    continue;
                }
                if (VisibilityTracker.this.f.isVisible(view2, view, n3, null)) continue;
                this.c.add(view);
            }
            if (VisibilityTracker.this.g != null) {
                VisibilityTracker.this.g.onVisibilityChanged(this.b, this.c);
            }
            this.b.clear();
            this.c.clear();
        }
    }

    static final class a {
        int a;
        int b;
        long c;
        View d;
        Integer e;

        a() {
        }
    }

    public static interface VisibilityTrackerListener {
        public void onVisibilityChanged(List<View> var1, List<View> var2);
    }
}

