/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class BaseEvent {
    private final ScribeCategory a;
    private final Name b;
    private final Category c;
    private final SdkProduct d;
    private final String e;
    private final String f;
    private final String g;
    private final String h;
    private final Double i;
    private final Double j;
    private final String k;
    private final Integer l;
    private final Integer m;
    private final Double n;
    private final Double o;
    private final Double p;
    private final ClientMetadata.TPNetworkType q;
    private final String r;
    private final String s;
    private final String t;
    private final String u;
    private final String v;
    private final String w;
    private final Double x;
    private final String y;
    private final Integer z;
    private final String A;
    private final Integer B;
    private final long C;
    private ClientMetadata D;
    private final double E;

    public BaseEvent(Builder builder) {
        Preconditions.checkNotNull(builder);
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
        this.d = builder.d;
        this.e = builder.e;
        this.f = builder.f;
        this.g = builder.g;
        this.h = builder.h;
        this.i = builder.i;
        this.j = builder.j;
        this.k = builder.k;
        this.n = builder.l;
        this.o = builder.m;
        this.p = builder.n;
        this.x = builder.o;
        this.y = builder.p;
        this.z = builder.q;
        this.A = builder.r;
        this.B = builder.s;
        this.E = builder.t;
        this.C = System.currentTimeMillis();
        this.D = ClientMetadata.getInstance();
        if (this.D != null) {
            this.l = this.D.getDeviceScreenWidthDip();
            this.m = this.D.getDeviceScreenHeightDip();
            this.q = this.D.getActiveNetworkType();
            this.r = this.D.getNetworkOperator();
            this.s = this.D.getNetworkOperatorName();
            this.t = this.D.getIsoCountryCode();
            this.u = this.D.getSimOperator();
            this.v = this.D.getSimOperatorName();
            this.w = this.D.getSimIsoCountryCode();
            return;
        }
        this.l = null;
        this.m = null;
        this.q = null;
        this.r = null;
        this.s = null;
        this.t = null;
        this.u = null;
        this.v = null;
        this.w = null;
    }

    public ScribeCategory getScribeCategory() {
        return this.a;
    }

    public Name getName() {
        return this.b;
    }

    public Category getCategory() {
        return this.c;
    }

    public SdkProduct getSdkProduct() {
        return this.d;
    }

    public String getSdkVersion() {
        if (this.D == null) {
            return null;
        }
        return this.D.getSdkVersion();
    }

    public String getAdUnitId() {
        return this.e;
    }

    public String getAdCreativeId() {
        return this.f;
    }

    public String getDspCreativeId() {
        return this.k;
    }

    public String getAdType() {
        return this.g;
    }

    public String getAdNetworkType() {
        return this.h;
    }

    public Double getAdWidthPx() {
        return this.i;
    }

    public Double getAdHeightPx() {
        return this.j;
    }

    public AppPlatform getAppPlatform() {
        return AppPlatform.ANDROID;
    }

    public String getAppName() {
        if (this.D == null) {
            return null;
        }
        return this.D.getAppName();
    }

    public String getAppPackageName() {
        if (this.D == null) {
            return null;
        }
        return this.D.getAppPackageName();
    }

    public String getAppVersion() {
        if (this.D == null) {
            return null;
        }
        return this.D.getAppVersion();
    }

    public String getObfuscatedClientAdvertisingId() {
        return "ifa:XXXX";
    }

    public Boolean getClientDoNotTrack() {
        return this.D == null || this.D.isDoNotTrackSet();
    }

    public String getDeviceManufacturer() {
        if (this.D == null) {
            return null;
        }
        return this.D.getDeviceManufacturer();
    }

    public String getDeviceModel() {
        if (this.D == null) {
            return null;
        }
        return this.D.getDeviceModel();
    }

    public String getDeviceProduct() {
        if (this.D == null) {
            return null;
        }
        return this.D.getDeviceProduct();
    }

    public String getDeviceOsVersion() {
        if (this.D == null) {
            return null;
        }
        return this.D.getDeviceOsVersion();
    }

    public Integer getDeviceScreenWidthDip() {
        return this.l;
    }

    public Integer getDeviceScreenHeightDip() {
        return this.m;
    }

    public Double getGeoLat() {
        return this.n;
    }

    public Double getGeoLon() {
        return this.o;
    }

    public Double getGeoAccuracy() {
        return this.p;
    }

    public Double getPerformanceDurationMs() {
        return this.x;
    }

    public ClientMetadata.TPNetworkType getNetworkType() {
        return this.q;
    }

    public String getNetworkOperatorCode() {
        return this.r;
    }

    public String getNetworkOperatorName() {
        return this.s;
    }

    public String getNetworkIsoCountryCode() {
        return this.t;
    }

    public String getNetworkSimCode() {
        return this.u;
    }

    public String getNetworkSimOperatorName() {
        return this.v;
    }

    public String getNetworkSimIsoCountryCode() {
        return this.w;
    }

    public String getRequestId() {
        return this.y;
    }

    public Integer getRequestStatusCode() {
        return this.z;
    }

    public String getRequestUri() {
        return this.A;
    }

    public Integer getRequestRetries() {
        return this.B;
    }

    public double getSamplingRate() {
        return this.E;
    }

    public Long getTimestampUtcMs() {
        return this.C;
    }

    public String toString() {
        return "BaseEvent\nScribeCategory: " + (Object)((Object)this.getScribeCategory()) + "\nName: " + (Object)((Object)this.getName()) + "\nCategory: " + (Object)((Object)this.getCategory()) + "\nSdkProduct: " + (Object)((Object)this.getSdkProduct()) + "\nSdkVersion: " + this.getSdkVersion() + "\nAdUnitId: " + this.getAdUnitId() + "\nAdCreativeId: " + this.getAdCreativeId() + "\nAdType: " + this.getAdType() + "\nAdNetworkType: " + this.getAdNetworkType() + "\nAdWidthPx: " + this.getAdWidthPx() + "\nAdHeightPx: " + this.getAdHeightPx() + "\nDspCreativeId: " + this.getDspCreativeId() + "\nAppPlatform: " + (Object)((Object)this.getAppPlatform()) + "\nAppName: " + this.getAppName() + "\nAppPackageName: " + this.getAppPackageName() + "\nAppVersion: " + this.getAppVersion() + "\nDeviceManufacturer: " + this.getDeviceManufacturer() + "\nDeviceModel: " + this.getDeviceModel() + "\nDeviceProduct: " + this.getDeviceProduct() + "\nDeviceOsVersion: " + this.getDeviceOsVersion() + "\nDeviceScreenWidth: " + this.getDeviceScreenWidthDip() + "\nDeviceScreenHeight: " + this.getDeviceScreenHeightDip() + "\nGeoLat: " + this.getGeoLat() + "\nGeoLon: " + this.getGeoLon() + "\nGeoAccuracy: " + this.getGeoAccuracy() + "\nPerformanceDurationMs: " + this.getPerformanceDurationMs() + "\nNetworkType: " + (Object)((Object)this.getNetworkType()) + "\nNetworkOperatorCode: " + this.getNetworkOperatorCode() + "\nNetworkOperatorName: " + this.getNetworkOperatorName() + "\nNetworkIsoCountryCode: " + this.getNetworkIsoCountryCode() + "\nNetworkSimCode: " + this.getNetworkSimCode() + "\nNetworkSimOperatorName: " + this.getNetworkSimOperatorName() + "\nNetworkSimIsoCountryCode: " + this.getNetworkSimIsoCountryCode() + "\nRequestId: " + this.getRequestId() + "\nRequestStatusCode: " + this.getRequestStatusCode() + "\nRequestUri: " + this.getRequestUri() + "\nRequestRetries: " + this.getRequestRetries() + "\nSamplingRate: " + this.getSamplingRate() + "\nTimestampUtcMs: " + new SimpleDateFormat().format(new Date(this.getTimestampUtcMs())) + "\n";
    }

    public static abstract class Builder {
        private ScribeCategory a;
        private Name b;
        private Category c;
        private SdkProduct d;
        private String e;
        private String f;
        private String g;
        private String h;
        private Double i;
        private Double j;
        private String k;
        private Double l;
        private Double m;
        private Double n;
        private Double o;
        private String p;
        private Integer q;
        private String r;
        private Integer s;
        private double t;

        public Builder(ScribeCategory scribeCategory, Name name, Category category, double d2) {
            Preconditions.checkNotNull((Object)scribeCategory);
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)category);
            Preconditions.checkArgument(d2 >= 0.0 && d2 <= 1.0);
            this.a = scribeCategory;
            this.b = name;
            this.c = category;
            this.t = d2;
        }

        public Builder withSdkProduct(SdkProduct sdkProduct) {
            this.d = sdkProduct;
            return this;
        }

        public Builder withAdUnitId(String string) {
            this.e = string;
            return this;
        }

        public Builder withAdCreativeId(String string) {
            this.f = string;
            return this;
        }

        public Builder withAdType(String string) {
            this.g = string;
            return this;
        }

        public Builder withAdNetworkType(String string) {
            this.h = string;
            return this;
        }

        public Builder withAdWidthPx(Double d2) {
            this.i = d2;
            return this;
        }

        public Builder withAdHeightPx(Double d2) {
            this.j = d2;
            return this;
        }

        public Builder withDspCreativeId(String string) {
            this.k = string;
            return this;
        }

        public Builder withGeoLat(Double d2) {
            this.l = d2;
            return this;
        }

        public Builder withGeoLon(Double d2) {
            this.m = d2;
            return this;
        }

        public Builder withGeoAccuracy(Double d2) {
            this.n = d2;
            return this;
        }

        public Builder withPerformanceDurationMs(Double d2) {
            this.o = d2;
            return this;
        }

        public Builder withRequestId(String string) {
            this.p = string;
            return this;
        }

        public Builder withRequestStatusCode(Integer n2) {
            this.q = n2;
            return this;
        }

        public Builder withRequestUri(String string) {
            this.r = string;
            return this;
        }

        public Builder withRequestRetries(Integer n2) {
            this.s = n2;
            return this;
        }

        public abstract BaseEvent build();
    }

    public static enum SamplingRate {
        AD_REQUEST,
        NATIVE_VIDEO,
        AD_INTERACTIONS;

        private final double a;

        private SamplingRate(double d2) {
            this.a = 0.1;
        }

        public final double getSamplingRate() {
            return this.a;
        }
    }

    public static enum Category {
        REQUESTS("requests"),
        NATIVE_VIDEO("native_video"),
        AD_INTERACTIONS("ad_interactions");

        private final String a;

        private Category(String string2) {
            this.a = string2;
        }

        public final String getCategory() {
            return this.a;
        }
    }

    public static enum Name {
        AD_REQUEST("ad_request"),
        REQ_REQUEST("req_request"),
        IMPRESSION_REQUEST("impression_request"),
        CLICK_REQUEST("click_request"),
        VIDEOFIN_REQUEST("videoFin_request"),
        DOWNLOAD_START("download_start"),
        DOWNLOAD_VIDEO_READY("download_video_ready"),
        DOWNLOAD_BUFFERING("download_video_buffering"),
        DOWNLOAD_FINISHED("download_finished"),
        ERROR_DURING_PLAYBACK("error_during_playback"),
        ERROR_FAILED_TO_PLAY("error_failed_to_play"),
        AD_DWELL_TIME("clickthrough_dwell_time");

        private final String a;

        private Name(String string2) {
            this.a = string2;
        }

        public final String getName() {
            return this.a;
        }
    }

    public static enum AppPlatform {
        NONE(0),
        IOS(1),
        ANDROID(2),
        MOBILE_WEB(3);

        private final int a;

        private AppPlatform(int n3) {
            this.a = n3;
        }

        public final int getType() {
            return this.a;
        }
    }

    public static enum SdkProduct {
        NONE(0),
        WEB_VIEW(1),
        NATIVE(2);

        private final int a;

        private SdkProduct(int n3) {
            this.a = n3;
        }

        public final int getType() {
            return this.a;
        }
    }

    public static enum ScribeCategory {
        EXCHANGE_CLIENT_EVENT("exchange_client_event"),
        EXCHANGE_CLIENT_ERROR("exchange_client_error");

        private final String a;

        private ScribeCategory(String string2) {
            this.a = string2;
        }

        public final String getCategory() {
            return this.a;
        }
    }
}

