/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.volley;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import com.tradplus.ads.volley.Cache;
import com.tradplus.ads.volley.DefaultRetryPolicy;
import com.tradplus.ads.volley.NetworkResponse;
import com.tradplus.ads.volley.RequestQueue;
import com.tradplus.ads.volley.Response;
import com.tradplus.ads.volley.RetryPolicy;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.VolleyLog;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;

public abstract class Request<T>
implements Comparable<Request<T>> {
    private static final String DEFAULT_PARAMS_ENCODING = "UTF-8";
    private final VolleyLog.a mEventLog = VolleyLog.a.ENABLED ? new VolleyLog.a() : null;
    private final int mMethod;
    private final String mUrl;
    private final int mDefaultTrafficStatsTag;
    private final Response.ErrorListener mErrorListener;
    private Integer mSequence;
    private RequestQueue mRequestQueue;
    private boolean mShouldCache = true;
    private boolean mCanceled = false;
    private boolean mResponseDelivered = false;
    private long mRequestBirthTime = 0L;
    private static final long SLOW_REQUEST_THRESHOLD_MS = 3000L;
    private RetryPolicy mRetryPolicy;
    private Cache.Entry mCacheEntry = null;
    private Object mTag;

    @Deprecated
    public Request(String string, Response.ErrorListener errorListener) {
        this(-1, string, errorListener);
    }

    public Request(int n2, String string, Response.ErrorListener errorListener) {
        this.mMethod = n2;
        this.mUrl = string;
        this.mErrorListener = errorListener;
        this.setRetryPolicy(new DefaultRetryPolicy());
        this.mDefaultTrafficStatsTag = Request.findDefaultTrafficStatsTag(string);
    }

    public int getMethod() {
        return this.mMethod;
    }

    public Request<?> setTag(Object object) {
        this.mTag = object;
        return this;
    }

    public Object getTag() {
        return this.mTag;
    }

    public Response.ErrorListener getErrorListener() {
        return this.mErrorListener;
    }

    public int getTrafficStatsTag() {
        return this.mDefaultTrafficStatsTag;
    }

    private static int findDefaultTrafficStatsTag(String string) {
        if (!TextUtils.isEmpty((CharSequence)string) && (string = Uri.parse((String)string)) != null && (string = string.getHost()) != null) {
            return string.hashCode();
        }
        return 0;
    }

    public Request<?> setRetryPolicy(RetryPolicy retryPolicy) {
        this.mRetryPolicy = retryPolicy;
        return this;
    }

    public void addMarker(String string) {
        if (VolleyLog.a.ENABLED) {
            this.mEventLog.add(string, Thread.currentThread().getId());
            return;
        }
        if (this.mRequestBirthTime == 0L) {
            this.mRequestBirthTime = SystemClock.elapsedRealtime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish(final String string) {
        if (this.mRequestQueue != null) {
            Object object = this;
            RequestQueue requestQueue = this.mRequestQueue;
            Object object2 = requestQueue.b;
            synchronized (object2) {
                requestQueue.b.remove(object);
            }
            if (((Request)object).shouldCache()) {
                object2 = requestQueue.a;
                synchronized (object2) {
                    object = ((Request)object).getCacheKey();
                    Queue<Request<?>> queue = requestQueue.a.remove(object);
                    if (queue != null) {
                        if (VolleyLog.DEBUG) {
                            VolleyLog.v("Releasing %d waiting requests for cacheKey=%s.", queue.size(), object);
                        }
                        requestQueue.c.addAll(queue);
                    }
                }
            }
        }
        if (VolleyLog.a.ENABLED) {
            final long l2 = Thread.currentThread().getId();
            if (Looper.myLooper() != Looper.getMainLooper()) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public final void run() {
                        Request.this.mEventLog.add(string, l2);
                        Request.this.mEventLog.finish(this.toString());
                    }
                });
                return;
            }
            this.mEventLog.add(string, l2);
            this.mEventLog.finish(this.toString());
            return;
        }
        long l3 = SystemClock.elapsedRealtime() - this.mRequestBirthTime;
        if (l3 >= 3000L) {
            VolleyLog.d("%d ms: %s", l3, this.toString());
        }
    }

    public Request<?> setRequestQueue(RequestQueue requestQueue) {
        this.mRequestQueue = requestQueue;
        return this;
    }

    public final Request<?> setSequence(int n2) {
        this.mSequence = n2;
        return this;
    }

    public final int getSequence() {
        if (this.mSequence == null) {
            throw new IllegalStateException("getSequence called before setSequence");
        }
        return this.mSequence;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getCacheKey() {
        return this.getUrl();
    }

    public Request<?> setCacheEntry(Cache.Entry entry) {
        this.mCacheEntry = entry;
        return this;
    }

    public Cache.Entry getCacheEntry() {
        return this.mCacheEntry;
    }

    public void cancel() {
        this.mCanceled = true;
    }

    public boolean isCanceled() {
        return this.mCanceled;
    }

    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    @Deprecated
    protected Map<String, String> getPostParams() {
        return this.getParams();
    }

    @Deprecated
    protected String getPostParamsEncoding() {
        return this.getParamsEncoding();
    }

    @Deprecated
    public String getPostBodyContentType() {
        return this.getBodyContentType();
    }

    @Deprecated
    public byte[] getPostBody() {
        Map<String, String> map = this.getPostParams();
        if (map != null && map.size() > 0) {
            return this.encodeParameters(map, this.getPostParamsEncoding());
        }
        return null;
    }

    protected Map<String, String> getParams() {
        return null;
    }

    protected String getParamsEncoding() {
        return DEFAULT_PARAMS_ENCODING;
    }

    public String getBodyContentType() {
        return "application/x-www-form-urlencoded; charset=" + this.getParamsEncoding();
    }

    public byte[] getBody() {
        Map<String, String> map = this.getParams();
        if (map != null && map.size() > 0) {
            return this.encodeParameters(map, this.getParamsEncoding());
        }
        return null;
    }

    private byte[] encodeParameters(Map<String, String> object, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry entry : object.entrySet()) {
                stringBuilder.append(URLEncoder.encode((String)entry.getKey(), string));
                stringBuilder.append('=');
                stringBuilder.append(URLEncoder.encode((String)entry.getValue(), string));
                stringBuilder.append('&');
            }
            return stringBuilder.toString().getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Encoding not supported: ".concat(String.valueOf(string)), unsupportedEncodingException);
        }
    }

    public final Request<?> setShouldCache(boolean bl) {
        this.mShouldCache = bl;
        return this;
    }

    public final boolean shouldCache() {
        return this.mShouldCache;
    }

    public Priority getPriority() {
        return Priority.NORMAL;
    }

    public final int getTimeoutMs() {
        return this.mRetryPolicy.getCurrentTimeout();
    }

    public RetryPolicy getRetryPolicy() {
        return this.mRetryPolicy;
    }

    public void markDelivered() {
        this.mResponseDelivered = true;
    }

    public boolean hasHadResponseDelivered() {
        return this.mResponseDelivered;
    }

    protected abstract Response<T> parseNetworkResponse(NetworkResponse var1);

    protected VolleyError parseNetworkError(VolleyError volleyError) {
        return volleyError;
    }

    protected abstract void deliverResponse(T var1);

    public void deliverError(VolleyError volleyError) {
        if (this.mErrorListener != null) {
            this.mErrorListener.onErrorResponse(volleyError);
        }
    }

    @Override
    public int compareTo(Request<T> request) {
        Priority priority;
        Priority priority2 = this.getPriority();
        if (priority2 == (priority = request.getPriority())) {
            return this.mSequence - request.mSequence;
        }
        return priority.ordinal() - priority2.ordinal();
    }

    public String toString() {
        String string = "0x" + Integer.toHexString(this.getTrafficStatsTag());
        return (this.mCanceled ? "[X] " : "[ ] ") + this.getUrl() + " " + string + " " + (Object)((Object)this.getPriority()) + " " + this.mSequence;
    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH,
        IMMEDIATE;

    }

    public static interface Method {
        public static final int DEPRECATED_GET_OR_POST = -1;
        public static final int GET = 0;
        public static final int POST = 1;
        public static final int PUT = 2;
        public static final int DELETE = 3;
        public static final int HEAD = 4;
        public static final int OPTIONS = 5;
        public static final int TRACE = 6;
        public static final int PATCH = 7;
    }
}

