/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.volley;

import android.os.Handler;
import android.os.Looper;
import com.tradplus.ads.volley.Cache;
import com.tradplus.ads.volley.CacheDispatcher;
import com.tradplus.ads.volley.ExecutorDelivery;
import com.tradplus.ads.volley.Network;
import com.tradplus.ads.volley.NetworkDispatcher;
import com.tradplus.ads.volley.Request;
import com.tradplus.ads.volley.ResponseDelivery;
import com.tradplus.ads.volley.VolleyLog;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestQueue {
    private AtomicInteger d = new AtomicInteger();
    final Map<String, Queue<Request<?>>> a = new HashMap();
    final Set<Request<?>> b = new HashSet();
    final PriorityBlockingQueue<Request<?>> c = new PriorityBlockingQueue();
    private final PriorityBlockingQueue<Request<?>> e = new PriorityBlockingQueue();
    private final Cache f;
    private final Network g;
    private final ResponseDelivery h;
    private NetworkDispatcher[] i;
    private CacheDispatcher j;

    public RequestQueue(Cache cache, Network network, int n2, ResponseDelivery responseDelivery) {
        this.f = cache;
        this.g = network;
        this.i = new NetworkDispatcher[n2];
        this.h = responseDelivery;
    }

    public RequestQueue(Cache cache, Network network, int n2) {
        this(cache, network, n2, new ExecutorDelivery(new Handler(Looper.getMainLooper())));
    }

    public RequestQueue(Cache cache, Network network) {
        this(cache, network, 4);
    }

    public void start() {
        this.stop();
        this.j = new CacheDispatcher(this.c, this.e, this.f, this.h);
        this.j.start();
        for (int i2 = 0; i2 < this.i.length; ++i2) {
            NetworkDispatcher networkDispatcher;
            this.i[i2] = networkDispatcher = new NetworkDispatcher(this.e, this.g, this.f, this.h);
            networkDispatcher.start();
        }
    }

    public void stop() {
        if (this.j != null) {
            this.j.quit();
        }
        for (int i2 = 0; i2 < this.i.length; ++i2) {
            if (this.i[i2] == null) continue;
            this.i[i2].quit();
        }
    }

    public int getSequenceNumber() {
        return this.d.incrementAndGet();
    }

    public Cache getCache() {
        return this.f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll(RequestFilter requestFilter) {
        Set<Request<?>> set = this.b;
        synchronized (set) {
            for (Request<?> request : this.b) {
                if (!requestFilter.apply(request)) continue;
                request.cancel();
            }
            return;
        }
    }

    public void cancelAll(final Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot cancelAll with a null tag");
        }
        this.cancelAll(new RequestFilter(){

            @Override
            public final boolean apply(Request<?> request) {
                return request.getTag() == object;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Request<T> add(Request<T> request) {
        request.setRequestQueue(this);
        Object object = this.b;
        synchronized (object) {
            this.b.add(request);
        }
        request.setSequence(this.getSequenceNumber());
        request.addMarker("add-to-queue");
        if (!request.shouldCache()) {
            this.e.add(request);
            return request;
        }
        object = this.a;
        synchronized (object) {
            String string = request.getCacheKey();
            if (this.a.containsKey(string)) {
                Queue<Request<?>> queue = this.a.get(string);
                if (queue == null) {
                    queue = new LinkedList();
                }
                queue.add(request);
                this.a.put(string, queue);
                if (VolleyLog.DEBUG) {
                    VolleyLog.v("Request for cacheKey=%s is in flight, putting on hold.", string);
                }
            } else {
                this.a.put(string, null);
                this.c.add(request);
            }
            return request;
        }
    }

    public static interface RequestFilter {
        public boolean apply(Request<?> var1);
    }
}

