/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.adapter.nativead;

import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.AdapterCheckTimeOut;
import com.tradplus.ads.base.common.TPAllImageLoader;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.network.response.ConfigResponse;
import java.util.ArrayList;

public abstract class TPNativeAdapter
extends TPBaseAdapter {
    private static final long TIME_DELTA = 30000L;
    private AdapterCheckTimeOut mCheckTimeOut;

    @Override
    public boolean isReady() {
        return false;
    }

    @Override
    public void init() {
        ConfigResponse.WaterfallBean waterfallBean = this.getWaterfallBean();
        if (waterfallBean == null) {
            return;
        }
        long l2 = waterfallBean.getAdValidTime();
        if (l2 <= 0L) {
            return;
        }
        this.mCheckTimeOut = new AdapterCheckTimeOut(30000L);
        this.mCheckTimeOut.setValidTime(l2 * 1000L);
    }

    public void setFirstLoadedTime() {
        if (this.mCheckTimeOut != null) {
            this.mCheckTimeOut.setFirstLoadTime();
        }
    }

    public boolean isAdsTimeOut() {
        if (this.mCheckTimeOut != null) {
            return this.mCheckTimeOut.checkIsTimeOut();
        }
        return false;
    }

    public void downloadAndCallback(final TPBaseAd tPBaseAd, boolean bl) {
        if (tPBaseAd == null) {
            return;
        }
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (!bl) {
            this.mLoadAdapterListener.loadAdapterLoaded(tPBaseAd);
            return;
        }
        ArrayList<String> arrayList = tPBaseAd.getDownloadImgUrls();
        if (arrayList != null && arrayList.size() > 0) {
            new TPAllImageLoader(arrayList, new TPAllImageLoader.OnImageLoadedListener(){

                @Override
                public final void onImageLoaded() {
                    TPNativeAdapter.this.mLoadAdapterListener.loadAdapterLoaded(tPBaseAd);
                }

                @Override
                public final void onError() {
                    TPNativeAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Third-party network failed to provide an ad."));
                }
            }).loadAllImage();
            return;
        }
        this.mLoadAdapterListener.loadAdapterLoaded(tPBaseAd);
    }
}

