/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.bean;

import android.text.TextUtils;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.mobileads.util.SegmentUtils;
import com.tradplus.ads.network.response.ConfigResponse;
import java.util.HashMap;
import java.util.Map;

public class TPAdInfo {
    public String tpAdUnitId;
    @Deprecated
    public String adUnitId;
    public String adSourceName;
    public String adNetworkId;
    public String adSourceId;
    public String ecpm;
    public String ecpmcny;
    @Deprecated
    public String ecpmExact;
    @Deprecated
    public String ecpmExactCny;
    public String ecpmLevel;
    public String ecpmPrecision;
    public long loadTime;
    @Deprecated
    public String currencyName;
    @Deprecated
    public int amount;
    public String rewardName;
    public int rewardNumber;
    public String isoCode;
    public int height;
    public int adViewHeight;
    public int adViewWidth;
    public int width;
    public Map<String, Object> rewardVerifyMap;
    public boolean isBiddingNetwork;
    public int waterfallIndex = -1;
    public String requestId;
    public String subChannel;
    public String channel;
    public String currency;
    public ConfigResponse.WaterfallBean.ConfigBean configBean;
    public String sceneId;
    public String configString;
    @Deprecated
    public String networkType;
    public String format;
    public String bucketId;
    public String segmentId;

    public TPAdInfo(String string, TPBaseAdapter tPBaseAdapter) {
        if (tPBaseAdapter == null) {
            return;
        }
        this.requestId = tPBaseAdapter.getRequestId();
        this.init(string);
        ConfigResponse.WaterfallBean waterfallBean = tPBaseAdapter.getWaterfallBean();
        if (waterfallBean == null) {
            return;
        }
        this.rewardVerifyMap = new HashMap<String, Object>();
        this.adSourceName = tPBaseAdapter.getNetworkName();
        this.adSourceId = tPBaseAdapter.getPlacementId();
        this.ecpmcny = "" + waterfallBean.getEcpm_cny();
        this.ecpm = "" + waterfallBean.getEcpm();
        this.ecpmLevel = "" + waterfallBean.getEcpmLevel();
        this.ecpmPrecision = waterfallBean.getEcpmPrecision();
        this.setExactByTPBaseAdapter(tPBaseAdapter);
        this.adNetworkId = waterfallBean.getId();
        this.loadTime = tPBaseAdapter.getLoadEndTime() - tPBaseAdapter.getLoadStartTime();
        this.isoCode = ClientMetadata.getInstance(GlobalTradPlus.getInstance().getContext()).getIsoCountryCode();
        this.height = tPBaseAdapter.getWaterfallBean().getAd_size_info().getY();
        this.width = tPBaseAdapter.getWaterfallBean().getAd_size_info().getX();
        this.isBiddingNetwork = waterfallBean.getNew_sort_type() == 9;
        this.waterfallIndex = tPBaseAdapter.getWaterFallIndex();
        this.configBean = waterfallBean.getConfigBean();
        this.configString = waterfallBean.getConfig();
        this.sceneId = tPBaseAdapter.getShowSceneId();
        this.getNetWorkTypeAndBkId(string);
        this.getNetWorkFormat(string);
        if (tPBaseAdapter instanceof TPBannerAdapter) {
            this.adViewHeight = ((TPBannerAdapter)tPBaseAdapter).getmAdViewHeight();
            this.adViewWidth = ((TPBannerAdapter)tPBaseAdapter).getmAdViewWidth();
        }
    }

    private void setExactByTPBaseAdapter(TPBaseAdapter tPBaseAdapter) {
        if (!TextUtils.isEmpty((CharSequence)this.ecpmPrecision) && this.ecpmPrecision.equals("exact") && !TextUtils.isEmpty((CharSequence)tPBaseAdapter.getPayLoadStr())) {
            try {
                this.ecpm = "" + JSON.parseObject(tPBaseAdapter.getPayLoadStr(), BiddingResponse.PayLoadInfo.class).getPrice();
                this.ecpmcny = "" + JSON.parseObject(tPBaseAdapter.getPayLoadStr(), BiddingResponse.PayLoadInfo.class).getPrice_cny();
                this.ecpmExact = "" + JSON.parseObject(tPBaseAdapter.getPayLoadStr(), BiddingResponse.PayLoadInfo.class).getPrice();
                this.ecpmExactCny = "" + JSON.parseObject(tPBaseAdapter.getPayLoadStr(), BiddingResponse.PayLoadInfo.class).getPrice_cny();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void setExactByConfigBean(ConfigResponse.WaterfallBean object, boolean bl) {
        if (!TextUtils.isEmpty((CharSequence)this.ecpmPrecision) && this.ecpmPrecision.equals("exact")) {
            if ((object = ((ConfigResponse.WaterfallBean)object).getPayLoadInfo()) != null) {
                this.ecpmExact = "" + ((BiddingResponse.PayLoadInfo)object).getPrice();
                this.ecpmExactCny = "" + ((BiddingResponse.PayLoadInfo)object).getPrice_cny();
                this.ecpm = "" + ((BiddingResponse.PayLoadInfo)object).getPrice();
                this.ecpmcny = "" + ((BiddingResponse.PayLoadInfo)object).getPrice_cny();
            } else {
                this.ecpmExact = "0";
                this.ecpmExactCny = "0";
                this.ecpm = "0";
                this.ecpmcny = "0";
            }
            if (!bl) {
                this.ecpmExact = "0";
                this.ecpmExactCny = "0";
                this.ecpm = "0";
                this.ecpmcny = "0";
            }
        }
    }

    public TPAdInfo(String string, ConfigResponse.WaterfallBean waterfallBean, long l2, String object, boolean bl) {
        if (waterfallBean == null) {
            return;
        }
        this.requestId = object;
        this.init(string);
        object = waterfallBean;
        if (object == null) {
            return;
        }
        this.rewardVerifyMap = new HashMap<String, Object>();
        this.adSourceName = ((ConfigResponse.WaterfallBean)object).getName();
        this.adSourceId = waterfallBean.getConfigBean().getPlacementId();
        this.ecpmcny = "" + ((ConfigResponse.WaterfallBean)object).getEcpm_cny();
        this.ecpm = "" + ((ConfigResponse.WaterfallBean)object).getEcpm();
        this.ecpmLevel = "" + ((ConfigResponse.WaterfallBean)object).getEcpmLevel();
        this.ecpmPrecision = ((ConfigResponse.WaterfallBean)object).getEcpmPrecision();
        this.setExactByConfigBean((ConfigResponse.WaterfallBean)object, bl);
        this.adNetworkId = ((ConfigResponse.WaterfallBean)object).getId();
        this.loadTime = System.currentTimeMillis() - l2;
        this.isoCode = ClientMetadata.getInstance(GlobalTradPlus.getInstance().getContext()).getIsoCountryCode();
        this.height = ((ConfigResponse.WaterfallBean)object).getAd_size_info().getY();
        this.width = ((ConfigResponse.WaterfallBean)object).getAd_size_info().getX();
        this.isBiddingNetwork = ((ConfigResponse.WaterfallBean)object).getNew_sort_type() == 9;
        this.configBean = ((ConfigResponse.WaterfallBean)object).getConfigBean();
        this.configString = ((ConfigResponse.WaterfallBean)object).getConfig();
        this.getNetWorkTypeAndBkId(string);
        this.getNetWorkFormat(string);
    }

    public TPAdInfo(String string, ConfigResponse.WaterfallBean waterfallBean, long l2, String string2) {
        this(string, waterfallBean, l2, string2, false);
    }

    public void init(String object) {
        TPAdInfo tPAdInfo = this;
        tPAdInfo.tpAdUnitId = tPAdInfo.adUnitId = object;
        if (SegmentUtils.customMap != null) {
            this.channel = SegmentUtils.customMap.get("channel");
            this.subChannel = SegmentUtils.customMap.get("sub_channel");
        }
        if ((object = SegmentUtils.customPlacementMap.get(this.tpAdUnitId)) != null) {
            if (!TextUtils.isEmpty((CharSequence)((String)object.get("channel")))) {
                this.channel = (String)object.get("channel");
            }
            if (!TextUtils.isEmpty((CharSequence)((String)object.get("sub_channel")))) {
                this.subChannel = (String)object.get("sub_channel");
            }
        }
    }

    public void setRewardInfo(String string, int n2) {
        TPAdInfo tPAdInfo = this;
        tPAdInfo.rewardName = tPAdInfo.currencyName = string;
        TPAdInfo tPAdInfo2 = this;
        tPAdInfo2.rewardNumber = tPAdInfo2.amount = n2;
    }

    public void setRewardVerifyMap(Map<String, Object> map) {
        if (map != null) {
            this.rewardVerifyMap.putAll(map);
        }
    }

    private void getNetWorkTypeAndBkId(String object) {
        object = ConfigLoadManager.getInstance().getLocalConfigResponse((String)object);
        if (object == null) {
            return;
        }
        this.bucketId = ((ConfigResponse)object).getBucket_id();
        this.segmentId = ((ConfigResponse)object).getSegment_id();
        int n2 = ((ConfigResponse)object).getSecType();
        if (n2 > 1) {
            switch (n2) {
                case 2: {
                    this.networkType = "Native Banner";
                    return;
                }
                case 3: {
                    this.networkType = "Native DrawVideo";
                    return;
                }
                case 4: {
                    this.networkType = "Native Splash";
                }
            }
            return;
        }
        this.networkType = ((ConfigResponse)object).getAdType();
    }

    private void getNetWorkFormat(String object) {
        object = ConfigLoadManager.getInstance().getLocalConfigResponse((String)object);
        if (object == null) {
            return;
        }
        int n2 = ((ConfigResponse)object).getSecType();
        if (n2 > 1) {
            switch (n2) {
                case 2: {
                    this.format = "native-banner";
                    return;
                }
                case 3: {
                    this.format = "native-draw";
                    return;
                }
                case 4: {
                    this.format = "native-splash";
                }
            }
            return;
        }
        String string = ((ConfigResponse)object).getAdType();
        if (TextUtils.equals((CharSequence)"interstitial-video", (CharSequence)string)) {
            this.format = "rewarded-video";
            return;
        }
        this.format = ((ConfigResponse)object).getAdType();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("----------------------\n");
        stringBuffer.append("tpAdUnitId:");
        stringBuffer.append(this.tpAdUnitId);
        stringBuffer.append("\n");
        stringBuffer.append("adSourceName:");
        stringBuffer.append(this.adSourceName);
        stringBuffer.append("\n");
        stringBuffer.append("adNetworkId:");
        stringBuffer.append(this.adNetworkId);
        stringBuffer.append("\n");
        stringBuffer.append("adSourceId:");
        stringBuffer.append(this.adSourceId);
        stringBuffer.append("\n");
        stringBuffer.append("ecpm:");
        stringBuffer.append(this.ecpm);
        stringBuffer.append("\n");
        stringBuffer.append("ecpmcny:");
        stringBuffer.append(this.ecpmcny);
        stringBuffer.append("\n");
        stringBuffer.append("ecpmExact:");
        stringBuffer.append(this.ecpmExact);
        stringBuffer.append("\n");
        stringBuffer.append("ecpmLevel:");
        stringBuffer.append(this.ecpmLevel);
        stringBuffer.append("\n");
        stringBuffer.append("ecpmPrecision:");
        stringBuffer.append(this.ecpmPrecision);
        stringBuffer.append("\n");
        stringBuffer.append("loadTime:");
        stringBuffer.append(this.loadTime);
        stringBuffer.append("\n");
        stringBuffer.append("rewardName:");
        stringBuffer.append(this.rewardName);
        stringBuffer.append("\n");
        stringBuffer.append("rewardNumber:");
        stringBuffer.append(this.rewardNumber);
        stringBuffer.append("\n");
        stringBuffer.append("isBiddingNetwork:");
        stringBuffer.append(this.isBiddingNetwork);
        stringBuffer.append("\n");
        stringBuffer.append("waterfallIndex:");
        stringBuffer.append(this.waterfallIndex);
        stringBuffer.append("\n");
        stringBuffer.append("requestId:");
        stringBuffer.append(this.requestId);
        stringBuffer.append("\n");
        stringBuffer.append("subChannel:");
        stringBuffer.append(this.subChannel);
        stringBuffer.append("\n");
        stringBuffer.append("channel:");
        stringBuffer.append(this.channel);
        stringBuffer.append("\n");
        stringBuffer.append("iso:");
        stringBuffer.append(this.isoCode);
        stringBuffer.append("\n");
        stringBuffer.append("sceneId:");
        stringBuffer.append(this.sceneId);
        stringBuffer.append("\n");
        stringBuffer.append("configString:");
        stringBuffer.append(this.configString);
        stringBuffer.append("\n");
        stringBuffer.append("networkType:");
        stringBuffer.append(this.networkType);
        stringBuffer.append("\n");
        stringBuffer.append("bucketId:");
        stringBuffer.append(this.bucketId);
        stringBuffer.append("\n");
        stringBuffer.append("segmentId:");
        stringBuffer.append(this.segmentId);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

