/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.config;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.config.TradPlusConfigUtils;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.base.filter.FrequencyUtils;
import com.tradplus.ads.common.AdFormat;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.util.b;
import com.tradplus.ads.network.Networking;
import com.tradplus.ads.network.OnConfigListener;
import com.tradplus.ads.network.TradPlusConfigRequest;
import com.tradplus.ads.network.response.ConfigResponse;
import com.tradplus.ads.pushcenter.event.request.SimplifyEvent;
import com.tradplus.ads.pushcenter.reqeust.AdconfRequest;
import com.tradplus.ads.pushcenter.utils.PushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.pushcenter.utils.SendMessageUtil;
import com.tradplus.ads.volley.RequestQueue;
import com.tradplus.ads.volley.VolleyError;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigLoadManager {
    private static final String CONFIG_AES_KEY = "tradplus";
    private static ConfigLoadManager mInstance = null;
    private ConcurrentHashMap<String, ConfigResponse> mConfigResponses = new ConcurrentHashMap();

    private ConfigLoadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized ConfigLoadManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<ConfigLoadManager> clazz = ConfigLoadManager.class;
        synchronized (ConfigLoadManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ConfigLoadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void clearConfigResponse() {
        this.mConfigResponses.clear();
    }

    public ConfigResponse getLocalConfigResponse(String string) {
        ConfigResponse configResponse = this.mConfigResponses.get(string);
        if (configResponse != null) {
            return configResponse;
        }
        GlobalTradPlus.getInstance().getContext();
        configResponse = TradPlusConfigUtils.getInstance().getConfigByUnitId(string);
        if (configResponse != null) {
            this.mConfigResponses.put(string, configResponse);
        }
        return configResponse;
    }

    public void loadConfig(String object, ConfigLoadListener object2) {
        final Context context = GlobalTradPlus.getInstance().getContext();
        Object object3 = this.mConfigResponses.get(object);
        if (object3 != null && !TradPlusConfigUtils.isIsTestModeByConfig()) {
            object2.onSuccess((ConfigResponse)object3);
            this.checkConfigTimeout(context, (String)object, (ConfigResponse)object3);
            return;
        }
        object3 = new b(context, (String)object, "", 0L);
        new b(context, (String)object, "", 0L).g = new OnConfigListener((String)object, (ConfigLoadListener)object2){
            final /* synthetic */ String b;
            final /* synthetic */ ConfigLoadListener c;
            {
                this.b = string;
                this.c = configLoadListener;
            }

            @Override
            public final void onSuccess(ConfigResponse configResponse) {
                ConfigLoadManager.this.checkConfigTimeout(context, this.b, configResponse);
                if (this.c == null) {
                    return;
                }
                if (configResponse != null) {
                    ConfigLoadManager.this.mConfigResponses.put(this.b, configResponse);
                    FrequencyUtils.getInstance().saveFrequency(configResponse.getFrequency(), this.b);
                    this.c.onSuccess(configResponse);
                    return;
                }
                this.c.onFailed(new VolleyError());
            }

            @Override
            public final void onFailed(VolleyError volleyError) {
                this.c.onFailed(volleyError);
            }
        };
        object2 = object = object3;
        SendMessageUtil.getInstance().sendLoadAdconfStart(((b)object2).b, ((b)object2).a, true);
        ((b)object2).c = new AdconfRequest(((b)object2).b, PushMessageUtils.PushStatus.EV_PRE_LOAD_ADCONF.getValue());
        ((b)object2).e = new SimplifyEvent(PushMessageUtils.PushStatus.EV_PRE_LOAD_ADCONF.getValue());
        TPTaskManager.getInstance().runNormalTask(new Runnable(){
            final /* synthetic */ boolean a;
            {
                this.a = true;
            }

            @Override
            public final void run() {
                ClientMetadata.getInstance(b.this.b).getGAIDM();
                final boolean bl = this.a;
                Object object = b.this;
                String string = ((b)object).a();
                LogUtil.ownShow("adUrl:".concat(String.valueOf(string)), "TradPlus");
                ConfigResponse configResponse = TradPlusConfigUtils.getInstance().getConfigByUnitId(((b)object).a);
                if (configResponse == null) {
                    LogUtil.ownShow("config request unitid = " + ((b)object).a, "TradPlus");
                    Object object2 = new TradPlusConfigRequest.Listener(){

                        @Override
                        public final void onSuccess(ConfigResponse configResponse) {
                            if (configResponse != null) {
                                b.a(configResponse);
                                ClientMetadata.getInstance(b.this.b).putSegmentIds(b.this.a, configResponse.getBucket_id(), configResponse.getSegment_id());
                                b.this.c.setLuid(b.this.a);
                                b.this.c.setRt("" + RequestUtils.getInstance().countRuntime(b.this.c.getCreateTime()));
                                b.this.c.setEc("1");
                                b.this.c.setCf("1");
                                b.this.e.setLuid(b.this.a);
                                b.this.e.setLt("" + RequestUtils.getInstance().countRuntime(b.this.e.getCreateTime()));
                                b.this.e.setEc("1");
                                if (configResponse.getCode() != null) {
                                    if (!configResponse.getCode().equals("0")) {
                                        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.APPID_MATCH_ADUNITAD);
                                    }
                                    b.this.c.setSc(configResponse.getCode());
                                }
                                if (bl) {
                                    TPPushCenter.getInstance().saveEvent(b.this.c);
                                    TPPushCenter.getInstance().saveEvent(b.this.e);
                                }
                                configResponse.setCreateTime(System.currentTimeMillis());
                                TradPlusConfigUtils.getInstance().setConfigByUnitId(b.this.b, b.this.a, configResponse);
                            } else {
                                b.this.c.setRt("" + RequestUtils.getInstance().countRuntime(b.this.c.getCreateTime()));
                                b.this.c.setEc("10");
                                b.this.c.setCf("1");
                                b.this.e.setLt("" + RequestUtils.getInstance().countRuntime(b.this.e.getCreateTime()));
                                b.this.e.setEc("10");
                                TPPushCenter.getInstance().saveEvent(b.this.c);
                                TPPushCenter.getInstance().saveEvent(b.this.e);
                            }
                            if (b.this.g != null) {
                                b.this.g.onSuccess(configResponse);
                            }
                        }

                        @Override
                        public final void onErrorResponse(VolleyError volleyError) {
                            Log.e((String)"TradPlus", (String)("Response is Failed,error:" + volleyError.getMessage()));
                            b.this.c.setLuid(b.this.a);
                            b.this.c.setRt("" + RequestUtils.getInstance().countRuntime(b.this.c.getCreateTime()));
                            b.this.c.setCf("1");
                            b.this.e.setLuid(b.this.a);
                            b.this.e.setLt("" + RequestUtils.getInstance().countRuntime(b.this.e.getCreateTime()));
                            if (volleyError.networkResponse != null) {
                                b.this.c.setEc(RequestUtils.getInstance().getNetWorkStatus(volleyError.networkResponse.statusCode));
                                b.this.e.setEc(RequestUtils.getInstance().getNetWorkStatus(volleyError.networkResponse.statusCode));
                            } else {
                                b.this.c.setEc("7");
                                b.this.e.setEc("7");
                            }
                            if (bl) {
                                TPPushCenter.getInstance().saveEvent(b.this.c);
                                TPPushCenter.getInstance().saveEvent(b.this.e);
                            }
                            if (b.this.g != null) {
                                b.this.g.onFailed(volleyError);
                            }
                        }
                    };
                    object2 = new TradPlusConfigRequest(string, AdFormat.INTERSTITIAL, ((b)object).a, ((b)object).b, (TradPlusConfigRequest.Listener)object2);
                    object = Networking.getThreadResultQueue(((b)object).b);
                    if (object != null) {
                        ((RequestQueue)object).add(object2);
                    }
                    return;
                }
                LogUtil.ownShow("config local unitid = " + ((b)object).a, "TradPlus");
                ClientMetadata.getInstance(((b)object).b).putSegmentIds(((b)object).a, configResponse.getBucket_id(), configResponse.getSegment_id());
                ((b)object).c.setLuid(((b)object).a);
                ((b)object).c.setRt("" + RequestUtils.getInstance().countRuntime(((b)object).c.getCreateTime()));
                ((b)object).c.setEc("1");
                ((b)object).c.setCf("2");
                ((b)object).e.setLuid(((b)object).a);
                ((b)object).e.setLt("" + RequestUtils.getInstance().countRuntime(((b)object).e.getCreateTime()));
                ((b)object).e.setEc("1");
                TPPushCenter.getInstance().saveEvent(((b)object).c);
                TPPushCenter.getInstance().saveEvent(((b)object).e);
                if (((b)object).g != null) {
                    ((b)object).g.onSuccess(configResponse);
                }
            }
        });
    }

    public void setDefaultConfig(String string, String object) {
        if (object == null || ((String)object).length() <= 0) {
            return;
        }
        Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig getLocalConfig start---------");
        ConfigResponse configResponse = this.getLocalConfigResponse(string);
        Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig getLocalConfig end---------");
        if (configResponse != null) {
            return;
        }
        if (((String)object).contains("\n")) {
            object = ((String)object).replaceAll("\n", "").replaceAll("\r", "").replaceAll(" ", "");
        }
        try {
            object = Base64.decode((byte[])((String)object).getBytes(), (int)0);
            object = new String((byte[])object, "utf-8");
            Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig decode ========");
            object = JSON.parseObject((String)object, ConfigResponse.class);
            if (object != null) {
                Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig success ========");
                this.mConfigResponses.put(string, (ConfigResponse)object);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig error ==========");
            return;
        }
    }

    public String getCurrentConfig(String object) {
        if ((object = this.getLocalConfigResponse((String)object)) == null) {
            return "";
        }
        String string = "";
        try {
            string = Base64.encodeToString((byte[])JSON.toJSONString(object).getBytes(), (int)0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private boolean checkConfigTimeout(final Context context, final String string, ConfigResponse object) {
        if (object == null) {
            return true;
        }
        long l2 = ((ConfigResponse)object).getExpires();
        long l3 = ((ConfigResponse)object).getCreateTime();
        if (System.currentTimeMillis() - l3 >= (TradPlus.isLocalDebugMode ? 300L : l2) * 1000L) {
            object = new b(context, string, ((ConfigResponse)object).getResp_uid(), ((ConfigResponse)object).getResp_time());
            v0.g = new OnConfigListener(){

                @Override
                public final void onSuccess(ConfigResponse configResponse) {
                    if (configResponse != null) {
                        ConfigResponse configResponse2 = (ConfigResponse)ConfigLoadManager.this.mConfigResponses.get(string);
                        if (configResponse.getResp_uid() != null && configResponse2 != null && configResponse.getResp_uid().equals(configResponse2.getResp_uid())) {
                            configResponse2.setCreateTime(configResponse.getCreateTime());
                            return;
                        }
                        ConfigLoadManager.this.mConfigResponses.put(string, configResponse);
                    }
                }

                @Override
                public final void onFailed(VolleyError volleyError) {
                }
            };
            TPTaskManager.getInstance().runNormalTask(new Runnable((b)object){
                final /* synthetic */ b b;
                {
                    this.b = b2;
                }

                @Override
                public final void run() {
                    ClientMetadata.getInstance(context).getGAIDM();
                    Object object = this.b;
                    SendMessageUtil.getInstance().sendLoadAdconfStart(((b)object).b, ((b)object).a, true);
                    ((b)object).d = new AdconfRequest(((b)object).b, PushMessageUtils.PushStatus.EV_PRE_LOAD_ADCONF.getValue());
                    ((b)object).f = new SimplifyEvent(PushMessageUtils.PushStatus.EV_PRE_LOAD_ADCONF.getValue());
                    Object object2 = ((b)object).a();
                    LogUtil.ownShow("adUrl:".concat(String.valueOf(object2)), "TradPlus");
                    TradPlusConfigRequest.Listener listener = new TradPlusConfigRequest.Listener(){

                        @Override
                        public final void onSuccess(ConfigResponse configResponse) {
                            if (configResponse != null) {
                                ClientMetadata clientMetadata = ClientMetadata.getInstance(b.this.b);
                                if (!configResponse.getCode().equals("201")) {
                                    configResponse.setCreateTime(System.currentTimeMillis());
                                    b.a(configResponse);
                                    TradPlusConfigUtils.getInstance().setConfigByUnitId(b.this.b, b.this.a, configResponse);
                                    b.this.d.setLuid(b.this.a);
                                    b.this.d.setRt("" + RequestUtils.getInstance().countRuntime(b.this.d.getCreateTime()));
                                    b.this.d.setEc("1");
                                    b.this.d.setCf("1");
                                    b.this.f.setLuid(b.this.a);
                                    b.this.f.setLt("" + RequestUtils.getInstance().countRuntime(b.this.f.getCreateTime()));
                                    b.this.f.setEc("1");
                                    if (!configResponse.getCode().equals("0")) {
                                        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.APPID_MATCH_ADUNITAD);
                                    }
                                    b.this.d.setSc(configResponse.getCode());
                                    TPPushCenter.getInstance().saveEvent(b.this.d);
                                    TPPushCenter.getInstance().saveEvent(b.this.f);
                                    clientMetadata.putSegmentIds(b.this.a, configResponse.getBucket_id(), configResponse.getSegment_id());
                                    if (b.this.g != null) {
                                        b.this.g.onSuccess(configResponse);
                                        return;
                                    }
                                } else {
                                    configResponse = TradPlusConfigUtils.getInstance().getConfigByUnitId(b.this.a);
                                    if (configResponse != null) {
                                        b.this.d.setLuid(b.this.a);
                                        b.this.d.setRt("" + RequestUtils.getInstance().countRuntime(b.this.d.getCreateTime()));
                                        b.this.d.setEc("1");
                                        b.this.d.setCf("1");
                                        b.this.f.setLuid(b.this.a);
                                        b.this.f.setLt("" + RequestUtils.getInstance().countRuntime(b.this.f.getCreateTime()));
                                        b.this.f.setEc("1");
                                        configResponse.setCreateTime(System.currentTimeMillis());
                                        TradPlusConfigUtils.getInstance().setConfigByUnitId(b.this.b, b.this.a, configResponse);
                                        clientMetadata.putSegmentIds(b.this.a, configResponse.getBucket_id(), configResponse.getSegment_id());
                                        TPPushCenter.getInstance().saveEvent(b.this.d);
                                        TPPushCenter.getInstance().saveEvent(b.this.f);
                                        if (b.this.g != null) {
                                            b.this.g.onSuccess(configResponse);
                                            return;
                                        }
                                    } else {
                                        b.this.d.setRt("" + RequestUtils.getInstance().countRuntime(b.this.d.getCreateTime()));
                                        b.this.d.setEc("10");
                                        b.this.d.setCf("1");
                                        b.this.f.setLt("" + RequestUtils.getInstance().countRuntime(b.this.f.getCreateTime()));
                                        b.this.f.setEc("10");
                                        TPPushCenter.getInstance().saveEvent(b.this.d);
                                        TPPushCenter.getInstance().saveEvent(b.this.f);
                                    }
                                }
                                return;
                            }
                            if (b.this.g != null) {
                                b.this.g.onFailed(null);
                            }
                        }

                        @Override
                        public final void onErrorResponse(VolleyError volleyError) {
                            Log.e((String)"TradPlus", (String)("Response is Failed,error:" + volleyError.getMessage()));
                            b.this.d.setLuid(b.this.a);
                            b.this.d.setRt("" + RequestUtils.getInstance().countRuntime(b.this.d.getCreateTime()));
                            b.this.d.setCf("1");
                            b.this.f.setLuid(b.this.a);
                            b.this.f.setLt("" + RequestUtils.getInstance().countRuntime(b.this.f.getCreateTime()));
                            if (volleyError.networkResponse != null) {
                                b.this.d.setEc(RequestUtils.getInstance().getNetWorkStatus(volleyError.networkResponse.statusCode));
                                b.this.f.setEc(RequestUtils.getInstance().getNetWorkStatus(volleyError.networkResponse.statusCode));
                            } else {
                                b.this.d.setEc("7");
                                b.this.f.setEc("7");
                            }
                            TPPushCenter.getInstance().saveEvent(b.this.d);
                            TPPushCenter.getInstance().saveEvent(b.this.f);
                            if (b.this.g != null) {
                                b.this.g.onFailed(volleyError);
                            }
                        }
                    };
                    object2 = new TradPlusConfigRequest((String)object2, AdFormat.INTERSTITIAL, ((b)object).a, ((b)object).b, listener);
                    object = Networking.getThreadResultQueue(((b)object).b);
                    if (object != null) {
                        ((RequestQueue)object).add(object2);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public static interface ConfigLoadListener {
        public void onSuccess(ConfigResponse var1);

        public void onFailed(VolleyError var1);
    }
}

