/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.db;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import com.tradplus.ads.base.GetApplication;
import com.tradplus.ads.base.db.DBStoreProvider;
import com.tradplus.ads.base.db.api.cache.Store;
import com.tradplus.ads.base.db.api.cache.StoreProvider;
import com.tradplus.ads.base.db.entity.AdSourceFrenquency;
import com.tradplus.ads.base.db.entity.AdUnitConfig;
import com.tradplus.ads.base.db.entity.AdUnitFrenquency;
import com.tradplus.ads.base.db.entity.Event;
import com.tradplus.ads.base.db.entity.EventAdx;
import com.tradplus.ads.base.db.entity.EventCross;
import com.tradplus.ads.base.db.entity.EventSimplify;
import com.tradplus.ads.base.db.entity.KVEntity;
import com.tradplus.ads.base.db.entity.Tracks;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.common.JSONHelper;
import com.tradplus.ads.network.FSOpenResponse;
import com.tradplus.ads.network.response.ConfigResponse;
import com.tradplus.ads.pushcenter.event.EventBaseRequest;
import com.tradplus.ads.pushcenter.event.request.SimplifyEvent;
import com.tradplus.ads.pushcenter.reqeust.BaseRequest;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class StoreManager {
    private static StoreProvider<String> storeProvider;

    public static void init(Context context) {
        storeProvider = DBStoreProvider.create(context);
    }

    private static <T> Store<String, T> getStore(Class<T> clazz) {
        if (storeProvider == null) {
            StoreManager.init(GetApplication.getContext());
        }
        return storeProvider.getStore(clazz);
    }

    public static String getVersionName() {
        return "8.3.20.1";
    }

    public static boolean checkVersion(String string) {
        return StoreManager.getVersionName().compareTo(string) != 0;
    }

    private static String toJson(Object object) {
        if (object instanceof JSONObject) {
            return object.toString();
        }
        return JSONHelper.toJSON(object);
    }

    private static <T> T fromJson(String string, Class<T> clazz) {
        return JSONHelper.fromJson(string, clazz);
    }

    public static void saveFrequency(String string, ConfigResponse.FrequencyBean frequencyBean) {
        if (frequencyBean == null) {
            return;
        }
        AdUnitFrenquency adUnitFrenquency = StoreManager.getStore(AdUnitFrenquency.class).get(string);
        long l2 = System.currentTimeMillis();
        if (adUnitFrenquency == null) {
            adUnitFrenquency = new AdUnitFrenquency();
            adUnitFrenquency.setId(string);
            adUnitFrenquency.setLoad_time(l2);
            adUnitFrenquency.setShow_time(l2);
        } else if ((l2 - adUnitFrenquency.getShow_time()) / 60000L >= (long)adUnitFrenquency.getTime()) {
            adUnitFrenquency.setShow_time(l2);
            adUnitFrenquency.setShow_count(0);
        }
        adUnitFrenquency.setTime_limit(frequencyBean.getLimit());
        adUnitFrenquency.setTime(frequencyBean.getTime());
        adUnitFrenquency.setVersion_name(StoreManager.getVersionName());
        StoreManager.getStore(AdUnitFrenquency.class).save((AdUnitFrenquency[])new AdUnitFrenquency[]{adUnitFrenquency});
    }

    public static ConfigResponse.FrequencyBean getFrequency(String object, boolean bl) {
        object = StoreManager.getStore(AdUnitFrenquency.class).get((String)object);
        if (object == null || bl && StoreManager.checkVersion(((AdUnitFrenquency)object).getVersion_name())) {
            return null;
        }
        ConfigResponse.FrequencyBean frequencyBean = new ConfigResponse.FrequencyBean();
        frequencyBean.setLimit(((AdUnitFrenquency)object).getTime_limit());
        frequencyBean.setTime(((AdUnitFrenquency)object).getTime());
        return frequencyBean;
    }

    public static void addFrequencyShowCount(String object) {
        Store<String, AdUnitFrenquency> store = StoreManager.getStore(AdUnitFrenquency.class);
        object = store.get((String)object);
        if (object == null) {
            return;
        }
        Object object2 = object;
        ((AdUnitFrenquency)object2).setShow_count(((AdUnitFrenquency)object2).getShow_count() + 1);
        ((AdUnitFrenquency)object).setShow_time(System.currentTimeMillis());
        store.save((AdUnitFrenquency[])new AdUnitFrenquency[]{object});
    }

    public static boolean needShowAd(String object) {
        Store<String, AdUnitFrenquency> store = StoreManager.getStore(AdUnitFrenquency.class);
        object = store.get((String)object);
        if (object == null || ((AdUnitFrenquency)object).getTime_limit() == -1 || ((AdUnitFrenquency)object).getTime() == -1) {
            return true;
        }
        long l2 = System.currentTimeMillis();
        if ((l2 - ((AdUnitFrenquency)object).getShow_time()) / 60000L >= (long)((AdUnitFrenquency)object).getTime()) {
            ((AdUnitFrenquency)object).setLoad_time(l2);
            ((AdUnitFrenquency)object).setShow_count(0);
            store.save((AdUnitFrenquency[])new AdUnitFrenquency[]{object});
            return true;
        }
        return ((AdUnitFrenquency)object).getTime_limit() > ((AdUnitFrenquency)object).getShow_count();
    }

    public static NetWorkFrequencyUtils.NetworkFrequencyBean getNetworkFrequency(String object, boolean bl) {
        object = StoreManager.getStore(AdSourceFrenquency.class).get((String)object);
        if (object == null || bl && StoreManager.checkVersion(((AdSourceFrenquency)object).getVersion_name())) {
            return null;
        }
        NetWorkFrequencyUtils.NetworkFrequencyBean networkFrequencyBean = new NetWorkFrequencyUtils.NetworkFrequencyBean();
        networkFrequencyBean.setHourTime(((AdSourceFrenquency)object).getHourTime());
        networkFrequencyBean.setDayTime(((AdSourceFrenquency)object).getDayTime());
        networkFrequencyBean.setDayCount(((AdSourceFrenquency)object).getDayCount());
        networkFrequencyBean.setHourCount(((AdSourceFrenquency)object).getHourCount());
        networkFrequencyBean.setShowTime(((AdSourceFrenquency)object).getShowTime());
        networkFrequencyBean.setCapping_day(((AdSourceFrenquency)object).getCapping_day());
        networkFrequencyBean.setCapping_hour(((AdSourceFrenquency)object).getCapping_hour());
        networkFrequencyBean.setPacing_min(((AdSourceFrenquency)object).getPacing_min());
        return networkFrequencyBean;
    }

    public static void saveNetworkFrequency(String string, NetWorkFrequencyUtils.NetworkFrequencyBean networkFrequencyBean) {
        AdSourceFrenquency adSourceFrenquency = new AdSourceFrenquency();
        adSourceFrenquency.setId(string);
        adSourceFrenquency.setVersion_name(StoreManager.getVersionName());
        adSourceFrenquency.setDayTime(networkFrequencyBean.getDayTime());
        adSourceFrenquency.setHourTime(networkFrequencyBean.getHourTime());
        adSourceFrenquency.setHourCount(networkFrequencyBean.getHourCount());
        adSourceFrenquency.setDayCount(networkFrequencyBean.getDayCount());
        adSourceFrenquency.setShowTime(networkFrequencyBean.getShowTime());
        adSourceFrenquency.setCapping_day(networkFrequencyBean.getCapping_day());
        adSourceFrenquency.setCapping_hour(networkFrequencyBean.getCapping_hour());
        adSourceFrenquency.setPacing_min(networkFrequencyBean.getPacing_min());
        StoreManager.getStore(AdSourceFrenquency.class).save((AdSourceFrenquency[])new AdSourceFrenquency[]{adSourceFrenquency});
    }

    public static void saveConfigResponse(String string, ConfigResponse configResponse) {
        AdUnitConfig adUnitConfig = new AdUnitConfig();
        adUnitConfig.setId(string);
        adUnitConfig.setVersion_name(StoreManager.getVersionName());
        adUnitConfig.setBean(StoreManager.toJson(configResponse));
        StoreManager.getStore(AdUnitConfig.class).save((AdUnitConfig[])new AdUnitConfig[]{adUnitConfig});
    }

    public static ConfigResponse getLocalConfigResponse(String object, boolean bl) {
        object = StoreManager.getStore(AdUnitConfig.class).get((String)object);
        if (object == null || bl && StoreManager.checkVersion(((AdUnitConfig)object).getVersion_name())) {
            return null;
        }
        return StoreManager.fromJson(((AdUnitConfig)object).getBean(), ConfigResponse.class);
    }

    public static void clearConfigResponse() {
        StoreManager.getStore(AdUnitConfig.class).clear();
    }

    public static void saveFSOpenResponse(FSOpenResponse fSOpenResponse) {
        fSOpenResponse.setCreate_time(System.currentTimeMillis());
        fSOpenResponse.setVersion_name(StoreManager.getVersionName());
        KVEntity kVEntity = new KVEntity();
        kVEntity.setKey(fSOpenResponse.getClass().getName());
        kVEntity.setValue(StoreManager.toJson(fSOpenResponse));
        kVEntity.setType(fSOpenResponse.getClass().getName());
        StoreManager.getStore(KVEntity.class).save((KVEntity[])new KVEntity[]{kVEntity});
    }

    public static FSOpenResponse getLocalFSOpenResponse(boolean bl) {
        Object object = StoreManager.getStore(KVEntity.class).get(FSOpenResponse.class.getName());
        object = object == null ? null : StoreManager.fromJson(((KVEntity)object).getValue(), FSOpenResponse.class);
        if (object == null || bl && StoreManager.checkVersion(((FSOpenResponse)object).getVersion_name())) {
            return null;
        }
        return object;
    }

    public static Pair<String[], String[]> getEvent(int n2) {
        List<Event> list = StoreManager.getStore(Event.class).getList(n2);
        if (list == null || list.size() == 0) {
            return null;
        }
        int n3 = list.size();
        String[] stringArray = new String[n3];
        String[] stringArray2 = new String[n3];
        Pair pair = new Pair((Object)stringArray, (Object)stringArray2);
        for (int i2 = 0; i2 < n3; ++i2) {
            Event event = list.get(i2);
            stringArray[i2] = event.getId();
            stringArray2[i2] = event.getContent();
        }
        return pair;
    }

    public static Pair<String[], String[]> getSimplifyEvent(int n2) {
        List<EventSimplify> list = StoreManager.getStore(EventSimplify.class).getList(n2);
        if (list == null || list.size() == 0) {
            return null;
        }
        int n3 = list.size();
        String[] stringArray = new String[n3];
        String[] stringArray2 = new String[n3];
        Pair pair = new Pair((Object)stringArray, (Object)stringArray2);
        for (int i2 = 0; i2 < n3; ++i2) {
            EventSimplify eventSimplify = list.get(i2);
            stringArray[i2] = eventSimplify.getId();
            stringArray2[i2] = eventSimplify.getContent();
        }
        return pair;
    }

    public static int getEventCount() {
        return StoreManager.getStore(Event.class).count();
    }

    public static int getSimplifyEventCount() {
        return StoreManager.getStore(EventSimplify.class).count();
    }

    public static void clearEvent() {
        StoreManager.getStore(Event.class).clear();
    }

    public static void clearSimplifyEvent() {
        StoreManager.getStore(EventSimplify.class).clear();
    }

    public static void removeEvent(String[] stringArray) {
        StoreManager.getStore(Event.class).delete((String[])stringArray);
    }

    public static void removeSimplifyEvent(String[] stringArray) {
        StoreManager.getStore(EventSimplify.class).delete((String[])stringArray);
    }

    public static void saveEvent(BaseRequest baseRequest) {
        if (baseRequest == null) {
            return;
        }
        Event event = new Event();
        event.setId(UUID.randomUUID().toString());
        event.setContent(StoreManager.toJson(baseRequest));
        StoreManager.getStore(Event.class).save((Event[])new Event[]{event});
    }

    public static void saveSimplifyEvent(SimplifyEvent simplifyEvent) {
        if (simplifyEvent == null) {
            return;
        }
        EventSimplify eventSimplify = new EventSimplify();
        eventSimplify.setId(UUID.randomUUID().toString());
        eventSimplify.setContent(StoreManager.toJson(simplifyEvent));
        StoreManager.getStore(EventSimplify.class).save((EventSimplify[])new EventSimplify[]{eventSimplify});
    }

    public static Pair<String[], String[]> saveEventJSONArray(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        int n2 = jSONArray.length();
        Event[] eventArray = new Event[n2];
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Event event = new Event();
            event.setId(UUID.randomUUID().toString());
            stringArray[i2] = event.getId();
            try {
                event.setContent(StoreManager.toJson(jSONArray.get(i2)));
            }
            catch (Exception exception) {}
            stringArray2[i2] = event.getContent();
            eventArray[i2] = event;
        }
        StoreManager.getStore(Event.class).save((Event[])eventArray);
        return new Pair((Object)stringArray, (Object)stringArray2);
    }

    public static Pair<String[], String[]> saveSimplifyEventJSONArray(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        int n2 = jSONArray.length();
        EventSimplify[] eventSimplifyArray = new EventSimplify[n2];
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            EventSimplify eventSimplify = new EventSimplify();
            eventSimplify.setId(UUID.randomUUID().toString());
            stringArray[i2] = eventSimplify.getId();
            try {
                eventSimplify.setContent(StoreManager.toJson(jSONArray.get(i2)));
            }
            catch (Exception exception) {}
            stringArray2[i2] = eventSimplify.getContent();
            eventSimplifyArray[i2] = eventSimplify;
        }
        StoreManager.getStore(EventSimplify.class).save((EventSimplify[])eventSimplifyArray);
        return new Pair((Object)stringArray, (Object)stringArray2);
    }

    public static Pair<String[], String[]> getEventCross(int n2) {
        List<EventCross> list = StoreManager.getStore(EventCross.class).getList(n2);
        if (list == null || list.size() == 0) {
            return null;
        }
        int n3 = list.size();
        String[] stringArray = new String[n3];
        String[] stringArray2 = new String[n3];
        Pair pair = new Pair((Object)stringArray, (Object)stringArray2);
        for (int i2 = 0; i2 < n3; ++i2) {
            EventCross eventCross = list.get(i2);
            stringArray[i2] = eventCross.getId();
            stringArray2[i2] = eventCross.getContent();
        }
        return pair;
    }

    public static int getEventCountCross() {
        return StoreManager.getStore(EventCross.class).count();
    }

    public static void saveCrossEvent(EventBaseRequest eventBaseRequest) {
        if (eventBaseRequest == null) {
            return;
        }
        EventCross eventCross = new EventCross();
        eventCross.setId(UUID.randomUUID().toString());
        eventCross.setContent(StoreManager.toJson(eventBaseRequest));
        StoreManager.getStore(EventCross.class).save((EventCross[])new EventCross[]{eventCross});
    }

    public static void clearCrossEvent() {
        StoreManager.getStore(EventCross.class).clear();
    }

    public static Pair<String[], String[]> saveCrossEventJSONArray(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        int n2 = jSONArray.length();
        EventCross[] eventCrossArray = new EventCross[jSONArray.length()];
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        int n3 = jSONArray.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            EventCross eventCross = new EventCross();
            eventCross.setId(UUID.randomUUID().toString());
            stringArray[i2] = eventCross.getId();
            try {
                eventCross.setContent(StoreManager.toJson(jSONArray.get(i2)));
            }
            catch (Exception exception) {}
            stringArray2[i2] = eventCross.getContent();
            eventCrossArray[i2] = eventCross;
        }
        StoreManager.getStore(EventCross.class).save((EventCross[])eventCrossArray);
        return new Pair((Object)stringArray, (Object)stringArray2);
    }

    public static void removeCrossEvent(String[] stringArray) {
        StoreManager.getStore(EventCross.class).delete((String[])stringArray);
    }

    public static Pair<String[], String[]> getEventAdx(int n2) {
        List<EventAdx> list = StoreManager.getStore(EventAdx.class).getList(n2);
        if (list == null || list.size() == 0) {
            return null;
        }
        int n3 = list.size();
        String[] stringArray = new String[n3];
        String[] stringArray2 = new String[n3];
        Pair pair = new Pair((Object)stringArray, (Object)stringArray2);
        for (int i2 = 0; i2 < n3; ++i2) {
            EventAdx eventAdx = list.get(i2);
            stringArray[i2] = eventAdx.getId();
            stringArray2[i2] = eventAdx.getContent();
        }
        return pair;
    }

    public static int getEventCountAdx() {
        return StoreManager.getStore(EventAdx.class).count();
    }

    public static void saveAdxEvent(Object object) {
        if (object == null) {
            return;
        }
        EventAdx eventAdx = new EventAdx();
        eventAdx.setId(UUID.randomUUID().toString());
        eventAdx.setContent(StoreManager.toJson(object));
        StoreManager.getStore(EventAdx.class).save((EventAdx[])new EventAdx[]{eventAdx});
    }

    public static void clearAdxEvent() {
        StoreManager.getStore(EventAdx.class).clear();
    }

    public static Pair<String[], String[]> saveAdxEventJSONArray(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        int n2 = jSONArray.length();
        EventAdx[] eventAdxArray = new EventAdx[jSONArray.length()];
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        int n3 = jSONArray.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            EventAdx eventAdx = new EventAdx();
            eventAdx.setId(UUID.randomUUID().toString());
            stringArray[i2] = eventAdx.getId();
            try {
                eventAdx.setContent(StoreManager.toJson(jSONArray.get(i2)));
            }
            catch (Exception exception) {}
            stringArray2[i2] = eventAdx.getContent();
            eventAdxArray[i2] = eventAdx;
        }
        StoreManager.getStore(EventAdx.class).save((EventAdx[])eventAdxArray);
        return new Pair((Object)stringArray, (Object)stringArray2);
    }

    public static void removeAdxEvent(String[] stringArray) {
        StoreManager.getStore(EventAdx.class).delete((String[])stringArray);
    }

    public static void saveTrack(Pair<String[], String[]> pair) {
        int n2 = ((String[])pair.first).length;
        Tracks[] tracksArray = new Tracks[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Tracks tracks = new Tracks();
            tracks.setId(((String[])pair.first)[i2]);
            tracks.setUrl(((String[])pair.first)[i2]);
            if (pair.second != null) {
                tracks.setContent(((String[])pair.second)[i2]);
            }
            tracksArray[i2] = tracks;
        }
        StoreManager.getStore(Tracks.class).save((Tracks[])tracksArray);
    }

    public static void removeTracks(String string) {
        StoreManager.getStore(Tracks.class).delete((String[])new String[]{string});
    }

    public static String getTracksContent(String object) {
        object = StoreManager.getStore(Tracks.class).get((String)object);
        if (object == null || TextUtils.isEmpty((CharSequence)((Tracks)object).getContent())) {
            return null;
        }
        return ((Tracks)object).getContent();
    }

    public static Pair<String[], String[]> getTracksContent(int n2) {
        List<Tracks> list = StoreManager.getStore(Tracks.class).getList(n2);
        if (list == null || list.size() == 0) {
            return null;
        }
        int n3 = list.size();
        String[] stringArray = new String[n3];
        String[] stringArray2 = new String[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            Tracks tracks = list.get(i2);
            stringArray[i2] = tracks.getId();
            stringArray2[i2] = tracks.getContent();
        }
        return new Pair((Object)stringArray, (Object)stringArray2);
    }
}

