/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network;

import android.util.Log;
import com.tradplus.ads.base.common.TPTaskManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.conn.ConnectTimeoutException;

public abstract class BaseHttpRequest {
    private static final String TAG = "BaseHttpLoader";
    public static final int POST = 1;
    public static final int GET = 2;
    public static final int CONNECT_TIMEOUT = 20000;
    public static final int READ_TIMEOUT = 60000;
    private static final int ERROR_CRASH = 11001;
    private static final int ERROR_GENERATE_URL = 11000;
    private static final int ERROR_TIMEOUT = 11002;
    private static final int ERROR_PARSE_RESULT = 11003;
    protected OnHttpLoaderListener mListener;
    protected boolean mCanceled;

    public void request(OnHttpLoaderListener onHttpLoaderListener) {
        this.mCanceled = false;
        this.mListener = onHttpLoaderListener;
        this.load();
    }

    public void canceled() {
        this.mCanceled = true;
    }

    protected abstract int requestType();

    protected abstract String generateURL();

    protected abstract Map<String, String> addHeaders();

    protected abstract byte[] postContent();

    protected abstract Object parseResult(String var1);

    private void load() {
        Runnable runnable = () -> {
            try {
                String string = this.generateURL();
                this.requestWithUrl(string);
                return;
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                if (this.mListener != null) {
                    this.mListener.loadError(11000, string);
                }
                return;
            }
        };
        TPTaskManager.getInstance().runNormalTask(runnable);
    }

    /*
     * WARNING - void declaration
     */
    private void requestWithUrl(String object) {
        block32: {
            HttpURLConnection httpURLConnection = null;
            try {
                int n2;
                Log.i((String)TAG, (String)"request url: ".concat(String.valueOf(object)));
                httpURLConnection = (HttpURLConnection)new URL((String)object).openConnection();
                int n3 = this.requestType();
                if (n3 == 1) {
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setRequestMethod("POST");
                    httpURLConnection.setUseCaches(false);
                } else {
                    httpURLConnection.setInstanceFollowRedirects(false);
                }
                Object object3 = this.addHeaders();
                if (object3 != null && object3.size() > 0) {
                    for (String object22 : object3.keySet()) {
                        httpURLConnection.addRequestProperty(object22, object3.get(object22));
                    }
                }
                if (this.mCanceled) {
                    this.onCancelCallback();
                    return;
                }
                httpURLConnection.setConnectTimeout(20000);
                httpURLConnection.setReadTimeout(60000);
                httpURLConnection.connect();
                if (n3 == 1) {
                    byte[] byArray = this.postContent();
                    Object object4 = byArray;
                    if (byArray != null) {
                        OutputStream outputStream = httpURLConnection.getOutputStream();
                        outputStream.write((byte[])object4);
                        outputStream.flush();
                        outputStream.close();
                    }
                }
                if ((n2 = httpURLConnection.getResponseCode()) != 200) {
                    void var6_17;
                    if (n2 != 302) {
                        this.onErrorCallback(n2, "http failed!");
                        return;
                    }
                    if (this.mCanceled) {
                        this.onCancelCallback();
                        return;
                    }
                    String string = httpURLConnection.getHeaderField("Location");
                    if (string == null) {
                        this.onErrorCallback(n2, "302 but Location is null");
                        return;
                    }
                    if (!string.startsWith("http")) {
                        String string2 = (String)object + string;
                    }
                    this.requestWithUrl((String)var6_17);
                    return;
                }
                if (this.mCanceled) {
                    this.onCancelCallback();
                    return;
                }
                InputStream inputStream = this.getGzipInputStream(httpURLConnection);
                object = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                StringBuilder stringBuilder = new StringBuilder();
                while ((object3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append((String)object3);
                }
                bufferedReader.close();
                ((InputStreamReader)object).close();
                if (inputStream != null) {
                    inputStream.close();
                }
                if ((object = this.parseResult(stringBuilder.toString())) == null) {
                    this.onErrorCallback(11003, "result parse error! resultStr=" + stringBuilder.toString());
                    return;
                }
                if (this.mListener != null) {
                    this.mListener.loadSuccess(object);
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                    return;
                }
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                this.onErrorCallback(11002, connectTimeoutException.getMessage());
                return;
            }
            catch (Throwable throwable) {
                String string = throwable.getMessage();
                this.onErrorCallback(11001, string);
                return;
            }
            finally {
                if (httpURLConnection == null) break block32;
                httpURLConnection.disconnect();
            }
        }
    }

    private void onErrorCallback(int n2, String string) {
        if (this.mListener != null) {
            this.mListener.loadError(n2, string);
        }
    }

    private void onCancelCallback() {
        if (this.mListener != null) {
            this.mListener.loadCanceled();
        }
    }

    public InputStream getGzipInputStream(HttpURLConnection object) {
        if (object == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = ((URLConnection)object).getInputStream();
        }
        catch (Exception exception) {}
        object = ((URLConnection)object).getHeaderField("Content-Encoding");
        if ("gzip".equalsIgnoreCase((String)object)) {
            try {
                byte[] byArray = new byte[2];
                object = new BufferedInputStream(inputStream);
                ((BufferedInputStream)object).mark(2);
                int n2 = ((FilterInputStream)object).read(byArray);
                ((BufferedInputStream)object).reset();
                int n3 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
                if (n2 != -1 && n3 == 35615) {
                    object = new GZIPInputStream((InputStream)object);
                }
            }
            catch (Exception exception) {
                object = inputStream;
            }
            return object;
        }
        return inputStream;
    }

    protected byte[] compress(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(string.getBytes("utf-8"));
            gZIPOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static interface OnHttpLoaderListener {
        public void loadSuccess(Object var1);

        public void loadError(int var1, String var2);

        public void loadCanceled();
    }
}

