/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONPath;
import com.tradplus.ads.common.serialization.annotation.JSONField;
import com.tradplus.ads.common.serialization.annotation.JSONType;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONScanner;

public class JSONPatch {
    public static String apply(String string, String string2) {
        return JSON.toJSONString(JSONPatch.apply(JSON.parse(string, Feature.OrderedField), string2));
    }

    public static Object apply(Object object, String operationArray) {
        boolean bl;
        Operation[] operationArray2 = operationArray;
        if (operationArray != null) {
            for (int i2 = 0; i2 < operationArray2.length(); ++i2) {
                char c2 = operationArray2.charAt(i2);
                if (JSONScanner.isWhitespace(c2)) continue;
                bl = c2 == '{';
                break;
            }
        } else {
            bl = false;
        }
        block8: for (Operation operation : bl ? new Operation[]{JSON.parseObject((String)operationArray, Operation.class)} : JSON.parseObject((String)operationArray, Operation[].class)) {
            JSONPath jSONPath = JSONPath.compile(operation.path);
            switch (operation.type) {
                case add: {
                    jSONPath.patchAdd(object, operation.value, false);
                    continue block8;
                }
                case replace: {
                    jSONPath.patchAdd(object, operation.value, true);
                    continue block8;
                }
                case remove: {
                    jSONPath.remove(object);
                    continue block8;
                }
                case copy: 
                case move: {
                    Object object2 = JSONPath.compile(operation.from);
                    Object object3 = ((JSONPath)object2).eval(object);
                    if (operation.type == OperationType.move && !((JSONPath)object2).remove(object)) {
                        throw new JSONException("json patch move error : " + operation.from + " -> " + operation.path);
                    }
                    jSONPath.set(object, object3);
                    continue block8;
                }
                case test: {
                    Object object2 = jSONPath.eval(object);
                    if (object2 == null) {
                        return operation.value == null;
                    }
                    return object2.equals(operation.value);
                }
            }
        }
        return object;
    }

    public static enum OperationType {
        add,
        remove,
        replace,
        move,
        copy,
        test;

    }

    @JSONType(orders={"op", "from", "path", "value"})
    public static class Operation {
        @JSONField(name="op")
        public OperationType type;
        public String from;
        public String path;
        public Object value;
    }
}

