/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONObject;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicInteger;

public class IntegerCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static IntegerCodec instance = new IntegerCodec();

    @Override
    public void write(JSONSerializer object, Object clazz, Object object2, Type type, int n2) {
        object = ((JSONSerializer)object).out;
        object2 = (Number)((Object)clazz);
        if (object2 == null) {
            ((SerializeWriter)object).writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        if (clazz instanceof Long) {
            ((SerializeWriter)object).writeLong(((Number)object2).longValue());
        } else {
            ((SerializeWriter)object).writeInt(((Number)object2).intValue());
        }
        if (((SerializeWriter)object).isEnabled(SerializerFeature.WriteClassName)) {
            clazz = object2.getClass();
            if (clazz == Byte.class) {
                ((SerializeWriter)object).write(66);
                return;
            }
            if (clazz == Short.class) {
                ((SerializeWriter)object).write(83);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser object, Type type, Object object2) {
        JSONLexer jSONLexer = ((DefaultJSONParser)object).lexer;
        int n2 = jSONLexer.token();
        if (n2 == 8) {
            jSONLexer.nextToken(16);
            return null;
        }
        try {
            if (n2 == 2) {
                n2 = jSONLexer.intValue();
                jSONLexer.nextToken(16);
                object = n2;
            } else if (n2 == 3) {
                object = TypeUtils.intValue(jSONLexer.decimalValue());
                jSONLexer.nextToken(16);
            } else if (n2 == 12) {
                JSONObject jSONObject = new JSONObject(true);
                ((DefaultJSONParser)object).parseObject(jSONObject);
                object = TypeUtils.castToInt(jSONObject);
            } else {
                object = TypeUtils.castToInt(((DefaultJSONParser)object).parse());
            }
        }
        catch (Exception exception) {
            object = "parseInt error";
            if (object2 != null) {
                object = (String)object + ", field : " + object2;
            }
            throw new JSONException((String)object, exception);
        }
        if (type == AtomicInteger.class) {
            return (T)new AtomicInteger((Integer)object);
        }
        return (T)object;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

