/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import java.io.FileDescriptor;

public class BitmapUtil {
    public static Bitmap getBitmap(String string, int n2, int n3) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            new BitmapFactory.Options().inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
            options.inSampleSize = BitmapUtil.calculateSampleSize(options.outWidth, options.outHeight, n2, n3);
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static Bitmap getBitmap(FileDescriptor fileDescriptor, int n2, int n3) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            new BitmapFactory.Options().inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
            options.inSampleSize = BitmapUtil.calculateSampleSize(options.outWidth, options.outHeight, n2, n3);
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static int calculateSampleSize(int n2, int n3, int n4, int n5) {
        int n6 = 1;
        if (n4 <= 0 && n5 <= 0) {
            return 1;
        }
        while (n2 / n6 > n4 && n3 / n6 > n5) {
            n6 *= 2;
        }
        return n6;
    }

    public static Bitmap blurBitmap(Context context, Bitmap bitmap) {
        try {
            Bitmap bitmap2 = Bitmap.createBitmap((int)(bitmap.getWidth() / 3), (int)(bitmap.getHeight() / 3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            context = RenderScript.create((Context)context);
            ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)context, (Element)Element.U8_4((RenderScript)context));
            bitmap = Allocation.createFromBitmap((RenderScript)context, (Bitmap)bitmap);
            Allocation allocation = Allocation.createFromBitmap((RenderScript)context, (Bitmap)bitmap2);
            scriptIntrinsicBlur.setRadius(25.0f);
            scriptIntrinsicBlur.setInput((Allocation)bitmap);
            scriptIntrinsicBlur.forEach(allocation);
            allocation.copyTo(bitmap2);
            new Canvas(bitmap2).drawColor(0x33000000);
            context.destroy();
            return bitmap2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

