/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.mobileads.util.network;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.util.network.NetStateChangeObserver;
import com.tradplus.ads.mobileads.util.network.NetworkChangeReceiver;

public class NetworkChangeManager {
    private static NetworkChangeManager a;
    private NetStateChangeObserver b;
    private boolean c;
    private ConnectivityManager.NetworkCallback d;

    public static synchronized NetworkChangeManager getInstance() {
        if (a == null) {
            a = new NetworkChangeManager();
        }
        return a;
    }

    public NetworkChangeManager() {
        if (!this.checkHasChangeNetworkPermission()) {
            this.c = true;
        }
    }

    public boolean checkHasChangeNetworkPermission() {
        boolean bl;
        try {
            Context context = GlobalTradPlus.getInstance().getContext();
            if (context == null) {
                return false;
            }
            PackageManager packageManager = context.getPackageManager();
            bl = 0 == packageManager.checkPermission("android.permission.CHANGE_NETWORK_STATE", context.getPackageName());
        }
        catch (Exception exception) {
            return false;
        }
        return bl;
    }

    public void setCloseNetworkChangeReceiver(boolean bl) {
        this.c = bl;
    }

    public void startConnectivityNetwork(Context context) {
        try {
            if (!this.c) {
                this.c = true;
                if (Build.VERSION.SDK_INT >= 24) {
                    context = (ConnectivityManager)context.getSystemService("connectivity");
                    this.d = new ConnectivityManager.NetworkCallback(){

                        public final void onAvailable(Network network) {
                            super.onAvailable(network);
                            LogUtil.ownShow("NetworkChangeManager network onAvailable");
                            if (NetworkChangeManager.this.b != null) {
                                NetworkChangeManager.this.b.onConnect();
                            }
                        }

                        public final void onLost(Network network) {
                            LogUtil.ownShow("NetworkChangeManager network lost");
                            super.onLost(network);
                            if (NetworkChangeManager.this.b != null) {
                                NetworkChangeManager.this.b.onDisconnect();
                            }
                        }

                        public final void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
                            super.onCapabilitiesChanged(network, networkCapabilities);
                            if (networkCapabilities.hasCapability(16)) {
                                if (networkCapabilities.hasTransport(1)) {
                                    if (NetworkChangeManager.this.b != null) {
                                        NetworkChangeManager.this.b.onConnect();
                                        return;
                                    }
                                } else if (networkCapabilities.hasTransport(0)) {
                                    if (NetworkChangeManager.this.b != null) {
                                        NetworkChangeManager.this.b.onConnect();
                                        return;
                                    }
                                } else if (NetworkChangeManager.this.b != null) {
                                    NetworkChangeManager.this.b.onDisconnect();
                                }
                            }
                        }
                    };
                    context.registerDefaultNetworkCallback(this.d);
                    return;
                }
                NetworkChangeReceiver.registerReceiver(context);
                NetworkChangeReceiver.registerObserver(this.b);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void stopConnectivityNetwork(Context context) {
        if (Build.VERSION.SDK_INT < 24) {
            NetworkChangeReceiver.unRegisterReceiver(context);
            NetworkChangeReceiver.unRegisterObserver(this.b);
        } else if (this.d != null) {
            ((ConnectivityManager)context.getSystemService("connectivity")).unregisterNetworkCallback(this.d);
        }
        this.d = null;
        this.setNetStateChangeObserver(null);
    }

    public void setNetStateChangeObserver(NetStateChangeObserver netStateChangeObserver) {
        this.b = netStateChangeObserver;
    }
}

